/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.ParseException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/instructorAssignmentPref")
public class InstructorAssignmentPrefAction
extends PreferencesAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            super.execute(mapping, form, request, response);
            InstructorEditForm frm = (InstructorEditForm)form;
            MessageResources rsc = this.getResources(request);
            ActionMessages errors = new ActionMessages();
            String instructorId = request.getParameter("instructorId");
            String op = frm.getOp();
            String reloadCause = request.getParameter("reloadCause");
            if (op.equals(rsc.getMessage("button.reload")) || op.equals(MSG.actionAddTimePreference()) || op.equals(MSG.actionAddDistributionPreference()) || op.equals(MSG.actionAddCoursePreference()) || op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionBackToDetail()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) {
                instructorId = frm.getInstructorId();
            }
            if (op == null || op.trim().isEmpty() || op.equals(rsc.getMessage("button.reload")) && (reloadCause == null || reloadCause.trim().isEmpty())) {
                op = "init";
            }
            if (op == null || op.trim().isEmpty()) {
                throw new Exception(MSG.exceptionNullOperationNotSupported());
            }
            if (instructorId == null || instructorId.isEmpty()) {
                throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
            }
            frm.setScreenName("instructorPref");
            DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(instructorId));
            LookupTables.setupInstructorDistribTypes(request, this.sessionContext, inst);
            this.sessionContext.checkPermission(inst.getDepartment(), Right.InstructorAssignmentPreferences);
            if (op.equals(MSG.actionBackToDetail()) && instructorId != null && !instructorId.trim().isEmpty()) {
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                redirect.addParameter("instructorId", (Object)frm.getInstructorId());
                return redirect;
            }
            if (op.equals("init")) {
                frm.reset(mapping, request);
                this.doLoad(request, frm, inst, instructorId);
            }
            if (op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) {
                errors = frm.validate(mapping, request);
                if (errors.isEmpty()) {
                    this.doUpdate(frm, request);
                    if (op.equals(MSG.actionNextInstructor())) {
                        response.sendRedirect(response.encodeURL("instructorAssignmentPref.do?instructorId=" + frm.getNextId()));
                        return null;
                    }
                    if (op.equals(MSG.actionPreviousInstructor())) {
                        response.sendRedirect(response.encodeURL("instructorAssignmentPref.do?instructorId=" + frm.getPreviousId()));
                        return null;
                    }
                    ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                    redirect.addParameter("instructorId", (Object)frm.getInstructorId());
                    redirect.addParameter("showPrefs", (Object)"true");
                    return redirect;
                }
                this.saveErrors(request, errors);
            }
            HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
            frm.setAvailableTimePatterns(null);
            if (op.equals("init")) {
                this.initPrefs(frm, inst, null, true);
                timePatterns.add(new TimePattern(new Long(-1L)));
            }
            this.processPrefAction(request, frm, errors);
            for (Preference pref : inst.getPreferences()) {
                if (!(pref instanceof TimePref)) continue;
                frm.setAvailability(((TimePref)pref).getPreference());
                break;
            }
            LookupTables.setupCourses(request, inst);
            LookupTables.setupInstructorAttributeTypes(request, inst);
            LookupTables.setupInstructorAttributes(request, inst);
            BackTracker.markForBack(request, "instructorDetail.do?instructorId=" + frm.getInstructorId(), MSG.backInstructor(frm.getName() == null ? "null" : frm.getName().trim()), true, false);
            return mapping.findForward("showEdit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, InstructorEditForm frm, DepartmentalInstructor inst, String instructorId) {
        frm.setInstructorId(instructorId);
        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
            request.setAttribute("UnavailableDays.pattern", (Object)inst.getUnavailablePatternHtml(true));
        }
        frm.setName(inst.getName(UserProperty.NameFormat.get(this.sessionContext.getUser())) + (inst.getPositionType() == null ? "" : " (" + inst.getPositionType().getLabel() + ")"));
        frm.setMaxLoad(inst.getMaxLoad() == null ? null : Formats.getNumberFormat("0.##").format(inst.getMaxLoad()));
        frm.setTeachingPreference(inst.getTeachingPreference() == null ? PreferenceLevel.sProhibited : inst.getTeachingPreference().getPrefProlog());
        frm.clearAttributes();
        for (InstructorAttribute attribute : inst.getAttributes()) {
            frm.setAttribute(attribute.getUniqueId(), (Boolean)true);
        }
        try {
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorAssignmentPreferences);
            frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorAssignmentPreferences);
            frm.setNextId(next == null ? null : next.getUniqueId().toString());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    protected void doUpdate(InstructorEditForm frm, HttpServletRequest request) throws Exception {
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(frm.getInstructorId()), hibSession);
            if (frm.getMaxLoad() != null && !frm.getMaxLoad().isEmpty()) {
                try {
                    inst.setMaxLoad(Float.valueOf(Formats.getNumberFormat("0.##").parse(frm.getMaxLoad()).floatValue()));
                }
                catch (ParseException parseException) {}
            } else {
                inst.setMaxLoad(null);
            }
            if (frm.getTeachingPreference() != null && !frm.getTeachingPreference().isEmpty() && !PreferenceLevel.sProhibited.equals(frm.getTeachingPreference())) {
                inst.setTeachingPreference(PreferenceLevel.getPreferenceLevel(frm.getTeachingPreference()));
            } else {
                inst.setTeachingPreference(null);
            }
            for (InstructorAttribute attribute : inst.getDepartment().getAvailableAttributes()) {
                if (frm.getAttribute(attribute.getUniqueId())) {
                    if (inst.getAttributes().contains(attribute)) continue;
                    inst.getAttributes().add(attribute);
                    continue;
                }
                if (!inst.getAttributes().contains(attribute)) continue;
                inst.getAttributes().remove(attribute);
            }
            super.doUpdate(request, frm, inst, inst.getPreferences(), false, Preference.Type.TIME, Preference.Type.DISTRIBUTION, Preference.Type.COURSE);
            if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                inst.setUnavailablePatternAndOffset(request);
            }
            hibSession.saveOrUpdate((Object)inst);
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT, ChangeLog.Operation.UPDATE, null, inst.getDepartment());
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

