/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.EditRoomDeptForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="/editRoomDept")
public class EditRoomDeptAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EditRoomDeptForm editRoomDeptForm = (EditRoomDeptForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = editRoomDeptForm.getDoit();
        if (doit != null) {
            ActionMessages errors;
            if (doit.equals(rsc.getMessage("button.update"))) {
                errors = new ActionMessages();
                errors = editRoomDeptForm.validate(mapping, request);
                if (errors.size() == 0) {
                    this.doUpdate(editRoomDeptForm, request);
                    return mapping.findForward("showRoomDetail");
                }
                this.saveErrors(request, errors);
            }
            if (doit.equals(rsc.getMessage("button.returnToRoomDetail"))) {
                response.sendRedirect("roomDetail.do?id=" + editRoomDeptForm.getId());
                return null;
            }
            if (doit.equals(rsc.getMessage("button.addRoomDept"))) {
                if (editRoomDeptForm.getDept() == null || editRoomDeptForm.getDept().length() == 0) {
                    errors = new ActionMessages();
                    errors.add("roomDept", new ActionMessage("errors.required", (Object)"Department"));
                    this.saveErrors(request, errors);
                } else if (editRoomDeptForm.getDepartmentIds().contains(new Long(editRoomDeptForm.getDept()))) {
                    errors = new ActionMessages();
                    errors.add("roomDept", new ActionMessage("errors.alreadyPresent", (Object)"Department"));
                    this.saveErrors(request, errors);
                } else {
                    editRoomDeptForm.addDepartment(editRoomDeptForm.getDept());
                }
            }
            if (doit.equals(rsc.getMessage("button.removeRoomDept"))) {
                if (editRoomDeptForm.getDept() == null || editRoomDeptForm.getDept().length() == 0) {
                    errors = new ActionMessages();
                    errors.add("roomDept", new ActionMessage("errors.required", (Object)"Department"));
                    this.saveErrors(request, errors);
                } else if (!editRoomDeptForm.getDepartmentIds().contains(new Long(editRoomDeptForm.getDept()))) {
                    errors = new ActionMessages();
                    errors.add("roomDept", new ActionMessage("errors.notPresent", (Object)"Department"));
                    this.saveErrors(request, errors);
                } else {
                    editRoomDeptForm.removeDepartment(editRoomDeptForm.getDept());
                }
            }
        }
        Long id = Long.valueOf(request.getParameter("id"));
        LocationDAO ldao = new LocationDAO();
        Location location = (Location)ldao.get(id);
        this.sessionContext.checkPermission(location, Right.RoomEditAvailability);
        if (doit != null && doit.equals(rsc.getMessage("button.modifyRoomDepts"))) {
            TreeSet<RoomDept> roomDepts = new TreeSet<RoomDept>(location.getRoomDepts());
            for (RoomDept roomDept : roomDepts) {
                editRoomDeptForm.addDepartment(roomDept.getDepartment().getUniqueId().toString());
            }
        }
        boolean timeVertical = CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()));
        RequiredTimeTable rtt = location.getRoomSharingTable(this.sessionContext.getUser(), editRoomDeptForm.getDepartmentIds());
        rtt.getModel().setDefaultSelection(UserProperty.GridSize.get(this.sessionContext.getUser()));
        if (doit != null && (doit.equals(rsc.getMessage("button.removeRoomDept")) || doit.equals(rsc.getMessage("button.addRoomDept")))) {
            rtt.update((ServletRequest)request);
        }
        editRoomDeptForm.setSharingTable(rtt.print(true, timeVertical));
        if (location instanceof Room) {
            Room r = (Room)location;
            editRoomDeptForm.setName(r.getLabel());
            editRoomDeptForm.setNonUniv(false);
        } else if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nonUnivLocation = (NonUniversityLocation)location;
            editRoomDeptForm.setName(nonUnivLocation.getName());
            editRoomDeptForm.setNonUniv(true);
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("editRoomDept", new ActionMessage("errors.lookup.notFound", (Object)"Room Department"));
            this.saveErrors(request, errors);
        }
        this.setupDepartments(editRoomDeptForm, request, location);
        return mapping.findForward("showEditRoomDept");
    }

    private void doUpdate(EditRoomDeptForm editRoomDeptForm, HttpServletRequest request) throws Exception {
        Transaction tx = null;
        try {
            Department d;
            LocationDAO ldao = new LocationDAO();
            Session hibSession = ldao.getSession();
            tx = hibSession.beginTransaction();
            Location location = (Location)ldao.get(new Long(editRoomDeptForm.getId()), hibSession);
            this.sessionContext.checkPermission(location, Right.RoomEditAvailability);
            HashSet deptIds = new HashSet(editRoomDeptForm.getDepartmentIds());
            DepartmentDAO ddao = new DepartmentDAO();
            Iterator<RoomDept> i = location.getRoomDepts().iterator();
            while (i.hasNext()) {
                RoomDept rd = i.next();
                d = rd.getDepartment();
                if (deptIds.remove(d.getUniqueId())) continue;
                d.getRoomDepts().remove(rd);
                hibSession.saveOrUpdate((Object)rd.getDepartment());
                i.remove();
                hibSession.delete((Object)rd);
                location.removedFromDepartment(d, hibSession);
            }
            for (Long deptId : deptIds) {
                d = (Department)ddao.get(deptId, hibSession);
                RoomDept rd = new RoomDept();
                rd.setRoom(location);
                rd.setDepartment(d);
                rd.setControl(Boolean.FALSE);
                location.getRoomDepts().add(rd);
                hibSession.save((Object)rd);
                d.getRoomDepts().add(rd);
                hibSession.save((Object)d);
            }
            RequiredTimeTable rtt = location.getRoomSharingTable(location.getRoomDepts());
            rtt.update((ServletRequest)request);
            location.setRoomSharingTable(rtt);
            hibSession.saveOrUpdate((Object)location);
            ChangeLog.addChange(hibSession, this.sessionContext, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            tx.commit();
            ldao.getSession().refresh((Object)location);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void setupDepartments(EditRoomDeptForm editRoomDeptForm, HttpServletRequest request, Location location) throws Exception {
        Vector<LabelValueBean> availableDepts = new Vector<LabelValueBean>();
        HashSet<Department> currentDepts = new HashSet<Department>();
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        boolean hasControl = false;
        for (RoomDept rd : location.getRoomDepts()) {
            currentDepts.add(rd.getDepartment());
            if (!departments.contains(rd.getDepartment()) || !rd.isControl().booleanValue()) continue;
            hasControl = true;
        }
        TreeSet<Department> set = Department.findAllBeingUsed(location.getSession().getUniqueId());
        for (Department d : set) {
            if (!hasControl && !departments.contains(d) && currentDepts.contains(d)) continue;
            availableDepts.add(new LabelValueBean(d.getDeptCode() + " - " + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
    }
}

