/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.cpsolver.coursett.model.TimeLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ClassesForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/classes")
public class ClassesAction
extends Action {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session session;
        String op;
        ClassesForm myForm = (ClassesForm)form;
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (request.getParameter("select") != null) {
            myForm.load(request.getSession());
            if (request.getParameter("subject") != null) {
                myForm.setSubjectArea(request.getParameter("subject"));
            } else if (myForm.canDisplayAllSubjectsAtOnce().booleanValue()) {
                myForm.setSubjectArea("--ALL--");
            }
            if (request.getParameter("year") != null && request.getParameter("term") != null && request.getParameter("campus") != null && (session = Session.getSessionUsingInitiativeYearTerm(request.getParameter("campus"), request.getParameter("year"), request.getParameter("term"))) != null) {
                myForm.setSession(session.getUniqueId());
            }
            if (request.getParameter("course") != null) {
                myForm.setCourseNumber(request.getParameter("course"));
            } else {
                myForm.setCourseNumber(null);
            }
            op = "Apply";
        }
        if ("Apply".equals(op)) {
            myForm.save(request.getSession());
            if (myForm.getUsername() != null && myForm.getUsername().length() > 0 && myForm.getPassword() != null && myForm.getPassword().length() > 0) {
                try {
                    UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)myForm.getUsername(), (Object)myForm.getPassword());
                    Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                    SecurityContextHolder.getContext().setAuthentication(authResult);
                    UserContext user = (UserContext)authResult.getPrincipal();
                    if (user.getCurrentAuthority() == null || !user.getCurrentAuthority().hasRight(Right.PersonalSchedule)) {
                        for (UserAuthority userAuthority : user.getAuthorities()) {
                            if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(myForm.getSession()) || !userAuthority.hasRight(Right.PersonalSchedule)) continue;
                            user.setCurrentAuthority(userAuthority);
                            break;
                        }
                    }
                    request.getSession().setAttribute("loginPage", (Object)"classes");
                    LoginManager.loginSuceeded(authResult.getName());
                    if (user.getCurrentAuthority() == null) {
                        response.sendRedirect("selectPrimaryRole.do");
                        return null;
                    }
                    return mapping.findForward("personal");
                }
                catch (Exception e) {
                    myForm.setMessage("Authentication failed: " + e.getMessage());
                    LoginManager.addFailedLoginAttempt(myForm.getUsername(), new Date());
                }
            }
        }
        myForm.load(request.getSession());
        WebTable.setOrder(this.sessionContext, "classes.order", request.getParameter("ord"), 1);
        if (myForm.getSession() != null && myForm.getSubjectArea() != null && myForm.getSubjectArea().length() > 0 && (session = (Session)new SessionDAO().get(myForm.getSession())).getStatusType().canNoRoleReportClass()) {
            int ord;
            PdfWebTable pdfWebTable;
            List classes = null;
            SubjectArea sa = null;
            if ("--ALL--".equals(myForm.getSubjectArea())) {
                classes = Class_.findAll(myForm.getSession());
            } else {
                sa = SubjectArea.findByAbbv(myForm.getSession(), myForm.getSubjectArea());
                if (sa != null) {
                    classes = ApplicationProperty.CourseOfferingTitleSearch.isTrue() && myForm.getCourseNumber() != null && myForm.getCourseNumber().length() > 2 ? Class_DAO.getInstance().getSession().createQuery("select distinct c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and co.subjectArea.uniqueId=:subjectAreaId and (co.courseNbr like :courseNbr or lower(co.title) like ('%' || lower(:courseNbr) || '%'))").setLong("sessionId", myForm.getSession().longValue()).setLong("subjectAreaId", sa.getUniqueId().longValue()).setString("courseNbr", myForm.getCourseNumber().replaceAll("\\*", "%")).setCacheable(true).list() : (myForm.getCourseNumber() != null && myForm.getCourseNumber().length() > 0 ? Class_DAO.getInstance().getSession().createQuery("select distinct c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and co.subjectArea.uniqueId=:subjectAreaId and co.courseNbr like :courseNbr").setLong("sessionId", myForm.getSession().longValue()).setLong("subjectAreaId", sa.getUniqueId().longValue()).setString("courseNbr", myForm.getCourseNumber().replaceAll("\\*", "%")).setCacheable(true).list() : Class_DAO.getInstance().getSession().createQuery("select distinct c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and co.subjectArea.uniqueId=:subjectAreaId").setLong("sessionId", myForm.getSession().longValue()).setLong("subjectAreaId", sa.getUniqueId().longValue()).setCacheable(true).list());
                }
            }
            if (classes != null && !classes.isEmpty() && (pdfWebTable = this.getTable(true, myForm, classes, ord = WebTable.getOrder(this.sessionContext, "classes.order"))) != null) {
                myForm.setTable(pdfWebTable.printTable(ord), pdfWebTable.getNrColumns(), pdfWebTable.getLines().size());
            }
        }
        return mapping.findForward("show");
    }

    public int getDaysCode(Set meetings) {
        int daysCode = 0;
        for (Meeting meeting : meetings) {
            Calendar date = Calendar.getInstance(Locale.US);
            date.setTime(meeting.getMeetingDate());
            switch (date.get(7)) {
                case 2: {
                    daysCode |= Constants.DAY_CODES[0];
                    break;
                }
                case 3: {
                    daysCode |= Constants.DAY_CODES[1];
                    break;
                }
                case 4: {
                    daysCode |= Constants.DAY_CODES[2];
                    break;
                }
                case 5: {
                    daysCode |= Constants.DAY_CODES[3];
                    break;
                }
                case 6: {
                    daysCode |= Constants.DAY_CODES[4];
                    break;
                }
                case 7: {
                    daysCode |= Constants.DAY_CODES[5];
                    break;
                }
                case 1: {
                    daysCode |= Constants.DAY_CODES[6];
                }
            }
        }
        return daysCode;
    }

    protected String getMeetingTime(Class_ clazz) {
        DatePattern dp;
        String meetingTime = "";
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        DatePattern datePattern = dp = assignment == null ? null : assignment.getDatePattern();
        if (meetings != null && !meetings.isEmpty()) {
            int dayCode = this.getDaysCode(meetings);
            String days = "";
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                days = days + CONSTANTS.shortDays()[i];
            }
            meetingTime = meetingTime + days;
            Meeting first = meetings.first();
            meetingTime = meetingTime + " " + first.startTime() + " - " + first.stopTime();
        } else if (assignment != null) {
            TimeLocation t = assignment.getTimeLocation();
            meetingTime = meetingTime + t.getDayHeader() + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + t.getEndTimeHeader(CONSTANTS.useAmPm());
        } else {
            meetingTime = meetingTime + "Arr Hrs";
        }
        if (meetings != null && !meetings.isEmpty()) {
            if (dp == null || !dp.isDefault()) {
                Date first = meetings.first().getMeetingDate();
                Date last = meetings.last().getMeetingDate();
                meetingTime = dp != null && dp.getType() == 1 ? meetingTime + " (" + dpf.format(first) + " - " + dpf.format(last) + " " + dp.getName() + ")" : meetingTime + " (" + dpf.format(first) + " - " + dpf.format(last) + ")";
            }
        } else if (dp != null && !dp.isDefault()) {
            meetingTime = dp.getType() == 1 ? meetingTime + " (" + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate()) + " " + dp.getName() + ")" : meetingTime + " (" + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate()) + ")";
        }
        return meetingTime;
    }

    protected String getMeetingRooms(boolean html, Class_ clazz) {
        String meetingRooms = "";
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        TreeSet<Location> locations = new TreeSet<Location>();
        if (meetings != null && !meetings.isEmpty()) {
            for (Meeting meeting : meetings) {
                if (meeting.getLocation() == null) continue;
                locations.add(meeting.getLocation());
            }
        } else if (assignment != null && assignment.getDatePattern() != null) {
            Iterator<Location> i = assignment.getRooms().iterator();
            while (i.hasNext()) {
                locations.add(i.next());
            }
        }
        for (Location location : locations) {
            if (meetingRooms.length() > 0) {
                meetingRooms = meetingRooms + ", ";
            }
            meetingRooms = meetingRooms + (html ? location.getLabelWithHint() : location.getLabel());
        }
        return meetingRooms;
    }

    protected long getMeetingComparable(Class_ clazz) {
        TreeSet<Meeting> meetings;
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> treeSet = meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        if (meetings != null && !meetings.isEmpty()) {
            return meetings.first().getMeetingDate().getTime();
        }
        if (assignment != null) {
            return assignment.getTimeLocation().getStartSlot();
        }
        return -1L;
    }

    protected String getMeetingInstructor(Class_ clazz) {
        String meetingInstructor = "";
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return meetingInstructor;
        }
        for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
            if (meetingInstructor.length() > 0) {
                meetingInstructor = meetingInstructor + ", ";
            }
            meetingInstructor = meetingInstructor + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatLastInitial);
        }
        return meetingInstructor;
    }

    public boolean match(ClassesForm form, CourseOffering co) {
        if ("--ALL--".equals(form.getSubjectArea())) {
            return true;
        }
        if (!co.getSubjectArea().getSubjectAreaAbbreviation().equals(form.getSubjectArea())) {
            return false;
        }
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && form.getCourseNumber() != null && form.getCourseNumber().length() > 2) {
            return co.getCourseNbr().matches(form.getCourseNumber().replaceAll("\\*", ".*")) || co.getTitle() != null && co.getTitle().toLowerCase().contains(form.getCourseNumber().toLowerCase());
        }
        if (form.getCourseNumber() != null && form.getCourseNumber().length() > 0) {
            return co.getCourseNbr().matches(form.getCourseNumber().replaceAll("\\*", ".*"));
        }
        return true;
    }

    private PdfWebTable getTable(boolean html, ClassesForm form, Collection<Class_> classes, int ord) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(6, form.getSessionLabel() + " classes" + ("--ALL--".equals(form.getSubjectArea()) ? "" : " (" + form.getSubjectArea() + (form.getCourseNumber() != null && form.getCourseNumber().length() > 0 ? " " + form.getCourseNumber() : "") + ")"), "classes.do?ord=%%", new String[]{"Course", "Instruction" + nl + "Type", "Section", "Time", "Room", "Instructor"}, new String[]{"left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        boolean suffix = ApplicationProperty.ExaminationReportsClassSufix.isTrue();
        for (Class_ clazz : classes) {
            for (CourseOffering co : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (!this.match(form, co)) continue;
                String course = co.getCourseName();
                String itype = clazz.getSchedulingSubpart().getItypeDesc();
                int itypeCmp = clazz.getSchedulingSubpart().getItype().getItype();
                String section = suffix && clazz.getClassSuffix(co) != null ? clazz.getClassSuffix(co) : clazz.getSectionNumberString();
                String time = this.getMeetingTime(clazz);
                long timeCmp = this.getMeetingComparable(clazz);
                String room = this.getMeetingRooms(html, clazz);
                String instr = this.getMeetingInstructor(clazz);
                table.addLine(new String[]{course, itype, section, time, room, instr}, new Comparable[]{new MultiComparable((Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable(Integer.valueOf(itypeCmp), (Comparable)((Object)course), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)course), (Comparable)((Object)section), Integer.valueOf(itypeCmp), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable(Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)room), Long.valueOf(timeCmp), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)instr), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room))});
            }
        }
        return table;
    }
}

