/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.ClassSearchAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassListForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/classShowSearch")
public class ClassShowSearchAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BackTracker.markForBack(request, null, null, false, true);
        this.sessionContext.checkPermission(Right.Classes);
        this.sessionContext.setAttribute(SessionAttribute.CallingPage, (Object)"classShowSearch");
        Object sas = this.sessionContext.getAttribute(SessionAttribute.ClassesSubjectAreas);
        Object cn = this.sessionContext.getAttribute(SessionAttribute.ClassesCourseNumber);
        String subjectAreaIds = "";
        String courseNbr = "";
        if ((sas == null || sas.toString().trim().isEmpty()) && (cn == null || cn.toString().trim().isEmpty())) {
            sas = this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            cn = this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
        }
        request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ClassListForm classListForm = (ClassListForm)form;
        ClassSearchAction.setupGeneralFormFilters(this.sessionContext, classListForm);
        ClassSearchAction.setupClassListSpecificFormFilters(this.sessionContext, classListForm);
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            classListForm.setExams(null);
        }
        classListForm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        if (sas == null && classListForm.getSubjectAreas().size() == 1) {
            sas = ((SubjectArea)classListForm.getSubjectAreas().iterator().next()).getUniqueId().toString();
        }
        if (Constants.ALL_OPTION_VALUE.equals(sas)) {
            sas = null;
        }
        if (sas != null && sas.toString().trim().length() > 0) {
            subjectAreaIds = sas.toString();
            try {
                if (cn != null && cn.toString().trim().length() > 0) {
                    courseNbr = cn.toString();
                }
                Debug.debug("Subject Areas: " + subjectAreaIds);
                Debug.debug("Course Number: " + courseNbr);
                classListForm.setSubjectAreaIds(subjectAreaIds.split(","));
                classListForm.setCourseNbr(courseNbr);
                Integer maxSubjectsToSearch = ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue();
                if (maxSubjectsToSearch != null && maxSubjectsToSearch >= 0 && classListForm.getSubjectAreaIds().length > maxSubjectsToSearch) {
                    return mapping.findForward("showClassSearch");
                }
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                StringBuffer subjIds = new StringBuffer();
                classListForm.setClasses(ClassSearchAction.getClasses(classListForm, WebSolver.getClassAssignmentProxy(request.getSession())));
                Collection classes = classListForm.getClasses();
                if (classes.isEmpty()) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("searchResult", new ActionMessage("errors.generic", (Object)"No records matching the search criteria were found."));
                    this.saveErrors(request, errors);
                    return mapping.findForward("showClassSearch");
                }
                for (int i = 0; i < classListForm.getSubjectAreaIds().length; ++i) {
                    if (i > 0) {
                        names.append(",");
                        subjIds.append(",");
                    }
                    ids.append("&subjectAreaIds=" + classListForm.getSubjectAreaIds()[i]);
                    subjIds.append(classListForm.getSubjectAreaIds()[i]);
                    names.append(((SubjectArea)new SubjectAreaDAO().get(new Long(classListForm.getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
                }
                BackTracker.markForBack(request, "classSearch.do?doit=Search&loadFilter=1&" + ids + "&courseNbr=" + URLEncoder.encode(classListForm.getCourseNbr(), "utf-8"), "Classes (" + names + (classListForm.getCourseNbr() == null || classListForm.getCourseNbr().length() == 0 ? "" : " " + classListForm.getCourseNbr()) + ")", true, true);
                return mapping.findForward("showClassList");
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Ids session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.ClassesSubjectAreas);
                this.sessionContext.removeAttribute(SessionAttribute.ClassesCourseNumber);
            }
        }
        return mapping.findForward("showClassSearch");
    }
}

