/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao._RootDAO;

public class MakeEventsForAllCommitedAssignments {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(new Properties());
            Session hibSession = new _RootDAO().getSession();
            List commitedSolutions = hibSession.createQuery("select s from Solution s where s.commited = true").list();
            int idx = 0;
            for (Solution s : commitedSolutions) {
                System.out.println("Procession solution " + ++idx + "/" + commitedSolutions.size() + " (" + s.getOwner().getName() + " of " + s.getSession().getLabel() + ", committed " + s.getCommitDate() + ")");
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Iterator j = hibSession.createQuery("select e from Solution s inner join s.assignments a, ClassEvent e where e.clazz=a.clazz and s.uniqueId=:solutionId").setLong("solutionId", s.getUniqueId().longValue()).iterate();
                    while (j.hasNext()) {
                        ClassEvent e = (ClassEvent)j.next();
                        hibSession.delete((Object)e);
                    }
                    j = hibSession.createQuery("select a from Assignment a where a.solution.uniqueId = :solutionId").setLong("solutionId", s.getUniqueId().longValue()).iterate();
                    while (j.hasNext()) {
                        Assignment a = (Assignment)j.next();
                        ClassEvent event = a.generateCommittedEvent(null, true);
                        if (event != null && !event.getMeetings().isEmpty()) {
                            System.out.println("  " + a.getClassName() + " " + a.getPlacement().getLongName(true));
                            hibSession.saveOrUpdate((Object)event);
                        }
                        if (event == null || !event.getMeetings().isEmpty() || event.getUniqueId() == null) continue;
                        hibSession.delete((Object)event);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx == null) throw e;
                    tx.rollback();
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

