/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningLoader;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.curricula.LastLikeStudentCourseDemands;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.duration.DurationModel;

public class StudentSectioningDatabaseLoader
extends StudentSectioningLoader {
    private static Log sLog = LogFactory.getLog(StudentSectioningDatabaseLoader.class);
    private boolean iIncludeCourseDemands = true;
    private boolean iIncludeUseCommittedAssignments = false;
    private boolean iMakeupAssignmentsFromRequiredPrefs = false;
    private boolean iLoadStudentInfo = true;
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private String iOwnerId = null;
    private Long iSessionId = null;
    private long iMakeupAssignmentId = 0L;
    private BitSet iFreeTimePattern = null;
    private Date iDatePatternFirstDate = null;
    private boolean iTweakLimits = false;
    private boolean iAllowToKeepCurrentEnrollment = false;
    private long iMakeupReservationId = 0L;
    private boolean iLoadSectioningInfos = false;
    private boolean iProjections = false;
    private boolean iFixWeights = true;
    private boolean iCheckForNoBatchStatus = true;
    private boolean iCheckEnabledForScheduling = true;
    private boolean iLoadRequestGroups = false;
    private String iRequestGroupRegExp = null;
    private Query iStudentQuery = null;
    private boolean iNoUnlimitedGroupReservations = false;
    private boolean iLinkedClassesMustBeUsed = false;
    private boolean iAllowDefaultCourseAlternatives = false;
    private boolean iIncludeUnavailabilities = true;
    private String iShortDistanceAccomodationReference = null;
    private boolean iCheckOverrideStatus = false;
    private boolean iValidateOverrides = false;
    private CourseRequestsValidationProvider iValidationProvider = null;
    private List<Long> iUpdatedStudents = new ArrayList<Long>();
    private NameFormat iStudentNameFormat = null;
    private NameFormat iInstructorNameFormat = null;
    private StudentSolver iValidator = null;
    private boolean iCheckRequestStatusSkipCancelled = false;
    private boolean iCheckRequestStatusSkipPending = false;
    private int iNrValidationThreads = 1;
    private boolean iCanContinue = true;
    private boolean iCheckCriticalCourses = false;
    private CriticalCoursesProvider iCriticalCoursesProvider = null;
    private int iNrCheckCriticalThreads = 1;
    private boolean iMoveCriticalCoursesUp = false;
    private boolean iCorrectConfigLimit = false;
    private boolean iUseSnapShotLimits = false;
    private String iPriorityStudentGroupReference = null;
    private Query iProjectedStudentQuery = null;
    private Progress iProgress = null;
    private StudentCourseDemands iStudentCourseDemands = null;
    private boolean iUseAmPm = true;
    private String iDatePatternFormat = null;
    private boolean iShowClassSuffix = false;
    private boolean iShowConfigName = false;
    private boolean iMaxCreditChecking = false;
    private float iMaxDefaultCredit = -1.0f;
    private float iMinDefaultCredit = -1.0f;
    private Date iClassesFixedDate = null;
    private int iClassesFixedDateIndex = 0;
    private int iDayOfWeekOffset = 0;
    Map<Long, Map<String, Integer>> iCourse2Curricula2Weight = new Hashtable<Long, Map<String, Integer>>();

    public StudentSectioningDatabaseLoader(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        super(model, assignment);
        String projQuery;
        String query;
        this.iIncludeCourseDemands = model.getProperties().getPropertyBoolean("Load.IncludeCourseDemands", this.iIncludeCourseDemands);
        this.iIncludeUseCommittedAssignments = model.getProperties().getPropertyBoolean("Load.IncludeUseCommittedAssignments", this.iIncludeUseCommittedAssignments);
        this.iLoadStudentInfo = model.getProperties().getPropertyBoolean("Load.LoadStudentInfo", this.iLoadStudentInfo);
        this.iMakeupAssignmentsFromRequiredPrefs = model.getProperties().getPropertyBoolean("Load.MakeupAssignmentsFromRequiredPrefs", this.iMakeupAssignmentsFromRequiredPrefs);
        this.iInitiative = model.getProperties().getProperty("Data.Initiative");
        this.iYear = model.getProperties().getProperty("Data.Year");
        this.iTerm = model.getProperties().getProperty("Data.Term");
        this.iOwnerId = model.getProperties().getProperty("General.OwnerPuid");
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", null);
        this.iTweakLimits = model.getProperties().getPropertyBoolean("Load.TweakLimits", this.iTweakLimits);
        this.iAllowToKeepCurrentEnrollment = model.getProperties().getPropertyBoolean("Load.AllowToKeepCurrentEnrollment", this.iAllowToKeepCurrentEnrollment);
        this.iLoadSectioningInfos = model.getProperties().getPropertyBoolean("Load.LoadSectioningInfos", this.iLoadSectioningInfos);
        this.iProgress = Progress.getInstance((Object)this.getModel());
        this.iFixWeights = model.getProperties().getPropertyBoolean("Load.FixWeights", this.iFixWeights);
        this.iCheckForNoBatchStatus = model.getProperties().getPropertyBoolean("Load.CheckForNoBatchStatus", this.iCheckForNoBatchStatus);
        this.iCheckEnabledForScheduling = model.getProperties().getPropertyBoolean("Load.CheckEnabledForScheduling", this.iCheckEnabledForScheduling);
        this.iLoadRequestGroups = model.getProperties().getPropertyBoolean("Load.RequestGroups", this.iLoadRequestGroups);
        this.iRequestGroupRegExp = model.getProperties().getProperty("Load.RequestGroupRegExp");
        this.iDatePatternFormat = ApplicationProperty.DatePatternFormatUseDates.value();
        this.iNoUnlimitedGroupReservations = model.getProperties().getPropertyBoolean("Load.NoUnlimitedGroupReservations", this.iNoUnlimitedGroupReservations);
        this.iUseSnapShotLimits = model.getProperties().getPropertyBoolean("Load.UseSnapShotLimits", this.iUseSnapShotLimits);
        this.iCorrectConfigLimit = model.getProperties().getPropertyBoolean("Load.CorrectConfigLimit", this.iCorrectConfigLimit);
        this.iLinkedClassesMustBeUsed = model.getProperties().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        this.iAllowDefaultCourseAlternatives = ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue();
        this.iIncludeUnavailabilities = model.getProperties().getPropertyBoolean("Load.IncludeUnavailabilities", this.iIncludeUnavailabilities);
        this.iShortDistanceAccomodationReference = model.getProperties().getProperty("Distances.ShortDistanceAccommodationReference", "SD");
        this.iPriorityStudentGroupReference = model.getProperties().getProperty("Load.PriorityStudentGroupReference", null);
        this.iCheckOverrideStatus = model.getProperties().getPropertyBoolean("Load.CheckOverrideStatus", this.iCheckOverrideStatus);
        this.iValidateOverrides = model.getProperties().getPropertyBoolean("Load.ValidateOverrides", this.iValidateOverrides);
        if ((this.iValidateOverrides || this.iCheckOverrideStatus) && ApplicationProperty.CustomizationCourseRequestsValidation.value() != null) {
            try {
                this.iValidationProvider = (CourseRequestsValidationProvider)Class.forName(ApplicationProperty.CustomizationCourseRequestsValidation.value()).newInstance();
            }
            catch (Exception e) {
                this.iProgress.error("Failed to create course request validation provider: " + e.getMessage());
            }
            this.iNrValidationThreads = model.getProperties().getPropertyInt("CourseRequestsValidation.NrThreads", 10);
        }
        this.iCheckCriticalCourses = model.getProperties().getPropertyBoolean("Load.CheckCriticalCourses", this.iCheckCriticalCourses);
        if (this.iCheckCriticalCourses && ApplicationProperty.CustomizationCriticalCourses.value() != null) {
            try {
                this.iCriticalCoursesProvider = (CriticalCoursesProvider)Class.forName(ApplicationProperty.CustomizationCriticalCourses.value()).newInstance();
            }
            catch (Exception e) {
                this.iProgress.error("Failed to create critical courses provider: " + e.getMessage());
            }
            this.iNrCheckCriticalThreads = model.getProperties().getPropertyInt("CheckCriticalCourses.NrThreads", 10);
        }
        try {
            String studentCourseDemandsClassName = ((StudentSectioningModel)this.getModel()).getProperties().getProperty("StudentSct.ProjectedCourseDemadsClass", LastLikeStudentCourseDemands.class.getName());
            if (studentCourseDemandsClassName.indexOf(32) >= 0) {
                studentCourseDemandsClassName = studentCourseDemandsClassName.replace(" ", "");
            }
            if (studentCourseDemandsClassName.indexOf(46) < 0) {
                studentCourseDemandsClassName = "org.unitime.timetable.solver.curricula." + studentCourseDemandsClassName;
            }
            Class<?> studentCourseDemandsClass = Class.forName(studentCourseDemandsClassName);
            this.iStudentCourseDemands = (StudentCourseDemands)studentCourseDemandsClass.getConstructor(DataProperties.class).newInstance(((StudentSectioningModel)this.getModel()).getProperties());
            this.iProgress.info("Projected demands: " + ((StudentSectioningModel)this.getModel()).getProperties().getProperty("StudentSct.ProjectedCourseDemadsClass", LastLikeStudentCourseDemands.class.getName()));
        }
        catch (Exception e) {
            if (model.getProperties().getPropertyBoolean("Load.IncludeLastLikeStudents", false)) {
                this.iStudentCourseDemands = new ProjectedStudentCourseDemands(model.getProperties());
                this.iProgress.info("Projected demands: Projected Student Course Demands");
            }
            this.iProgress.info("Projected demands: None");
        }
        if (this.iStudentCourseDemands != null && this.iStudentCourseDemands instanceof StudentCourseDemands.NeedsStudentIdGenerator) {
            ((StudentCourseDemands.NeedsStudentIdGenerator)((Object)this.iStudentCourseDemands)).setStudentIdGenerator(new IdGenerator());
        }
        if ((query = model.getProperties().getProperty("Load.StudentQuery", null)) != null && !query.isEmpty()) {
            this.iStudentQuery = new Query(query);
            this.iProgress.info("Student filter: " + this.iStudentQuery);
        }
        this.iProjections = "Projection".equals(model.getProperties().getProperty("StudentSctBasic.Mode", "Initial"));
        this.iUseAmPm = model.getProperties().getPropertyBoolean("General.UseAmPm", this.iUseAmPm);
        this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
        this.iStudentNameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
        this.iInstructorNameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
        this.iCheckRequestStatusSkipCancelled = model.getProperties().getPropertyBoolean("Load.CheckRequestStatusSkipCancelled", this.iCheckRequestStatusSkipCancelled);
        this.iCheckRequestStatusSkipPending = model.getProperties().getPropertyBoolean("Load.CheckRequestStatusSkipPending", this.iCheckRequestStatusSkipPending);
        this.iMaxCreditChecking = model.getProperties().getPropertyBoolean("Load.MaxCreditChecking", this.iMaxCreditChecking);
        this.iMaxDefaultCredit = model.getProperties().getPropertyFloat("Load.DefaultMaxCredit", this.iMaxDefaultCredit);
        this.iMinDefaultCredit = model.getProperties().getPropertyFloat("Load.DefaultMinCredit", this.iMinDefaultCredit);
        this.iMoveCriticalCoursesUp = model.getProperties().getPropertyBoolean("Load.MoveCriticalCoursesUp", this.iMoveCriticalCoursesUp);
        String classesFixedDate = ((StudentSectioningModel)this.getModel()).getProperties().getProperty("General.ClassesFixedDate", "");
        if (!classesFixedDate.isEmpty()) {
            try {
                this.iClassesFixedDate = new SimpleDateFormat("yyyy-MM-dd").parse(classesFixedDate);
            }
            catch (Exception e) {
                this.iProgress.warn("Failed to parse classes fixed date " + classesFixedDate + ". The date must be in the yyyy-mm-dd format.");
            }
        }
        if ((projQuery = model.getProperties().getProperty("Load.ProjectedStudentQuery", null)) != null && !projQuery.isEmpty()) {
            this.iProjectedStudentQuery = new Query(projQuery);
            this.iProgress.info("Projected students filter: " + this.iProjectedStudentQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.iProgress.setStatus("Loading input data ...");
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            hibSession = SessionDAO.getInstance().getSession();
            hibSession.setCacheMode(CacheMode.IGNORE);
            hibSession.setFlushMode(FlushMode.MANUAL);
            tx = hibSession.beginTransaction();
            Session session = null;
            if (this.iSessionId != null) {
                session = (Session)SessionDAO.getInstance().get(this.iSessionId);
                if (session != null) {
                    this.iYear = session.getAcademicYear();
                    this.iTerm = session.getAcademicTerm();
                    this.iInitiative = session.getAcademicInitiative();
                    ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Year", this.iYear);
                    ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Term", this.iTerm);
                    ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Initiative", this.iInitiative);
                }
            } else {
                session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
                if (session != null) {
                    this.iSessionId = session.getUniqueId();
                    ((StudentSectioningModel)this.getModel()).getProperties().setProperty("General.SessionId", String.valueOf(this.iSessionId));
                }
            }
            if (session == null) {
                throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
            }
            ApplicationProperties.setSessionId(session.getUniqueId());
            if (this.iClassesFixedDate != null) {
                Date firstDay = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
                this.iClassesFixedDateIndex = Days.daysBetween((ReadablePartial)new LocalDate((Object)firstDay), (ReadablePartial)new LocalDate((Object)this.iClassesFixedDate)).getDays();
                this.iDayOfWeekOffset = Constants.getDayOfWeek(firstDay);
                this.iProgress.info("Classes Fixed Date: " + this.iClassesFixedDate + " (date pattern index: " + this.iClassesFixedDateIndex + ")");
            }
            this.iProgress.info("Loading data for " + this.iInitiative + " " + this.iTerm + this.iYear + "...");
            if (((StudentSectioningModel)this.getModel()).getDistanceConflict() != null) {
                TravelTime.populateTravelTimes(((StudentSectioningModel)this.getModel()).getDistanceConflict().getDistanceMetric(), this.iSessionId, hibSession);
            }
            this.load(session, hibSession);
            if (!this.iUpdatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(hibSession, null, this.iSessionId, this.iUpdatedStudents);
                hibSession.flush();
            }
            tx.commit();
        }
        catch (Exception e) {
            this.iProgress.fatal("Unable to load sectioning problem, reason: " + e.getMessage(), (Throwable)e);
            sLog.error((Object)e.getMessage(), (Throwable)e);
            tx.rollback();
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
            if (this.iValidationProvider != null) {
                this.iValidationProvider.dispose();
            }
            if (this.iCriticalCoursesProvider != null) {
                this.iCriticalCoursesProvider.dispose();
            }
        }
    }

    private List<Instructor> getInstructors(Class_ clazz) {
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return null;
        }
        ArrayList<Instructor> ret = new ArrayList<Instructor>();
        TreeSet<ClassInstructor> ts = new TreeSet<ClassInstructor>(clazz.getClassInstructors());
        for (ClassInstructor ci : ts) {
            if (!ci.isLead().booleanValue() || ci.getResponsibility() != null && ci.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary)) continue;
            ret.add(new Instructor(ci.getInstructor().getUniqueId().longValue(), ci.getInstructor().getExternalUniqueId(), this.iInstructorNameFormat.format(ci.getInstructor()), ci.getInstructor().getEmail()));
        }
        return ret;
    }

    public TimeLocation makeupTime(Class_ c) {
        DatePattern datePattern = c.effectiveDatePattern();
        if (datePattern == null) {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ": no date pattern set");
            return null;
        }
        for (TimePref tp : c.getEffectiveTimePreferences()) {
            TimePatternModel pattern = tp.getTimePatternModel();
            if (pattern.isExactTime()) {
                DurationModel dm = c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(c.getSchedulingSubpart().getMinutesPerWk(), c.effectiveDatePattern(), pattern.getExactDays());
                int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                return new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), breakTime);
            }
            for (int time = 0; time < pattern.getNrTimes(); ++time) {
                for (int day = 0; day < pattern.getNrDays(); ++day) {
                    String pref = pattern.getPreference(day, time);
                    if (!pref.equals(PreferenceLevel.sRequired)) continue;
                    return new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, 0.77), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), pattern.getBreakTime());
                }
            }
        }
        if (c.getEffectiveTimePreferences().isEmpty()) {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ": no time preference set");
        } else {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ": no required time set");
        }
        return null;
    }

    public Vector makeupRooms(Class_ c) {
        Vector<RoomLocation> rooms = new Vector<RoomLocation>();
        for (RoomPref rp : c.getEffectiveRoomPreferences()) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) {
                this.iProgress.warn("        -- makup room for " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ": preference for " + rp.getRoom().getLabel() + " is not required");
                continue;
            }
            Location room = rp.getRoom();
            RoomLocation roomLocation = new RoomLocation(room.getUniqueId(), room.getLabel(), room instanceof Room ? ((Room)room).getBuilding().getUniqueId() : null, 0, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar().booleanValue(), null);
            rooms.addElement(roomLocation);
        }
        return rooms;
    }

    public Placement makeupPlacement(Class_ c) {
        TimeLocation time = this.makeupTime(c);
        if (time == null) {
            return null;
        }
        Vector rooms = this.makeupRooms(c);
        Vector<TimeLocation> times = new Vector<TimeLocation>(1);
        times.addElement(time);
        Lecture lecture = new Lecture(c.getUniqueId(), null, c.getSchedulingSubpart().getUniqueId(), c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName), times, (List)rooms, rooms.size(), new Placement(null, time, (List)rooms), 0, 0, 1.0);
        lecture.setNote(c.getNotes());
        Placement p = (Placement)lecture.getInitialAssignment();
        p.setAssignmentId(new Long(this.iMakeupAssignmentId++));
        lecture.setBestAssignment((Value)p, 0L);
        this.iProgress.trace("makup placement for " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ": " + p.getLongName(this.iUseAmPm));
        return p;
    }

    private int getCourseLimit(CourseOffering co) {
        if (!this.iCorrectConfigLimit) {
            int limit = 0;
            for (InstrOfferingConfig ioc : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                Integer snapShotLimit;
                if (ioc.isUnlimitedEnrollment().booleanValue()) {
                    return -1;
                }
                int configLimit = ioc.getLimit();
                if (this.iUseSnapShotLimits && (snapShotLimit = ioc.getSnapShotLimit()) != null && snapShotLimit > configLimit) {
                    configLimit = snapShotLimit;
                }
                limit += configLimit;
            }
            if (co.getReservation() != null) {
                limit = co.getReservation();
            }
            if (limit >= 9999) {
                return -1;
            }
            return limit;
        }
        int reservedDisabledSpace = 0;
        for (org.unitime.timetable.model.Reservation r : co.getInstructionalOffering().getReservations()) {
            int reservationLimit;
            StudentGroup gr;
            if (r instanceof LearningCommunityReservation && !((LearningCommunityReservation)r).getCourse().equals(co) || !(r instanceof StudentGroupReservation)) continue;
            if (!r.getClasses().isEmpty()) {
                boolean needDisabled = false;
                for (Class_ c : r.getClasses()) {
                    if (c.isEnabledForStudentScheduling().booleanValue()) continue;
                    needDisabled = true;
                }
                if (!needDisabled) continue;
            }
            if ((gr = ((StudentGroupReservation)r).getGroup()).getType() == null || gr.getType().getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.WithGroupReservation) continue;
            int n = r.getLimit() == null ? (this.iNoUnlimitedGroupReservations ? gr.getStudents().size() : -1) : (reservationLimit = r.getLimit().intValue());
            if (reservationLimit >= 0) {
                reservedDisabledSpace += reservationLimit;
                continue;
            }
            reservedDisabledSpace = -1;
            break;
        }
        int limit = 0;
        int limitDisabled = 0;
        boolean updated = false;
        for (InstrOfferingConfig ioc : co.getInstructionalOffering().getInstrOfferingConfigs()) {
            Integer snapShotLimit;
            if (ioc.isUnlimitedEnrollment().booleanValue()) {
                return -1;
            }
            int configLimit = ioc.getLimit();
            if (this.iUseSnapShotLimits && (snapShotLimit = ioc.getSnapShotLimit()) != null && snapShotLimit > configLimit) {
                configLimit = snapShotLimit;
            }
            int configEnabled = configLimit;
            for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
                int subpartEnabled = 0;
                int subpartDisabled = 0;
                for (Class_ c : subpart.getClasses()) {
                    int classLimit = this.getSectionLimit(c, false);
                    if (c.isCancelled().booleanValue()) {
                        classLimit = 0;
                        for (StudentClassEnrollment e : c.getStudentEnrollments()) {
                            if ((!this.iCheckForNoBatchStatus || !e.getStudent().hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) && (this.iStudentQuery == null || this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(e.getStudent())))) continue;
                            ++classLimit;
                        }
                    }
                    if (c.isEnabledForStudentScheduling().booleanValue()) {
                        subpartEnabled += classLimit;
                        continue;
                    }
                    subpartDisabled += classLimit;
                    for (StudentClassEnrollment e : c.getStudentEnrollments()) {
                        if ((!this.iCheckForNoBatchStatus || !e.getStudent().hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) && (this.iStudentQuery == null || this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(e.getStudent())))) continue;
                        ++subpartEnabled;
                        --subpartDisabled;
                    }
                }
                int subpartLimit = subpartEnabled + subpartDisabled;
                if (subpartLimit < configLimit) {
                    configLimit = subpartLimit;
                    updated = true;
                }
                if (subpartEnabled >= configEnabled) continue;
                configEnabled = subpartEnabled;
                updated = true;
            }
            limit += configEnabled;
            limitDisabled += configLimit - configEnabled;
        }
        if (limitDisabled > 0) {
            limit += Math.min(limitDisabled, reservedDisabledSpace);
        }
        if (updated && co.getReservation() == null) {
            this.iProgress.debug("Course limit of " + co.getCourseName() + " decreased to " + limit + " (disabled: " + limitDisabled + ", reserved: " + reservedDisabledSpace + ").");
        }
        if (co.getReservation() != null) {
            limit = co.getReservation();
        }
        if (limit >= 9999) {
            return -1;
        }
        return limit;
    }

    private int getConfigLimit(InstrOfferingConfig ioc) {
        Integer snapShotLimit;
        if (ioc.isUnlimitedEnrollment().booleanValue()) {
            return -1;
        }
        int configLimit = ioc.getLimit();
        if (configLimit >= 9999) {
            return -1;
        }
        if (this.iUseSnapShotLimits && (snapShotLimit = ioc.getSnapShotLimit()) != null && snapShotLimit > configLimit) {
            this.iProgress.debug("Using snapshot limit for " + ioc.getCourseName() + " [" + ioc.getName() + "] (limit: " + configLimit + ", snapshot: " + snapShotLimit + ")");
            configLimit = snapShotLimit;
        }
        if (!this.iCorrectConfigLimit) {
            return configLimit;
        }
        int reservedDisabledSpace = 0;
        for (org.unitime.timetable.model.Reservation r : ioc.getInstructionalOffering().getReservations()) {
            int reservationLimit;
            StudentGroup gr;
            if (!(r instanceof StudentGroupReservation) || !r.getConfigurations().isEmpty() && !r.getConfigurations().contains(ioc)) continue;
            if (!r.getClasses().isEmpty()) {
                boolean thisConfig = false;
                boolean needDisabled = false;
                for (Class_ c : r.getClasses()) {
                    if (c.getSchedulingSubpart().getInstrOfferingConfig().equals(ioc)) {
                        thisConfig = true;
                    }
                    if (c.isEnabledForStudentScheduling().booleanValue()) continue;
                    needDisabled = true;
                }
                if (!thisConfig || !needDisabled) continue;
            }
            if ((gr = ((StudentGroupReservation)r).getGroup()).getType() == null || gr.getType().getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.WithGroupReservation) continue;
            int n = r.getLimit() == null ? (this.iNoUnlimitedGroupReservations ? gr.getStudents().size() : -1) : (reservationLimit = r.getLimit().intValue());
            if (reservationLimit >= 0) {
                reservedDisabledSpace += reservationLimit;
                continue;
            }
            reservedDisabledSpace = -1;
            break;
        }
        for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
            int subpartEnabled = 0;
            int subpartDisabled = 0;
            for (Class_ c : subpart.getClasses()) {
                int classLimit = this.getSectionLimit(c, false);
                if (c.isCancelled().booleanValue()) {
                    classLimit = 0;
                    for (StudentClassEnrollment e : c.getStudentEnrollments()) {
                        if ((!this.iCheckForNoBatchStatus || !e.getStudent().hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) && (this.iStudentQuery == null || this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(e.getStudent())))) continue;
                        ++classLimit;
                    }
                }
                if (c.isEnabledForStudentScheduling().booleanValue()) {
                    subpartEnabled += classLimit;
                    continue;
                }
                subpartDisabled += classLimit;
                for (StudentClassEnrollment e : c.getStudentEnrollments()) {
                    if ((!this.iCheckForNoBatchStatus || !e.getStudent().hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) && (this.iStudentQuery == null || this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(e.getStudent())))) continue;
                    ++subpartEnabled;
                    --subpartDisabled;
                }
            }
            int subpartLimit = subpartEnabled + (reservedDisabledSpace < 0 ? subpartDisabled : Math.min(subpartDisabled, reservedDisabledSpace));
            if (subpartLimit >= configLimit) continue;
            configLimit = subpartLimit;
            this.iProgress.debug("Configuration limit of " + ioc.getCourseName() + " [" + ioc.getName() + "] decreased to " + configLimit + " (" + subpart.getItypeDesc().trim() + (subpart.getSchedulingSubpartSuffix() == null ? "" : " " + subpart.getSchedulingSubpartSuffix()) + " enabled: " + subpartEnabled + ", disabled: " + subpartDisabled + ", reserved: " + reservedDisabledSpace + ").");
        }
        return configLimit;
    }

    public int getSectionLimit(Class_ clazz, boolean infinityCheck) {
        int minLimit = clazz.getExpectedCapacity();
        int maxLimit = clazz.getMaxExpectedCapacity();
        if (this.iUseSnapShotLimits && clazz.getSnapshotLimit() != null) {
            if (minLimit < clazz.getSnapshotLimit()) {
                if (infinityCheck) {
                    this.iProgress.debug("Using snapshot limit for " + clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " (limit: " + clazz.getExpectedCapacity() + ", snapshot: " + clazz.getSnapshotLimit() + ")");
                }
                minLimit = clazz.getSnapshotLimit();
            }
            if (maxLimit < clazz.getSnapshotLimit()) {
                maxLimit = clazz.getSnapshotLimit();
            }
        }
        int classLimit = maxLimit;
        if (minLimit < maxLimit) {
            org.unitime.timetable.model.Assignment a = clazz.getCommittedAssignment();
            Placement p = null;
            if (this.iMakeupAssignmentsFromRequiredPrefs) {
                p = this.makeupPlacement(clazz);
            } else if (a != null) {
                p = a.getPlacement();
            }
            if (p != null) {
                int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                classLimit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
            }
        }
        if (infinityCheck && (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || classLimit >= 9999)) {
            return -1;
        }
        return classLimit;
    }

    private Offering loadOffering(InstructionalOffering io, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        if (io.getInstrOfferingConfigs().isEmpty()) {
            return null;
        }
        String courseName = io.getCourseName();
        Offering offering = new Offering(io.getUniqueId().longValue(), courseName);
        for (CourseOffering co : io.getCourseOfferings()) {
            if (!co.isAllowStudentScheduling()) continue;
            int projected = co.getProjectedDemand() == null ? 0 : co.getProjectedDemand();
            Course course = new Course(co.getUniqueId().longValue(), co.getSubjectArea().getSubjectAreaAbbreviation(), co.getCourseNbr(), offering, this.getCourseLimit(co), projected);
            if (co.getCredit() != null) {
                course.setCredit(co.getCredit().creditAbbv() + "|" + co.getCredit().creditText());
            }
            courseTable.put(co.getUniqueId(), course);
        }
        Hashtable<Long, Section> class2section = new Hashtable<Long, Section>();
        Hashtable<Long, Subpart> ss2subpart = new Hashtable<Long, Subpart>();
        DecimalFormat df = new DecimalFormat("000");
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            Config config = new Config(ioc.getUniqueId().longValue(), this.getConfigLimit(ioc), courseName + " [" + ioc.getName() + "]", offering);
            InstructionalMethod im = ioc.getEffectiveInstructionalMethod();
            if (im != null) {
                config.setInstructionalMethodId(im.getUniqueId());
                config.setInstructionalMethodName(im.getLabel());
                config.setInstructionalMethodReference(im.getReference());
            }
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator());
            subparts.addAll(ioc.getSchedulingSubparts());
            Iterator iterator = subparts.iterator();
            while (iterator.hasNext()) {
                Subpart parentSubpart;
                SchedulingSubpart ss = (SchedulingSubpart)iterator.next();
                String sufix = ss.getSchedulingSubpartSuffix();
                Subpart subpart = parentSubpart = ss.getParentSubpart() == null ? null : (Subpart)ss2subpart.get(ss.getParentSubpart().getUniqueId());
                if (ss.getParentSubpart() != null && parentSubpart == null) {
                    this.iProgress.error("Subpart " + ss.getSchedulingSubpartLabel() + " has parent " + ss.getSchedulingSubpartLabel() + ", but the appropriate parent subpart is not loaded.");
                }
                Subpart subpart2 = new Subpart(ss.getUniqueId().longValue(), df.format(ss.getItype().getItype()) + sufix, ss.getItype().getAbbv().trim() + (ioc.getInstructionalMethod() == null ? "" : " (" + ioc.getInstructionalMethod().getLabel() + ")"), config, parentSubpart);
                subpart2.setAllowOverlap(ss.isStudentAllowOverlap().booleanValue());
                if (ss.getCredit() != null) {
                    subpart2.setCredit(ss.getCredit().creditAbbv() + "|" + ss.getCredit().creditText());
                }
                ss2subpart.put(ss.getUniqueId(), subpart2);
                for (Class_ c : ss.getClasses()) {
                    int firstMeeting;
                    Section parentSection;
                    Section section = parentSection = c.getParentClass() == null ? null : (Section)class2section.get(c.getParentClass().getUniqueId());
                    if (c.getParentClass() != null && parentSection == null) {
                        this.iProgress.error("Class " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " has parent " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + ", but the appropriate parent section is not loaded.");
                    }
                    org.unitime.timetable.model.Assignment a = c.getCommittedAssignment();
                    Placement p = null;
                    if (this.iMakeupAssignmentsFromRequiredPrefs) {
                        p = this.makeupPlacement(c);
                    } else if (a != null) {
                        p = a.getPlacement();
                    }
                    if (p != null && p.getTimeLocation() != null) {
                        p.getTimeLocation().setDatePattern(p.getTimeLocation().getDatePatternId(), this.datePatternName(a.getDatePattern(), p.getTimeLocation()), p.getTimeLocation().getWeekCode());
                    }
                    Section section2 = new Section(c.getUniqueId().longValue(), this.getSectionLimit(c, true), c.getClassSuffix() == null ? c.getSectionNumberString() : c.getClassSuffix(), subpart2, p, this.getInstructors(c), parentSection);
                    if (this.iCheckEnabledForScheduling && !c.isEnabledForStudentScheduling().booleanValue()) {
                        section2.setEnabled(false);
                    }
                    if (this.iClassesFixedDateIndex > 0 && p != null && p.getTimeLocation() != null && p.getTimeLocation().getFirstMeeting(this.iDayOfWeekOffset) < this.iClassesFixedDateIndex) {
                        this.iProgress.info("Class " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " " + p.getLongName(this.iUseAmPm) + " starts before the fixed date, it is marked as disabled for student scheduling.");
                        section2.setEnabled(false);
                    }
                    if (this.iClassesFixedDateIndex > 0 && a == null && c.effectiveDatePattern() != null && (firstMeeting = c.effectiveDatePattern().getPatternBitSet().nextSetBit(0)) >= 0 && firstMeeting < this.iClassesFixedDateIndex) {
                        this.iProgress.info("Class " + c.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " Arranged Hours " + c.effectiveDatePattern().getName() + " starts before the fixed date, it is marked as disabled for student scheduling.");
                        section2.setEnabled(false);
                    }
                    for (CourseOffering course : io.getCourseOfferings()) {
                        String suffix = c.getClassSuffix(course);
                        if (suffix == null) continue;
                        section2.setName(course.getUniqueId().longValue(), suffix);
                    }
                    section2.setCancelled(c.isCancelled().booleanValue());
                    class2section.put(c.getUniqueId(), section2);
                    classTable.put(c.getUniqueId(), section2);
                }
            }
        }
        for (org.unitime.timetable.model.Reservation reservation : io.getReservations()) {
            Object type;
            ArrayList<Long> studentIds;
            Object r = null;
            if (reservation instanceof OverrideReservation) {
                studentIds = new ArrayList<Long>();
                for (org.unitime.timetable.model.Student student : ((IndividualReservation)reservation).getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = reservation.isAlwaysExpired() ? new ReservationOverride(reservation.getUniqueId().longValue(), offering, studentIds) : new org.cpsolver.studentsct.reservation.IndividualReservation(reservation.getUniqueId().longValue(), offering, studentIds);
                type = ((OverrideReservation)reservation).getOverrideType();
                r.setPriority(ApplicationProperty.ReservationPriorityOverride.intValue().intValue());
                r.setMustBeUsed(((ReservationInterface.OverrideType)((Object)type)).isMustBeUsed());
                r.setAllowOverlap(((ReservationInterface.OverrideType)((Object)type)).isAllowTimeConflict());
                r.setCanAssignOverLimit(((ReservationInterface.OverrideType)((Object)type)).isAllowOverLimit());
            } else if (reservation instanceof IndividualOverrideReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((IndividualReservation)reservation).getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = reservation.isAlwaysExpired() ? new ReservationOverride(reservation.getUniqueId().longValue(), offering, studentIds) : new org.cpsolver.studentsct.reservation.IndividualReservation(reservation.getUniqueId().longValue(), offering, studentIds);
                r.setPriority(reservation.getPriority());
                r.setMustBeUsed(reservation.isMustBeUsed());
                r.setAllowOverlap(reservation.isAllowOverlap());
                r.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
            } else if (reservation instanceof IndividualReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((IndividualReservation)reservation).getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = new org.cpsolver.studentsct.reservation.IndividualReservation(reservation.getUniqueId().longValue(), offering, studentIds);
                r.setPriority(ApplicationProperty.ReservationPriorityIndividual.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapIndividual.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitIndividual.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedIndividual.isTrue());
            } else if (reservation instanceof GroupOverrideReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((StudentGroupReservation)reservation).getGroup().getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = ((StudentGroupReservation)reservation).isAlwaysExpired() ? new ReservationOverride(reservation.getUniqueId().longValue(), offering, studentIds) : new GroupReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? (this.iNoUnlimitedGroupReservations ? (double)studentIds.size() : -1.0) : (double)reservation.getLimit().intValue(), offering, studentIds);
                r.setPriority(reservation.getPriority());
                r.setMustBeUsed(reservation.isMustBeUsed());
                r.setAllowOverlap(reservation.isAllowOverlap());
                r.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
                type = ((StudentGroupReservation)reservation).getGroup().getType();
                if (type != null && ((StudentGroupType)type).getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
                    r.setAllowDisabled(true);
                }
            } else if (reservation instanceof LearningCommunityReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((LearningCommunityReservation)reservation).getGroup().getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                CourseOffering co = ((LearningCommunityReservation)reservation).getCourse();
                for (Course course : offering.getCourses()) {
                    if (!co.getUniqueId().equals(course.getId())) continue;
                    r = new org.cpsolver.studentsct.reservation.LearningCommunityReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? (this.iNoUnlimitedGroupReservations ? (double)studentIds.size() : -1.0) : (double)reservation.getLimit().intValue(), course, studentIds);
                }
                r.setPriority(ApplicationProperty.ReservationPriorityLearningCommunity.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapLearningCommunity.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitLearningCommunity.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedLearningCommunity.isTrue());
                StudentGroupType studentGroupType = ((StudentGroupReservation)reservation).getGroup().getType();
                if (studentGroupType != null && studentGroupType.getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
                    r.setAllowDisabled(true);
                }
            } else if (reservation instanceof StudentGroupReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((StudentGroupReservation)reservation).getGroup().getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = new GroupReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? (this.iNoUnlimitedGroupReservations ? (double)studentIds.size() : -1.0) : (double)reservation.getLimit().intValue(), offering, studentIds);
                r.setPriority(ApplicationProperty.ReservationPriorityGroup.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapGroup.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitGroup.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedGroup.isTrue());
                type = ((StudentGroupReservation)reservation).getGroup().getType();
                if (type != null && ((StudentGroupType)type).getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
                    r.setAllowDisabled(true);
                }
            } else if (reservation instanceof CurriculumReservation) {
                Object clasf2;
                CurriculumReservation cr = (CurriculumReservation)reservation;
                ArrayList classifications = new ArrayList();
                for (Object clasf2 : cr.getClassifications()) {
                    classifications.add(((BaseAcademicClassification)clasf2).getCode());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                clasf2 = cr.getMajors().iterator();
                while (clasf2.hasNext()) {
                    PosMajor major = (PosMajor)clasf2.next();
                    arrayList.add(major.getCode());
                }
                r = new org.cpsolver.studentsct.reservation.CurriculumReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? -1.0 : (double)reservation.getLimit().intValue(), offering, cr.getArea().getAcademicAreaAbbreviation(), (Collection)classifications, arrayList);
                r.setPriority(ApplicationProperty.ReservationPriorityCurriculum.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue());
            } else if (reservation instanceof CourseReservation) {
                CourseOffering co = ((CourseReservation)reservation).getCourse();
                for (Course course : offering.getCourses()) {
                    if (!co.getUniqueId().equals(course.getId())) continue;
                    r = new org.cpsolver.studentsct.reservation.CourseReservation(reservation.getUniqueId().longValue(), course);
                }
                r.setPriority(ApplicationProperty.ReservationPriorityCourse.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCourse.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCourse.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCourse.isTrue());
            }
            if (r == null) {
                this.iProgress.warn("Failed to load reservation " + reservation.getUniqueId() + ".");
                continue;
            }
            r.setExpired(reservation.isExpired());
            block16: for (InstrOfferingConfig ioc : reservation.getConfigurations()) {
                for (Config config : offering.getConfigs()) {
                    if (!ioc.getUniqueId().equals(config.getId())) continue;
                    r.addConfig(config);
                    continue block16;
                }
            }
            block18: for (Class_ c : reservation.getClasses()) {
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (!c.getUniqueId().equals(section.getId())) continue;
                            r.addSection(section);
                            continue block18;
                        }
                    }
                }
            }
        }
        if (io.isByReservationOnly().booleanValue()) {
            new DummyReservation(offering);
        }
        return offering;
    }

    public void skipStudent(org.unitime.timetable.model.Student s, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        this.iProgress.debug("Skipping student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + NameFormat.defaultFormat().format(s) + ")");
        HashMap assignment = new HashMap();
        for (StudentClassEnrollment studentClassEnrollment : s.getClassEnrollments()) {
            Section section = classTable.get(studentClassEnrollment.getClazz().getUniqueId());
            Course course = courseTable.get(studentClassEnrollment.getCourseOffering().getUniqueId());
            if (section == null || course == null) continue;
            ArrayList<Section> sections = (ArrayList<Section>)assignment.get(course);
            if (sections == null) {
                Config config;
                sections = new ArrayList<Section>();
                assignment.put(course, sections);
                if (course.getLimit() > 0) {
                    course.setLimit(course.getLimit() - 1);
                }
                if ((config = section.getSubpart().getConfig()).getLimit() > 0) {
                    config.setLimit(config.getLimit() - 1);
                }
            }
            if (section.getLimit() > 0) {
                section.setLimit(section.getLimit() - 1);
            }
            sections.add(section);
        }
        for (Map.Entry entry : assignment.entrySet()) {
            org.cpsolver.studentsct.reservation.CurriculumReservation c;
            org.cpsolver.studentsct.reservation.LearningCommunityReservation g;
            Course course = (Course)entry.getKey();
            List sections = (List)entry.getValue();
            Reservation reservation = null;
            for (Reservation r : course.getOffering().getReservations()) {
                if (r.getReservationLimit() >= 0.0 && r.getReservationLimit() < 1.0 && !r.mustBeUsed()) continue;
                boolean applicable = false;
                if (r instanceof org.cpsolver.studentsct.reservation.LearningCommunityReservation) {
                    applicable = ((org.cpsolver.studentsct.reservation.LearningCommunityReservation)r).getStudentIds().contains(s.getUniqueId()) && course.equals((Object)((org.cpsolver.studentsct.reservation.LearningCommunityReservation)r).getCourse());
                } else if (r instanceof GroupReservation) {
                    applicable = ((GroupReservation)r).getStudentIds().contains(s.getUniqueId());
                } else if (r instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                    applicable = ((org.cpsolver.studentsct.reservation.IndividualReservation)r).getStudentIds().contains(s.getUniqueId());
                } else if (r instanceof org.cpsolver.studentsct.reservation.CourseReservation) {
                    applicable = course.equals((Object)((org.cpsolver.studentsct.reservation.CourseReservation)r).getCourse());
                } else if (r instanceof org.cpsolver.studentsct.reservation.CurriculumReservation) {
                    org.cpsolver.studentsct.reservation.CurriculumReservation c2 = (org.cpsolver.studentsct.reservation.CurriculumReservation)r;
                    for (StudentAreaClassificationMajor aac : s.getAreaClasfMajors()) {
                        if (!c2.getAcademicArea().equals(aac.getAcademicArea().getAcademicAreaAbbreviation()) || !c2.getClassifications().isEmpty() && !c2.getClassifications().contains(aac.getAcademicClassification().getCode()) || !c2.getMajors().isEmpty() && !c2.getMajors().contains(aac.getMajor().getCode())) continue;
                        applicable = true;
                        break;
                    }
                }
                if (!applicable) continue;
                if (!r.mustBeUsed()) {
                    boolean included = true;
                    for (Section section : sections) {
                        if (!r.getConfigs().isEmpty() && !r.getConfigs().contains(section.getSubpart().getConfig())) {
                            included = false;
                            break;
                        }
                        Set sectionsThisSubpart = r.getSections(section.getSubpart());
                        if (sectionsThisSubpart == null || sectionsThisSubpart.contains(section)) continue;
                        included = false;
                        break;
                    }
                    if (!included) continue;
                }
                if (reservation != null && r.compareTo(this.getAssignment(), reservation) >= 0) continue;
                reservation = r;
            }
            if (reservation == null) continue;
            if (reservation instanceof org.cpsolver.studentsct.reservation.LearningCommunityReservation) {
                g = (org.cpsolver.studentsct.reservation.LearningCommunityReservation)reservation;
                g.getStudentIds().remove(s.getUniqueId());
                if (!(g.getReservationLimit() >= 1.0) || g.getReservationLimit() == (double)g.getCourse().getLimit()) continue;
                g.setReservationLimit(g.getReservationLimit() - 1.0);
                continue;
            }
            if (reservation instanceof GroupReservation) {
                g = (GroupReservation)reservation;
                g.getStudentIds().remove(s.getUniqueId());
                if (!(g.getReservationLimit() >= 1.0)) continue;
                g.setReservationLimit(g.getReservationLimit() - 1.0);
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                org.cpsolver.studentsct.reservation.IndividualReservation i = (org.cpsolver.studentsct.reservation.IndividualReservation)reservation;
                i.getStudentIds().remove(s.getUniqueId());
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.CourseReservation || !(reservation instanceof org.cpsolver.studentsct.reservation.CurriculumReservation) || !((c = (org.cpsolver.studentsct.reservation.CurriculumReservation)reservation).getReservationLimit() >= 1.0)) continue;
            c.setReservationLimit(c.getReservationLimit() - 1.0);
        }
        this.updateCurriculumCounts(s);
    }

    protected void checkOverrideStatuses(org.hibernate.Session hibSession, List<org.unitime.timetable.model.Student> students) {
        ArrayList<org.unitime.timetable.model.Student> filteredStudents = new ArrayList<org.unitime.timetable.model.Student>();
        for (org.unitime.timetable.model.Student s : students) {
            if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch) || this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) continue;
            filteredStudents.add(s);
        }
        this.setPhase("Checking override statuses...", filteredStudents.size());
        OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(this.iOwnerId).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
        Collection<Long> updatedStudentIds = this.iValidationProvider.updateStudents(null, new OnlineSectioningHelper(hibSession, user), filteredStudents);
        if (updatedStudentIds != null) {
            this.iUpdatedStudents.addAll(updatedStudentIds);
        }
    }

    protected void validateOverrides(org.hibernate.Session hibSession, List<org.unitime.timetable.model.Student> students) {
        if (this.iNrValidationThreads <= 1) {
            this.setPhase("Validate overrides...", students.size());
            for (org.unitime.timetable.model.Student s : students) {
                this.incProgress();
                if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch) || this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) continue;
                this.validateOverrides(hibSession, s);
            }
        } else {
            ArrayList<org.unitime.timetable.model.Student> filteredStudents = new ArrayList<org.unitime.timetable.model.Student>();
            for (org.unitime.timetable.model.Student s : students) {
                if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch) || this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) continue;
                filteredStudents.add(s);
            }
            this.setPhase("Validate overrides...", filteredStudents.size());
            ArrayList<Worker> workers = new ArrayList<Worker>();
            Iterator<org.unitime.timetable.model.Student> iterator = filteredStudents.iterator();
            for (int i = 0; i < this.iNrValidationThreads; ++i) {
                workers.add(new Worker(hibSession, i, iterator));
            }
            for (Worker worker : workers) {
                worker.start();
            }
            for (Worker worker : workers) {
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    this.iCanContinue = false;
                    try {
                        worker.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.iCanContinue) {
                throw new RuntimeException("The validate was interrupted.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateOverrides(org.hibernate.Session hibSession, org.unitime.timetable.model.Student s) {
        if (this.iValidator == null) {
            this.iValidator = new StudentSolver(((StudentSectioningModel)this.getModel()).getProperties(), null);
            this.iValidator.setInitalSolution((Solution<Request, Enrollment>)new Solution(this.getModel(), this.getAssignment()));
        }
        OnlineSectioningLog.Action.Builder action = OnlineSectioningLog.Action.newBuilder();
        action.setOperation("validate-overrides");
        action.setSession(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iSessionId).setName(this.iTerm + this.iYear + this.iInitiative));
        action.setStartTime(System.currentTimeMillis());
        OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(this.iOwnerId).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
        action.setUser(user);
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(s.getUniqueId()).setExternalId(s.getExternalUniqueId()).setName(this.iStudentNameFormat.format(s)).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
        long c0 = OnlineSectioningHelper.getCpuTime();
        try {
            if (this.iValidationProvider.revalidateStudent(this.iValidator, new OnlineSectioningHelper(hibSession, user), s, action)) {
                this.iUpdatedStudents.add(s.getUniqueId());
                action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
            } else {
                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
            }
        }
        catch (Exception e) {
            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            if (e.getCause() != null) {
                action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
            } else {
                action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
            }
        }
        finally {
            action.setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            action.setEndTime(System.currentTimeMillis());
            OnlineSectioningLogger.getInstance().record(OnlineSectioningLog.Log.newBuilder().addAction(action).build());
        }
    }

    public Student loadStudent(org.hibernate.Session hibSession, org.unitime.timetable.model.Student s, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        if (this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) {
            this.skipStudent(s, courseTable, classTable);
            return null;
        }
        if (this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) {
            this.skipStudent(s, courseTable, classTable);
            return null;
        }
        this.iProgress.debug("Loading student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + this.iStudentNameFormat.format(s) + ")");
        Student student = new Student(s.getUniqueId().longValue());
        student.setExternalId(s.getExternalUniqueId());
        student.setName(this.iStudentNameFormat.format(s));
        student.setStatus(s.getSectioningStatus() == null ? null : s.getSectioningStatus().getReference());
        if (this.iPriorityStudentGroupReference != null) {
            for (StudentGroup g : s.getGroups()) {
                if (!this.iPriorityStudentGroupReference.equals(g.getGroupAbbreviation())) continue;
                student.setPriority(true);
            }
        }
        if (this.iLoadStudentInfo) {
            this.loadStudentInfo(student, s);
        }
        if (this.iShortDistanceAccomodationReference != null) {
            for (StudentAccomodation ac : s.getAccomodations()) {
                if (!this.iShortDistanceAccomodationReference.equals(ac.getAbbreviation())) continue;
                student.setNeedShortDistances(true);
            }
        }
        for (StudentGroup g : s.getGroups()) {
            StudentGroupType type = g.getType();
            if (type == null || type.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.AlwaysAllowed) continue;
            student.setAllowDisabled(true);
            break;
        }
        float maxCredit = this.iMaxDefaultCredit;
        if (s.getMaxCredit() != null) {
            maxCredit = s.getMaxCredit().floatValue();
        }
        if (s.getOverrideMaxCredit() != null) {
            if (s.isRequestApproved()) {
                maxCredit = s.getOverrideMaxCredit().floatValue();
            } else if (s.isRequestCancelled() && !this.iCheckRequestStatusSkipCancelled) {
                maxCredit = s.getOverrideMaxCredit().floatValue();
            } else if (s.isRequestPending() && !this.iCheckRequestStatusSkipPending) {
                maxCredit = s.getOverrideMaxCredit().floatValue();
            }
        }
        if (maxCredit > 0.0f) {
            student.setMaxCredit(Float.valueOf(maxCredit));
        }
        float minCredit = this.iMinDefaultCredit;
        if (s.getMinCredit() != null) {
            minCredit = s.getMinCredit().floatValue();
        }
        if (minCredit >= 0.0f && minCredit <= maxCredit) {
            student.setMinCredit(Float.valueOf(minCredit));
        }
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        HashSet<CourseOffering> alternatives = new HashSet<CourseOffering>();
        demands.addAll(s.getCourseDemands());
        float credit = 0.0f;
        for (CourseDemand cd : demands) {
            Section section;
            HashSet<Long> subparts;
            CourseCreditUnitConfig creditCfg;
            Object course;
            if (cd.getFreeTime() != null) {
                TimeLocation ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, Long.valueOf(-1L), "", this.iFreeTimePattern, 0);
                new FreeTimeRequest(cd.getUniqueId().longValue(), cd.getPriority().intValue(), cd.isAlternative().booleanValue(), student, ft);
                continue;
            }
            if (cd.getCourseRequests().isEmpty()) continue;
            Iterator<WaitList> courses = new Vector();
            HashSet<Choice> selChoices = new HashSet<Choice>();
            HashSet<Choice> reqChoices = new HashSet<Choice>();
            HashSet<Choice> wlChoices = new HashSet<Choice>();
            HashSet<Section> assignedSections = new HashSet<Section>();
            Config assignedConfig = null;
            TreeSet<org.unitime.timetable.model.CourseRequest> crs = new TreeSet<org.unitime.timetable.model.CourseRequest>(new Comparator<org.unitime.timetable.model.CourseRequest>(){

                @Override
                public int compare(org.unitime.timetable.model.CourseRequest r1, org.unitime.timetable.model.CourseRequest r2) {
                    return r1.getOrder().compareTo(r2.getOrder());
                }
            });
            crs.addAll(cd.getCourseRequests());
            float creditThisRequest = 0.0f;
            for (org.unitime.timetable.model.CourseRequest cr : crs) {
                if (cr.isRequestRejected() && cr.getClassEnrollments().isEmpty()) {
                    this.iProgress.info("Requested course " + cr.getCourseOffering().getCourseName() + " has rejected override for " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ")");
                    continue;
                }
                if (this.iCheckRequestStatusSkipCancelled && cr.isRequestCancelled() && cr.getClassEnrollments().isEmpty()) {
                    this.iProgress.info("Requested course " + cr.getCourseOffering().getCourseName() + " has cancelled override for " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ")");
                    continue;
                }
                if (this.iCheckRequestStatusSkipPending && cr.isRequestPending() && cr.getClassEnrollments().isEmpty()) {
                    this.iProgress.info("Requested course " + cr.getCourseOffering().getCourseName() + " has pending override for " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ")");
                    continue;
                }
                course = courseTable.get(cr.getCourseOffering().getUniqueId());
                if (course == null) {
                    this.iProgress.warn("Student " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + cr.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                creditCfg = cr.getCourseOffering().getCredit();
                if (creditCfg != null && creditThisRequest < creditCfg.getMinCredit()) {
                    creditThisRequest = creditCfg.getMinCredit();
                }
                for (ClassWaitList cwl : cr.getClassWaitLists()) {
                    Section section2 = course.getOffering().getSection(cwl.getClazz().getUniqueId().longValue());
                    if (section2 == null || !cwl.getType().equals(ClassWaitList.Type.LOCKED.ordinal())) continue;
                    wlChoices.add(section2.getChoice());
                }
                if (cr.getPreferences() != null) {
                    for (StudentSectioningPref p : cr.getPreferences()) {
                        boolean required = p.isRequired();
                        if (p instanceof StudentClassPref) {
                            StudentClassPref scp = (StudentClassPref)p;
                            Section section3 = course.getOffering().getSection(scp.getClazz().getUniqueId().longValue());
                            if (section3 == null) continue;
                            (required ? reqChoices : selChoices).add(section3.getChoice());
                            continue;
                        }
                        if (!(p instanceof StudentInstrMthPref)) continue;
                        StudentInstrMthPref imp = (StudentInstrMthPref)p;
                        for (Config config : course.getOffering().getConfigs()) {
                            if (config.getInstructionalMethodId() == null || !config.getInstructionalMethodId().equals(imp.getInstructionalMethod().getUniqueId())) continue;
                            (required ? reqChoices : selChoices).add(new Choice(config));
                        }
                    }
                }
                if (assignedConfig == null) {
                    subparts = new HashSet();
                    for (StudentClassEnrollment enrl : cr.getClassEnrollments()) {
                        section = course.getOffering().getSection(enrl.getClazz().getUniqueId().longValue());
                        if (section != null) {
                            if (((StudentSectioningModel)this.getModel()).isMPP()) {
                                selChoices.add(section.getChoice());
                                if (this.iAllowToKeepCurrentEnrollment && !reqChoices.isEmpty()) {
                                    reqChoices.add(new Choice(section));
                                    reqChoices.add(new Choice(section.getSubpart().getConfig()));
                                }
                            }
                            assignedSections.add(section);
                            if (assignedConfig != null && assignedConfig.getId() != section.getSubpart().getConfig().getId()) {
                                this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                            }
                            assignedConfig = section.getSubpart().getConfig();
                            if (subparts.add(section.getSubpart().getId())) continue;
                            this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart.");
                            continue;
                        }
                        this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): class " + enrl.getClazz().getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " not known.");
                    }
                }
                ((Vector)((Object)courses)).addElement((WaitList)course);
            }
            if (this.iAllowDefaultCourseAlternatives && crs.size() == 1 && !cd.isAlternative().booleanValue()) {
                CourseOffering co = crs.first().getCourseOffering();
                CourseOffering alt = co.getAlternativeOffering();
                if (alt != null) {
                    block9: for (CourseDemand d : demands) {
                        for (org.unitime.timetable.model.CourseRequest r : d.getCourseRequests()) {
                            if (!alt.equals(r.getCourseOffering())) continue;
                            alt = null;
                            break block9;
                        }
                    }
                }
                if (alt != null && alternatives.add(alt)) {
                    course = courseTable.get(alt.getUniqueId());
                    if (course == null) {
                        this.iProgress.warn("Course " + co.getCourseName() + "has an alternative course " + alt.getCourseName() + " that is not loaded (" + s.getExternalUniqueId() + ").");
                    } else {
                        creditCfg = alt.getCredit();
                        if (creditCfg != null && creditThisRequest < creditCfg.getMinCredit()) {
                            creditThisRequest = creditCfg.getMinCredit();
                        }
                        if (assignedConfig == null) {
                            subparts = new HashSet<Long>();
                            for (StudentClassEnrollment enrl : alt.getClassEnrollments(s)) {
                                section = course.getOffering().getSection(enrl.getClazz().getUniqueId().longValue());
                                if (section != null) {
                                    if (((StudentSectioningModel)this.getModel()).isMPP()) {
                                        selChoices.add(section.getChoice());
                                        if (this.iAllowToKeepCurrentEnrollment && !reqChoices.isEmpty()) {
                                            reqChoices.add(new Choice(section));
                                            reqChoices.add(new Choice(section.getSubpart().getConfig()));
                                        }
                                    }
                                    assignedSections.add(section);
                                    if (assignedConfig != null && assignedConfig.getId() != section.getSubpart().getConfig().getId()) {
                                        this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                                    }
                                    assignedConfig = section.getSubpart().getConfig();
                                    if (subparts.add(section.getSubpart().getId())) continue;
                                    this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart.");
                                    continue;
                                }
                                this.iProgress.error("There is a problem assigning " + course.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): class " + enrl.getClazz().getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " not known.");
                            }
                        }
                        ((Vector)((Object)courses)).addElement((WaitList)course);
                    }
                }
            }
            if (((Vector)((Object)courses)).isEmpty()) continue;
            CourseRequest request = new CourseRequest(cd.getUniqueId().longValue(), cd.getPriority().intValue(), cd.isAlternative() != false || this.iMaxCreditChecking && maxCredit > 0.0f && (credit += creditThisRequest) > maxCredit, student, courses, cd.isWaitlist().booleanValue(), cd.isCriticalOverride() != null ? cd.isCriticalOverride() : cd.isCritical() != null && cd.isCritical() != false, Long.valueOf(cd.getTimestamp().getTime()));
            request.getSelectedChoices().addAll(selChoices);
            request.getRequiredChoices().addAll(reqChoices);
            request.getWaitlistedChoices().addAll(wlChoices);
            if (assignedConfig != null && assignedSections.size() == assignedConfig.getSubparts().size()) {
                Enrollment enrollment = new Enrollment((Request)request, 0, assignedConfig, assignedSections, this.getAssignment());
                request.setInitialAssignment((Value)enrollment);
            }
            if (!cd.isAlternative().booleanValue() && maxCredit > 0.0f && credit > maxCredit) {
                if (this.iMaxCreditChecking) {
                    this.iProgress.info("Request " + request + " is treated as alternative (" + credit + " > " + maxCredit + ") for " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ")");
                } else {
                    this.iProgress.info("Request " + request + " is over the max cerdit limit for " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ")");
                }
            }
            if (assignedConfig == null || assignedSections.size() == assignedConfig.getSubparts().size()) continue;
            this.iProgress.error("There is a problem assigning " + request.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ") wrong number of classes (has " + assignedSections.size() + ", expected " + assignedConfig.getSubparts().size() + ").");
        }
        if (!s.getClassEnrollments().isEmpty() || !s.getWaitlists().isEmpty()) {
            Course course2;
            TreeSet<Course> courses = new TreeSet<Course>(new Comparator<Course>(){

                @Override
                public int compare(Course c1, Course c2) {
                    return (c1.getSubjectArea() + " " + c1.getCourseNumber()).compareTo(c2.getSubjectArea() + " " + c2.getCourseNumber());
                }
            });
            Hashtable<Long, Long> timeStamp = new Hashtable<Long, Long>();
            for (StudentClassEnrollment enrl : s.getClassEnrollments()) {
                if (enrl.getCourseRequest() != null || alternatives.contains(enrl.getCourseOffering())) continue;
                course2 = courseTable.get(enrl.getCourseOffering().getUniqueId());
                if (course2 == null) {
                    this.iProgress.warn("Student " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + enrl.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                if (enrl.getTimestamp() != null) {
                    timeStamp.put(enrl.getCourseOffering().getUniqueId(), enrl.getTimestamp().getTime());
                }
                courses.add(course2);
            }
            for (WaitList w : s.getWaitlists()) {
                course2 = courseTable.get(w.getCourseOffering().getUniqueId());
                if (course2 == null) {
                    this.iProgress.warn("Student " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + w.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                if (w.getTimestamp() != null) {
                    timeStamp.put(w.getCourseOffering().getUniqueId(), w.getTimestamp().getTime());
                }
                courses.add(course2);
            }
            int priority = 0;
            block14: for (Course course2 : courses) {
                Vector<Course> cx = new Vector<Course>();
                cx.add(course2);
                CourseRequest request = null;
                for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest) || this.getAssignment().getValue((Variable)r) != null || !((CourseRequest)r).getCourses().contains(course2)) continue;
                    request = (CourseRequest)r;
                    break;
                }
                if (request == null) {
                    request = new CourseRequest(course2.getId(), priority++, false, student, cx, true, (Long)timeStamp.get(course2.getId()));
                }
                HashSet<Section> assignedSections = new HashSet<Section>();
                Config assignedConfig = null;
                HashSet<Long> subparts = new HashSet<Long>();
                for (StudentClassEnrollment enrl : s.getClassEnrollments()) {
                    if (course2.getId() != enrl.getCourseOffering().getUniqueId().longValue()) continue;
                    Section section = course2.getOffering().getSection(enrl.getClazz().getUniqueId().longValue());
                    if (section != null) {
                        assignedSections.add(section);
                        if (assignedConfig != null && assignedConfig.getId() != section.getSubpart().getConfig().getId()) {
                            this.iProgress.error("There is a problem assigning " + request.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                            continue block14;
                        }
                        assignedConfig = section.getSubpart().getConfig();
                        if (subparts.add(section.getSubpart().getId())) continue;
                        this.iProgress.error("There is a problem assigning " + request.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart.");
                        continue block14;
                    }
                    this.iProgress.error("There is a problem assigning " + request.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): class " + enrl.getClazz().getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + " not known.");
                    Section x = classTable.get(enrl.getClazz().getUniqueId());
                    if (x == null) continue block14;
                    this.iProgress.info("  but a class with the same id is loaded, but under offering " + x.getSubpart().getConfig().getOffering().getName() + " (id is " + x.getSubpart().getConfig().getOffering().getId() + ", expected " + course2.getOffering().getId() + ")");
                    continue block14;
                }
                if (assignedConfig != null && assignedSections.size() == assignedConfig.getSubparts().size()) {
                    Enrollment enrollment = new Enrollment((Request)request, 0, assignedConfig, assignedSections, this.getAssignment());
                    request.setInitialAssignment((Value)enrollment);
                }
                if (assignedConfig == null || assignedSections.size() == assignedConfig.getSubparts().size()) continue;
                this.iProgress.error("There is a problem assigning " + request.getName() + " to " + this.iStudentNameFormat.format(s) + " (" + s.getExternalUniqueId() + "): wrong number of classes (has " + assignedSections.size() + ", expected " + assignedConfig.getSubparts().size() + ").");
            }
        }
        return student;
    }

    public void assignStudent(Student student) {
        for (Request r : student.getRequests()) {
            if (r.getInitialAssignment() == null || !student.isAvailable((Enrollment)r.getInitialAssignment()) || !r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment()).isEmpty()) continue;
            this.getAssignment().assign(0L, r.getInitialAssignment());
        }
    }

    public void checkForConflicts(Student student) {
        float credit = 0.0f;
        for (Request r : student.getRequests()) {
            if (this.getAssignment().getValue((Variable)r) != null || r.getInitialAssignment() == null || !(r instanceof CourseRequest)) continue;
            if (!student.isAvailable((Enrollment)r.getInitialAssignment())) {
                this.iProgress.error("There is a problem assigning " + r.getName() + " to " + student.getName() + " (" + student.getExternalId() + "): Student not available.");
                continue;
            }
            if (r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment()).isEmpty()) {
                this.getAssignment().assign(0L, r.getInitialAssignment());
                continue;
            }
            CourseRequest cr = (CourseRequest)r;
            Enrollment enrl = (Enrollment)r.getInitialAssignment();
            if (enrl != null) {
                credit += enrl.getCredit();
            }
            if ((this.iAllowToKeepCurrentEnrollment || this.iTweakLimits) && student.getId() >= 0L) {
                this.iProgress.info("There was a problem assigning " + cr.getName() + " to " + student.getName() + " (" + student.getExternalId() + ") ");
                boolean hasMustUse = false;
                for (Reservation reservation : enrl.getOffering().getReservations()) {
                    if (!reservation.isApplicable(student) || !reservation.mustBeUsed() || reservation.isExpired()) continue;
                    hasMustUse = true;
                }
                boolean hasLimit = false;
                boolean hasOverlap = false;
                boolean hasDisabled = false;
                for (Section section : enrl.getSections()) {
                    if (section.getTime() != null) {
                        block3: for (Request q : student.getRequests()) {
                            Enrollment enrlx = (Enrollment)this.getAssignment().getValue((Variable)q);
                            if (enrlx == null || !(q instanceof CourseRequest)) continue;
                            for (Section sectionx : enrlx.getSections()) {
                                if (sectionx.getTime() == null || !sectionx.isOverlapping((SctAssignment)section)) continue;
                                hasOverlap = true;
                                continue block3;
                            }
                        }
                    }
                    if (section.getLimit() >= 0 && section.getLimit() < 1 + section.getEnrollments(this.getAssignment()).size()) {
                        if (this.iTweakLimits) {
                            section.setLimit(section.getEnrollments(this.getAssignment()).size() + 1);
                            section.clearReservationCache();
                            this.iProgress.info("Limit of " + section.getSubpart().getConfig().getOffering().getName() + " section " + section.getSubpart().getName() + " " + section.getName() + " increased to " + section.getLimit());
                        } else {
                            hasLimit = true;
                        }
                    }
                    if (section.isEnabled()) continue;
                    hasDisabled = true;
                }
                if (enrl.getConfig().getLimit() >= 0 && enrl.getConfig().getLimit() < 1 + enrl.getConfig().getEnrollments(this.getAssignment()).size()) {
                    if (this.iTweakLimits) {
                        enrl.getConfig().setLimit(enrl.getConfig().getEnrollments(this.getAssignment()).size() + 1);
                        enrl.getConfig().clearReservationCache();
                        this.iProgress.info("Limit of " + enrl.getConfig().getOffering().getName() + " configuration " + enrl.getConfig().getName() + " increased to " + enrl.getConfig().getLimit());
                    } else {
                        hasLimit = true;
                    }
                }
                if (enrl.getCourse() != null && enrl.getCourse().getLimit() >= 0 && enrl.getCourse().getLimit() < 1 + enrl.getCourse().getEnrollments(this.getAssignment()).size()) {
                    if (this.iTweakLimits) {
                        enrl.getCourse().setLimit(enrl.getCourse().getEnrollments(this.getAssignment()).size() + 1);
                        this.iProgress.info("Limit of " + enrl.getConfig().getOffering().getName() + " course increased to " + enrl.getCourse().getLimit());
                    } else {
                        hasLimit = true;
                    }
                }
                if (this.iAllowToKeepCurrentEnrollment && student.hasMaxCredit() && credit > student.getMaxCredit()) {
                    student.setMaxCredit(Float.valueOf(credit));
                    this.iProgress.info("Max credit increased to " + credit + " for " + student.getName() + " (" + student.getExternalId() + ") ");
                }
                if (this.iAllowToKeepCurrentEnrollment) {
                    ReservationOverride reservation = new ReservationOverride(--this.iMakeupReservationId, enrl.getOffering(), new Long[]{student.getId()});
                    if (hasLimit) {
                        reservation.setCanAssignOverLimit(true);
                    }
                    if (hasOverlap) {
                        reservation.setAllowOverlap(true);
                    }
                    if (hasDisabled) {
                        reservation.setAllowDisabled(hasDisabled);
                    }
                    if (hasMustUse) {
                        reservation.setMustBeUsed(true);
                        reservation.setExpired(false);
                    } else {
                        reservation.setExpired(true);
                    }
                    TreeSet<String> props = new TreeSet<String>();
                    if (reservation.mustBeUsed()) {
                        props.add("mustBeUsed");
                    }
                    if (reservation.isAllowOverlap()) {
                        props.add("allowOverlap");
                    }
                    if (reservation.canAssignOverLimit()) {
                        props.add("allowOverLimit");
                    }
                    if (reservation.isAllowDisabled()) {
                        props.add("allowDisabled");
                    }
                    if (reservation.isExpired()) {
                        props.add("expired");
                    }
                    this.iProgress.info("Created an override reservation for " + cr.getName() + " of " + student.getName() + " (" + student.getExternalId() + ") " + props);
                    for (Section section : enrl.getSections()) {
                        reservation.addSection(section);
                    }
                }
                enrl.guessReservation(this.getAssignment(), true);
                if (r.getModel().conflictValues(this.getAssignment(), (Value)enrl).isEmpty()) {
                    this.getAssignment().assign(0L, (Value)enrl);
                    continue;
                }
            }
            this.iProgress.error("There is a problem assigning " + cr.getName() + " to " + student.getName() + " (" + student.getExternalId() + ")");
            boolean hasLimit = false;
            boolean hasOverlap = false;
            for (Section section : enrl.getSections()) {
                this.iProgress.info("  " + section.getSubpart().getName() + " " + section.getName() + (section.getTime() == null ? "" : " " + section.getTime().getLongName(this.iUseAmPm)));
                if (section.getTime() != null) {
                    for (Request q : student.getRequests()) {
                        Enrollment enrlx = (Enrollment)this.getAssignment().getValue((Variable)q);
                        if (enrlx == null || !(q instanceof CourseRequest)) continue;
                        for (Section sectionx : enrlx.getSections()) {
                            if (sectionx.getTime() == null || !sectionx.isOverlapping((SctAssignment)section)) continue;
                            this.iProgress.info("    overlaps with " + sectionx.getSubpart().getConfig().getOffering().getName() + " " + sectionx.getSubpart().getName() + " " + sectionx.getName() + " " + sectionx.getTime().getLongName(this.iUseAmPm));
                            hasOverlap = true;
                        }
                    }
                }
                if (section.getLimit() < 0 || section.getLimit() >= 1 + section.getEnrollments(this.getAssignment()).size()) continue;
                this.iProgress.info("    has no space available (limit is " + section.getLimit() + ")");
                hasLimit = true;
            }
            if (enrl.getConfig().getLimit() >= 0 && enrl.getConfig().getLimit() < 1 + enrl.getConfig().getEnrollments(this.getAssignment()).size()) {
                this.iProgress.info("  config " + enrl.getConfig().getName() + " has no space available (limit is " + enrl.getConfig().getLimit() + ")");
                hasLimit = true;
            }
            if (enrl.getCourse() != null && enrl.getCourse().getLimit() >= 0 && enrl.getCourse().getLimit() < 1 + enrl.getCourse().getEnrollments(this.getAssignment()).size()) {
                this.iProgress.info("  course " + enrl.getCourse().getName() + " has no space available (limit is " + enrl.getCourse().getLimit() + ")");
                hasLimit = true;
            }
            if (hasLimit || hasOverlap) continue;
            for (Map.Entry e : r.getModel().conflictConstraints(this.getAssignment(), r.getInitialAssignment()).entrySet()) {
                for (Enrollment enrlx : (Set)e.getValue()) {
                    for (Section sectionx : enrlx.getSections()) {
                        this.iProgress.info("    conflicts with " + sectionx.getSubpart().getConfig().getOffering().getName() + " " + sectionx.getSubpart().getName() + " " + sectionx.getName() + (sectionx.getTime() == null ? "" : " " + sectionx.getTime().getLongName(this.iUseAmPm)) + " due to " + ((Constraint)e.getKey()).getClass().getSimpleName());
                    }
                    if (enrlx.getRequest().getStudent().getId() == student.getId()) continue;
                    this.iProgress.info("    of a different student (" + enrlx.getRequest().getStudent().getExternalId() + ")");
                }
            }
        }
    }

    public void reorderStudentRequests(Student student) {
        int assigned = 0;
        int critical = 0;
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            if (r.getInitialAssignment() != null && this.getAssignment().getValue((Variable)r) != null) {
                ++assigned;
            }
            if (!r.isCritical() || r.isAlternative()) continue;
            ++critical;
        }
        if (((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments() && assigned > 0 || this.iMoveCriticalCoursesUp && critical > 0) {
            Collections.sort(student.getRequests(), new Comparator<Request>(){

                @Override
                public int compare(Request r1, Request r2) {
                    if (r1.isAlternative() != r2.isAlternative()) {
                        return r1.isAlternative() ? 1 : -1;
                    }
                    if (((StudentSectioningModel)StudentSectioningDatabaseLoader.this.getModel()).isMPP() && ((StudentSectioningModel)StudentSectioningDatabaseLoader.this.getModel()).getKeepInitialAssignments()) {
                        boolean a2;
                        boolean a1 = r1 instanceof CourseRequest && r1.getInitialAssignment() != null && StudentSectioningDatabaseLoader.this.getAssignment().getValue((Variable)r1) != null;
                        boolean bl = a2 = r2 instanceof CourseRequest && r2.getInitialAssignment() != null && StudentSectioningDatabaseLoader.this.getAssignment().getValue((Variable)r2) != null;
                        if (a1 != a2) {
                            return a1 ? -1 : 1;
                        }
                    }
                    if (StudentSectioningDatabaseLoader.this.iMoveCriticalCoursesUp) {
                        boolean c2;
                        boolean c1 = r1 instanceof CourseRequest && r1.isCritical();
                        boolean bl = c2 = r2 instanceof CourseRequest && r2.isCritical();
                        if (c1 != c2) {
                            return c1 ? -1 : 1;
                        }
                    }
                    return r1.getPriority() < r2.getPriority() ? -1 : 1;
                }
            });
            int p = 0;
            for (Request r : student.getRequests()) {
                r.setPriority(p++);
            }
        }
    }

    private String curriculum(Student student) {
        if (!student.getAreaClassificationMajors().isEmpty()) {
            AreaClassificationMajor acm = (AreaClassificationMajor)student.getAreaClassificationMajors().get(0);
            return acm.getArea() + ":" + acm.getClassification() + ":" + acm.getMajor();
        }
        return (student.getAcademicAreaClasiffications().isEmpty() ? "" : ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(0)).getArea() + ":" + ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(0)).getCode()) + ":" + (student.getMajors().isEmpty() ? "" : ((AcademicAreaCode)student.getMajors().get(0)).getCode());
    }

    private String curriculum(org.unitime.timetable.model.Student student) {
        String curriculum = "";
        Iterator<StudentAreaClassificationMajor> iterator = student.getAreaClasfMajors().iterator();
        if (iterator.hasNext()) {
            StudentAreaClassificationMajor aac = iterator.next();
            return aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getAcademicClassification().getCode() + ":" + aac.getMajor().getCode();
        }
        return curriculum;
    }

    private void updateCurriculumCounts(Student student) {
        String curriculum = this.curriculum(student);
        for (Request request : student.getRequests()) {
            Integer cx;
            if (!(request instanceof CourseRequest)) continue;
            Course course = request.getInitialAssignment() != null ? ((Enrollment)request.getInitialAssignment()).getCourse() : (Course)((CourseRequest)request).getCourses().get(0);
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(course.getId());
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(course.getId(), c2w);
            }
            c2w.put(curriculum, 1 + ((cx = c2w.get(curriculum)) == null ? 0 : cx));
        }
    }

    private void updateCurriculumCounts(org.unitime.timetable.model.Student student) {
        String curriculum = this.curriculum(student);
        HashSet<Long> courses = new HashSet<Long>();
        for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
            Integer cx;
            Long courseId = enrollment.getCourseOffering().getUniqueId();
            if (!courses.add(courseId)) continue;
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(courseId);
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(courseId, c2w);
            }
            c2w.put(curriculum, 1 + ((cx = (Integer)c2w.get(curriculum)) == null ? 0 : cx));
        }
        block1: for (CourseDemand demand : student.getCourseDemands()) {
            Integer cx;
            BaseCourseRequest request = null;
            for (org.unitime.timetable.model.CourseRequest r : demand.getCourseRequests()) {
                if (courses.contains(r.getCourseOffering().getUniqueId())) continue block1;
                if (request != null && r.getOrder() >= request.getOrder()) continue;
                request = r;
            }
            if (request == null) continue;
            Long courseId = request.getCourseOffering().getUniqueId();
            courses.add(courseId);
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(courseId);
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(courseId, c2w);
            }
            c2w.put(curriculum, 1 + ((cx = c2w.get(curriculum)) == null ? 0 : cx));
        }
    }

    private void fixWeights(org.hibernate.Session hibSession, Collection<Course> courses) {
        this.setPhase("Computing projected request weights...", courses.size());
        for (Course course : courses) {
            this.incProgress();
            Map<String, Integer> cur2real = this.iCourse2Curricula2Weight.get(course.getId());
            if (cur2real != null) {
                Object real;
                Hashtable<String, Double> cur2proj = new Hashtable<String, Double>();
                for (CourseRequest request : course.getRequests()) {
                    if (!((Course)request.getCourses().get(0)).equals((Object)course) || !request.getStudent().isDummy()) continue;
                    Double proj = (Double)cur2proj.get(this.curriculum(request.getStudent()));
                    cur2proj.put(this.curriculum(request.getStudent()), request.getWeight() + (proj == null ? 0.0 : proj));
                }
                for (String cur : cur2proj.keySet()) {
                    double proj = (Double)cur2proj.get(cur);
                    real = cur2real.get(cur);
                    if (real == null) continue;
                    this.iProgress.debug("Projected demands for course " + course.getName() + ": " + cur.replace(':', ' ') + " multiplies by " + ((double)((Integer)real).intValue() >= proj ? 0.0 : (proj - (double)((Integer)real).intValue()) / proj) + " (projected=" + proj + ", real=" + real + ")");
                }
                for (CourseRequest request : course.getRequests()) {
                    if (!((Course)request.getCourses().get(0)).equals((Object)course) || !request.getStudent().isDummy()) continue;
                    double proj = (Double)cur2proj.get(this.curriculum(request.getStudent()));
                    real = cur2real.get(this.curriculum(request.getStudent()));
                    if (real == null) continue;
                    request.setWeight(request.getWeight() * ((double)((Integer)real).intValue() >= proj ? 0.0 : (proj - (double)((Integer)real).intValue()) / proj));
                }
            }
            double nrStudents = 0.0;
            double nrLastLike = 0.0;
            int lastLikeCount = 0;
            for (CourseRequest request : course.getRequests()) {
                if (!((Course)request.getCourses().get(0)).equals((Object)course)) continue;
                nrStudents += request.getWeight();
                if (!request.getStudent().isDummy()) continue;
                nrLastLike += request.getWeight();
                ++lastLikeCount;
            }
            double projected = course.getProjected();
            double limit = course.getLimit();
            if (limit >= 9999.0) {
                limit = -1.0;
            }
            int configLimit = 0;
            for (Config config : course.getOffering().getConfigs()) {
                if (config.getLimit() < 0 || config.getLimit() >= 9999) {
                    configLimit = -1;
                    break;
                }
                int cLimit = config.getLimit();
                for (Subpart subpart : config.getSubparts()) {
                    int subpartLimit = 0;
                    for (Section section : subpart.getSections()) {
                        if (section.getLimit() < 0 || section.getLimit() >= 9999) {
                            subpartLimit = -1;
                            break;
                        }
                        subpartLimit += section.getLimit();
                    }
                    if (subpartLimit < 0 || subpartLimit >= cLimit) continue;
                    cLimit = subpartLimit;
                }
                configLimit += cLimit;
            }
            if (course.getOffering().getCourses().size() > 1) {
                int offeringLimit = 0;
                for (Course c : course.getOffering().getCourses()) {
                    if (c.getLimit() < 0 || c.getLimit() >= 9999) {
                        offeringLimit = -1;
                        break;
                    }
                    offeringLimit += c.getLimit();
                }
                if (configLimit >= 0 && configLimit < offeringLimit) {
                    limit = limit * (double)configLimit / (double)offeringLimit;
                } else if (configLimit >= 0 && offeringLimit < 0) {
                    limit = configLimit / course.getOffering().getCourses().size();
                }
            } else if (configLimit >= 0 && ((double)configLimit < limit || limit < 0.0)) {
                limit = configLimit;
            }
            if (limit < 0.0) {
                this.iProgress.debug("Course " + course.getName() + " is unlimited.");
                continue;
            }
            if (projected <= 0.0) {
                this.iProgress.info("No projected demand for course " + course.getName() + ", using course limit (" + Math.round(limit) + ")");
                projected = limit;
            } else if (limit < projected) {
                if (!this.iProjections) {
                    this.iProgress.info("Projected number of students is over course limit for course " + course.getName() + " (" + Math.round(projected) + ">" + Math.round(limit) + ")");
                }
                projected = limit;
            }
            if (lastLikeCount <= 0) {
                this.iProgress.info("No projected course demands for course " + course.getName());
                continue;
            }
            double weight = nrLastLike <= 0.0 ? 0.0 : Math.max(0.0, projected - (nrStudents - nrLastLike)) / nrLastLike;
            this.iProgress.debug("Projected student weight for " + course.getName() + " is " + weight + " (projected=" + nrLastLike + ", real=" + (nrStudents - nrLastLike) + ", limit=" + projected + ")");
            int left = 0;
            for (CourseRequest request : new ArrayList(course.getRequests())) {
                if (!request.getStudent().isDummy()) continue;
                request.setWeight(weight * request.getWeight());
                if (request.getWeight() <= 0.0) {
                    Student student = request.getStudent();
                    ((StudentSectioningModel)this.getModel()).removeVariable((Request)request);
                    student.getRequests().remove(request);
                    for (Course c : request.getCourses()) {
                        c.getRequests().remove(request);
                    }
                    if (!student.getRequests().isEmpty()) continue;
                    ((StudentSectioningModel)this.getModel()).removeStudent(student);
                    continue;
                }
                ++left;
            }
            if (left > 0) continue;
            this.iProgress.info("No projected course demands needed for course " + course.getName());
        }
        ((StudentSectioningModel)this.getModel()).requestWeightsChanged(this.getAssignment());
    }

    public void loadStudentInfo(Student student, org.unitime.timetable.model.Student s) {
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : s.getAreaClasfMajors()) {
            student.getAreaClassificationMajors().add(new AreaClassificationMajor(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getMajor().getCode()));
        }
        for (StudentGroup studentGroup : s.getGroups()) {
            student.getMinors().add(new AcademicAreaCode(studentGroup.getType() == null ? "" : studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName()));
        }
        for (StudentAccomodation studentAccomodation : s.getAccomodations()) {
            student.getMinors().add(new AcademicAreaCode("A", studentAccomodation.getAbbreviation(), studentAccomodation.getName()));
        }
        for (Advisor advisor : s.getAdvisors()) {
            student.getAdvisors().add(new Instructor(0L, advisor.getExternalUniqueId(), advisor.getLastName() == null ? null : this.iInstructorNameFormat.format(advisor), advisor.getEmail()));
        }
    }

    public void loadRequestGroups(Student student, org.unitime.timetable.model.Student s) {
        for (StudentGroup g : s.getGroups()) {
            if (this.iRequestGroupRegExp != null && !this.iRequestGroupRegExp.isEmpty() && !g.getGroupName().matches(this.iRequestGroupRegExp) || g.getType() != null && !g.getType().isKeepTogether().booleanValue()) continue;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                Course course = (Course)cr.getCourses().get(0);
                RequestGroup group = null;
                for (RequestGroup rg : course.getRequestGroups()) {
                    if (rg.getId() != g.getUniqueId().longValue()) continue;
                    group = rg;
                    break;
                }
                if (group == null) {
                    group = new RequestGroup(g.getUniqueId().longValue(), g.getGroupName(), course);
                }
                cr.addRequestGroup(group);
            }
        }
    }

    public static BitSet getFreeTimeBitSet(Session session) {
        int startMonth = session.getPatternStartMonth();
        int endMonth = session.getPatternEndMonth();
        int size = DateUtils.getDayOfYear(0, endMonth + 1, session.getSessionStartYear()) - DateUtils.getDayOfYear(1, startMonth, session.getSessionStartYear());
        BitSet ret = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            ret.set(i);
        }
        return ret;
    }

    private String datePatternName(DatePattern dp, TimeLocation time) {
        int idx;
        if ("never".equals(this.iDatePatternFormat)) {
            return dp.getName();
        }
        if ("extended".equals(this.iDatePatternFormat) && dp.getType() != 3) {
            return dp.getName();
        }
        if ("alternate".equals(this.iDatePatternFormat) && dp.getType() == 1) {
            return dp.getName();
        }
        if (time.getWeekCode().isEmpty()) {
            return time.getDatePatternName();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(this.iDatePatternFirstDate);
        cal.add(6, idx);
        Date first = null;
        for (idx = time.getWeekCode().nextSetBit(0); idx < time.getWeekCode().size() && first == null; ++idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return time.getDatePatternName();
        }
        cal.setTime(this.iDatePatternFirstDate);
        cal.add(6, idx);
        Date last = null;
        for (idx = time.getWeekCode().length() - 1; idx >= 0 && last == null; --idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return time.getDatePatternName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public static Date getDatePatternFirstDay(Session s) {
        return DateUtils.getDate(1, s.getPatternStartMonth(), s.getSessionStartYear());
    }

    public static List<Collection<Section>> getSections(DistributionPref pref, SectionProvider classTable) {
        ArrayList<Collection<Section>> ret = new ArrayList<Collection<Section>>();
        DistributionPref.Structure structure = pref.getStructure();
        if (structure == null) {
            structure = DistributionPref.Structure.AllClasses;
        }
        if (structure == DistributionPref.Structure.Progressive) {
            int maxSize = 0;
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    maxSize = Math.max(maxSize, 1);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                maxSize = Math.max(maxSize, ((SchedulingSubpart)distributionObject.getPrefGroup()).getClasses().size());
            }
            Set[] sections = new Set[maxSize];
            for (int i = 0; i < sections.length; ++i) {
                sections[i] = new HashSet();
            }
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(pref.getDistributionObjects());
            Collections.sort(distributionObjects, new TimetableDatabaseLoader.ChildrenFirstDistributionObjectComparator());
            for (DistributionObject distributionObject : distributionObjects) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section == null) continue;
                    for (int j = 0; j < sections.length; ++j) {
                        sections[j].add(section);
                    }
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (int j = 0; j < sections.length; ++j) {
                    Section section = null;
                    block11: for (Section s : sections[j]) {
                        for (Section p = s.getParent(); p != null; p = p.getParent()) {
                            if (p.getSubpart().getId() != subpart.getUniqueId().longValue()) continue;
                            section = s;
                            break block11;
                        }
                    }
                    if (section == null) {
                        section = classTable.get(((Class_)classes.get(j % classes.size())).getUniqueId());
                    }
                    if (section == null) continue;
                    sections[j].add(section);
                }
            }
            for (Set s : sections) {
                ret.add(s);
            }
        } else if (structure == DistributionPref.Structure.OneOfEach) {
            ArrayList<Section> sections = new ArrayList<Section>();
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                int count = 0;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section != null) {
                        sections.add(section);
                        ++count;
                    }
                } else if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Section section = classTable.get(clazz.getUniqueId());
                        if (section == null) continue;
                        sections.add(section);
                        ++count;
                    }
                }
                if (count <= 0) continue;
                counts.add(count);
            }
            if (counts.size() > 1) {
                Enumeration e = DistributionPref.permutations(sections, counts);
                while (e.hasMoreElements()) {
                    ret.add(e.nextElement());
                }
            }
        } else {
            ArrayList<Section> sections = new ArrayList<Section>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section == null) continue;
                    sections.add(section);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ clazz : classes) {
                    Section section = classTable.get(clazz.getUniqueId());
                    if (section == null) continue;
                    sections.add(section);
                }
            }
            if (structure == DistributionPref.Structure.Pairwise) {
                if (sections.size() >= 2) {
                    for (int idx1 = 0; idx1 < sections.size() - 1; ++idx1) {
                        Section s1 = (Section)sections.get(idx1);
                        for (int idx2 = idx1 + 1; idx2 < sections.size(); ++idx2) {
                            Section s2 = (Section)sections.get(idx2);
                            HashSet<Section> s = new HashSet<Section>();
                            s.add(s1);
                            s.add(s2);
                            ret.add(s);
                        }
                    }
                }
            } else if (structure == DistributionPref.Structure.AllClasses) {
                ret.add(sections);
            } else {
                int grouping = 2;
                switch (structure) {
                    case GroupsOfTwo: {
                        grouping = 2;
                        break;
                    }
                    case GroupsOfThree: {
                        grouping = 3;
                        break;
                    }
                    case GroupsOfFour: {
                        grouping = 4;
                        break;
                    }
                    case GroupsOfFive: {
                        grouping = 5;
                    }
                }
                ArrayList<Section> s = new ArrayList<Section>();
                for (Section section : sections) {
                    s.add(section);
                    if (s.size() != grouping) continue;
                    ret.add(s);
                    s = new ArrayList();
                }
                if (s.size() >= 2) {
                    ret.add(new HashSet(s));
                }
            }
        }
        return ret;
    }

    public void load(Session session, org.hibernate.Session hibSession) {
        List distPrefs;
        Student student;
        this.iFreeTimePattern = StudentSectioningDatabaseLoader.getFreeTimeBitSet(session);
        this.iDatePatternFirstDate = StudentSectioningDatabaseLoader.getDatePatternFirstDay(session);
        Hashtable<Long, Course> courseTable = new Hashtable<Long, Course>();
        final Hashtable<Long, Section> classTable = new Hashtable<Long, Section>();
        List offerings = hibSession.createQuery("select distinct io from InstructionalOffering io left join io.courseOfferings as co left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c left join fetch io.reservations as r where io.session.uniqueId = :sessionId and io.notOffered = false and co.subjectArea.department.allowStudentScheduling = true").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
        this.setPhase("Loading course offerings...", offerings.size());
        for (InstructionalOffering io : offerings) {
            this.incProgress();
            Object offering = this.loadOffering(io, courseTable, classTable);
            if (offering == null) continue;
            ((StudentSectioningModel)this.getModel()).addOffering((Offering)offering);
        }
        HashMap<String, Student> ext2student = new HashMap<String, Student>();
        if (this.iIncludeCourseDemands || this.iProjections) {
            List students = hibSession.createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cw left join fetch s.classEnrollments as e left join fetch s.waitlists as w " + (this.iLoadStudentInfo ? "left join fetch s.areaClasfMajors as a left join fetch s.groups as g " : "") + "where s.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
            if (this.iValidateOverrides && this.iValidationProvider != null) {
                this.validateOverrides(hibSession, students);
            } else if (this.iCheckOverrideStatus && this.iValidationProvider != null) {
                this.checkOverrideStatuses(hibSession, students);
            }
            if (this.iCheckCriticalCourses) {
                this.checkCriticalCourses(hibSession, students);
            }
            this.setPhase("Loading student requests...", students.size());
            Iterator i = students.iterator();
            while (i.hasNext()) {
                Student student2;
                org.unitime.timetable.model.Student s = (org.unitime.timetable.model.Student)i.next();
                this.incProgress();
                if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || (student2 = this.loadStudent(hibSession, s, courseTable, classTable)) == null) continue;
                this.updateCurriculumCounts(student2);
                if (this.iProjections) {
                    for (Request request : student2.getRequests()) {
                        if (request.getInitialAssignment() != null && ((Enrollment)request.getInitialAssignment()).isCourseRequest()) {
                            Enrollment enrollment = (Enrollment)request.getInitialAssignment();
                            if (enrollment.getConfig().getLimit() > 0) {
                                enrollment.getConfig().setLimit(enrollment.getConfig().getLimit() - 1);
                            }
                            for (Object section : enrollment.getSections()) {
                                if (section.getLimit() <= 0) continue;
                                section.setLimit(section.getLimit() - 1);
                            }
                            if (enrollment.getCourse() != null && enrollment.getCourse().getLimit() > 0) {
                                enrollment.getCourse().setLimit(enrollment.getCourse().getLimit() - 1);
                            }
                            if (enrollment.getReservation() != null) {
                                if (enrollment.getReservation() instanceof GroupReservation && enrollment.getReservation().getReservationLimit() >= 1.0) {
                                    ((GroupReservation)enrollment.getReservation()).getStudentIds().remove(student2.getId());
                                    ((GroupReservation)enrollment.getReservation()).setReservationLimit(((GroupReservation)enrollment.getReservation()).getReservationLimit() - 1.0);
                                } else if (enrollment.getReservation() instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                                    ((org.cpsolver.studentsct.reservation.IndividualReservation)enrollment.getReservation()).getStudentIds().remove(student2.getId());
                                } else if (enrollment.getReservation() instanceof org.cpsolver.studentsct.reservation.CurriculumReservation && enrollment.getReservation().getReservationLimit() >= 1.0) {
                                    ((org.cpsolver.studentsct.reservation.CurriculumReservation)enrollment.getReservation()).setReservationLimit(enrollment.getReservation().getReservationLimit() - 1.0);
                                }
                            }
                        }
                        if (!(request instanceof CourseRequest)) continue;
                        for (Course course : ((CourseRequest)request).getCourses()) {
                            course.getRequests().remove(request);
                        }
                    }
                    continue;
                }
                if (this.iLoadRequestGroups) {
                    this.loadRequestGroups(student2, s);
                }
                if (student2.getExternalId() != null && !student2.getExternalId().isEmpty()) {
                    ext2student.put(student2.getExternalId(), student2);
                }
                ((StudentSectioningModel)this.getModel()).addStudent(student2);
            }
        }
        if (this.iIncludeUnavailabilities) {
            this.setPhase("Loading unavailabilities...", offerings.size());
            for (Object offering : offerings) {
                this.incProgress();
                for (InstrOfferingConfig config : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs()) {
                    for (SchedulingSubpart schedulingSubpart : config.getSchedulingSubparts()) {
                        for (Class_ clazz : schedulingSubpart.getClasses()) {
                            Object section;
                            section = classTable.get(clazz.getUniqueId());
                            if (section == null || section.isCancelled() || section.getTime() == null) continue;
                            for (ClassInstructor ci : clazz.getClassInstructors()) {
                                boolean canOverlap;
                                Student student3;
                                if (ci.getInstructor().getExternalUniqueId() == null || ci.getInstructor().getExternalUniqueId().isEmpty() || (student3 = (Student)ext2student.get(ci.getInstructor().getExternalUniqueId())) == null) continue;
                                boolean bl = canOverlap = ci.isLead() == false;
                                if (ci.getTeachingRequest() != null) {
                                    for (TeachingClassRequest teachingClassRequest : ci.getTeachingRequest().getClassRequests()) {
                                        if (!teachingClassRequest.getTeachingClass().equals(ci.getClassInstructing())) continue;
                                        canOverlap = teachingClassRequest.isCanOverlap();
                                        break;
                                    }
                                }
                                new Unavailability(student3, (Section)section, canOverlap);
                            }
                            for (TeachingClassRequest tcr : clazz.getTeachingRequests()) {
                                if (tcr.isAssignInstructor().booleanValue() || !tcr.getTeachingRequest().isCommitted()) continue;
                                for (DepartmentalInstructor di : tcr.getTeachingRequest().getAssignedInstructors()) {
                                    if (di.getExternalUniqueId() == null || di.getExternalUniqueId().isEmpty() || (student = (Student)ext2student.get(di.getExternalUniqueId())) == null) continue;
                                    new Unavailability(student, (Section)section, tcr.isCanOverlap().booleanValue());
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!(distPrefs = hibSession.createQuery("select p from DistributionPref p, Department d where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and p.owner = d and p.prefLevel.prefProlog = :pref").setString("ref1", GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setString("ref2", "NO_CONFLICT").setString("pref", PreferenceLevel.sRequired).setLong("sessionId", this.iSessionId.longValue()).list()).isEmpty()) {
            this.setPhase("Loading distribution preferences...", distPrefs.size());
            Iterator p = new SectionProvider(){

                @Override
                public Section get(Long classId) {
                    return (Section)classTable.get(classId);
                }
            };
            for (DistributionPref pref : distPrefs) {
                this.incProgress();
                for (Collection collection : StudentSectioningDatabaseLoader.getSections(pref, (SectionProvider)((Object)p))) {
                    if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                        ((StudentSectioningModel)this.getModel()).addLinkedSections(this.iLinkedClassesMustBeUsed, collection);
                        continue;
                    }
                    for (Section s1 : collection) {
                        for (Section s2 : collection) {
                            if (s1.equals((Object)s2)) continue;
                            s1.addIgnoreConflictWith(s2.getId());
                        }
                    }
                }
            }
        }
        this.setPhase("Assigning students...", ((StudentSectioningModel)this.getModel()).getStudents().size());
        for (Student student4 : ((StudentSectioningModel)this.getModel()).getStudents()) {
            this.incProgress();
            this.assignStudent(student4);
        }
        this.setPhase("Checking for student conflicts...", ((StudentSectioningModel)this.getModel()).getStudents().size());
        for (Student student2 : ((StudentSectioningModel)this.getModel()).getStudents()) {
            this.incProgress();
            this.checkForConflicts(student2);
        }
        if (((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
            this.setPhase("Moving assigned requests first...", ((StudentSectioningModel)this.getModel()).getStudents().size());
            for (Student student2 : ((StudentSectioningModel)this.getModel()).getStudents()) {
                this.incProgress();
                this.reorderStudentRequests(student2);
            }
        } else if (this.iMoveCriticalCoursesUp) {
            this.setPhase("Moving critical requests first...", ((StudentSectioningModel)this.getModel()).getStudents().size());
            for (Student student2 : ((StudentSectioningModel)this.getModel()).getStudents()) {
                this.incProgress();
                this.reorderStudentRequests(student2);
            }
        }
        if (this.iStudentCourseDemands != null) {
            this.iStudentCourseDemands.init(hibSession, this.iProgress, (Session)SessionDAO.getInstance().get(this.iSessionId, hibSession), offerings);
            Hashtable<Long, Student> students = new Hashtable<Long, Student>();
            Hashtable<Long, HashSet<Long>> classAssignments = null;
            if (this.iIncludeUseCommittedAssignments && !this.iStudentCourseDemands.isMakingUpStudents()) {
                classAssignments = new Hashtable<Long, HashSet<Long>>();
                List enrollments = hibSession.createQuery("select distinct se.studentId, se.clazz.uniqueId from StudentEnrollment se where se.solution.commited=true and se.solution.owner.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                this.setPhase("Loading projected class assignments...", enrollments.size());
                for (Object[] objectArray : enrollments) {
                    this.incProgress();
                    Long studentId = (Long)objectArray[0];
                    Long classId = (Long)objectArray[1];
                    HashSet<Long> classIds = (HashSet<Long>)classAssignments.get(studentId);
                    if (classIds == null) {
                        classIds = new HashSet<Long>();
                        classAssignments.put(studentId, classIds);
                    }
                    classIds.add(classId);
                }
            }
            this.setPhase("Loading projected course requests...", offerings.size());
            long requestId = -1L;
            for (InstructionalOffering io : offerings) {
                this.incProgress();
                for (CourseOffering co : io.getCourseOfferings()) {
                    Set<StudentCourseDemands.WeightedStudentId> demands;
                    Course course = courseTable.get(co.getUniqueId());
                    if (course == null || (demands = this.iStudentCourseDemands.getDemands(co)) == null) continue;
                    block24: for (StudentCourseDemands.WeightedStudentId demand : demands) {
                        Set classIds;
                        if (this.iProjectedStudentQuery != null && (demand.getStudent() != null && !this.iProjectedStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(demand.getStudent())) || demand.getStudent() == null && !this.iProjectedStudentQuery.match(new ProjectedStudentMatcher(demand)))) continue;
                        student = (Student)students.get(demand.getStudentId());
                        if (student == null) {
                            student = new Student(demand.getStudentId(), true);
                            for (StudentCourseDemands.AreaClasfMajor acm : demand.getMajors()) {
                                student.getAreaClassificationMajors().add(new AreaClassificationMajor(acm.getArea(), acm.getClasf(), acm.getMajor()));
                            }
                            students.put(demand.getStudentId(), student);
                        }
                        ArrayList<Course> arrayList = new ArrayList<Course>();
                        arrayList.add(course);
                        CourseRequest request = new CourseRequest(requestId--, 0, false, student, arrayList, false, null);
                        request.setWeight((double)demand.getWeight());
                        if (classAssignments == null || classAssignments.isEmpty() || (classIds = (Set)classAssignments.get(demand.getStudentId())) == null) continue;
                        block26: for (Enrollment enrollment : request.values(this.getAssignment())) {
                            for (Section section : enrollment.getSections()) {
                                if (classIds.contains(section.getId())) continue;
                                continue block26;
                            }
                            request.setInitialAssignment((Value)enrollment);
                            continue block24;
                        }
                    }
                }
            }
            for (Student student5 : students.values()) {
                ((StudentSectioningModel)this.getModel()).addStudent(student5);
                this.assignStudent(student5);
            }
            for (Student student3 : students.values()) {
                this.checkForConflicts(student3);
            }
            if (this.iFixWeights) {
                this.fixWeights(hibSession, courseTable.values());
            }
            ((StudentSectioningModel)this.getModel()).createAssignmentContexts(this.getAssignment(), true);
        }
        if (this.iLoadSectioningInfos) {
            List infos = hibSession.createQuery("select i from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", this.iSessionId.longValue()).list();
            this.setPhase("Loading sectioning infos...", infos.size());
            for (SectioningInfo info : infos) {
                this.incProgress();
                Section section = classTable.get(info.getClazz().getUniqueId());
                if (section == null) continue;
                section.setSpaceExpected(info.getNbrExpectedStudents().doubleValue());
                section.setSpaceHeld(info.getNbrHoldingStudents().doubleValue());
                if (section.getLimit() < 0 || !((double)(section.getLimit() - section.getEnrollments(this.getAssignment()).size()) <= section.getSpaceExpected())) continue;
                this.iProgress.info("Section " + section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName() + " has high demand (limit: " + section.getLimit() + ", enrollment: " + section.getEnrollments(this.getAssignment()).size() + ", expected: " + section.getSpaceExpected() + ")");
            }
        }
        this.setPhase("Done", 1L);
        this.incProgress();
    }

    protected void checkTermination() {
        if (this.getTerminationCondition() != null && !this.getTerminationCondition().canContinue(new Solution(this.getModel(), this.getAssignment()))) {
            throw new RuntimeException("The load was interrupted.");
        }
    }

    protected void setPhase(String phase, long progressMax) {
        this.checkTermination();
        this.iProgress.setPhase(phase, progressMax);
    }

    protected void incProgress() {
        this.checkTermination();
        this.iProgress.incProgress();
    }

    protected void checkCriticalCourses(org.hibernate.Session hibSession, List<org.unitime.timetable.model.Student> students) {
        if (this.iNrCheckCriticalThreads <= 1) {
            this.setPhase("Checking critical courses...", students.size());
            for (org.unitime.timetable.model.Student s : students) {
                this.incProgress();
                if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch) || this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) continue;
                this.checkCriticalCourses(hibSession, s);
            }
        } else {
            ArrayList<org.unitime.timetable.model.Student> filteredStudents = new ArrayList<org.unitime.timetable.model.Student>();
            for (org.unitime.timetable.model.Student s : students) {
                if (s.getCourseDemands().isEmpty() && s.getClassEnrollments().isEmpty() && s.getWaitlists().isEmpty() || this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch) || this.iStudentQuery != null && !this.iStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(s))) continue;
                filteredStudents.add(s);
            }
            this.setPhase("Checking critical courses...", filteredStudents.size());
            ArrayList<CriticalCoursesWorker> workers = new ArrayList<CriticalCoursesWorker>();
            Iterator<org.unitime.timetable.model.Student> iterator = filteredStudents.iterator();
            for (int i = 0; i < this.iNrCheckCriticalThreads; ++i) {
                workers.add(new CriticalCoursesWorker(hibSession, i, iterator));
            }
            for (CriticalCoursesWorker worker : workers) {
                worker.start();
            }
            for (CriticalCoursesWorker worker : workers) {
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    this.iCanContinue = false;
                    try {
                        worker.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.iCanContinue) {
                throw new RuntimeException("The critical course check was interrupted.");
            }
        }
    }

    protected boolean isCritical(CourseDemand cd, CriticalCoursesProvider.CriticalCourses critical) {
        if (critical == null || cd.isAlternative().booleanValue()) {
            return false;
        }
        for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
            if (cr.getOrder() != 0 || !critical.isCritical(cr.getCourseOffering())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCriticalCourses(org.hibernate.Session hibSession, org.unitime.timetable.model.Student s) {
        if (this.iValidator == null) {
            this.iValidator = new StudentSolver(((StudentSectioningModel)this.getModel()).getProperties(), null);
            this.iValidator.setInitalSolution((Solution<Request, Enrollment>)new Solution(this.getModel(), this.getAssignment()));
        }
        OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(this.iOwnerId).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
        OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, user);
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setOperation("critical-courses");
        action.setSession(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iSessionId).setName(this.iTerm + this.iYear + this.iInitiative));
        action.setStartTime(System.currentTimeMillis());
        action.setUser(user);
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(s.getUniqueId()).setExternalId(s.getExternalUniqueId()).setName(this.iStudentNameFormat.format(s)).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
        long c0 = OnlineSectioningHelper.getCpuTime();
        try {
            CriticalCoursesProvider.CriticalCourses critical = this.iCriticalCoursesProvider.getCriticalCourses(this.iValidator, helper, new XStudent(s, helper, this.iFreeTimePattern));
            boolean changed = false;
            for (CourseDemand cd : s.getCourseDemands()) {
                boolean crit = this.isCritical(cd, critical);
                if (cd.isCritical() != null && cd.isCritical() == crit) continue;
                cd.setCritical(crit);
                hibSession.update((Object)cd);
                changed = true;
            }
            if (changed) {
                this.iUpdatedStudents.add(s.getUniqueId());
                action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
            } else {
                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
            }
        }
        catch (Exception e) {
            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            if (e.getCause() != null) {
                action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
            } else {
                action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
            }
        }
        finally {
            action.setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            action.setEndTime(System.currentTimeMillis());
            OnlineSectioningLogger.getInstance().record(OnlineSectioningLog.Log.newBuilder().addAction(action).build());
        }
    }

    public class ProjectedStudentMatcher
    implements Query.TermMatcher {
        private StudentCourseDemands.WeightedStudentId iStudent;

        public ProjectedStudentMatcher(StudentCourseDemands.WeightedStudentId student) {
            this.iStudent = student;
        }

        public StudentCourseDemands.WeightedStudentId student() {
            return this.iStudent;
        }

        @Override
        public boolean match(String attr, String term) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (attr == null && term.isEmpty()) {
                                return true;
                            }
                            if (!"area".equals(attr)) break block5;
                            for (StudentCourseDemands.AreaClasfMajor acm : this.student().getMajors()) {
                                if (!this.eq(acm.getArea(), term)) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!"clasf".equals(attr) && !"classification".equals(attr)) break block7;
                        for (StudentCourseDemands.AreaClasfMajor acm : this.student().getMajors()) {
                            if (!this.eq(acm.getClasf(), term)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!"major".equals(attr)) break block8;
                    for (StudentCourseDemands.AreaClasfMajor acm : this.student().getMajors()) {
                        if (!this.eq(acm.getMajor(), term)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!"group".equals(attr)) break block6;
                for (StudentCourseDemands.Group group : this.student().getGroups()) {
                    if (!this.eq(group.getName(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }
    }

    protected class CriticalCoursesWorker
    extends Thread {
        private org.hibernate.Session iHibSession;
        private Iterator<org.unitime.timetable.model.Student> iStudents;

        public CriticalCoursesWorker(org.hibernate.Session hibSession, int index, Iterator<org.unitime.timetable.model.Student> students) {
            this.setName("CriticalCourses-" + (1 + index));
            this.iStudents = students;
            this.iHibSession = hibSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has started.");
            try (org.hibernate.Session hibSession = null;){
                hibSession = StudentDAO.getInstance().createNewSession();
                while (true) {
                    org.unitime.timetable.model.Student student = null;
                    Iterator<org.unitime.timetable.model.Student> iterator = this.iStudents;
                    synchronized (iterator) {
                        if (!StudentSectioningDatabaseLoader.this.iCanContinue) {
                            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has stopped.");
                            return;
                        }
                        if (!this.iStudents.hasNext()) {
                            break;
                        }
                        student = this.iStudents.next();
                        StudentSectioningDatabaseLoader.this.iProgress.incProgress();
                    }
                    org.unitime.timetable.model.Student newStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getUniqueId(), hibSession);
                    StudentSectioningDatabaseLoader.this.checkCriticalCourses(hibSession, newStudent);
                    Iterator<org.unitime.timetable.model.Student> iterator2 = this.iStudents;
                    synchronized (iterator2) {
                        this.iHibSession.merge((Object)newStudent);
                    }
                }
            }
            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has finished.");
        }
    }

    protected class Worker
    extends Thread {
        private org.hibernate.Session iHibSession;
        private Iterator<org.unitime.timetable.model.Student> iStudents;

        public Worker(org.hibernate.Session hibSession, int index, Iterator<org.unitime.timetable.model.Student> students) {
            this.setName("OverrideValidator-" + (1 + index));
            this.iStudents = students;
            this.iHibSession = hibSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has started.");
            try (org.hibernate.Session hibSession = null;){
                hibSession = StudentDAO.getInstance().createNewSession();
                while (true) {
                    org.unitime.timetable.model.Student student = null;
                    Iterator<org.unitime.timetable.model.Student> iterator = this.iStudents;
                    synchronized (iterator) {
                        if (!StudentSectioningDatabaseLoader.this.iCanContinue) {
                            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has stopped.");
                            return;
                        }
                        if (!this.iStudents.hasNext()) {
                            break;
                        }
                        student = this.iStudents.next();
                        StudentSectioningDatabaseLoader.this.iProgress.incProgress();
                    }
                    org.unitime.timetable.model.Student newStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getUniqueId(), hibSession);
                    StudentSectioningDatabaseLoader.this.validateOverrides(hibSession, newStudent);
                    Iterator<org.unitime.timetable.model.Student> iterator2 = this.iStudents;
                    synchronized (iterator2) {
                        this.iHibSession.merge((Object)newStudent);
                    }
                }
            }
            StudentSectioningDatabaseLoader.this.iProgress.debug(this.getName() + " has finished.");
        }
    }

    public static interface SectionProvider {
        public Section get(Long var1);
    }
}

