/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.server.solver.TimetableGridContext;
import org.unitime.timetable.server.solver.TimetableGridHelper;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.timegrid.SolverGridModel;

public class TimetableGridSolverHelper
extends TimetableGridHelper {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, RoomConstraint room, TimetableGridContext context) {
        RoomSharingModel sharing;
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.ROOM.ordinal(), room.getResourceId());
        model.setName(room.getRoomName());
        model.setSize(room.getCapacity());
        model.setType(room.getType());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        if (room instanceof DiscouragedRoomConstraint) {
            model.setNameColor(PreferenceLevel.prolog2color(PreferenceLevel.sStronglyDiscouraged));
        }
        Assignment assignment = solver.currentSolution().getAssignment();
        ArrayList<Placement> assignments = new ArrayList<Placement>();
        BitSet week = null;
        if (context.getFirstDay() >= 0) {
            week = new BitSet();
            for (int i = 0; i < 7; ++i) {
                int d = context.getFirstDay() + i - context.getWeekOffset();
                if (d < 0) continue;
                week.set(d);
            }
            week = null;
        }
        for (Lecture lecture : room.variables()) {
            Placement placement = (Placement)assignment.getValue((Variable)lecture);
            if (placement == null || !placement.hasRoomLocation(model.getResourceId()) || week != null && !placement.getTimeLocation().shareWeeks(week)) continue;
            assignments.add(placement);
        }
        TimetableGridSolverHelper.createCells(model, solver, assignments, context, false);
        HashSet<Long> deptIds = new HashSet<Long>();
        String deptIdsStr = solver.getProperties().getProperty("General.DepartmentIds");
        if (deptIdsStr != null) {
            StringTokenizer stk = new StringTokenizer(deptIdsStr, ",");
            while (stk.hasMoreTokens()) {
                deptIds.add(Long.valueOf(stk.nextToken()));
            }
        }
        if ((sharing = room.getSharingModel()) != null) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                int start = 0;
                Boolean av = null;
                for (int j = 0; j < 288; ++j) {
                    Long dept;
                    Boolean available = sharing.isFreeForAll(i, j) ? Boolean.valueOf(true) : (sharing.isNotAvailable(i, j) ? Boolean.valueOf(false) : Boolean.valueOf((dept = sharing.getDepartmentId(i, j)) == null || deptIds.contains(dept)));
                    if (av == null) {
                        av = available;
                        start = j;
                        continue;
                    }
                    if (av.equals(available)) continue;
                    if (!av.booleanValue()) {
                        TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
                        bg.setBackground(sBgColorNotAvailable);
                        bg.setSlot(start);
                        bg.setLength(j - start);
                        bg.setDay(i);
                        bg.setAvailable(false);
                        model.addBackground(bg);
                    }
                    av = available;
                    start = j;
                }
                if (av == null || av.booleanValue()) continue;
                TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
                bg.setBackground(sBgColorNotAvailable);
                bg.setSlot(start);
                bg.setLength(288 - start);
                bg.setDay(i);
                bg.setAvailable(false);
                model.addBackground(bg);
            }
        }
        if (room.getAvailableArray() != null) {
            HashSet<Placement> done = new HashSet<Placement>();
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < 288; ++j) {
                    List placements = room.getAvailableArray()[i * 288 + j];
                    if (placements == null || placements.isEmpty()) continue;
                    for (Placement p : placements) {
                        if (!context.isShowEvents() && p.getAssignmentId() == null || !done.add(p) || week != null && !p.getTimeLocation().shareWeeks(week)) continue;
                        TimetableGridSolverHelper.createCells(model, solver, p, context, true);
                    }
                }
            }
        }
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, InstructorConstraint instructor, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.INSTRUCTOR.ordinal(), instructor.getId());
        model.setName(instructor.getName());
        model.setType(instructor.getType());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Assignment assignment = solver.currentSolution().getAssignment();
        ArrayList<Placement> assignments = new ArrayList<Placement>();
        BitSet week = null;
        if (context.getFirstDay() >= 0) {
            week = new BitSet();
            for (int i = 0; i < 7; ++i) {
                int d = context.getFirstDay() + i - context.getWeekOffset();
                if (d < 0) continue;
                week.set(d);
            }
        }
        for (Lecture lecture : instructor.variables()) {
            Placement placement = (Placement)assignment.getValue((Variable)lecture);
            if (placement == null || week != null && !placement.getTimeLocation().shareWeeks(week)) continue;
            assignments.add(placement);
        }
        TimetableGridSolverHelper.createCells(model, solver, assignments, context, false);
        if (instructor.getUnavailabilities() != null) {
            for (Placement p : instructor.getUnavailabilities()) {
                if (!context.isShowEvents() && p.getAssignmentId() == null || week != null && !p.getTimeLocation().shareWeeks(week)) continue;
                TimetableGridSolverHelper.createCells(model, solver, p, context, true);
            }
        }
        for (Student student : ((TimetableModel)solver.currentSolution().getModel()).getAllStudents()) {
            if (!instructor.equals((Object)student.getInstructor())) continue;
            for (Lecture lecture : student.getLectures()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null || instructor.variables().contains(lecture) || week != null && !placement.getTimeLocation().shareWeeks(week)) continue;
                for (TimetableGridInterface.TimetableGridCell cell : TimetableGridSolverHelper.createCells(model, solver, placement, context, false)) {
                    cell.setItalics(true);
                }
            }
        }
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, DepartmentSpreadConstraint department, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.DEPARTMENT.ordinal(), department.getDepartmentId());
        model.setName(department.getName());
        model.setSize(department.variables().size());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Assignment assignment = solver.currentSolution().getAssignment();
        ArrayList<Placement> placements = new ArrayList<Placement>();
        for (Lecture lecture : department.variables()) {
            Placement placement = (Placement)assignment.getValue((Variable)lecture);
            if (placement == null) continue;
            placements.add(placement);
        }
        TimetableGridSolverHelper.createCells(model, solver, placements, context, false);
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, int resourceType, long resourceId, String name, int size, Collection<Placement> placements, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(resourceType, resourceId);
        model.setName(name);
        model.setSize(size);
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        TimetableGridSolverHelper.createCells(model, solver, placements, context, false);
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, String name, List<Student> students, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.CURRICULUM.ordinal(), -1L);
        model.setName(name);
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Assignment assignment = solver.currentSolution().getAssignment();
        Hashtable<Long, String> groups = new Hashtable<Long, String>();
        for (Object[] o : CurriculumDAO.getInstance().getSession().createQuery("select c.course.instructionalOffering.uniqueId, g.name from CurriculumCourse c inner join c.groups g where c.classification.curriculum.abbv || ' ' || c.classification.academicClassification.code = :name and c.classification.curriculum.department.session.uniqueId = :sessionId").setString("name", name).setLong("sessionId", solver.getProperties().getPropertyLong("General.SessionId", null).longValue()).setCacheable(true).list()) {
            Long courseId = (Long)o[0];
            String group = (String)o[1];
            String string = (String)groups.get(courseId);
            groups.put(courseId, (string == null ? "" : string + ", ") + group);
        }
        double size = 0.0;
        Hashtable<Placement, Double> placements = new Hashtable<Placement, Double>();
        for (Student student : students) {
            int cnt = 0;
            double w = 0.0;
            for (Lecture lecture : student.getLectures()) {
                w += student.getOfferingWeight(lecture.getConfiguration());
                ++cnt;
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                Double old = (Double)placements.get(placement);
                placements.put(placement, student.getOfferingWeight(lecture.getConfiguration()) + (old == null ? 0.0 : old));
            }
            if (student.getCommitedPlacements() != null) {
                for (Placement placement : student.getCommitedPlacements()) {
                    w += student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
                    ++cnt;
                    Double old = (Double)placements.get(placement);
                    placements.put(placement, student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration()) + (old == null ? 0.0 : old));
                }
            }
            if (cnt <= 0) continue;
            size += w / (double)cnt;
        }
        model.setSize((int)Math.round(size));
        model.setUtilization(TimetableGridSolverHelper.countUtilization(context, placements.keySet()));
        for (Map.Entry entry : placements.entrySet()) {
            for (TimetableGridInterface.TimetableGridCell cell : TimetableGridSolverHelper.createCells(model, solver, (Placement)entry.getKey(), context, ((Lecture)((Placement)entry.getKey()).variable()).isCommitted())) {
                String group = ((Lecture)((Placement)entry.getKey()).variable()).getConfiguration() == null ? null : (String)groups.get(((Lecture)((Placement)entry.getKey()).variable()).getConfiguration().getOfferingId());
                cell.setGroup("(" + Math.round((Double)entry.getValue()) + (group == null ? "" : ", " + group) + ")");
            }
        }
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(TimetableSolver solver, StudentGroup group, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.STUDENT_GROUP.ordinal(), group.getId());
        model.setName(group.getName());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Assignment assignment = solver.currentSolution().getAssignment();
        double size = 0.0;
        Hashtable<Placement, Double> placements = new Hashtable<Placement, Double>();
        for (Student student : group.getStudents()) {
            int cnt = 0;
            double w = 0.0;
            for (Lecture lecture : student.getLectures()) {
                w += student.getOfferingWeight(lecture.getConfiguration());
                ++cnt;
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                Double old = (Double)placements.get(placement);
                placements.put(placement, student.getOfferingWeight(lecture.getConfiguration()) + (old == null ? 0.0 : old));
            }
            if (student.getCommitedPlacements() != null) {
                for (Placement placement : student.getCommitedPlacements()) {
                    w += student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
                    ++cnt;
                    Double old = (Double)placements.get(placement);
                    placements.put(placement, student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration()) + (old == null ? 0.0 : old));
                }
            }
            if (cnt <= 0) continue;
            size += w / (double)cnt;
        }
        model.setSize((int)Math.round(size));
        model.setUtilization(StudentGroupInfo.value(group));
        for (Map.Entry entry : placements.entrySet()) {
            for (TimetableGridInterface.TimetableGridCell cell : TimetableGridSolverHelper.createCells(model, solver, (Placement)entry.getKey(), context, ((Lecture)((Placement)entry.getKey()).variable()).isCommitted())) {
                cell.setGroup("(" + Math.round((Double)entry.getValue()) + ")");
            }
        }
        return model;
    }

    protected static void createCells(TimetableGridInterface.TimetableGridModel model, TimetableSolver solver, Collection<Placement> placements, TimetableGridContext context, boolean notAvailable) {
        model.setUtilization(TimetableGridSolverHelper.countUtilization(context, placements));
        for (Placement placement : placements) {
            if (((Lecture)placement.variable()).isCommitted()) continue;
            TimetableGridSolverHelper.createCells(model, solver, placement, context, notAvailable);
        }
    }

    protected static void createCells(TimetableGridInterface.TimetableGridModel model, TimetableSolver solver, Placement[] resource, TimetableGridContext context, int firstDay, int lastDay) {
        HashMap<Lecture, TimetableGridInterface.TimetableGridCell> processed = new HashMap<Lecture, TimetableGridInterface.TimetableGridCell>();
        ArrayList<Placement> placements = new ArrayList<Placement>();
        for (int i = firstDay; i < lastDay; ++i) {
            for (int j = 0; j < 288; ++j) {
                Lecture lecture;
                Placement placement = resource[i * 288 + j];
                if (placement == null || (lecture = (Lecture)placement.variable()).isCommitted()) continue;
                TimetableGridInterface.TimetableGridCell cell = (TimetableGridInterface.TimetableGridCell)processed.get(lecture);
                if (cell == null) {
                    cell = TimetableGridSolverHelper.createCell(model, solver, i, j, (Lecture)placement.variable(), placement, context, false);
                    processed.put(lecture, cell);
                    placements.add(placement);
                } else {
                    cell = new TimetableGridInterface.TimetableGridCell(cell, i, placement.getTimeLocation().getDatePatternName());
                }
                model.addCell(cell);
                j += placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            }
        }
        model.setUtilization(TimetableGridSolverHelper.countUtilization(context, placements));
    }

    protected static List<TimetableGridInterface.TimetableGridCell> createCells(TimetableGridInterface.TimetableGridModel model, TimetableSolver solver, Placement placement, TimetableGridContext context, boolean notAvailable) {
        ArrayList<TimetableGridInterface.TimetableGridCell> cells = new ArrayList<TimetableGridInterface.TimetableGridCell>();
        TimetableGridInterface.TimetableGridCell cell = null;
        TimeLocation.IntEnumeration f = placement.getTimeLocation().getStartSlots();
        while (f.hasMoreElements()) {
            int slot = (Integer)f.nextElement();
            int idx = (7 + slot / 288 - context.getWeekOffset()) % 7;
            if (context.getFirstDay() >= 0 && !placement.getTimeLocation().getWeekCode().get(context.getFirstDay() + idx)) continue;
            cell = cell == null ? TimetableGridSolverHelper.createCell(model, solver, slot / 288, slot % 288, (Lecture)placement.variable(), placement, context, notAvailable) : new TimetableGridInterface.TimetableGridCell(cell, slot / 288, placement.getTimeLocation().getDatePatternName());
            model.addCell(cell);
            cells.add(cell);
        }
        return cells;
    }

    protected static TimetableGridInterface.TimetableGridCell createCell(TimetableGridInterface.TimetableGridModel model, TimetableSolver solver, int day, int slot, Lecture lecture, Placement placement, TimetableGridContext context, boolean notAvailable) {
        TimetableGridInterface.TimetableGridCell cell = new TimetableGridInterface.TimetableGridCell();
        if (lecture.getClassId() < 0L) {
            cell.setType(TimetableGridInterface.TimetableGridCell.Type.Event);
            cell.setId(-lecture.getClassId().longValue());
        } else {
            cell.setType(TimetableGridInterface.TimetableGridCell.Type.Class);
            cell.setId(lecture.getClassId());
            cell.setCommitted(lecture.isCommitted());
        }
        cell.addName(lecture.getName());
        cell.setDay(day);
        cell.setSlot(slot);
        cell.setLength(placement.getTimeLocation().getNrSlotsPerMeeting());
        int bgMode = context.getBgMode();
        if (notAvailable) {
            cell.setBackground(sBgColorNotAvailable);
        }
        DecimalFormat df = new DecimalFormat("0.0");
        Assignment assignment = solver.currentSolution().getAssignment();
        int studConf = lecture.countStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement);
        double penalty = 0.0;
        if (solver.getPerturbationsCounter() != null) {
            penalty = solver.getPerturbationsCounter().getPerturbationPenalty(assignment, solver.currentSolution().getModel(), (Value)placement, new Vector());
        }
        DepartmentSpreadConstraint deptConstraint = null;
        for (Constraint c : lecture.constraints()) {
            if (!(c instanceof DepartmentSpreadConstraint)) continue;
            deptConstraint = (DepartmentSpreadConstraint)c;
            break;
        }
        block0 : switch (TimetableGridHelper.BgMode.values()[bgMode]) {
            case TimePref: {
                if (notAvailable) break;
                int timePref = placement.getTimeLocation().getPreference();
                if (PreferenceLevel.sNeutral.equals(PreferenceLevel.int2prolog(timePref)) && lecture.nrTimeLocations() == 1) {
                    timePref = PreferenceLevel.sIntLevelRequired;
                }
                cell.setBackground(TimetableGridSolverHelper.pref2color(timePref));
                break;
            }
            case RoomPref: {
                if (notAvailable) break;
                int roomPref = placement.getRoomPreference();
                if (model.getResourceType() == TimetableGridHelper.ResourceType.ROOM.ordinal() && model.getResourceId() != null) {
                    roomPref = placement.getRoomLocation(model.getResourceId()).getPreference();
                }
                if (PreferenceLevel.sNeutral.equals(PreferenceLevel.int2prolog(roomPref)) && lecture.nrRoomLocations() == lecture.getNrRooms()) {
                    roomPref = PreferenceLevel.sIntLevelRequired;
                }
                cell.setBackground(TimetableGridSolverHelper.pref2color(roomPref));
                break;
            }
            case StudentConf: {
                cell.setBackground(TimetableGridSolverHelper.conflicts2color(studConf));
                if (model.getResourceType() != TimetableGridHelper.ResourceType.INSTRUCTOR.ordinal()) break;
                for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
                    if (jenrl.getNrInstructors() <= 0 || !jenrl.isInConflict(assignment)) continue;
                    for (Student student : jenrl.getInstructors()) {
                        if (!model.getResourceId().equals(student.getInstructor().getResourceId()) || student.getInstructor().variables().contains(lecture)) continue;
                        cell.setBackground(sBgColorRequired);
                        break block0;
                    }
                }
                break;
            }
            case InstructorBtbPref: {
                int instrPref = 0;
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    instrPref += ic.getPreferenceCombination(assignment, placement);
                }
                cell.setBackground(TimetableGridSolverHelper.pref2color(instrPref));
                break;
            }
            case Perturbations: {
                if (notAvailable) break;
                String perPref = PreferenceLevel.sNeutral;
                if (lecture.getInitialAssignment() != null) {
                    perPref = placement.equals((Object)lecture.getInitialAssignment()) ? PreferenceLevel.sStronglyPreferred : (placement.sameTime((Placement)lecture.getInitialAssignment()) ? PreferenceLevel.sDiscouraged : (placement.sameRooms((Placement)lecture.getInitialAssignment()) ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                }
                cell.setBackground(TimetableGridSolverHelper.pref2color(perPref));
                break;
            }
            case PerturbationPenalty: {
                if (notAvailable) break;
                cell.setBackground(TimetableGridSolverHelper.conflicts2color((int)Math.ceil(penalty)));
                break;
            }
            case HardConflicts: {
                if (notAvailable) break;
                cell.setBackground(TimetableGridSolverHelper.pref2color(SolverGridModel.hardConflicts2pref((Assignment<Lecture, Placement>)assignment, lecture, placement)));
                break;
            }
            case DepartmentalBalancing: {
                if (notAvailable || deptConstraint == null) break;
                cell.setBackground(TimetableGridSolverHelper.conflicts2colorFast(deptConstraint.getMaxPenalty(assignment, placement)));
                break;
            }
            case TooBigRooms: {
                if (notAvailable) break;
                long minRoomSize = lecture.minRoomSize();
                int roomSize = placement.getRoomSize();
                if (roomSize < lecture.minRoomSize()) {
                    cell.setBackground(TimetableGridSolverHelper.pref2color(PreferenceLevel.sRequired));
                } else {
                    cell.setBackground(TimetableGridSolverHelper.pref2color(((TooBigRooms)solver.currentSolution().getModel().getCriterion(TooBigRooms.class)).getPreference(placement)));
                }
                if (lecture.getNrRooms() <= 0) break;
                cell.setPreference((lecture.nrRoomLocations() == 1 ? "<u>" : "") + lecture.minRoomUse() + (lecture.maxRoomUse() != lecture.minRoomUse() ? " - " + lecture.maxRoomUse() : "") + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize + (lecture.nrRoomLocations() == 1 ? "</u>" : ""));
                break;
            }
            case StudentGroups: {
                TimetableModel tm = (TimetableModel)solver.currentSolution().getModel();
                if (tm.getStudentGroups().isEmpty()) break;
                int nrGroups = 0;
                double value = 0.0;
                int allAssigned = 0;
                int grandTotal = 0;
                for (StudentGroup group : tm.getStudentGroups()) {
                    int total = 0;
                    int assigned = 0;
                    if (model.getResourceType() == TimetableGridHelper.ResourceType.STUDENT_GROUP.ordinal() && !model.getResourceId().equals(group.getId())) continue;
                    for (Student student : group.getStudents()) {
                        if (lecture.getConfiguration() == null || !student.hasOffering(lecture.getConfiguration().getOfferingId())) continue;
                        ++total;
                        if (!lecture.students().contains(student)) continue;
                        ++assigned;
                    }
                    if (total <= true || assigned <= 0) continue;
                    allAssigned += assigned;
                    grandTotal += total;
                    int limit = Math.max(lecture.students().size(), lecture.classLimit(assignment));
                    if (total > limit) {
                        total = limit;
                    }
                    ++nrGroups;
                    value += (double)assigned / (double)total;
                }
                if (nrGroups <= 0) break;
                cell.setBackground(TimetableGridSolverHelper.percentage2color((int)Math.round(100.0 * value / (double)nrGroups)));
                cell.setPreference(nrGroups == 1 ? allAssigned + " of " + grandTotal : nrGroups + " groups");
            }
        }
        if (!notAvailable) {
            int roomPref = placement.getRoomPreference();
            if (model.getResourceType() == TimetableGridHelper.ResourceType.ROOM.ordinal() && model.getResourceId() != null) {
                roomPref = placement.getRoomLocation(model.getResourceId()).getPreference();
            }
            if (!cell.hasPreference()) {
                cell.setPreference((lecture.getBestTimePreference() < placement.getTimeLocation().getNormalizedPreference() ? "<span style='color:red'>" + (int)(placement.getTimeLocation().getNormalizedPreference() - lecture.getBestTimePreference()) + "</span>" : "" + (int)(placement.getTimeLocation().getNormalizedPreference() - lecture.getBestTimePreference())) + ", " + (studConf > 0 ? "<span style='color:rgb(20,130,10)'>" + studConf + "</span>" : "" + studConf) + ", " + (lecture.getBestRoomPreference() < roomPref ? "<span style='color:blue'>" + (roomPref - lecture.getBestRoomPreference()) + "</span>" : "" + (roomPref - lecture.getBestRoomPreference())));
            }
            int btbInstrPref = 0;
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                btbInstrPref += ic.getPreferenceCombination(assignment, placement);
            }
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.TimePreference, (int)placement.getTimeLocation().getNormalizedPreference());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflicts, lecture.countStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement));
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsCommitted, lecture.countCommittedStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement));
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsDistance, lecture.countDistanceStudentConflicts(assignment, placement));
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsHard, lecture.countHardStudentConflicts(assignment, placement));
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.RoomPreference, roomPref);
            if (!lecture.getInstructorConstraints().isEmpty()) {
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.InstructorPreference, btbInstrPref);
            }
            if (lecture.getInitialAssignment() != null) {
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.InitialAssignment, ((Placement)lecture.getInitialAssignment()).equals((Object)placement) ? "-" : ((Placement)lecture.getInitialAssignment()).getName());
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.PerturbationPenalty, df.format(penalty));
            }
            if (deptConstraint != null) {
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.DepartmentBalance, deptConstraint.getMaxPenalty(assignment, placement));
            }
            int gcPref = 0;
            for (Constraint c : lecture.constraints()) {
                GroupConstraint gc;
                if (!(c instanceof GroupConstraint) || (gc = (GroupConstraint)c).isHard() || gc.getPreference() > 0 && gc.getCurrentPreference(assignment) == 0 || gc.getPreference() < 0 && gc.getCurrentPreference(assignment) < 0) continue;
                gcPref = Math.max(gcPref, Math.abs(gc.getPreference()));
            }
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.DistributionPreference, gcPref);
            if (bgMode == TimetableGridHelper.BgMode.DistributionConstPref.ordinal()) {
                cell.setBackground(TimetableGridSolverHelper.pref2color(gcPref));
            }
        }
        cell.setDays(placement.getTimeLocation().getDayHeader());
        cell.setTime(placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
        cell.setDate(placement.getTimeLocation().getDatePatternName());
        cell.setWeekCode(TimetableGridSolverHelper.pattern2string(placement.getTimeLocation().getWeekCode()));
        if (placement.isMultiRoom()) {
            for (RoomLocation room : placement.getRoomLocations()) {
                cell.addRoom(room.getName());
            }
        } else if (placement.getRoomLocation() != null) {
            cell.addRoom(placement.getRoomLocation().getName());
        }
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            cell.addInstructor(ic.getName());
        }
        return cell;
    }

    protected static double countUtilization(TimetableGridContext context, Iterable<Placement> placements) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Placement p : placements) {
            int slot;
            int dow;
            int idx;
            int stop;
            int start;
            TimeLocation t = p == null ? null : p.getTimeLocation();
            if (t == null || (start = Math.max(context.getFirstSlot(), t.getStartSlot())) > (stop = Math.min(context.getLastSlot(), t.getStartSlot() + t.getLength() - 1))) continue;
            if (context.getFirstDay() >= 0) {
                for (idx = context.getFirstDay(); idx < 7 + context.getFirstDay(); ++idx) {
                    dow = (idx + context.getStartDayDayOfWeek()) % 7;
                    if (!t.getWeekCode().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                    for (slot = start; slot <= stop; ++slot) {
                        slots.add(288 * idx + slot);
                    }
                }
                continue;
            }
            idx = -1;
            while ((idx = t.getWeekCode().nextSetBit(1 + idx)) >= 0) {
                dow = (idx + context.getStartDayDayOfWeek()) % 7;
                if (!context.getDefaultDatePattern().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                for (slot = start; slot <= stop; ++slot) {
                    slots.add(288 * idx + slot);
                }
            }
        }
        return (float)slots.size() / (context.getNumberOfWeeks() * 12.0f);
    }

    public static void addCrosslistedNames(TimetableGridInterface.TimetableGridModel model, TimetableGridContext context) {
        block11: {
            HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>> id2cells;
            block10: {
                id2cells = new HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>>();
                for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                    if (cell.getType() != TimetableGridInterface.TimetableGridCell.Type.Class || cell.getId() == null || cell.getId() < 0L) continue;
                    ArrayList<TimetableGridInterface.TimetableGridCell> cells = (ArrayList<TimetableGridInterface.TimetableGridCell>)id2cells.get(cell.getId());
                    if (cells == null) {
                        cells = new ArrayList<TimetableGridInterface.TimetableGridCell>();
                        id2cells.put(cell.getId(), cells);
                    }
                    cells.add(cell);
                }
                if (id2cells.isEmpty()) {
                    return;
                }
                if (id2cells.size() > 1000) break block10;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", id2cells.keySet(), (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                        cell.addName(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()));
                    }
                }
                break block11;
            }
            ArrayList<Long> ids = new ArrayList<Long>(1000);
            for (Long id : id2cells.keySet()) {
                ids.add(id);
                if (ids.size() != 1000) continue;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                        cell.addName(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()));
                    }
                }
                ids.clear();
            }
            if (ids.isEmpty()) break block11;
            for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                    cell.addName(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()));
                }
            }
        }
    }

    public static void fixClassName(TimetableGridContext context, TimetableGridInterface.TimetableGridCell cell, Class_ clazz, CourseOffering course) {
        Set<CourseOffering> courses;
        cell.clearName();
        if (context.isShowClassNameTwoLines()) {
            String extId;
            cell.addName(clazz.getCourseName());
            String label = clazz.getItypeDesc().trim() + " " + clazz.getSectionNumberString();
            if (context.isShowClassSuffix() && (extId = clazz.getClassSuffix(course)) != null && !extId.isEmpty() && !extId.equalsIgnoreCase(clazz.getSectionNumberString())) {
                label = label + " - " + extId;
            }
            if (context.isShowConfigName() && course.getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                label = label + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getName() + ")";
            }
            cell.addName(label);
        } else {
            cell.addName(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()));
        }
        if (context.isShowCourseTitle() && course.getTitle() != null && !course.getTitle().isEmpty()) {
            cell.addName(course.getTitle());
        }
        if (context.isShowCourseTitle()) {
            cell.addTitle(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()) + (course.getTitle() != null && !course.getTitle().isEmpty() ? " - " + course.getTitle() : ""));
        } else if (context.isShowClassNameTwoLines()) {
            cell.addTitle(clazz.getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()));
        }
        if (context.isShowCrossLists() && (courses = course.getInstructionalOffering().getCourseOfferings()).size() > 1) {
            for (CourseOffering co : new TreeSet<CourseOffering>(courses)) {
                if (co.isIsControl().booleanValue()) continue;
                cell.addName(clazz.getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
                if (context.isShowCourseTitle()) {
                    if (co.getTitle() != null && !co.getTitle().isEmpty()) {
                        cell.addName(co.getTitle());
                        cell.addTitle(clazz.getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()) + " - " + co.getTitle());
                        continue;
                    }
                    cell.addTitle(clazz.getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
                    continue;
                }
                if (!context.isShowClassNameTwoLines()) continue;
                cell.addTitle(clazz.getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
            }
        }
    }

    public static void fixClassNames(TimetableGridInterface.TimetableGridModel model, TimetableGridContext context) {
        block11: {
            HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>> id2cells;
            block10: {
                id2cells = new HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>>();
                for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                    if (cell.getType() != TimetableGridInterface.TimetableGridCell.Type.Class || cell.getId() == null || cell.getId() < 0L) continue;
                    ArrayList<TimetableGridInterface.TimetableGridCell> cells = (ArrayList<TimetableGridInterface.TimetableGridCell>)id2cells.get(cell.getId());
                    if (cells == null) {
                        cells = new ArrayList<TimetableGridInterface.TimetableGridCell>();
                        id2cells.put(cell.getId(), cells);
                    }
                    cells.add(cell);
                }
                if (id2cells.isEmpty()) {
                    return;
                }
                if (id2cells.size() > 1000) break block10;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", id2cells.keySet(), (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                        TimetableGridSolverHelper.fixClassName(context, cell, clazz, course);
                    }
                }
                break block11;
            }
            ArrayList<Long> ids = new ArrayList<Long>(1000);
            for (Long id : id2cells.keySet()) {
                ids.add(id);
                if (ids.size() != 1000) continue;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                        TimetableGridSolverHelper.fixClassName(context, cell, clazz, course);
                    }
                }
                ids.clear();
            }
            if (ids.isEmpty()) break block11;
            for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(clazz.getUniqueId())) {
                    TimetableGridSolverHelper.fixClassName(context, cell, clazz, course);
                }
            }
        }
    }

    public static void fixInstructors(TimetableGridInterface.TimetableGridModel model, TimetableGridContext context) {
        block15: {
            String query;
            HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>> id2cells;
            block14: {
                id2cells = new HashMap<Long, ArrayList<TimetableGridInterface.TimetableGridCell>>();
                for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                    if (timetableGridCell.getType() != TimetableGridInterface.TimetableGridCell.Type.Class || timetableGridCell.getId() == null || timetableGridCell.getId() < 0L || !timetableGridCell.isCommitted()) continue;
                    ArrayList<TimetableGridInterface.TimetableGridCell> cells = (ArrayList<TimetableGridInterface.TimetableGridCell>)id2cells.get(timetableGridCell.getId());
                    if (cells == null) {
                        cells = new ArrayList<TimetableGridInterface.TimetableGridCell>();
                        id2cells.put(timetableGridCell.getId(), cells);
                    }
                    timetableGridCell.resetInstructors();
                    cells.add(timetableGridCell);
                }
                if (id2cells.isEmpty()) {
                    return;
                }
                query = null;
                if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
                    query = "select ci.classInstructing.uniqueId, ci.instructor from ClassInstructor ci where ci.classInstructing.uniqueId in :classIds";
                    if (ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue()) {
                        query = query + " and ci.classInstructing.displayInstructor = true";
                    }
                    if (ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) {
                        query = query + " and ci.lead = true";
                    }
                } else {
                    query = "select a.clazz.uniqueId, i from Assignment a inner join a.instructors i where a.solution.commited = true and a.clazz.uniqueId in :classIds";
                }
                if (id2cells.size() > 1000) break block14;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery(query).setParameterList("classIds", id2cells.keySet(), (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Long classId = (Long)o[0];
                    DepartmentalInstructor instructor = (DepartmentalInstructor)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(classId)) {
                        cell.addInstructor(instructor.getName(context.getInstructorNameFormat()));
                    }
                }
                break block15;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>(1000);
            for (Long id : id2cells.keySet()) {
                arrayList.add(id);
                if (arrayList.size() != 1000) continue;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery(query).setParameterList("classIds", arrayList, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Long classId = (Long)o[0];
                    DepartmentalInstructor instructor = (DepartmentalInstructor)o[1];
                    for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(classId)) {
                        cell.addInstructor(instructor.getName(context.getInstructorNameFormat()));
                    }
                }
                arrayList.clear();
            }
            if (arrayList.isEmpty()) break block15;
            for (Object[] o : Class_DAO.getInstance().getSession().createQuery(query).setParameterList("classIds", arrayList, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                Long classId = (Long)o[0];
                DepartmentalInstructor instructor = (DepartmentalInstructor)o[1];
                for (TimetableGridInterface.TimetableGridCell cell : (List)id2cells.get(classId)) {
                    cell.addInstructor(instructor.getName(context.getInstructorNameFormat()));
                }
            }
        }
    }
}

