/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.SolutionChangesFilterRequest.class)
public class SolutionChangesFilterBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.SolutionChangesFilterRequest, CourseTimetablingSolverInterface.SolutionChangesFilterResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.SolutionChangesFilterResponse execute(CourseTimetablingSolverInterface.SolutionChangesFilterRequest request, SessionContext context) {
        context.checkPermission(Right.SolutionChanges);
        CourseTimetablingSolverInterface.SolutionChangesFilterResponse response = new CourseTimetablingSolverInterface.SolutionChangesFilterResponse();
        FilterInterface.FilterParameterInterface reference = new FilterInterface.FilterParameterInterface();
        reference.setName("reference");
        reference.setType("list");
        reference.setMultiSelect(false);
        reference.addOption("0", MESSAGES.compareWithBestSolution());
        reference.addOption("1", MESSAGES.compareWithInitialSolution());
        reference.addOption("2", MESSAGES.compareWithSelectedSolution());
        reference.setDefaultValue(context.getUser().getProperty("SolutionChanges.reference", "0"));
        reference.setLabel(MESSAGES.propCompareSolutionWith());
        response.addParameter(reference);
        FilterInterface.FilterParameterInterface simplifiedMode = new FilterInterface.FilterParameterInterface();
        simplifiedMode.setName("simpleMode");
        simplifiedMode.setType("boolean");
        simplifiedMode.setLabel(MESSAGES.propCourseTimetablingSolverSimplifiedMode());
        simplifiedMode.setDefaultValue(context.getUser().getProperty("SuggestionsModel.simpleMode", "0"));
        response.addParameter(simplifiedMode);
        FilterInterface.FilterParameterInterface reversedMode = new FilterInterface.FilterParameterInterface();
        reversedMode.setName("reversedMode");
        reversedMode.setType("boolean");
        reversedMode.setLabel(MESSAGES.propCompareSolutionReversed());
        reversedMode.setDefaultValue(context.getUser().getProperty("SuggestionsModel.reversedMode", "0"));
        response.addParameter(reversedMode);
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(true)) {
            response.addPreference(new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), false));
        }
        return response;
    }
}

