/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.util.Collection;
import org.cpsolver.studentsct.report.DistanceConflictTable;
import org.cpsolver.studentsct.report.RequestGroupTable;
import org.cpsolver.studentsct.report.RequestPriorityTable;
import org.cpsolver.studentsct.report.SectionConflictTable;
import org.cpsolver.studentsct.report.TableauReport;
import org.cpsolver.studentsct.report.TimeOverlapConflictTable;
import org.cpsolver.studentsct.report.UnbalancedSectionsTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningReports;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.reports.studentsct.CriticalCoursesReport;
import org.unitime.timetable.reports.studentsct.IndividualStudentTimeOverlaps;
import org.unitime.timetable.reports.studentsct.PerturbationsReport;
import org.unitime.timetable.reports.studentsct.StudentAvailabilityConflicts;
import org.unitime.timetable.reports.studentsct.UnasignedCourseRequests;
import org.unitime.timetable.reports.studentsct.UnusedReservations;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

@GwtRpcImplements(value=SectioningReports.SectioningReportTypesRpcRequest.class)
public class SectioningReportTypesBackend
implements GwtRpcImplementation<SectioningReports.SectioningReportTypesRpcRequest, GwtRpcResponseList<SectioningReports.ReportTypeInterface>> {
    protected static final StudentSectioningMessages SCT_MSG = Localization.create(StudentSectioningMessages.class);
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;

    @Override
    public GwtRpcResponseList<SectioningReports.ReportTypeInterface> execute(SectioningReports.SectioningReportTypesRpcRequest request, SessionContext context) {
        Collection<SectioningReports.ReportTypeInterface> types;
        StudentSolverProxy solver;
        GwtRpcResponseList<SectioningReports.ReportTypeInterface> ret = new GwtRpcResponseList<SectioningReports.ReportTypeInterface>();
        for (ReportType type : ReportType.values()) {
            ret.add(type.toReportTypeInterface());
        }
        if (!request.isOnline() && (solver = this.studentSectioningSolverService.getSolver()) != null && (types = solver.getReportTypes()) != null && !types.isEmpty()) {
            ret.addAll(types);
        }
        return ret;
    }

    public static enum ReportType {
        TIME_CONFLICTS("Time Conflicts", SectionConflictTable.class.getName(), "type", "OVERLAPS", "overlapsIncludeAll", "true"),
        AVAILABLE_CONFLICTS("Availability Conflicts", SectionConflictTable.class.getName(), "type", "UNAVAILABILITIES", "overlapsIncludeAll", "true"),
        SECTION_CONFLICTS("Time & Availability Conflicts", SectionConflictTable.class.getName(), "type", "OVERLAPS_AND_UNAVAILABILITIES", "overlapsIncludeAll", "true"),
        UNBALANCED_SECTIONS("Unbalanced Classes", UnbalancedSectionsTable.class.getName(), new String[0]),
        DISTANCE_CONFLICTS("Distance Conflicts", DistanceConflictTable.class.getName(), new String[0]),
        TIME_OVERLAPS("Time Overlaps", TimeOverlapConflictTable.class.getName(), new String[0]),
        REQUEST_GROUPS("Request Groups", RequestGroupTable.class.getName(), new String[0]),
        PERTURBATIONS("Perturbations", PerturbationsReport.class.getName(), new String[0]),
        INDIVIDUAL_TIME_OVERLAPS("Individual Student Time Overlaps", IndividualStudentTimeOverlaps.class.getName(), new String[0]),
        NOT_ALLOWED_TIME_OVERLAPS("Not Allowed Time Overlaps", IndividualStudentTimeOverlaps.class.getName(), "includeAllowedOverlaps", "false"),
        INDIVIDUAL_TIME_OVERLAPS_BT("Individual Student Time Overlaps (Exclude Break Times)", IndividualStudentTimeOverlaps.class.getName(), "ignoreBreakTimeConflicts", "true"),
        NOT_ALLOWED_TIME_OVERLAPS_BT("Not Allowed Time Overlaps (Exclude Break Times)", IndividualStudentTimeOverlaps.class.getName(), "ignoreBreakTimeConflicts", "true", "includeAllowedOverlaps", "false"),
        TEACHING_CONFLICTS("Teaching Conflicts", StudentAvailabilityConflicts.class.getName(), new String[0]),
        TEACHING_CONFLICTS_NA("Teaching Conflicts (Exclude Allowed)", StudentAvailabilityConflicts.class.getName(), "includeAllowedOverlaps", "false"),
        NOT_ASSIGNED_COURSE_REQUESTS(SCT_MSG.reportUnassignedCourseRequests(), UnasignedCourseRequests.class.getName(), new String[0]),
        UNUSED_GROUP_RES(SCT_MSG.reportUnusedGroupReservations(), UnusedReservations.class.getName(), "type", "group"),
        UNUSED_INDIVIDUAL_RES(SCT_MSG.reportUnusedIndividualReservations(), UnusedReservations.class.getName(), "type", "individual"),
        UNUSED_OVERRIDE_RES(SCT_MSG.reportUnusedOverrideReservations(), UnusedReservations.class.getName(), "type", "override"),
        UNUSED_LC_RES(SCT_MSG.reportUnusedLearningCommunityReservations(), UnusedReservations.class.getName(), "type", "lc"),
        COURSE_REQUESTS(SCT_MSG.reportCourseRequestsWithPriorities(), RequestPriorityTable.class.getName(), "pritify", "false"),
        TABLEAU_REPORT(SCT_MSG.reportTableauReport(), TableauReport.class.getName(), "pritify", "false"),
        TABLEAU_SIMPLE(SCT_MSG.reportTableauSimpleReport(), TableauReport.class.getName(), "pritify", "false", "simple", "true"),
        CRITICAL(SCT_MSG.reportCriticalCoursesReport(), CriticalCoursesReport.class.getName(), "pritify", "false");

        String iName;
        String iImplementation;
        String[] iParameters;

        private ReportType(String name, String implementation, String ... params) {
            this.iName = name;
            this.iImplementation = implementation;
            this.iParameters = params;
        }

        public String getName() {
            return this.iName;
        }

        public String getImplementation() {
            return this.iImplementation;
        }

        public String[] getParameters() {
            return this.iParameters;
        }

        public SectioningReports.ReportTypeInterface toReportTypeInterface() {
            return new SectioningReports.ReportTypeInterface(this.name(), this.iName, this.iImplementation, this.iParameters);
        }
    }
}

