/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.fileupload.FileItem;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.PeriodicTaskDAO;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.GetTasksBackend;
import org.unitime.timetable.util.CalendarUtils;

@GwtRpcImplements(value=TaskInterface.SaveTaskDetailsRpcRequest.class)
public class SaveTaskBackend
implements GwtRpcImplementation<TaskInterface.SaveTaskDetailsRpcRequest, TaskInterface> {
    @Override
    public TaskInterface execute(TaskInterface.SaveTaskDetailsRpcRequest request, SessionContext context) {
        context.checkPermission(Right.TaskEdit);
        org.hibernate.Session hibSession = PeriodicTaskDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            TaskInterface task = request.getTask();
            PeriodicTask t = null;
            if (task.getId() != null) {
                t = (PeriodicTask)PeriodicTaskDAO.getInstance().get(task.getId(), hibSession);
            }
            if (t == null) {
                t = new PeriodicTask();
                t.setScript((Script)ScriptDAO.getInstance().get(task.getScript().getId(), hibSession));
                t.setOwner(TimetableManager.findByExternalId(context.getUser().getExternalUserId()));
                t.setParameters(new HashSet<TaskParameter>());
                t.setSchedule(new HashSet<TaskExecution>());
                t.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
            }
            Date ts = new Date();
            t.setEmail(task.getEmail());
            t.setName(task.getName());
            ArrayList<TaskParameter> parameters = new ArrayList<TaskParameter>(t.getParameters());
            for (ScriptParameter p : t.getScript().getParameters()) {
                TaskParameter tp = null;
                Iterator i = parameters.iterator();
                while (i.hasNext()) {
                    TaskParameter x = (TaskParameter)i.next();
                    if (!x.getName().equals(p.getName())) continue;
                    tp = x;
                    i.remove();
                    break;
                }
                String value = task.getParameter(p.getName());
                if ("file".equals(p.getType())) {
                    FileItem file = (FileItem)context.getAttribute(SessionAttribute.LastUploadedFile);
                    if (file != null) {
                        t.setInputFile(file.get());
                        value = file.getName();
                    } else if (tp != null && t.getInputFile() != null) {
                        value = tp.getValue();
                    } else {
                        t.setInputFile(null);
                    }
                }
                if (value != null) {
                    if (tp == null) {
                        tp = new TaskParameter();
                        tp.setTask(t);
                        tp.setName(p.getName());
                        t.getParameters().add(tp);
                    }
                    tp.setValue(value);
                    continue;
                }
                if (tp == null) continue;
                tp.setTask(null);
                hibSession.delete((Object)tp);
            }
            for (TaskParameter tp : parameters) {
                t.getParameters().remove(tp);
                tp.setTask(null);
                hibSession.delete((Object)tp);
            }
            int base = CalendarUtils.date2dayOfYear(t.getSession().getSessionStartYear(), t.getSession().getSessionBeginDateTime());
            ArrayList<TaskExecution> executions = new ArrayList<TaskExecution>(t.getSchedule());
            for (TaskInterface.TaskExecutionInterface exec : task.getExecutions()) {
                TaskExecution execution = null;
                int index = exec.getDayOfYear() - base;
                exec.setExecutionDate(SaveTaskBackend.getScheduleDate(t.getSession(), index, exec.getSlot()));
                Iterator i = executions.iterator();
                while (i.hasNext()) {
                    TaskExecution e = (TaskExecution)i.next();
                    if (!e.getExecutionPeriod().equals(exec.getSlot()) || !e.getExecutionDate().equals(index)) continue;
                    execution = e;
                    i.remove();
                    break;
                }
                if (execution != null) continue;
                execution = new TaskExecution();
                execution.setCreatedDate(ts);
                execution.setExecutionDate(index);
                execution.setExecutionPeriod(exec.getSlot());
                execution.setScheduledDate(SaveTaskBackend.getScheduleDate(t.getSession(), index, exec.getSlot()));
                execution.setExecutionStatus(TaskInterface.ExecutionStatus.CREATED.ordinal());
                execution.setTask(t);
                t.getSchedule().add(execution);
            }
            for (TaskExecution e : executions) {
                if (e.getExecutionStatus().intValue() != TaskInterface.ExecutionStatus.CREATED.ordinal()) continue;
                t.getSchedule().remove(e);
                e.setTask(null);
                hibSession.delete((Object)e);
            }
            if (t.getUniqueId() == null) {
                t.setUniqueId((Long)hibSession.save((Object)t));
            } else {
                hibSession.update((Object)t);
            }
            hibSession.flush();
            tx.commit();
            return GetTasksBackend.getTask(t, context);
        }
        catch (Exception e) {
            tx.rollback();
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    public static Date getScheduleDate(Session session, int date, int slot) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(session.getSessionBeginDateTime());
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(6, date);
        c.add(12, slot * 5);
        return c.getTime();
    }
}

