/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.permissions.SimpleSessionPermission;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

public class StudentSchedulingPermissions {

    @PermissionForRight(value=Right.StudentSchedulingChangeCriticalOverride)
    public static class StudentSchedulingChangeCriticalOverride
    implements Permission<Student> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Student source) {
            if (!this.permissionSession.check(user, source.getSession())) {
                return false;
            }
            if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdmin)) {
                return true;
            }
            if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisor)) {
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                    return true;
                }
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyMyStudents)) {
                    for (Advisor advisor : source.getAdvisors()) {
                        if (!advisor.getRole().getReference().equals(user.getCurrentAuthority().getRole()) || !advisor.getExternalUniqueId().equals(user.getExternalUserId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingCanRequirePreferences)
    public static class StudentSchedulingCanRequirePreferences
    implements Permission<Student> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Student source) {
            if (!this.permissionSession.check(user, source.getSession())) {
                return false;
            }
            StudentSectioningStatus status = source.getEffectiveStatus();
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.canreq)) {
                    return false;
                }
                return source.getExternalUniqueId().equals(user.getExternalUserId());
            }
            return user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdmin) || user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisor);
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingCanRegister)
    public static class StudentSchedulingCanRegister
    implements Permission<Student> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Student source) {
            if (!this.permissionSession.check(user, source.getSession()) && !source.getSession().getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister)) {
                return false;
            }
            StudentSectioningStatus status = source.getEffectiveStatus();
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.registration)) {
                    return false;
                }
                return source.getExternalUniqueId().equals(user.getExternalUserId());
            }
            if ((status == null || status.hasOption(StudentSectioningStatus.Option.regadmin)) && user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdmin)) {
                return true;
            }
            if ((status == null || status.hasOption(StudentSectioningStatus.Option.regadvisor)) && user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisor)) {
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                    return true;
                }
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyMyStudents)) {
                    for (Advisor advisor : source.getAdvisors()) {
                        if (!advisor.getRole().getReference().equals(user.getCurrentAuthority().getRole()) || !advisor.getExternalUniqueId().equals(user.getExternalUserId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingCanEnroll)
    public static class StudentSchedulingCanEnroll
    implements Permission<Student> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Student source) {
            if (!this.permissionSession.check(user, source.getSession()) && !source.getSession().getStatusType().can(DepartmentStatusType.Status.StudentsOnline)) {
                return false;
            }
            StudentSectioningStatus status = source.getEffectiveStatus();
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.enrollment)) {
                    return false;
                }
                return source.getExternalUniqueId().equals(user.getExternalUserId());
            }
            if ((status == null || status.hasOption(StudentSectioningStatus.Option.admin)) && user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdmin)) {
                return true;
            }
            if ((status == null || status.hasOption(StudentSectioningStatus.Option.advisor)) && user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisor)) {
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                    return true;
                }
                if (user.getCurrentAuthority().hasRight(Right.StudentSchedulingAdvisorCanModifyMyStudents)) {
                    for (Advisor advisor : source.getAdvisors()) {
                        if (!advisor.getRole().getReference().equals(user.getCurrentAuthority().getRole()) || !advisor.getExternalUniqueId().equals(user.getExternalUserId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingAdmin)
    public static class StudentSchedulingAdmin
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSchedulingAdvisor)
    public static class StudentSchedulingAdvisor
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSchedulingRecheckCriticalCourses)
    public static class StudentSchedulingRecheckCriticalCourses
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister) && ApplicationProperty.CustomizationCriticalCourses.value() != null;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingValidateStudentOverrides)
    public static class StudentSchedulingValidateStudentOverrides
    extends StudentSchedulingCheckStudentOverrides {
    }

    @PermissionForRight(value=Right.StudentSchedulingCheckStudentOverrides)
    public static class StudentSchedulingCheckStudentOverrides
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister) && ApplicationProperty.CustomizationCourseRequestsValidation.value() != null;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingRequestStudentUpdate)
    public static class StudentSchedulingRequestStudentUpdate
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && CustomStudentEnrollmentHolder.isCanRequestUpdates();
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingChangeStudentGroup)
    public static class StudentSchedulingChangeStudentGroup
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && (source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) || source.getStatusType().can(DepartmentStatusType.Status.StudentsAssistant) || source.getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister));
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingChangeStudentStatus)
    public static class StudentSchedulingChangeStudentStatus
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && (source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) || source.getStatusType().can(DepartmentStatusType.Status.StudentsAssistant) || source.getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister));
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingEmailStudent)
    public static class StudentSchedulingEmailStudent
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source);
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingMassCancel)
    public static class StudentSchedulingMassCancel
    extends SimpleSessionPermission {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) && CustomStudentEnrollmentHolder.isAllowWaitListing();
        }
    }

    @PermissionForRight(value=Right.StudentEnrollments)
    public static class StudentEnrollments
    implements Permission<Student> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Student source) {
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                return source.getExternalUniqueId().equals(user.getExternalUserId());
            }
            return true;
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    @PermissionForRight(value=Right.OfferingEnrollments)
    public static class OfferingEnrollments
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (OfferingCoordinator coordinator : source.getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            for (CourseOffering course : source.getCourseOfferings()) {
                if (!this.permissionDepartment.check(user, course.getSubjectArea().getDepartment())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.ConsentApproval)
    public static class ConsentApproval
    implements Permission<CourseOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (source.getConsentType() == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                if (!"IN".equals(source.getConsentType().getReference())) {
                    return false;
                }
                for (OfferingCoordinator coordinator : source.getInstructionalOffering().getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            return this.permissionDepartment.check(user, source.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment());
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    @PermissionForRight(value=Right.CourseRequests)
    public static class CourseRequests
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source, DepartmentStatusType.Status.StudentsPreRegister)) {
                return false;
            }
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                List<? extends UserQualifier> q = user.getCurrentAuthority().getQualifiers("Student");
                if (q == null || q.isEmpty()) {
                    return false;
                }
                Student student = (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId());
                if (student == null) {
                    return false;
                }
                StudentSectioningStatus status = student.getEffectiveStatus();
                return status == null || status.hasOption(StudentSectioningStatus.Option.regenabled);
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (UserAuthority userAuthority : user.getAuthorities("Student", new SimpleQualifier("Session", source.getUniqueId()))) {
                    StudentSectioningStatus status;
                    Student student;
                    List<? extends UserQualifier> q = userAuthority.getQualifiers("Student");
                    if (q == null || q.isEmpty() || (student = (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId())) == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.regenabled)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.SchedulingReports)
    public static class SchedulingReports
    extends SchedulingAssistant {
    }

    @PermissionForRight(value=Right.SchedulingDashboard)
    public static class SchedulingDashboard
    extends SchedulingAssistant {
        @Override
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) || this.permissionSession.check(user, source, DepartmentStatusType.Status.StudentsPreRegister);
        }
    }

    @PermissionForRight(value=Right.SchedulingAssistant)
    public static class SchedulingAssistant
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        SolverServerService solverServerService;

        protected boolean hasInstance(Long sessionId) {
            if (sessionId == null) {
                return false;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().hasSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source, DepartmentStatusType.Status.StudentsAssistant, DepartmentStatusType.Status.StudentsOnline)) {
                return false;
            }
            if (!this.hasInstance(user.getCurrentAcademicSessionId())) {
                return false;
            }
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                List<? extends UserQualifier> q = user.getCurrentAuthority().getQualifiers("Student");
                if (q == null || q.isEmpty()) {
                    return false;
                }
                Student student = (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId());
                if (student == null) {
                    return false;
                }
                StudentSectioningStatus status = student.getEffectiveStatus();
                return status == null || status.hasOption(StudentSectioningStatus.Option.enabled);
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (UserAuthority userAuthority : user.getAuthorities("Student", new SimpleQualifier("Session", source.getUniqueId()))) {
                    StudentSectioningStatus status;
                    Student student;
                    List<? extends UserQualifier> q = userAuthority.getQualifiers("Student");
                    if (q == null || q.isEmpty() || (student = (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId())) == null || (status = student.getEffectiveStatus()) == null || status.hasOption(StudentSectioningStatus.Option.enabled)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.EnrollmentAuditPDFReports)
    public static class EnrollmentAuditPDFReports
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverPublish)
    public static class StudentSectioningSolverPublish
    extends StudentSectioningSolver {
    }

    @PermissionForRight(value=Right.StudentSectioningSolutionExportXml)
    public static class StudentSectioningSolutionExportXml
    extends StudentSectioningSolver {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverSave)
    public static class StudentSectioningSolverSave
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverReports)
    public static class StudentSectioningSolverReports
    extends StudentSectioningSolverDashboard {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverDashboard)
    public static class StudentSectioningSolverDashboard
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        SolverService<StudentSolverProxy> studentSectioningSolverService;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source)) {
                return false;
            }
            return user.getCurrentAuthority().hasRight(Right.StudentSectioningSolver) || this.studentSectioningSolverService.getSolver() != null;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.StudentSectioningSolverLog)
    public static class StudentSectioningSolverLog
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSectioningSolver)
    public static class StudentSectioningSolver
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentScheduling)
    public static class StudentScheduling
    extends SimpleSessionPermission {
    }
}

