/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;

public class CriticalCoursesReport
implements StudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private StudentSectioningModel iModel = null;

    public CriticalCoursesReport(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    protected String curriculum(Student student) {
        String curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = curriculum + (curriculum.isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        String group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (AcademicAreaCode aac : student.getMinors()) {
            if ("A".equals(aac.getArea())) continue;
            groups.add(aac.getCode());
        }
        for (String g : groups) {
            group = group + (group.isEmpty() ? "" : ", ") + g;
        }
        return group;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportPriority()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.report1stAlt()), new CSVFile.CSVField((Object)MSG.report2ndAlt()), new CSVFile.CSVField((Object)MSG.reportEnrolledCourse()), new CSVFile.CSVField((Object)MSG.reportEnrolledChoice())});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int priority = 0;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                ++priority;
                if (!cr.isCritical() || cr.isAlternative()) continue;
                Enrollment e = (Enrollment)cr.getAssignment(assignment);
                Course course = (Course)cr.getCourses().get(0);
                Course alt1 = cr.getCourses().size() < 2 ? null : (Course)cr.getCourses().get(1);
                Course alt2 = cr.getCourses().size() < 3 ? null : (Course)cr.getCourses().get(2);
                Course enrolled = e == null ? null : e.getCourse();
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField((Object)student.getExternalId()), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)(dbStudent == null ? null : dbStudent.getEmail())), new CSVFile.CSVField((Object)this.curriculum(student)), new CSVFile.CSVField((Object)this.group(student)), new CSVFile.CSVField(priority), new CSVFile.CSVField((Object)course.getName()), new CSVFile.CSVField((Object)(alt1 == null ? "" : alt1.getName())), new CSVFile.CSVField((Object)(alt2 == null ? "" : alt2.getName())), new CSVFile.CSVField((Object)(enrolled == null ? "" : enrolled.getName())), new CSVFile.CSVField((Object)(enrolled == null ? "" : String.valueOf(cr.getCourses().indexOf(enrolled) + 1)))});
            }
        }
        return csv;
    }
}

