/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.WSCHByDayOfWeekAndHourOfDay;

public class WSCHByBuildingDayOfWeekHourOfDay
extends WSCHByDayOfWeekAndHourOfDay {
    private TreeSet<Building> usedBuildings = new TreeSet();

    @Override
    public String reportName() {
        return MSG.wseByBuildingDayOfWeekAndHourOfDayReport();
    }

    @Override
    public String reportDescription() {
        return MSG.wseByBuildingDayOfWeekAndHourOfDayReportNote();
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnBuilding());
        hdr.add(MSG.columnDayOfWeek());
        this.addTimeColumns(hdr);
        this.setHeader(hdr);
    }

    @Override
    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        this.calculatePeriodsWithEnrollments(pointInTimeData, hibSession);
        int minute = this.startOnHalfHour ? 30 : 0;
        for (Building b : this.usedBuildings) {
            for (int dayOfWeek = 1; dayOfWeek < 8; ++dayOfWeek) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(b.getAbbreviation());
                row.add(this.getDayOfWeekLabel(this.periodDayOfWeek(dayOfWeek)));
                for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
                    String key = this.getPeriodTag(b.getUniqueId().toString(), dayOfWeek, hourOfDay, minute);
                    row.add(this.periodEnrollmentMap.get(key) == null ? "0" : "" + ((WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(key)).getWeeklyStudentEnrollment());
                }
                this.addDataRow(row);
            }
        }
    }

    private void calculatePeriodsWithEnrollments(PointInTimeData pointInTimeData, Session hibSession) {
        HashMap<Long, Building> permIdToBuilding = new HashMap<Long, Building>();
        Building nonUniversityLocationBuilding = new Building();
        nonUniversityLocationBuilding.setAbbreviation(MSG.labelUnknown());
        nonUniversityLocationBuilding.setAbbrName(MSG.labelUnknown());
        nonUniversityLocationBuilding.setName(MSG.labelUnknown());
        nonUniversityLocationBuilding.setUniqueId(new Long(-1L));
        for (Location l : pointInTimeData.getSession().getRooms()) {
            if (l instanceof Room) {
                Room r = (Room)l;
                permIdToBuilding.put(r.getPermanentId(), r.getBuilding());
                continue;
            }
            if (!(l instanceof NonUniversityLocation)) continue;
            NonUniversityLocation nul = (NonUniversityLocation)l;
            permIdToBuilding.put(nul.getPermanentId(), nonUniversityLocationBuilding);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct pc").append("\tfrom PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append("\tinner join pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pitCourseOfferings as pco").append("\twhere pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :sessId").append(" and pc.pitSchedulingSubpart.itype.organized = true").append(" and pco.subjectArea.uniqueId = :saId").append("\tand pco.isControl = true");
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (SubjectArea subjectArea : pointInTimeData.getSession().getSubjectAreas()) {
            for (PitClass pc : hibSession.createQuery(sb.toString()).setLong("sessId", pointInTimeData.getUniqueId().longValue()).setLong("saId", subjectArea.getUniqueId().longValue()).setCacheable(true).list()) {
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                for (Long roomPermanentId : pc.getLocationPeriodUseMap().keySet()) {
                    if (permIdToBuilding.get(roomPermanentId) == null) continue;
                    for (Date period : pc.getLocationPeriodUseMap().get(roomPermanentId)) {
                        String label = this.getPeriodTag(((Building)permIdToBuilding.get(roomPermanentId)).getUniqueId().toString(), period);
                        this.usedBuildings.add((Building)permIdToBuilding.get(roomPermanentId));
                        WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment pe = (WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(label);
                        if (pe == null) {
                            pe = new WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment(this, label, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                            this.periodEnrollmentMap.put(label, pe);
                        }
                        pe.addEnrollment(1.0f * (float)pc.getEnrollment().intValue() / pc.countRoomsForPeriod(period));
                    }
                }
            }
        }
    }
}

