/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class AbbvExamScheduleByCourseReport
extends PdfLegacyExamReport {
    public AbbvExamScheduleByCourseReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY COURSE", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        Vector<String> lines = new Vector<String>();
        int n = this.iNrLines - 2;
        if (!this.iDispRooms) {
            String b;
            ExamInfo.ExamSectionInfo last = null;
            int lx = 0;
            for (ExamAssignment examAssignment : new TreeSet<ExamAssignmentInfo>(this.getExams())) {
                if (examAssignment.getPeriod() == null || !this.hasSubjectArea(examAssignment)) continue;
                boolean firstSection = true;
                TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>(new Comparator<ExamInfo.ExamSectionInfo>(){

                    @Override
                    public int compare(ExamInfo.ExamSectionInfo s1, ExamInfo.ExamSectionInfo s2) {
                        if (!AbbvExamScheduleByCourseReport.this.hasSubjectAreas()) {
                            return s1.compareTo(s2);
                        }
                        if (AbbvExamScheduleByCourseReport.this.hasSubjectArea(s1.getOwner().getCourse().getSubjectArea())) {
                            if (!AbbvExamScheduleByCourseReport.this.hasSubjectArea(s2.getOwner().getCourse().getSubjectArea())) {
                                return -1;
                            }
                        } else if (AbbvExamScheduleByCourseReport.this.hasSubjectArea(s2.getOwner().getCourse().getSubjectArea())) {
                            return 1;
                        }
                        return s1.compareTo(s2);
                    }
                });
                sections.addAll(examAssignment.getSectionsIncludeCrosslistedDummies());
                for (ExamInfo.ExamSectionInfo section : sections) {
                    String w;
                    boolean sameSubj = false;
                    boolean sameCrs = false;
                    boolean sameSct = false;
                    boolean sameItype = false;
                    if (lx % n != 0 && last != null && last.getSubject().equals(section.getSubject())) {
                        sameSubj = true;
                        if (last.getCourseNbr().equals(section.getCourseNbr())) {
                            sameCrs = true;
                            if (last.getSection().equals(section.getSection())) {
                                sameSct = true;
                            }
                            if (last.getItype().equals(section.getItype())) {
                                sameItype = true;
                            }
                        }
                    }
                    last = section;
                    ++lx;
                    if (firstSection) {
                        if (this.iItype) {
                            lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()), 5) + " " + this.lpad(sameSct ? "" : section.getSection(), 9) + "  " + this.formatPeriod(examAssignment));
                        } else {
                            lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.lpad(sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()), 9) + "  " + this.formatShortPeriodNoEndTime(examAssignment));
                        }
                    } else if (this.iItype) {
                        w = "w/" + (sameCrs ? "" : section.getSubject() + " ") + (sameCrs ? "" : section.getCourseNbr() + " ") + (sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()) + " ") + (sameSct ? "" : section.getSection());
                        if (w.length() < 32) {
                            w = this.lpad(w, 32);
                        }
                        lines.add(w);
                    } else {
                        w = "w/" + (sameCrs ? "" : section.getSubject() + " ") + (sameCrs ? "" : section.getCourseNbr() + " ") + (sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()));
                        if (w.length() < 26) {
                            w = this.lpad(w, 26);
                        }
                        lines.add(w);
                    }
                    firstSection = false;
                }
            }
            if (this.iItype) {
                if (this.iExternal) {
                    this.setHeader(new String[]{"Subject Course   ExtID Section    Date      Time            | Subject Course   ExtID Section    Date      Time           ", "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------"});
                } else {
                    this.setHeader(new String[]{"Subject Course   Type  Section    Date      Time            | Subject Course   Type  Section    Date      Time           ", "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------"});
                }
            } else {
                this.setHeader(new String[]{"Subject Course   Section    Date    Time   | Subject Course   Section    Date    Time   | Subject Course   Section    Date    Time  ", "------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------"});
            }
            this.printHeader();
            if (this.iItype) {
                for (int idx = 0; idx < lines.size(); idx += 2 * n) {
                    for (int i = 0; i < n; ++i) {
                        String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : "";
                        b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : "";
                        this.println(this.rpad(a, 60) + "| " + b);
                    }
                }
            } else {
                for (int idx = 0; idx < lines.size(); idx += 3 * n) {
                    for (int i = 0; i < n; ++i) {
                        String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : "";
                        b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : "";
                        String c = i + idx + 2 * n < lines.size() ? (String)lines.elementAt(i + idx + 2 * n) : "";
                        this.println(this.rpad(a, 43) + "| " + this.rpad(b, 43) + "| " + c);
                    }
                }
            }
        } else {
            Object b;
            ExamInfo.ExamSectionInfo last = null;
            int lx = 0;
            for (ExamAssignment examAssignment : new TreeSet<ExamAssignmentInfo>(this.getExams())) {
                if (examAssignment.getPeriod() == null || !this.hasSubjectArea(examAssignment)) continue;
                Vector<String> rooms = new Vector<String>();
                if (examAssignment.getRooms() == null || examAssignment.getRooms().isEmpty()) {
                    rooms.add(this.rpad(this.iNoRoom, 11));
                } else {
                    b = examAssignment.getRooms().iterator();
                    while (b.hasNext()) {
                        ExamRoomInfo room = b.next();
                        rooms.add(this.formatRoom(room));
                    }
                }
                Vector<ExamInfo.ExamSectionInfo> sections = new Vector<ExamInfo.ExamSectionInfo>(examAssignment.getSectionsIncludeCrosslistedDummies());
                Collections.sort(sections, new Comparator<ExamInfo.ExamSectionInfo>(){

                    @Override
                    public int compare(ExamInfo.ExamSectionInfo s1, ExamInfo.ExamSectionInfo s2) {
                        if (!AbbvExamScheduleByCourseReport.this.hasSubjectAreas()) {
                            return s1.compareTo(s2);
                        }
                        if (AbbvExamScheduleByCourseReport.this.hasSubjectArea(s1.getOwner().getCourse().getSubjectArea())) {
                            if (!AbbvExamScheduleByCourseReport.this.hasSubjectArea(s2.getOwner().getCourse().getSubjectArea())) {
                                return -1;
                            }
                        } else if (AbbvExamScheduleByCourseReport.this.hasSubjectArea(s2.getOwner().getCourse().getSubjectArea())) {
                            return 1;
                        }
                        return s1.compareTo(s2);
                    }
                });
                for (int i = 0; i < Math.max(rooms.size(), sections.size()); ++i) {
                    String a = i < rooms.size() ? (String)rooms.elementAt(i) : this.rpad("", 11);
                    ExamInfo.ExamSectionInfo section = i < sections.size() ? sections.elementAt(i) : null;
                    boolean sameSubj = false;
                    boolean sameCrs = false;
                    boolean sameSct = false;
                    boolean sameItype = false;
                    if (lx % n != 0 && last != null && section != null && last.getSubject().equals(section.getSubject())) {
                        sameSubj = true;
                        if (last.getCourseNbr().equals(section.getCourseNbr())) {
                            sameCrs = true;
                            if (last.getSection().equals(section.getSection())) {
                                sameSct = true;
                            }
                            if (last.getItype().equals(section.getItype())) {
                                sameItype = true;
                            }
                        }
                    }
                    if (i == 0) {
                        if (this.iItype) {
                            lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()), 5) + " " + this.lpad(sameSct ? "" : section.getSection(), 9) + " " + this.formatShortPeriod(section.getExamAssignment()) + " " + a);
                        } else {
                            lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.lpad(sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()), 9) + " " + this.formatPeriod(section.getExamAssignment()) + " " + a);
                        }
                    } else if (section != null) {
                        String w;
                        if (this.iItype) {
                            w = "w/" + (sameCrs ? "" : section.getSubject() + " ") + (sameCrs ? "" : section.getCourseNbr() + " ") + (sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()) + " ") + (sameSct ? "" : section.getSection());
                            if (w.length() < 32) {
                                w = this.lpad(w, 32);
                            }
                            lines.add(this.rpad(w, 55) + a);
                        } else {
                            w = "w/" + (sameCrs ? "" : section.getSubject() + " ") + (sameCrs ? "" : section.getCourseNbr() + " ") + (sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()));
                            if (w.length() < 26) {
                                w = this.lpad(w, 26);
                            }
                            lines.add(this.rpad(w, 53) + a);
                        }
                    } else {
                        lines.add(this.rpad("", this.iItype ? 55 : 53) + a);
                    }
                    ++lx;
                }
            }
            if (this.iItype) {
                if (this.iExternal) {
                    this.setHeader(new String[]{"Subject Course   ExtID Section   Date    Time          Bldg  Room |Subject Course   ExtID Section   Date    Time          Bldg  Room", "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----"});
                } else {
                    this.setHeader(new String[]{"Subject Course   Type  Section   Date    Time          Bldg  Room |Subject Course   Type  Section   Date    Time          Bldg  Room", "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----"});
                }
            } else {
                this.setHeader(new String[]{"Subject Course   Section   Date      Time            Bldg  Room  | Subject Course   Section   Date      Time            Bldg  Room ", "------- -------- --------- --------- --------------- ----- ----- | ------- -------- --------- --------- --------------- ----- -----"});
            }
            this.printHeader();
            for (int idx = 0; idx < lines.size(); idx += 2 * n) {
                for (int i = 0; i < n; ++i) {
                    String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : this.rpad("", 65);
                    Object object = b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : this.rpad("", 65);
                    if (this.iItype) {
                        this.println(this.rpad(a, 66) + "|" + this.rpad((String)b, 66));
                        continue;
                    }
                    this.println(this.rpad(a, 65) + "| " + this.rpad((String)b, 64));
                }
            }
        }
    }
}

