/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindEnrollmentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.EnrollmentInfo>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Query iQuery;
    protected Integer iLimit = null;
    protected Long iCourseId;
    protected Set<Long> iCoursesIcoordinate;
    protected Set<Long> iCoursesIcanApprove;
    protected Set<Long> iMyStudents;
    protected Set<String> iSubjectAreas;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindEnrollmentInfoAction withParams(String query, Long courseId, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove, Set<Long> myStudents, Set<String> subjects) {
        this.iQuery = new Query(query);
        this.iCourseId = courseId;
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        this.iMyStudents = myStudents;
        this.iSubjectAreas = subjects;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindEnrollmentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public Long courseId() {
        return this.iCourseId;
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    public boolean hasMatchingSubjectArea(String subject) {
        return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.EnrollmentInfo> ret = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        boolean solver = server instanceof StudentSolver;
        Set<Long> studentIds = null;
        if (!solver) {
            Set<Long> set = studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        }
        if (this.courseId() == null) {
            HashSet<Long> students = new HashSet<Long>();
            HashSet<Long> matchingStudents = new HashSet<Long>();
            int gEnrl = 0;
            int gWait = 0;
            int gRes = 0;
            int gUnasg = 0;
            int gUnasgPrim = 0;
            int gtEnrl = 0;
            int gtWait = 0;
            int gtRes = 0;
            int gtUnasg = 0;
            int gtUnasgPrim = 0;
            int gConNeed = 0;
            int gtConNeed = 0;
            int gOvrNeed = 0;
            int gtOvrNeed = 0;
            for (XCourseId xCourseId : server.findCourses(new FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup))) {
                int n;
                int n2;
                XCourse course;
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || (course = offering.getCourse(xCourseId.getCourseId())) == null) continue;
                XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
                boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(xCourseId.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(course.getSubjectArea());
                e.setCourseNbr(course.getCourseNumber());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentAbbv());
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int tEnrl = 0;
                int tWait = 0;
                int n3 = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int ovrNeed = 0;
                int tOvrNeed = 0;
                HashSet<Long> addedStudents = new HashSet<Long>();
                boolean checkOverrides = !this.query().hasAttribute("override");
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XStudent student;
                    XOverride override;
                    if (!xCourseRequest.hasCourse(xCourseId.getCourseId())) continue;
                    if (students.add(xCourseRequest.getStudentId())) {
                        addedStudents.add(xCourseRequest.getStudentId());
                    }
                    if (xCourseRequest.getEnrollment() != null && !xCourseRequest.getEnrollment().getCourseId().equals(xCourseId.getCourseId()) || checkOverrides && xCourseRequest.getEnrollment() == null && (override = xCourseRequest.getOverride(xCourseId)) != null && !override.isApproved()) continue;
                    if (studentIds != null && !studentIds.contains(xCourseRequest.getStudentId())) {
                        if (xCourseRequest.getEnrollment() != null) {
                            ++tEnrl;
                            if (xCourseRequest.getEnrollment().getReservation() != null) {
                                ++n3;
                            }
                            if (course.getConsentLabel() == null || xCourseRequest.getEnrollment().getApproval() != null) continue;
                            ++tConNeed;
                            continue;
                        }
                        student = server.getStudent(xCourseRequest.getStudentId());
                        if (student == null || !student.canAssign(xCourseRequest)) continue;
                        ++tUnasg;
                        if (xCourseRequest.isAlternative() || !xCourseRequest.isPrimary(xCourseId)) continue;
                        ++tUnasgPrim;
                        if (!xCourseRequest.isWaitlist()) continue;
                        ++tWait;
                        continue;
                    }
                    student = server.getStudent(xCourseRequest.getStudentId());
                    if (student == null) continue;
                    StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, xCourseRequest, isConsentToDoCourse, this.isMyStudent(student), lookup, server);
                    if (this.query().match(m)) {
                        matchingStudents.add(xCourseRequest.getStudentId());
                        ++match;
                        if (m.enrollment() != null) {
                            ++enrl;
                            if (m.enrollment().getReservation() != null) {
                                ++res;
                            }
                            if (course.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                                ++conNeed;
                            }
                        } else if (m.student().canAssign(m.request())) {
                            ++unasg;
                            if (!m.request().isAlternative() && m.request().isPrimary(xCourseId)) {
                                ++unasgPrim;
                                if (m.request().isWaitlist()) {
                                    ++wait;
                                }
                            }
                        }
                        if (m.request().isOverridePending(course)) {
                            ++ovrNeed;
                        }
                    } else if (solver) {
                        if (xCourseRequest.getEnrollment() != null) {
                            ++tEnrl;
                            if (xCourseRequest.getEnrollment().getReservation() != null) {
                                ++n3;
                            }
                            if (course.getConsentLabel() == null || xCourseRequest.getEnrollment().getApproval() != null) continue;
                            ++tConNeed;
                            continue;
                        }
                        if (student == null || !student.canAssign(xCourseRequest)) continue;
                        ++tUnasg;
                        if (xCourseRequest.isAlternative() || !xCourseRequest.isPrimary(xCourseId)) continue;
                        ++tUnasgPrim;
                        if (!xCourseRequest.isWaitlist()) continue;
                        ++tWait;
                        continue;
                    }
                    if (m.enrollment() != null) {
                        ++tEnrl;
                        if (m.enrollment().getReservation() != null) {
                            ++n3;
                        }
                        if (course.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            ++tConNeed;
                        }
                    } else if (m.student().canAssign(m.request())) {
                        ++tUnasg;
                        if (!m.request().isAlternative() && m.request().isPrimary(xCourseId)) {
                            ++tUnasgPrim;
                            if (m.request().isWaitlist()) {
                                ++tWait;
                            }
                        }
                    }
                    if (!m.request().isOverridePending(course)) continue;
                    ++tOvrNeed;
                }
                if (match == 0) {
                    students.removeAll(addedStudents);
                    continue;
                }
                gEnrl += enrl;
                gWait += wait;
                gUnasg += unasg;
                gUnasgPrim += unasgPrim;
                gRes += res;
                gConNeed += conNeed;
                gOvrNeed += ovrNeed;
                gtEnrl += tEnrl;
                gtWait += tWait;
                gtUnasg += tUnasg;
                gtUnasgPrim += tUnasgPrim;
                gtRes += n3;
                gtConNeed += tConNeed;
                gtOvrNeed += tOvrNeed;
                int limit = 0;
                for (XConfig config : offering.getConfigs()) {
                    if (config.getLimit() < 0) {
                        limit = -1;
                        break;
                    }
                    limit += config.getLimit();
                }
                e.setLimit(course.getLimit());
                e.setProjection(course.getProjected());
                int n4 = Math.max(0, offering.getUnreservedSpace(enrollments));
                if (course.getLimit() >= 0 && n4 > course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId())) {
                    n2 = course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId());
                }
                if (n2 == Integer.MAX_VALUE) {
                    n = -1;
                }
                e.setAvailable(n);
                if (n >= 0) {
                    int other = 0;
                    for (XCourse c : offering.getCourses()) {
                        if (c.equals(course)) continue;
                        other += enrollments.countEnrollmentsForCourse(c.getCourseId());
                    }
                    e.setOther(Math.min(course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId()) - n, other));
                    int lim = 0;
                    for (XConfig f : offering.getConfigs()) {
                        if (lim < 0 || f.getLimit() < 0) {
                            lim = -1;
                            continue;
                        }
                        lim += f.getLimit();
                    }
                    if (lim >= 0 && lim < course.getLimit()) {
                        e.setOther(e.getOther() + course.getLimit() - limit);
                    }
                }
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(n3);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                e.setOverrideNeeded(ovrNeed);
                e.setTotalOverrideNeeded(tOvrNeed);
                ret.add(e);
                if (this.limit() == null || ret.size() < this.limit()) continue;
                break;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                @Override
                public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                    int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return 0;
                }
            });
            ClassAssignmentInterface.EnrollmentInfo enrollmentInfo = new ClassAssignmentInterface.EnrollmentInfo();
            enrollmentInfo.setSubject(MSG.total());
            enrollmentInfo.setCourseNbr("");
            enrollmentInfo.setLimit(students.size());
            enrollmentInfo.setAvailable(matchingStudents.size());
            enrollmentInfo.setEnrollment(gEnrl);
            enrollmentInfo.setReservation(gRes);
            enrollmentInfo.setWaitlist(gWait);
            enrollmentInfo.setUnassigned(gUnasg);
            enrollmentInfo.setUnassignedPrimary(gUnasgPrim);
            enrollmentInfo.setTotalEnrollment(gtEnrl);
            enrollmentInfo.setTotalReservation(gtRes);
            enrollmentInfo.setTotalWaitlist(gtWait);
            enrollmentInfo.setTotalUnassigned(gtUnasg);
            enrollmentInfo.setTotalUnassignedPrimary(gtUnasgPrim);
            enrollmentInfo.setConsentNeeded(gConNeed);
            enrollmentInfo.setTotalConsentNeeded(gtConNeed);
            enrollmentInfo.setOverrideNeeded(gOvrNeed);
            enrollmentInfo.setTotalOverrideNeeded(gtOvrNeed);
            ret.add(enrollmentInfo);
        } else {
            XCourse info = server.getCourse(this.courseId());
            if (info == null) {
                return ret;
            }
            final XOffering offering = server.getOffering(info.getOfferingId());
            if (offering == null) {
                return ret;
            }
            XCourse course = offering.getCourse(info.getCourseId());
            if (course == null) {
                return ret;
            }
            XEnrollments enrollments = server.getEnrollments(info.getOfferingId());
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            XExpectations expectations = server.getExpectations(info.getOfferingId());
            boolean isConsentToDoCourse = this.isConsentToDoCourse(info);
            ArrayList<XSection> sections = new ArrayList<XSection>();
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    sections.addAll(subpart.getSections());
                }
            }
            Collections.sort(sections, new Comparator<XSection>(){

                @Override
                public int compare(XConfig c1, XConfig c2) {
                    int cmp = c1.getName().compareToIgnoreCase(c2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getConfigId().compareTo(c2.getConfigId());
                }

                public boolean isParent(XSubpart s1, XSubpart s2) {
                    XSubpart p1;
                    XSubpart xSubpart = p1 = s1.getParentId() == null ? null : offering.getSubpart(s1.getParentId());
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(XSubpart s1, XSubpart s2) {
                    int cmp = this.compare(offering.getConfig(s1.getConfigId()), offering.getConfig(s2.getConfigId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.isParent(s1, s2)) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    cmp = s1.getInstructionalType().compareTo(s2.getInstructionalType());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSubpartId().compareTo(s2.getSubpartId());
                }

                @Override
                public int compare(XSection s1, XSection s2) {
                    if (s1.getSubpartId().equals(s2.getSubpartId())) {
                        int cmp;
                        if (s1.getParentId() != null && (cmp = this.compare(offering.getSection(s1.getParentId()), offering.getSection(s2.getParentId()))) != 0) {
                            return cmp;
                        }
                        try {
                            cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        catch (NumberFormatException cmp2) {
                            // empty catch block
                        }
                        cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getSectionId().compareTo(s2.getSectionId());
                    }
                    XSection x = s1;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s2.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s2.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(x, s);
                            return cmp == 0 ? (x.equals(s1) ? -1 : this.compare(offering.getSubpart(x.getSubpartId()), offering.getSubpart(s.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    x = s2;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s1.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(s, x);
                            return cmp == 0 ? (x.equals(s2) ? 1 : this.compare(offering.getSubpart(s.getSubpartId()), offering.getSubpart(x.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    int cmp = this.compare(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(s2.getSubpartId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    try {
                        cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                        if (cmp != 0) {
                            return cmp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSectionId().compareTo(s2.getSectionId());
                }
            });
            boolean checkOverrides = !this.query().hasAttribute("override");
            HashMap<Long, HashSet<Long>> section2students = new HashMap<Long, HashSet<Long>>();
            for (XCourseRequest request : enrollments.getRequests()) {
                XOverride override;
                XStudent student;
                if (request.getEnrollment() != null || !request.hasCourse(this.courseId()) || (student = server.getStudent(request.getStudentId())) == null || !student.canAssign(request) || checkOverrides && request.getEnrollment() == null && (override = request.getOverride(info)) != null && !override.isApproved()) continue;
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest r = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server);
                block8: for (Enrollment en : r.values((Assignment)assignment)) {
                    for (Request x : r.getStudent().getRequests()) {
                        Enrollment xe = (Enrollment)assignment.getValue((Variable)x);
                        if (x.equals((Object)r) || xe == null || !xe.isOverlapping(en)) continue;
                        continue block8;
                    }
                    for (Section s : en.getSections()) {
                        HashSet<Long> students = (HashSet<Long>)section2students.get(s.getId());
                        if (students == null) {
                            students = new HashSet<Long>();
                            section2students.put(s.getId(), students);
                        }
                        students.add(student.getStudentId());
                    }
                }
            }
            for (XSection section : sections) {
                String consent;
                Object request32;
                void var25_50;
                StatusPageSuggestionsAction.CourseRequestMatcher m;
                XStudent student;
                XSection parent;
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(info.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(info.getSubjectArea());
                e.setCourseNbr(info.getCourseNumber());
                e.setTitle(info.getTitle());
                e.setConsent(info.getConsentAbbv());
                XSubpart subpart = offering.getSubpart(section.getSubpartId());
                XConfig config = offering.getConfig(subpart.getConfigId());
                e.setConfig(config.getName());
                e.setConfigId(config.getConfigId());
                e.setSubpart(subpart.getName());
                e.setSubpartId(subpart.getSubpartId());
                e.setClazz(section.getName(this.courseId()));
                e.setClazzId(section.getSectionId());
                XSection xSection = parent = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                while (parent != null) {
                    e.incLevel();
                    parent = parent.getParentId() == null ? null : offering.getSection(parent.getParentId());
                }
                int match = 0;
                boolean bl = false;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int other = 0;
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XEnrollment enrollment = xCourseRequest.getEnrollment();
                    if (enrollment == null || !enrollment.getSectionIds().contains(section.getSectionId())) continue;
                    if (!xCourseRequest.getEnrollment().getCourseId().equals(this.courseId())) {
                        ++other;
                        continue;
                    }
                    student = server.getStudent(xCourseRequest.getStudentId());
                    if (student == null) continue;
                    m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, xCourseRequest, isConsentToDoCourse, this.isMyStudent(student), lookup, server);
                    if (this.query().match(m)) {
                        ++match;
                        ++var25_50;
                        if (m.enrollment().getReservation() != null) {
                            ++res;
                        }
                        if (info.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            ++conNeed;
                        }
                    }
                    ++tEnrl;
                    if (m.enrollment().getReservation() != null) {
                        ++tRes;
                    }
                    if (info.getConsentLabel() == null || m.enrollment().getApproval() != null) continue;
                    ++tConNeed;
                }
                Set students = (Set)section2students.get(section.getSectionId());
                if (students != null) {
                    for (Object request32 : enrollments.getRequests()) {
                        XOverride override;
                        if (!students.contains(((XRequest)request32).getStudentId()) || ((XCourseRequest)request32).getEnrollment() != null || !((XCourseRequest)request32).hasCourse(this.courseId()) || (student = server.getStudent(((XRequest)request32).getStudentId())) == null || !student.canAssign((XCourseRequest)request32) || checkOverrides && ((XCourseRequest)request32).getEnrollment() == null && (override = ((XCourseRequest)request32).getOverride(info)) != null && !override.isApproved()) continue;
                        m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, (XCourseRequest)request32, isConsentToDoCourse, this.isMyStudent(student), lookup, server);
                        if (this.query().match(m)) {
                            ++match;
                            ++unasg;
                            if (!((XRequest)request32).isAlternative() && ((XCourseRequest)request32).isPrimary(info)) {
                                ++unasgPrim;
                                if (((XCourseRequest)request32).isWaitlist()) {
                                    ++wait;
                                }
                            }
                        }
                        ++tUnasg;
                        if (((XRequest)request32).isAlternative() || !((XCourseRequest)request32).isPrimary(info)) continue;
                        ++tUnasgPrim;
                        if (!((XCourseRequest)request32).isWaitlist()) continue;
                        ++tWait;
                    }
                }
                if (match == 0) continue;
                e.setLimit(section.getLimit());
                e.setOther(other);
                e.setAvailable(section.isCancelled() || !section.isEnabledForScheduling() ? 0 : Math.max(0, offering.getUnreservedSectionSpace(section.getSectionId(), enrollments)));
                if (e.getAvailable() == Integer.MAX_VALUE) {
                    e.setAvailable(-1);
                }
                e.setProjection(tEnrl + (int)Math.round(expectations.getExpectedSpace(section.getSectionId())));
                e.setEnrollment((int)var25_50);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                ClassAssignmentInterface.ClassAssignment classAssignment = new ClassAssignmentInterface.ClassAssignment();
                classAssignment.setClassId(section.getSectionId());
                classAssignment.setSubpart(section.getSubpartName());
                classAssignment.setClassNumber(section.getName(-1L));
                classAssignment.setSection(section.getName(this.courseId()));
                classAssignment.setExternalId(section.getExternalId(this.courseId()));
                classAssignment.setCancelled(section.isCancelled());
                classAssignment.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                if (section.getTime() != null) {
                    request32 = DayCode.toDayCodes(section.getTime().getDays()).iterator();
                    while (request32.hasNext()) {
                        DayCode d = (DayCode)((Object)request32.next());
                        classAssignment.addDay(d.getIndex());
                    }
                    classAssignment.setStart(section.getTime().getSlot());
                    classAssignment.setLength(section.getTime().getLength());
                    classAssignment.setBreakTime(section.getTime().getBreakTime());
                    classAssignment.setDatePattern(section.getTime().getDatePatternName());
                }
                if (section.getNrRooms() > 0) {
                    request32 = section.getRooms().iterator();
                    while (request32.hasNext()) {
                        XRoom rm = (XRoom)request32.next();
                        classAssignment.addRoom(rm.getUniqueId(), rm.getName());
                    }
                }
                if (section.getInstructors() != null) {
                    request32 = section.getInstructors().iterator();
                    while (request32.hasNext()) {
                        XInstructor instructor = (XInstructor)request32.next();
                        classAssignment.addInstructor(instructor.getName());
                        classAssignment.addInstructoEmail(instructor.getEmail());
                    }
                }
                if (section.getParentId() != null) {
                    classAssignment.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                }
                classAssignment.setSubpartId(section.getSubpartId());
                classAssignment.addNote(course.getNote());
                classAssignment.addNote(section.getNote());
                classAssignment.setCredit(subpart.getCredit(course.getCourseId()));
                Float creditOverride = section.getCreditOverride(course.getCourseId());
                if (creditOverride != null) {
                    classAssignment.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                if (classAssignment.getParentSection() == null && (consent = server.getCourse(this.courseId()).getConsentLabel()) != null) {
                    classAssignment.setParentSection(consent);
                }
                classAssignment.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                e.setAssignment(classAssignment);
                ret.add(e);
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return "find-enrollment-info";
    }

    public static class FindEnrollmentInfoCourseMatcher
    extends AbstractCourseMatcher {
        protected static final long serialVersionUID = 1L;
        protected Set<Long> iCoursesIcoordinate;
        protected Set<Long> iCoursesIcanApprove;
        protected Set<String> iSubjectAreas;
        protected Query iQuery;
        protected StatusPageSuggestionsAction.CourseLookup iLookup;

        public FindEnrollmentInfoCourseMatcher(Set<Long> coursesIcoordinate, Set<Long> coursesIcanApprove, Set<String> subjects, Query query, StatusPageSuggestionsAction.CourseLookup lookup) {
            this.iCoursesIcoordinate = coursesIcoordinate;
            this.iCoursesIcanApprove = coursesIcanApprove;
            this.iSubjectAreas = subjects;
            this.iQuery = query;
            this.iLookup = lookup;
        }

        public boolean isCourseVisible(Long courseId) {
            return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
        }

        public boolean isConsentToDoCourse(XCourse course) {
            return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
        }

        public boolean hasMatchingSubjectArea(String subject) {
            return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
        }

        @Override
        public boolean match(XCourseId id) {
            XCourse course = id instanceof XCourse ? (XCourse)id : this.getServer().getCourse(id.getCourseId());
            return course != null && this.isCourseVisible(course.getCourseId()) && this.hasMatchingSubjectArea(course.getSubjectArea()) && this.iQuery.match(new StatusPageSuggestionsAction.CourseInfoMatcher(course, this.isConsentToDoCourse(course), this.iLookup));
        }
    }
}

