/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.reservation.Reservation;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XLearningCommunityReservationSerializer.class)
public class XLearningCommunityReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private Set<Long> iStudentIds = new HashSet<Long>();
    private XCourseId iCourseId;
    private XStudent.XGroup iGroup;

    public XLearningCommunityReservation() {
    }

    public XLearningCommunityReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XLearningCommunityReservation(XOffering offering, LearningCommunityReservation reservation) {
        super(XReservationType.LearningCommunity, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iCourseId = new XCourseId(reservation.getCourse());
        this.iGroup = new XStudent.XGroup(reservation.getGroup());
        if (reservation.getGroup().getType() != null && reservation.getGroup().getType().getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
            this.setAllowDisabled(true);
        }
    }

    public XLearningCommunityReservation(org.cpsolver.studentsct.reservation.LearningCommunityReservation reservation) {
        super(XReservationType.LearningCommunity, (Reservation)reservation);
        this.iStudentIds.addAll(reservation.getStudentIds());
        this.iCourseId = new XCourseId(reservation.getCourse());
        this.iLimit = (int)Math.round(reservation.getLimit());
        this.setAllowDisabled(reservation.isAllowDisabled());
    }

    public XStudent.XGroup getGroup() {
        return this.iGroup;
    }

    public Long getCourseId() {
        return this.iCourseId.getCourseId();
    }

    @Override
    public Long getOfferingId() {
        return this.iCourseId.getOfferingId();
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        if (this.iGroup == null ? !this.iStudentIds.contains(student.getStudentId()) : !student.getGroups().contains(this.iGroup)) {
            return false;
        }
        if (course != null) {
            return this.iCourseId.equals(course);
        }
        for (XRequest request : student.getRequests()) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).getCourseIds().contains(this.iCourseId)) continue;
            return true;
        }
        return false;
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iGroup = in.readBoolean() ? new XStudent.XGroup(in) : null;
        int nrStudents = in.readInt();
        this.iStudentIds.clear();
        for (int i = 0; i < nrStudents; ++i) {
            this.iStudentIds.add(in.readLong());
        }
        this.iCourseId = new XCourseId(in);
        this.iLimit = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.iGroup != null) {
            out.writeBoolean(true);
            this.iGroup.writeExternal(out);
        }
        out.writeInt(this.iStudentIds.size());
        for (Long studentId : this.iStudentIds) {
            out.writeLong(studentId);
        }
        this.iCourseId.writeExternal(out);
        out.writeInt(this.iLimit);
    }

    public static class XLearningCommunityReservationSerializer
    implements Externalizer<XLearningCommunityReservation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XLearningCommunityReservation object) throws IOException {
            object.writeExternal(output);
        }

        public XLearningCommunityReservation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XLearningCommunityReservation(input);
        }
    }
}

