/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningSaver;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationHelper;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.solver.studentsct.InMemoryReport;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Formats;

public class PurdueBatchSolverValidator
extends StudentSectioningSaver {
    private static Log sLog = LogFactory.getLog(PurdueBatchSolverValidator.class);
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private String iOwnerId = null;
    private Progress iProgress = null;
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;
    private AcademicSessionInfo iSession;
    private InMemoryReport iCSV;
    private int iNrThreads = 1;
    private boolean iCanContinue = true;
    private Hashtable<Long, CourseOffering> iCourses = null;
    private Hashtable<Long, Class_> iClasses = null;

    public PurdueBatchSolverValidator(Solver solver) {
        super(solver);
        this.iInitiative = solver.getProperties().getProperty("Data.Initiative");
        this.iYear = solver.getProperties().getProperty("Data.Year");
        this.iTerm = solver.getProperties().getProperty("Data.Term");
        this.iOwnerId = solver.getProperties().getProperty("General.OwnerPuid");
        this.iProgress = Progress.getInstance((Object)this.getModel());
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
        this.iNrThreads = solver.getProperties().getPropertyInt("Save.XE.NrSaveThreads", 10);
        this.iCSV = new InMemoryReport("VALIDATION", "Last Validation Results (" + Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT).format(new Date()) + ")");
        ((StudentSolver)solver).setReport(this.iCSV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        this.iProgress.setStatus("Validating solution ...");
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        this.iCSV.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"PUID"), new CSVFile.CSVField((Object)"Name"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"CRN"), new CSVFile.CSVField((Object)"Code"), new CSVFile.CSVField((Object)"Message")});
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            hibSession = SessionDAO.getInstance().getSession();
            hibSession.setCacheMode(CacheMode.IGNORE);
            hibSession.setFlushMode(FlushMode.MANUAL);
            tx = hibSession.beginTransaction();
            Session session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
            if (session == null) {
                throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
            }
            ApplicationProperties.setSessionId(session.getUniqueId());
            this.iSession = new AcademicSessionInfo(session);
            this.validate(session, hibSession);
            hibSession.flush();
            tx.commit();
            tx = null;
        }
        catch (Exception e) {
            this.iProgress.fatal("Unable to validate, reason: " + e.getMessage(), (Throwable)e);
            sLog.error((Object)e.getMessage(), (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
            try {
                this.iClient.stop();
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void validate(Session session, org.hibernate.Session hibSession) {
        this.setPhase("Loading classes...", 1L);
        this.iClasses = new Hashtable();
        for (Class_ clazz : hibSession.createQuery("select distinct c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            this.iClasses.put(clazz.getUniqueId(), clazz);
        }
        this.incProgress();
        this.iCourses = new Hashtable();
        this.setPhase("Loading courses...", 1L);
        for (CourseOffering course : hibSession.createQuery("select distinct c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            this.iCourses.put(course.getUniqueId(), course);
        }
        this.incProgress();
        this.setPhase("Validating students...", ((StudentSectioningModel)this.getModel()).getStudents().size());
        if (this.iNrThreads <= 1) {
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                this.incProgress();
                if (student.isDummy()) continue;
                this.validateStudent(student);
            }
        } else {
            ArrayList<Worker> workers = new ArrayList<Worker>();
            Iterator<Student> students = ((StudentSectioningModel)this.getModel()).getStudents().iterator();
            for (int i = 0; i < this.iNrThreads; ++i) {
                workers.add(new Worker(i, students));
            }
            for (Worker worker : workers) {
                worker.start();
            }
            for (Worker worker : workers) {
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    this.iCanContinue = false;
                    try {
                        worker.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.iCanContinue) {
                throw new RuntimeException("The validate was interrupted.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateStudent(Student student) {
        long c0 = OnlineSectioningHelper.getCpuTime();
        OnlineSectioningLog.Action.Builder action = OnlineSectioningLog.Action.newBuilder();
        action.setOperation("batch-validate");
        action.setSession(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iSession.getUniqueId()).setName(this.iSession.toCompactString()));
        action.setStartTime(System.currentTimeMillis());
        action.setUser(this.getUser());
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getId()).setExternalId(student.getExternalId()).setName(student.getName()).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
        OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
        requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
        for (Request request : student.getRequests()) {
            Enrollment e;
            action.addRequest(OnlineSectioningHelper.toProto(request));
            if (!(request instanceof CourseRequest) || (e = (Enrollment)this.getAssignment().getValue((Variable)request)) == null) continue;
            for (Section section : e.getSections()) {
                requested.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, e));
            }
        }
        action.addEnrollment(requested);
        ArrayList<CSVFile.CSVField[]> csv = new ArrayList<CSVFile.CSVField[]>();
        try {
            this.validate(student, action, csv);
        }
        finally {
            action.setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
        }
        StringBuffer table = new StringBuffer();
        InMemoryReport inMemoryReport = this.iCSV;
        synchronized (inMemoryReport) {
            for (CSVFile.CSVField[] line : csv) {
                if (table.length() > 0) {
                    table.append("\n");
                }
                table.append(this.iCSV.addLine(line));
            }
            action.addOptionBuilder().setKey("table").setValue(table.toString());
        }
        OnlineSectioningLogger.getInstance().record(OnlineSectioningLog.Log.newBuilder().addAction(action).build());
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        return builder.create();
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiValidationSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site.validation", this.getSpecialRegistrationApiSite() + "/checkRestrictions");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.batch", "PREREG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(Student student, OnlineSectioningLog.Action.Builder action, List<CSVFile.CSVField[]> csv) {
        this.iProgress.info("[" + student.getExternalId() + "] " + student.getName());
        String term = this.iExternalTermProvider.getExternalTerm(this.iSession);
        String campus = this.iExternalTermProvider.getExternalCampus(this.iSession);
        String puid = this.getBannerId(student);
        SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        req.studentId = puid;
        req.term = term;
        req.campus = campus;
        req.mode = this.getSpecialRegistrationApiMode();
        for (Request request : student.getRequests()) {
            CourseOffering course;
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest() || (course = this.iCourses.get(enrollment.getCourse().getId())) == null) continue;
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null) continue;
                SpecialRegistrationHelper.addCrn(req, clazz.getExternalId(course));
            }
        }
        if (req.changes == null) {
            action.addOptionBuilder().setKey("validation_request").setValue(this.getGson().toJson((Object)req));
            action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
            return;
        }
        SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson();
            action.addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)req));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
            action.setApiPostTime(System.currentTimeMillis() - t1);
            resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
            action.addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
            if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                throw new SectioningException(resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)resp.status) + ")." : resp.message);
            }
        }
        catch (Exception e) {
            action.setApiException(e.getMessage());
            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getClass().getSimpleName() + ": " + e.getMessage()));
            this.iProgress.error("[" + student.getExternalId() + "] Failed to validate: " + e.getMessage(), (Throwable)e);
            csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)"FAIL"), new CSVFile.CSVField((Object)e.getMessage())});
            return;
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        if (resp != null && resp.outJson != null && resp.outJson.problems != null) {
            for (SpecialRegistrationInterface.Problem p : resp.outJson.problems) {
                if (p.crn == null) {
                    this.iProgress.warn("[" + student.getExternalId() + "] " + p.message);
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)p.code), new CSVFile.CSVField((Object)p.message)});
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(p.message));
                } else {
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)this.getCourseNameForCrn(student, p.crn)), new CSVFile.CSVField((Object)p.crn), new CSVFile.CSVField((Object)p.code), new CSVFile.CSVField((Object)p.message)});
                    this.iProgress.warn("[" + student.getExternalId() + "] " + p.crn + ": " + p.message);
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(p.crn + ": " + p.message));
                }
                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
            }
        }
    }

    protected String getBannerId(Student student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    public String getCourseNameForCrn(Student student, String crn) {
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest()) continue;
            CourseOffering course = this.iCourses.get(enrollment.getCourse().getId());
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null || course == null || !crn.equals(clazz.getExternalId(course))) continue;
                return course.getCourseName();
            }
        }
        return null;
    }

    public OfferingConsentType getConsent(Student student, String crn) {
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest()) continue;
            CourseOffering course = this.iCourses.get(enrollment.getCourse().getId());
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null || course == null || !crn.equals(clazz.getExternalId(course))) continue;
                course.getConsentType();
            }
        }
        return null;
    }

    protected OnlineSectioningLog.Entity getUser() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(this.iOwnerId).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
    }

    protected void checkTermination() {
        if (this.getTerminationCondition() != null && !this.getTerminationCondition().canContinue(this.getSolution())) {
            throw new RuntimeException("The validate was interrupted.");
        }
    }

    protected void setPhase(String phase, long progressMax) {
        this.checkTermination();
        this.iProgress.setPhase(phase, progressMax);
    }

    protected void incProgress() {
        this.checkTermination();
        this.iProgress.incProgress();
    }

    protected class Worker
    extends Thread {
        private Iterator<Student> iStudents;

        public Worker(int index, Iterator<Student> students) {
            this.setName("XEValidator-" + (1 + index));
            this.iStudents = students;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PurdueBatchSolverValidator.this.iProgress.debug(this.getName() + " has started.");
            while (true) {
                Student student = null;
                Iterator<Student> iterator = this.iStudents;
                synchronized (iterator) {
                    if (!PurdueBatchSolverValidator.this.iCanContinue) {
                        PurdueBatchSolverValidator.this.iProgress.debug(this.getName() + " has stopped.");
                        return;
                    }
                    if (!this.iStudents.hasNext()) {
                        break;
                    }
                    student = this.iStudents.next();
                    PurdueBatchSolverValidator.this.iProgress.incProgress();
                }
                if (student.isDummy()) continue;
                PurdueBatchSolverValidator.this.validateStudent(student);
            }
            PurdueBatchSolverValidator.this.iProgress.debug(this.getName() + " has finished.");
        }
    }
}

