/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class GsonRepresentation<T>
extends WriterRepresentation {
    private GsonBuilder iBuilder = null;
    private Representation iRepresentation = null;
    private T iObject = null;
    private Type iObjectType = null;
    private Class<T> iObjectClass = null;

    public GsonRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.iObject = null;
        this.iObjectClass = objectClass;
        this.iRepresentation = representation;
    }

    public GsonRepresentation(Representation representation, Type objectType) {
        super(representation.getMediaType());
        this.iObject = null;
        this.iObjectType = objectType;
        this.iRepresentation = representation;
    }

    public GsonRepresentation(T object) {
        super(MediaType.APPLICATION_JSON);
        this.iObject = object;
        this.iObjectClass = object == null ? null : object.getClass();
    }

    public GsonBuilder getBuilder() {
        if (this.iBuilder == null) {
            this.iBuilder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

                public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                    return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
                }
            }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

                public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
                }
            }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

                public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                    return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(src));
                }
            }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

                public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    try {
                        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                    }
                    catch (ParseException e) {
                        throw new JsonParseException(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        return this.iBuilder;
    }

    public T getObject() throws IOException {
        if (this.iObject == null && this.iRepresentation != null && this.iRepresentation.isAvailable()) {
            JsonReader reader = new JsonReader(this.iRepresentation.getReader());
            try {
                if (this.iObjectType != null) {
                    Object object = this.getBuilder().create().fromJson(reader, this.iObjectType);
                    return (T)object;
                }
                Object object = this.getBuilder().create().fromJson(reader, this.iObjectClass);
                return (T)object;
            }
            finally {
                reader.close();
                this.iRepresentation.release();
            }
        }
        return this.iObject;
    }

    public Class<T> getObjectClass() {
        return this.iObjectClass;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.iObjectClass = objectClass;
    }

    public Type getType() {
        return this.iObjectType;
    }

    public void setType(Type type) {
        this.iObjectType = type;
    }

    public void setObject(T object) {
        this.iObject = object;
    }

    public void write(Writer writer) throws IOException {
        if (this.iRepresentation != null) {
            this.iRepresentation.write(writer);
        } else if (this.iObjectType != null) {
            this.getBuilder().create().toJson(this.iObject, this.iObjectType, new JsonWriter(writer));
        } else {
            this.getBuilder().create().toJson(this.iObject, this.iObjectClass, new JsonWriter(writer));
        }
    }
}

