/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;

public interface StudentEnrollmentProvider {
    public void checkEligibility(OnlineSectioningServer var1, OnlineSectioningHelper var2, OnlineSectioningInterface.EligibilityCheck var3, XStudent var4) throws SectioningException;

    public List<EnrollmentFailure> enroll(OnlineSectioningServer var1, OnlineSectioningHelper var2, XStudent var3, List<EnrollmentRequest> var4, Set<Long> var5, OnlineSectioningInterface.GradeModes var6) throws SectioningException;

    public XEnrollment resection(OnlineSectioningServer var1, OnlineSectioningHelper var2, SectioningRequest var3, XEnrollment var4) throws SectioningException;

    public boolean requestUpdate(OnlineSectioningServer var1, OnlineSectioningHelper var2, Collection<XStudent> var3) throws SectioningException;

    public void dispose();

    public boolean isAllowWaitListing();

    public boolean isCanRequestUpdates();

    public static class EnrollmentRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XCourse iCourse;
        private List<XSection> iSections;
        private Set<String> iGradeModes;

        public EnrollmentRequest(XCourse course, List<XSection> sections) {
            this.iCourse = course;
            this.iSections = sections;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public List<XSection> getSections() {
            return this.iSections;
        }

        public float getCredit() {
            Float sectionCredit = null;
            for (XSection s : this.getSections()) {
                Float credit = s.getCreditOverride(this.getCourse().getCourseId());
                if (credit == null) continue;
                sectionCredit = Float.valueOf((sectionCredit == null ? 0.0f : sectionCredit.floatValue()) + credit.floatValue());
            }
            if (sectionCredit != null) {
                return sectionCredit.floatValue();
            }
            if (this.getCourse().hasCredit()) {
                return this.getCourse().getMinCredit().floatValue();
            }
            return 0.0f;
        }

        public String getGradeMode() {
            return this.iGradeModes != null && this.iGradeModes.size() == 1 ? this.iGradeModes.iterator().next() : null;
        }

        public void resetGradeMode(String gm) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new HashSet<String>();
            } else {
                this.iGradeModes.clear();
            }
            this.iGradeModes.add(gm);
        }

        public void setGradeMode(String gm) {
            if (gm != null && !gm.isEmpty()) {
                if (this.iGradeModes == null) {
                    this.iGradeModes = new HashSet<String>();
                }
                this.iGradeModes.add(gm);
            }
        }

        public boolean hasGradeMode() {
            return this.iGradeModes != null && this.iGradeModes.size() == 1;
        }

        public String toString() {
            return this.getCourse().getCourseName() + ": " + ToolBox.col2string(this.getSections(), (int)2);
        }
    }

    public static class EnrollmentFailure
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XCourse iCourse;
        private XSection iSection;
        private String iMessage;
        private boolean iEnrolled;
        private List<EnrollmentError> iErrors;

        public EnrollmentFailure(XCourse course, XSection section, String message, boolean enrolled, Collection<EnrollmentError> errors) {
            this(course, section, message, enrolled);
            if (errors != null) {
                this.iErrors = new ArrayList<EnrollmentError>(errors);
            }
        }

        public EnrollmentFailure(XCourse course, XSection section, String message, boolean enrolled, EnrollmentError ... errors) {
            this(course, section, message, enrolled);
            if (errors != null) {
                this.iErrors = new ArrayList<EnrollmentError>();
                for (EnrollmentError error : errors) {
                    this.iErrors.add(error);
                }
            }
        }

        public EnrollmentFailure(XCourse course, XSection section, String message, boolean enrolled) {
            this.iCourse = course;
            this.iSection = section;
            this.iMessage = message;
            this.iEnrolled = enrolled;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public XSection getSection() {
            return this.iSection;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean isEnrolled() {
            return this.iEnrolled;
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public void addError(String code, String message) {
            this.addError(new EnrollmentError(code, message));
        }

        public void addError(EnrollmentError error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList<EnrollmentError>();
            }
            this.iErrors.add(error);
        }

        public List<EnrollmentError> getErrors() {
            return this.iErrors;
        }

        public String toString() {
            return this.getCourse().getCourseName() + " " + this.getSection().getSubpartName() + " " + this.getSection().getName(this.getCourse().getCourseId()) + ": " + this.getMessage() + (this.isEnrolled() ? " (e)" : "");
        }
    }

    public static class EnrollmentError
    implements Serializable,
    Comparable<EnrollmentError> {
        private static final long serialVersionUID = 1L;
        private String iCode;
        private String iMessage;

        public EnrollmentError(String code, String message) {
            this.iCode = code;
            this.iMessage = message;
        }

        public String getCode() {
            return this.iCode;
        }

        public String getMessage() {
            return this.iMessage;
        }

        @Override
        public int compareTo(EnrollmentError ee) {
            int cmp = (this.getCode() == null ? "" : this.getCode()).compareTo(ee.getCode() == null ? "" : ee.getCode());
            if (cmp != 0) {
                return cmp;
            }
            return this.getMessage().compareTo(ee.getMessage());
        }

        public String toString() {
            return this.getCode() + ": " + this.getMessage();
        }
    }
}

