/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.server.sectioning.SectioningReportTypesBackend;

public class GenerateSectioningReport
implements OnlineSectioningAction<CSVFile> {
    private static final long serialVersionUID = 1L;
    private DataProperties iParameters = null;

    public GenerateSectioningReport withParameters(Properties parameters) {
        this.iParameters = parameters instanceof DataProperties ? (DataProperties)parameters : new DataProperties(parameters);
        return this;
    }

    @Override
    public CSVFile execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            String string;
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            DistanceMetric dm = server.getDistanceMetric();
            model.setDistanceConflict(new DistanceConflict(dm, model.getProperties()));
            model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            HashMap<Long, Offering> offerings = new HashMap<Long, Offering>();
            Hashtable<Long, Course> courses = new Hashtable<Long, Course>();
            HashMap groups = new HashMap();
            Hashtable<Long, Config> configs = new Hashtable<Long, Config>();
            Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
            Hashtable<Long, Section> sections = new Hashtable<Long, Section>();
            Hashtable<Long, Object> reservations = new Hashtable<Long, Object>();
            HashSet<XDistribution> linkedSections = new HashSet<XDistribution>();
            for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || offerings.containsKey(offering.getOfferingId())) continue;
                Offering offering2 = new Offering(offering.getOfferingId().longValue(), offering.getName());
                offering2.setModel((Model)model);
                for (XCourse course : offering.getCourses()) {
                    Course clonedCourse = new Course(course.getCourseId().longValue(), course.getSubjectArea(), course.getCourseNumber(), offering2, course.getLimit(), course.getProjected());
                    clonedCourse.setNote(course.getNote());
                    clonedCourse.setCredit(course.getCredit());
                    courses.put(course.getCourseId(), clonedCourse);
                }
                for (XConfig config : offering.getConfigs()) {
                    Config clonedConfig = new Config(config.getConfigId().longValue(), config.getLimit(), config.getName(), offering2);
                    if (config.getInstructionalMethod() != null) {
                        clonedConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                        clonedConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                        clonedConfig.setInstructionalMethodReference(config.getInstructionalMethod().getReference());
                    }
                    configs.put(config.getConfigId(), clonedConfig);
                    for (XSubpart subpart : config.getSubparts()) {
                        Subpart clonedSubpart = new Subpart(subpart.getSubpartId().longValue(), subpart.getInstructionalType(), subpart.getName(), clonedConfig, subpart.getParentId() == null ? null : (Subpart)subparts.get(subpart.getParentId()));
                        clonedSubpart.setAllowOverlap(subpart.isAllowOverlap());
                        clonedSubpart.setCredit(subpart.getCredit(null));
                        subparts.put(subpart.getSubpartId(), clonedSubpart);
                        for (XSection section : subpart.getSections()) {
                            Section clonedSection = new Section(section.getSectionId().longValue(), section.getLimit(), section.getName(), clonedSubpart, section.toPlacement(), section.toInstructors(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                            clonedSection.setName(-1L, section.getName(-1L));
                            clonedSection.setNote(section.getNote());
                            clonedSection.setCancelled(section.isCancelled());
                            clonedSection.setEnabled(section.isEnabledForScheduling());
                            for (XDistribution xDistribution : offering.getDistributions()) {
                                if (xDistribution.getDistributionType() == XDistributionType.IngoreConflicts && xDistribution.hasSection(section.getSectionId())) {
                                    for (Long id : xDistribution.getSectionIds()) {
                                        if (id.equals(section.getSectionId())) continue;
                                        clonedSection.addIgnoreConflictWith(id.longValue());
                                    }
                                    continue;
                                }
                                if (xDistribution.getDistributionType() != XDistributionType.LinkedSections) continue;
                                linkedSections.add(xDistribution);
                            }
                            sections.put(section.getSectionId(), clonedSection);
                        }
                    }
                }
                for (XReservation reservation : offering.getReservations()) {
                    Object clonedReservation = null;
                    switch (reservation.getType()) {
                        case Course: {
                            XCourseReservation xCourseReservation = (XCourseReservation)reservation;
                            clonedReservation = new CourseReservation(reservation.getReservationId().longValue(), (Course)courses.get(xCourseReservation.getCourseId()));
                            break;
                        }
                        case Curriculum: {
                            XCurriculumReservation curriculumR = (XCurriculumReservation)reservation;
                            clonedReservation = new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, curriculumR.getAcademicArea(), curriculumR.getClassifications(), curriculumR.getMajors());
                            break;
                        }
                        case Group: {
                            XIndividualReservation indR;
                            if (reservation instanceof XIndividualReservation) {
                                indR = (XIndividualReservation)reservation;
                                clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, indR.getStudentIds());
                                break;
                            }
                            XGroupReservation groupR = (XGroupReservation)reservation;
                            clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, new Long[0]);
                            ArrayList<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                            if (list == null) {
                                list = new ArrayList<GroupReservation>();
                                groups.put(groupR.getGroup(), list);
                            }
                            list.add((GroupReservation)clonedReservation);
                            break;
                        }
                        case Individual: {
                            XIndividualReservation indR = (XIndividualReservation)reservation;
                            clonedReservation = new IndividualReservation(reservation.getReservationId().longValue(), offering2, indR.getStudentIds());
                            break;
                        }
                        case IndividualOverride: {
                            XIndividualReservation ovrR = (XIndividualReservation)reservation;
                            clonedReservation = ovrR.isOverride() ? new ReservationOverride(reservation.getReservationId().longValue(), offering2, ovrR.getStudentIds()) : new IndividualReservation(reservation.getReservationId().longValue(), offering2, ovrR.getStudentIds());
                            clonedReservation.setMustBeUsed(ovrR.mustBeUsed());
                            clonedReservation.setAllowOverlap(ovrR.isAllowOverlap());
                            clonedReservation.setCanAssignOverLimit(ovrR.canAssignOverLimit());
                            break;
                        }
                        case GroupOverride: {
                            XGroupReservation groupR = (XGroupReservation)reservation;
                            clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, new Long[0]);
                            List<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                            if (list == null) {
                                list = new ArrayList<GroupReservation>();
                                groups.put(groupR.getGroup(), list);
                            }
                            list.add((GroupReservation)clonedReservation);
                            ((GroupReservation)clonedReservation).setMustBeUsed(groupR.mustBeUsed());
                            ((GroupReservation)clonedReservation).setAllowOverlap(groupR.isAllowOverlap());
                            ((GroupReservation)clonedReservation).setCanAssignOverLimit(groupR.canAssignOverLimit());
                            break;
                        }
                        case LearningCommunity: {
                            XLearningCommunityReservation lcR = (XLearningCommunityReservation)reservation;
                            clonedReservation = new LearningCommunityReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), (Course)courses.get(lcR.getCourseId()), lcR.getStudentIds());
                            if (lcR.getGroup() == null) break;
                            List<GroupReservation> list = (List)groups.get(lcR.getGroup());
                            if (list == null) {
                                list = new ArrayList();
                                groups.put(lcR.getGroup(), list);
                            }
                            list.add((GroupReservation)clonedReservation);
                            break;
                        }
                        default: {
                            clonedReservation = new DummyReservation(offering2);
                        }
                    }
                    for (Long configId : reservation.getConfigsIds()) {
                        clonedReservation.addConfig((Config)configs.get(configId));
                    }
                    for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                        HashSet clonedSections = new HashSet();
                        for (Long sectionId : entry.getValue()) {
                            clonedSections.add(sections.get(sectionId));
                        }
                        clonedReservation.getSections().put(subparts.get(entry.getKey()), clonedSections);
                    }
                    reservations.put(reservation.getReservationId(), clonedReservation);
                }
                offerings.put(offering.getOfferingId(), offering2);
                model.addOffering(offering2);
            }
            HashMap<Long, Student> students = new HashMap<Long, Student>();
            AssignmentMap assignmentMap = new AssignmentMap();
            for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                Collection<Long> offeringIds;
                XStudent student;
                XStudent xStudent = student = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                if (student == null) {
                    XReservation reservation;
                    reservation = null;
                    return reservation;
                }
                Student clonnedStudent = new Student(student.getStudentId().longValue());
                clonnedStudent.setExternalId(student.getExternalId());
                clonnedStudent.setName(student.getName());
                clonnedStudent.setNeedShortDistances(student.hasAccomodation(dm.getShortDistanceAccommodationReference()));
                clonnedStudent.setAllowDisabled(student.isAllowDisabled());
                for (XStudent.XGroup xGroup : student.getGroups()) {
                    clonnedStudent.getMinors().add(new AcademicAreaCode(xGroup.getType() == null ? "" : xGroup.getType(), xGroup.getAbbreviation(), xGroup.getTitle()));
                    List list = (List)groups.get(xGroup);
                    if (list == null) continue;
                    for (GroupReservation gr : list) {
                        gr.getStudentIds().add(student.getStudentId());
                    }
                }
                for (XAreaClassificationMajor xAreaClassificationMajor : student.getMajors()) {
                    clonnedStudent.getAreaClassificationMajors().add(new AreaClassificationMajor(xAreaClassificationMajor.getArea(), xAreaClassificationMajor.getClassification(), xAreaClassificationMajor.getMajor()));
                }
                for (XRequest xRequest : student.getRequests()) {
                    Reservation reservation;
                    GroupReservation gr;
                    if (xRequest instanceof XFreeTimeRequest) {
                        XFreeTimeRequest ft = (XFreeTimeRequest)xRequest;
                        new FreeTimeRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                        continue;
                    }
                    XCourseRequest cr = (XCourseRequest)xRequest;
                    ArrayList<Course> req = new ArrayList<Course>();
                    gr = cr.getCourseIds().iterator();
                    while (gr.hasNext()) {
                        XCourseId c = (XCourseId)gr.next();
                        Course course = (Course)courses.get(c.getCourseId());
                        if (course == null) continue;
                        req.add(course);
                    }
                    if (req.isEmpty()) continue;
                    CourseRequest clonnedRequest = new CourseRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, req, cr.isWaitlist(), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                    XEnrollment enrollment = cr.getEnrollment();
                    if (enrollment == null) continue;
                    Config config = (Config)configs.get(enrollment.getConfigId());
                    HashSet<Section> assignments = new HashSet<Section>();
                    for (Long sectionId : enrollment.getSectionIds()) {
                        Section section = (Section)sections.get(sectionId);
                        if (section == null) continue;
                        assignments.add(section);
                    }
                    Reservation reservation2 = reservation = enrollment.getReservation() == null ? null : (Reservation)reservations.get(enrollment.getReservation().getReservationId());
                    if (config == null || sections.isEmpty()) continue;
                    assignmentMap.assign(0L, (Value)new Enrollment((Request)clonnedRequest, 0, (Course)courses.get(enrollment.getCourseId()), config, assignments, reservation));
                }
                students.put(student.getStudentId(), clonnedStudent);
                model.addStudent(clonnedStudent);
                if (clonnedStudent.getExternalId() == null || clonnedStudent.getExternalId().isEmpty() || (offeringIds = server.getInstructedOfferings(clonnedStudent.getExternalId())) == null) continue;
                for (Long offeringId : offeringIds) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    offering.fillInUnavailabilities(clonnedStudent);
                }
            }
            for (XDistribution xDistribution : linkedSections) {
                ArrayList<Section> linked = new ArrayList<Section>();
                for (Long id : xDistribution.getSectionIds()) {
                    Section section = (Section)sections.get(id);
                    if (section == null) continue;
                    linked.add(section);
                }
                if (linked.size() <= 1) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, linked);
            }
            String name = this.iParameters.getProperty("report", null);
            if (name == null && (string = this.iParameters.getProperty("name")) != null) {
                name = SectioningReportTypesBackend.ReportType.valueOf(string).getImplementation();
            }
            if (name == null || name.isEmpty()) {
                CSVFile cSVFile = null;
                return cSVFile;
            }
            Class<?> clazz = Class.forName(name);
            StudentSectioningReport report = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(model);
            CSVFile cSVFile = report.create((Assignment)assignmentMap, this.iParameters);
            return cSVFile;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "report";
    }
}

