/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.UserContext;

public class SubjectArea
extends BaseSubjectArea
implements Comparable<SubjectArea> {
    private static final long serialVersionUID = 3256439188198207794L;
    public static String SUBJ_AREA_ATTR_NAME = "subjectAreaList";

    public SubjectArea() {
    }

    public SubjectArea(Long uniqueId) {
        super(uniqueId);
    }

    public static List getSubjectAreaList(Long sessionId) throws HibernateException {
        SubjectAreaDAO subjDAO = new SubjectAreaDAO();
        org.hibernate.Session hibSession = subjDAO.getSession();
        List subjs = hibSession.createCriteria(SubjectArea.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).list();
        return subjs;
    }

    public static SubjectArea findByAbbv(Long sessionId, String subjectAreaAbbr) {
        SubjectAreaDAO subjDAO = new SubjectAreaDAO();
        org.hibernate.Session hibSession = subjDAO.getSession();
        List subjs = hibSession.createCriteria(SubjectArea.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).add((Criterion)Restrictions.eq((String)"subjectAreaAbbreviation", (Object)subjectAreaAbbr)).list();
        if (subjs == null || subjs.size() == 0) {
            return null;
        }
        return (SubjectArea)subjs.get(0);
    }

    public static SubjectArea findByAbbv(org.hibernate.Session hibSession, Long sessionId, String subjectAreaAbbr) {
        return (SubjectArea)(hibSession == null ? SubjectAreaDAO.getInstance().getSession() : hibSession).createQuery("from SubjectArea where session.uniqueId = :sessionId and subjectAreaAbbreviation = :subjectAreaAbbr").setLong("sessionId", sessionId.longValue()).setString("subjectAreaAbbr", subjectAreaAbbr).setMaxResults(1).uniqueResult();
    }

    public ArrayList getManagers() {
        if (this.getDepartment() != null) {
            ArrayList<TimetableManager> al = new ArrayList<TimetableManager>();
            al.addAll(this.getDepartment().getTimetableManagers());
            return al;
        }
        return new ArrayList();
    }

    @Override
    public int compareTo(SubjectArea s) {
        int cmp = new NaturalOrderComparator().compare(this.getSubjectAreaAbbreviation() == null ? "" : this.getSubjectAreaAbbreviation(), s.getSubjectAreaAbbreviation() == null ? "" : s.getSubjectAreaAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(s.getUniqueId() == null ? -1L : s.getUniqueId());
    }

    @Override
    public String toString() {
        return this.getSubjectAreaAbbreviation() + " - " + this.getTitle();
    }

    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public Object clone() {
        SubjectArea newSubjectArea = new SubjectArea();
        newSubjectArea.setDepartment(this.getDepartment());
        newSubjectArea.setExternalUniqueId(this.getExternalUniqueId());
        newSubjectArea.setTitle(this.getTitle());
        newSubjectArea.setSession(this.getSession());
        newSubjectArea.setSubjectAreaAbbreviation(this.getSubjectAreaAbbreviation());
        return newSubjectArea;
    }

    public SubjectArea findSameSubjectAreaInSession(Session session) {
        String query = "select sa from SubjectArea sa where sa.department.session.uniqueId = " + session.getUniqueId().toString();
        SubjectAreaDAO saDao = new SubjectAreaDAO();
        List l = saDao.getQuery(query = query + " and sa.subjectAreaAbbreviation = '" + this.getSubjectAreaAbbreviation() + "'").list();
        if (l != null && l.size() == 1) {
            return (SubjectArea)l.get(0);
        }
        return null;
    }

    public boolean hasOfferedCourses() {
        Set<CourseOffering> courses = this.getCourseOfferings();
        for (CourseOffering co : courses) {
            if (co.getInstructionalOffering().isNotOffered().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static TreeSet<SubjectArea> getAllSubjectAreas(Long sessionId) {
        return new TreeSet<SubjectArea>(SubjectAreaDAO.getInstance().getQuery("from SubjectArea where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
    }

    public static TreeSet<SubjectArea> getUserSubjectAreas(UserContext user) {
        return SubjectArea.getUserSubjectAreas(user, true);
    }

    public static TreeSet<SubjectArea> getUserSubjectAreas(UserContext user, boolean allSubjectsIfExternalManager) {
        TreeSet<SubjectArea> subjectAreas = new TreeSet<SubjectArea>();
        if (user == null || user.getCurrentAuthority() == null) {
            return subjectAreas;
        }
        for (Department department : Department.getUserDepartments(user)) {
            if (department.isExternalManager().booleanValue() && allSubjectsIfExternalManager) {
                subjectAreas.addAll(department.getSession().getSubjectAreas());
                break;
            }
            subjectAreas.addAll(department.getSubjectAreas());
        }
        return subjectAreas;
    }
}

