/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;
import org.unitime.timetable.model.ExternalRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseRoom;
import org.unitime.timetable.model.dao.ExternalRoomDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.util.LocationPermIdGenerator;

public class Room
extends BaseRoom {
    private static final long serialVersionUID = 1L;
    public static String ROOM_LIST_ATTR_NAME = "roomsList";

    public Room() {
    }

    public Room(Long uniqueId) {
        super(uniqueId);
    }

    public String bldgAbbvRoomNumber() {
        return this.getBuildingAbbv() + " " + this.getRoomNumber();
    }

    @Override
    public String toString() {
        return this.bldgAbbvRoomNumber();
    }

    @Override
    public String getLabel() {
        return this.bldgAbbvRoomNumber();
    }

    @Override
    public void addToroomDepts(RoomDept roomDept) {
        if (null == this.getRoomDepts()) {
            this.setRoomDepts(new HashSet<RoomDept>());
        }
        this.getRoomDepts().add(roomDept);
    }

    public Object clone() {
        Room r = new Room();
        r.setBuilding(r.getBuilding());
        r.setCapacity(this.getCapacity());
        r.setClassification(this.getClassification());
        r.setCoordinateX(this.getCoordinateX());
        r.setCoordinateY(this.getCoordinateY());
        r.setArea(this.getArea());
        r.setDisplayName(this.getDisplayName());
        r.setExternalUniqueId(this.getExternalUniqueId());
        r.setIgnoreRoomCheck(this.isIgnoreRoomCheck());
        r.setIgnoreTooFar(this.isIgnoreTooFar());
        r.setPattern(this.getPattern());
        r.setRoomNumber(this.getRoomNumber());
        r.setRoomType(this.getRoomType());
        r.setSession(this.getSession());
        r.setPermanentId(this.getPermanentId());
        r.setExamCapacity(this.getExamCapacity());
        r.setExamTypes(new HashSet<ExamType>(this.getExamTypes()));
        r.setEventStatus(null);
        r.setBreakTime(this.getBreakTime());
        r.setNote(this.getNote());
        r.setEventAvailability(this.getEventAvailability());
        r.setShareNote(this.getShareNote());
        return r;
    }

    public Room findSameRoomInSession(Session newSession) throws Exception {
        if (newSession == null) {
            return null;
        }
        Room newRoom = null;
        RoomDAO rDao = new RoomDAO();
        newRoom = (Room)rDao.getSession().createCriteria(Room.class).add((Criterion)Restrictions.eq((String)"permanentId", (Object)this.getPermanentId())).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)newSession.getUniqueId())).setCacheable(true).uniqueResult();
        if (newRoom == null && this.getExternalUniqueId() != null) {
            newRoom = (Room)rDao.getSession().createCriteria(Room.class).add((Criterion)Restrictions.eq((String)"externalUniqueId", (Object)this.getExternalUniqueId())).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)newSession.getUniqueId())).setCacheable(true).uniqueResult();
        }
        return newRoom;
    }

    public static Room findByBldgIdRoomNbr(Long bldgId, String roomNbr, Long sessionId) {
        return (Room)new RoomDAO().getSession().createQuery("select r from Room r where r.building.uniqueId=:bldgId and r.roomNumber=:roomNbr and r.session.uniqueId=:sessionId").setLong("bldgId", bldgId.longValue()).setString("roomNbr", roomNbr).setLong("sessionId", sessionId.longValue()).uniqueResult();
    }

    public void addExternalRoomDept(ExternalRoomDepartment externalRoomDept, Set externalRoomDepts) {
        Department dept = Department.findByDeptCode(externalRoomDept.getDepartmentCode(), this.getSession().getUniqueId());
        RoomDept roomDept = null;
        RoomDeptDAO rdDao = new RoomDeptDAO();
        if (dept != null) {
            roomDept = new RoomDept();
            roomDept.setRoom(this);
            roomDept.setControl(new Boolean(ExternalRoomDepartment.isControllingExternalDept(externalRoomDept, externalRoomDepts)));
            roomDept.setDepartment(dept);
            this.addToroomDepts(roomDept);
            dept.addToroomDepts(roomDept);
            rdDao.saveOrUpdate(roomDept);
        }
    }

    public static void addNewExternalRoomsToSession(Session session) {
        String query = "from ExternalRoom er where er.building.session.uniqueId=:sessionId and er.building.externalUniqueId is not null and er.externalUniqueId is not null";
        boolean updateExistingRooms = ApplicationProperty.BuildingsExternalUpdateExistingRooms.isTrue();
        if (!updateExistingRooms) {
            query = query + " and er.externalUniqueId not in (select r.externalUniqueId from Room r where r.session.uniqueId =:sessionId and r.externalUniqueId is not null)";
        }
        boolean resetRoomFeatures = ApplicationProperty.BuildingsExternalUpdateExistingRoomFeatures.isTrue();
        boolean resetRoomDepartments = ApplicationProperty.BuildingsExternalUpdateExistingRoomDepartments.isTrue();
        String classifications = ApplicationProperty.BuildingsExternalUpdateClassification.value();
        if (classifications != null && !classifications.isEmpty()) {
            query = query + " and er.classification in :classifications";
        }
        org.hibernate.Session hibSession = ExternalRoomDAO.getInstance().getSession();
        Query q = hibSession.createQuery(query).setLong("sessionId", session.getUniqueId().longValue());
        if (classifications != null && !classifications.isEmpty()) {
            q.setParameterList("classifications", (Object[])classifications.split(","), (Type)new StringType());
        }
        for (ExternalRoom er : q.list()) {
            GlobalRoomFeature grf;
            Building b = Building.findByExternalIdAndSession(er.getBuilding().getExternalUniqueId(), session);
            if (b == null) {
                b = new Building();
                b.setAbbreviation(er.getBuilding().getAbbreviation());
                b.setCoordinateX(er.getBuilding().getCoordinateX());
                b.setCoordinateY(er.getBuilding().getCoordinateY());
                b.setExternalUniqueId(er.getBuilding().getExternalUniqueId());
                b.setName(er.getBuilding().getDisplayName());
                b.setSession(session);
                hibSession.saveOrUpdate((Object)b);
                hibSession.flush();
            } else if (updateExistingRooms) {
                b.setAbbreviation(er.getBuilding().getAbbreviation());
                b.setCoordinateX(er.getBuilding().getCoordinateX());
                b.setCoordinateY(er.getBuilding().getCoordinateY());
                b.setName(er.getBuilding().getDisplayName());
                hibSession.saveOrUpdate((Object)b);
            }
            Room r = (Room)hibSession.createQuery("from Room r where r.building.session.uniqueId = :sessionId and r.externalUniqueId = :externalId").setLong("sessionId", session.getUniqueId().longValue()).setString("externalId", er.getExternalUniqueId()).uniqueResult();
            if (r == null) {
                r = new Room();
                r.setBuilding(b);
                r.setCapacity(er.getCapacity());
                r.setExamCapacity(er.getExamCapacity());
                r.setClassification(er.getClassification());
                r.setCoordinateX(er.getCoordinateX());
                r.setCoordinateY(er.getCoordinateY());
                r.setArea(er.getArea());
                r.setDisplayName(er.getDisplayName());
                r.setExternalUniqueId(er.getExternalUniqueId());
                r.setIgnoreRoomCheck(new Boolean(false));
                r.setIgnoreTooFar(new Boolean(false));
                r.setRoomNumber(er.getRoomNumber());
                r.setRoomType(er.getRoomType());
                r.setSession(session);
                r.setFeatures(new HashSet<RoomFeature>());
                for (ExternalRoomFeature externalRoomFeature : er.getRoomFeatures()) {
                    grf = GlobalRoomFeature.findGlobalRoomFeatureForLabel(session, externalRoomFeature.getValue());
                    if (grf == null) {
                        grf = GlobalRoomFeature.findGlobalRoomFeatureForAbbv(session, externalRoomFeature.getName());
                    }
                    if (grf == null) continue;
                    grf.getRooms().add(r);
                    r.getFeatures().add(grf);
                }
                LocationPermIdGenerator.setPermanentId(r);
                hibSession.saveOrUpdate((Object)r);
                hibSession.flush();
                for (ExternalRoomDepartment externalRoomDepartment : er.getRoomDepartments()) {
                    r.addExternalRoomDept(externalRoomDepartment, er.getRoomDepartments());
                }
                continue;
            }
            if (!updateExistingRooms) continue;
            r.setBuilding(b);
            r.setCapacity(er.getCapacity());
            r.setExamCapacity(er.getExamCapacity());
            r.setClassification(er.getClassification());
            r.setCoordinateX(er.getCoordinateX());
            r.setCoordinateY(er.getCoordinateY());
            r.setArea(er.getArea());
            r.setDisplayName(er.getDisplayName());
            r.setRoomNumber(er.getRoomNumber());
            r.setRoomType(er.getRoomType());
            if (resetRoomFeatures) {
                Iterator<Serializable> i = r.getFeatures().iterator();
                while (i.hasNext()) {
                    RoomFeature roomFeature = i.next();
                    if (!(roomFeature instanceof GlobalRoomFeature)) continue;
                    roomFeature.getRooms().remove(r);
                    i.remove();
                }
                for (ExternalRoomFeature externalRoomFeature : er.getRoomFeatures()) {
                    grf = GlobalRoomFeature.findGlobalRoomFeatureForLabel(session, externalRoomFeature.getValue());
                    if (grf == null) {
                        grf = GlobalRoomFeature.findGlobalRoomFeatureForAbbv(session, externalRoomFeature.getName());
                    }
                    if (grf == null) continue;
                    grf.getRooms().add(r);
                    r.getFeatures().add(grf);
                }
            }
            hibSession.saveOrUpdate((Object)r);
            if (!resetRoomDepartments) continue;
            HashMap<String, ExternalRoomDepartment> code2extRoomDept = new HashMap<String, ExternalRoomDepartment>();
            for (ExternalRoomDepartment erd : er.getRoomDepartments()) {
                code2extRoomDept.put(erd.getDepartmentCode(), erd);
            }
            Iterator<RoomDept> iterator = r.getRoomDepts().iterator();
            while (iterator.hasNext()) {
                RoomDept rd = iterator.next();
                ExternalRoomDepartment erd = (ExternalRoomDepartment)code2extRoomDept.remove(rd.getDepartment().getDeptCode());
                if (erd != null) {
                    rd.setControl(ExternalRoomDepartment.isControllingExternalDept(erd, er.getRoomDepartments()));
                    hibSession.saveOrUpdate((Object)rd);
                    continue;
                }
                rd.getDepartment().getRoomDepts().remove(rd);
                iterator.remove();
                hibSession.delete((Object)rd);
            }
            for (ExternalRoomDepartment erd : code2extRoomDept.values()) {
                r.addExternalRoomDept(erd, er.getRoomDepartments());
            }
        }
        hibSession.flush();
    }

    @Override
    public String getRoomTypeLabel() {
        return this.getRoomType().getLabel();
    }

    @Override
    public List<Location> getFutureLocations() {
        ArrayList<Location> ret = new ArrayList<Location>();
        HashSet<Long> futureSessionIds = new HashSet<Long>();
        HashSet<Long> blackListedSessionIds = new HashSet<Long>();
        for (Location location : LocationDAO.getInstance().getSession().createQuery("select f from Room l, Room f where l.uniqueId = :uniqueId and l.session.academicInitiative = f.session.academicInitiative and l.session.sessionBeginDateTime < f.session.sessionBeginDateTime and ((l.permanentId = f.permanentId) or (not exists (from Location x where x.permanentId = f.permanentId and x.session = l.session) and l.roomType = f.roomType and ((length(f.externalUniqueId) > 0 and l.externalUniqueId = f.externalUniqueId) or ((f.externalUniqueId is null or length(f.externalUniqueId) = 0) and (l.externalUniqueId is null or length(l.externalUniqueId) = 0) and f.building.abbreviation = l.building.abbreviation and f.roomNumber = l.roomNumber and f.capacity = l.capacity)))) order by f.session.sessionBeginDateTime").setLong("uniqueId", this.getUniqueId().longValue()).setCacheable(true).list()) {
            if (futureSessionIds.add(location.getSession().getUniqueId())) {
                ret.add(location);
                continue;
            }
            blackListedSessionIds.add(location.getSession().getUniqueId());
        }
        if (!blackListedSessionIds.isEmpty()) {
            Iterator i = ret.iterator();
            while (i.hasNext()) {
                Location location;
                location = (Location)i.next();
                if (!blackListedSessionIds.contains(location.getSession().getUniqueId())) continue;
                i.remove();
            }
        }
        return ret;
    }
}

