/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDepartmentalInstructor;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

public class DepartmentalInstructor
extends BaseDepartmentalInstructor
implements Comparable,
NameInterface {
    private static final long serialVersionUID = 1L;
    public static String INSTR_LIST_ATTR_NAME = "instructorsList";
    public static String INSTR_HAS_PREF_ATTR_NAME = "instructorsHasPrefs";
    public static String INSTRDEPT_LIST_ATTR_NAME = "instructorDeptList";
    public static final String sNameFormatLastFist = NameFormat.LAST_FIRST.reference();
    public static final String sNameFormatFirstLast = NameFormat.FIRST_LAST.reference();
    public static final String sNameFormatInitialLast = NameFormat.INITIAL_LAST.reference();
    public static final String sNameFormatLastInitial = NameFormat.LAST_INITIAL.reference();
    public static final String sNameFormatFirstMiddleLast = NameFormat.FIRST_MIDDLE_LAST.reference();
    public static final String sNameFormatLastFirstMiddle = NameFormat.LAST_FIRST_MIDDLE.reference();
    public static final String sNameFormatShort = NameFormat.SHORT.reference();

    public DepartmentalInstructor() {
    }

    public DepartmentalInstructor(Long uniqueId) {
        super(uniqueId);
    }

    public String nameLastNameFirst() {
        return this.nameLastFirstMiddle();
    }

    public String nameFirstNameFirst() {
        return Constants.toInitialCase((this.hasFirstName() ? this.getFirstName() : "") + (this.hasMiddleName() ? " " + this.getMiddleName() : "") + (this.hasLastName() ? " " + this.getLastName() : "")).trim();
    }

    public String nameShort() {
        return (this.hasFirstName() ? this.getFirstName().substring(0, 1).toUpperCase() + ". " : "") + (this.hasLastName() ? this.getLastName().substring(0, 1).toUpperCase() + this.getLastName().substring(1, Math.min(10, this.getLastName().length())).toLowerCase() : "").trim();
    }

    public String getNameFirst() {
        return this.nameFirstNameFirst();
    }

    public String getNameLast() {
        return this.nameLastNameFirst();
    }

    public String getNameLastFirst() {
        return this.nameLastFirst();
    }

    public String getNameInitLast() {
        return this.nameInitLast();
    }

    private String nameInitLast() {
        return ((this.hasFirstName() ? this.getFirstName().trim().substring(0, 1).toUpperCase() : "") + (this.hasMiddleName() ? " " + this.getMiddleName().trim().substring(0, 1).toUpperCase() : "") + (this.hasLastName() ? " " + Constants.toInitialCase(this.getLastName()) : "")).trim();
    }

    private String nameLastFirst() {
        return Constants.toInitialCase((this.hasLastName() ? this.getLastName() : "") + (this.hasFirstName() ? ", " + this.getFirstName() : "")).trim();
    }

    public String nameFirstLast() {
        return Constants.toInitialCase((this.hasFirstName() ? this.getFirstName() : "") + (this.hasLastName() ? " " + this.getLastName() : "")).trim();
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    public boolean hasLastName() {
        return this.getLastName() != null && !this.getLastName().isEmpty();
    }

    public boolean hasFirstName() {
        return this.getFirstName() != null && !this.getFirstName().isEmpty();
    }

    public boolean hasMiddleName() {
        return this.getMiddleName() != null && !this.getMiddleName().isEmpty();
    }

    private String nameLastFirstMiddle() {
        return Constants.toInitialCase((this.hasLastName() ? this.getLastName() : "") + (this.hasFirstName() || this.hasMiddleName() ? "," : "") + (this.hasFirstName() ? " " + this.getFirstName() : "") + (this.hasMiddleName() ? " " + this.getMiddleName() : "")).trim();
    }

    public void removeClassInstructor(ClassInstructor classInstr) {
        Set<ClassInstructor> s = this.getClasses();
        for (ClassInstructor ci : s) {
            if (ci.getUniqueId().intValue() != classInstr.getUniqueId().intValue()) continue;
            s.remove(ci);
            break;
        }
    }

    @Override
    public String htmlLabel() {
        return this.nameFirstNameFirst() + ", " + this.getDepartment().getDeptCode();
    }

    @Override
    public Set getAvailableRooms() {
        TreeSet<Location> rooms = new TreeSet<Location>();
        for (RoomDept roomDept : this.getDepartment().getRoomDepts()) {
            rooms.add(roomDept.getRoom());
        }
        return rooms;
    }

    @Override
    public Set getAvailableRoomFeatures() {
        Set features = super.getAvailableRoomFeatures();
        features.addAll(DepartmentRoomFeature.getAllDepartmentRoomFeatures(this.getDepartment()));
        return features;
    }

    @Override
    public Set getAvailableRoomGroups() {
        Set groups = super.getAvailableRoomGroups();
        groups.addAll(RoomGroup.getAllDepartmentRoomGroups(this.getDepartment()));
        return groups;
    }

    public Set prefsOfTypeForDepartment(Class type, Department dept) {
        if (dept == null || dept.equals(this.getDepartment())) {
            return this.getPreferences(type);
        }
        return null;
    }

    public static List<DepartmentalInstructor> getAllForInstructor(DepartmentalInstructor di, Long sessionId) {
        if (di.getExternalUniqueId() == null || di.getExternalUniqueId().trim().isEmpty()) {
            ArrayList<DepartmentalInstructor> ret = new ArrayList<DepartmentalInstructor>(1);
            ret.add((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(di.getUniqueId()));
            return ret;
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId=:puid and department.session.uniqueId=:sessionId").setString("puid", di.getExternalUniqueId()).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<DepartmentalInstructor> getAllForInstructor(DepartmentalInstructor di) {
        return DepartmentalInstructor.getAllForInstructor(di, di.getDepartment().getSessionId());
    }

    public static List<DepartmentalInstructor> findInstructorsForDepartment(Long departmentId) throws Exception {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where department.uniqueId = :departmentId order by lastName, firstName, middleName").setLong("departmentId", departmentId.longValue()).setCacheable(true).list();
    }

    public static List<DepartmentalInstructor> findInstructorsForSession(Long sessionId) throws Exception {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where department.session.uniqueId = :sessionId order by lastName, firstName, middleName").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DepartmentalInstructor)) {
            return -1;
        }
        DepartmentalInstructor i = (DepartmentalInstructor)o;
        int cmp = this.nameLastNameFirst().compareToIgnoreCase(i.nameLastNameFirst());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(i.getUniqueId() == null ? -1L : i.getUniqueId());
    }

    public static boolean existInst(String puid) {
        if (puid == null) {
            return false;
        }
        DepartmentalInstructorDAO ddao = new DepartmentalInstructorDAO();
        List list = ddao.getSession().createCriteria(DepartmentalInstructor.class).add((Criterion)Restrictions.eq((String)"externalUniqueId", (Object)puid)).list();
        return list.size() != 0;
    }

    public static DepartmentalInstructor findByPuidDepartmentId(String puid, Long deptId) {
        return DepartmentalInstructor.findByPuidDepartmentId(puid, deptId, new DepartmentalInstructorDAO().getSession());
    }

    public static DepartmentalInstructor findByPuidDepartmentId(String puid, Long deptId, org.hibernate.Session hibSession) {
        try {
            return (DepartmentalInstructor)hibSession.createQuery("select d from DepartmentalInstructor d where d.externalUniqueId=:puid and d.department.uniqueId=:deptId").setString("puid", puid).setLong("deptId", deptId.longValue()).setCacheable(true).setFlushMode(FlushMode.MANUAL).uniqueResult();
        }
        catch (NonUniqueResultException e) {
            Debug.warning("There are two or more instructors with puid " + puid + " for department " + deptId + " -- returning the first one.");
            return (DepartmentalInstructor)hibSession.createQuery("select d from DepartmentalInstructor d where d.externalUniqueId=:puid and d.department.uniqueId=:deptId").setString("puid", puid).setLong("deptId", deptId.longValue()).setCacheable(true).setFlushMode(FlushMode.MANUAL).list().get(0);
        }
    }

    public DepartmentalInstructor findThisInstructorInSession(Long sessionId) {
        return this.findThisInstructorInSession(sessionId, new DepartmentalInstructorDAO().getSession());
    }

    public DepartmentalInstructor findThisInstructorInSession(Long sessionId, org.hibernate.Session hibSession) {
        Department newDept = this.getDepartment().findSameDepartmentInSession(sessionId, hibSession);
        if (newDept != null) {
            return DepartmentalInstructor.findByPuidDepartmentId(this.getExternalUniqueId(), newDept.getUniqueId(), hibSession);
        }
        return null;
    }

    public DepartmentalInstructor getNextDepartmentalInstructor(SessionContext context, Right right) throws Exception {
        List<DepartmentalInstructor> instructors = DepartmentalInstructor.findInstructorsForDepartment(this.getDepartment().getUniqueId());
        DepartmentalInstructor next = null;
        for (DepartmentalInstructor di : instructors) {
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? di.getDepartment() : di, right) || this.compareTo(di) >= 0 || next != null && next.compareTo(di) <= 0) continue;
            next = di;
        }
        return next;
    }

    public DepartmentalInstructor getPreviousDepartmentalInstructor(SessionContext context, Right right) throws Exception {
        List<DepartmentalInstructor> instructors = DepartmentalInstructor.findInstructorsForDepartment(this.getDepartment().getUniqueId());
        DepartmentalInstructor prev = null;
        for (DepartmentalInstructor di : instructors) {
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? di.getDepartment() : di, right) || this.compareTo(di) <= 0 || prev != null && prev.compareTo(di) >= 0) continue;
            prev = di;
        }
        return prev;
    }

    @Override
    public String toString() {
        return this.nameShort();
    }

    public boolean hasPreferences() {
        Iterator<Preference> i = null;
        try {
            i = this.getPreferences().iterator();
        }
        catch (ObjectNotFoundException e) {
            Debug.error("Exception " + e.getMessage() + " seen for " + this);
            new _RootDAO().getSession().refresh((Object)this);
            i = this.getPreferences() != null ? this.getPreferences().iterator() : null;
        }
        catch (Exception e) {
            i = null;
        }
        if (i == null) {
            return false;
        }
        while (i.hasNext()) {
            TimePref timePref;
            Preference preference = i.next();
            if (preference instanceof TimePref && ((timePref = (TimePref)preference).getPreference() == null || timePref.getPreference().matches("2*"))) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        DepartmentalInstructor newDepartmentalInstructor = new DepartmentalInstructor();
        newDepartmentalInstructor.setCareerAcct(this.getCareerAcct());
        newDepartmentalInstructor.setDepartment(this.getDepartment());
        newDepartmentalInstructor.setExternalUniqueId(this.getExternalUniqueId());
        newDepartmentalInstructor.setFirstName(this.getFirstName());
        newDepartmentalInstructor.setMiddleName(this.getMiddleName());
        newDepartmentalInstructor.setLastName(this.getLastName());
        newDepartmentalInstructor.setAcademicTitle(this.getAcademicTitle());
        newDepartmentalInstructor.setIgnoreToFar(this.isIgnoreToFar());
        newDepartmentalInstructor.setNote(this.getNote());
        newDepartmentalInstructor.setPositionType(this.getPositionType());
        newDepartmentalInstructor.setEmail(this.getEmail());
        newDepartmentalInstructor.setRole(this.getRole());
        newDepartmentalInstructor.setTeachingPreference(this.getTeachingPreference());
        newDepartmentalInstructor.setMaxLoad(this.getMaxLoad());
        return newDepartmentalInstructor;
    }

    public static List findAllExamInstructors(Long sessionId, Long examTypeId) {
        return new DepartmentalInstructorDAO().getSession().createQuery("select distinct i from Exam x inner join x.instructors i where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list();
    }

    public List<Exam> getExams(Integer examType) {
        if (this.getExternalUniqueId() != null) {
            return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId)) and x.examType.type=:examType").setLong("instructorId", this.getUniqueId().longValue()).setLong("sessionId", this.getDepartment().getSession().getUniqueId().longValue()).setString("externalId", this.getExternalUniqueId()).setInteger("examType", examType.intValue()).setCacheable(true).list();
        }
        return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.examType=:examType").setLong("instructorId", this.getUniqueId().longValue()).setInteger("examType", examType.intValue()).setCacheable(true).list();
    }

    public List<Exam> getExams(ExamType examType) {
        if (this.getExternalUniqueId() != null) {
            return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId)) and x.examType.uniqueId=:examTypeId").setLong("instructorId", this.getUniqueId().longValue()).setLong("sessionId", this.getDepartment().getSession().getUniqueId().longValue()).setString("externalId", this.getExternalUniqueId()).setLong("examTypeId", examType.getUniqueId().longValue()).setCacheable(true).list();
        }
        return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.examType.uniqueId=:examTypeId").setLong("instructorId", this.getUniqueId().longValue()).setLong("examTypeId", examType.getUniqueId().longValue()).setCacheable(true).list();
    }

    public List<Exam> getAllExams() {
        if (this.getExternalUniqueId() != null) {
            return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId))").setLong("instructorId", this.getUniqueId().longValue()).setLong("sessionId", this.getDepartment().getSession().getUniqueId().longValue()).setString("externalId", this.getExternalUniqueId()).setCacheable(true).list();
        }
        return new DepartmentalInstructorDAO().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId").setLong("instructorId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    public Collection<Assignment> getCommitedAssignments() {
        return new DepartmentalInstructorDAO().getSession().createQuery("select a from Assignment a inner join a.instructors i where a.solution.commited=true and i.uniqueId=:instructorId").setLong("instructorId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    @Override
    public Session getSession() {
        return this.getDepartment().getSession();
    }

    public static boolean canLookupInstructor() {
        return ApplicationProperty.InstructorExternalIdLookupClass.value() != null;
    }

    public static ExternalUidLookup.UserInfo lookupInstructor(String externalId) throws Exception {
        ExternalUidLookup lookup = null;
        String className = ApplicationProperty.InstructorExternalIdLookupClass.value();
        if (className != null) {
            lookup = (ExternalUidLookup)Class.forName(className).newInstance();
        }
        return lookup == null ? null : lookup.doLookup(externalId);
    }

    public Set<InstructorAttribute> getAttributes(InstructorAttributeType type) {
        TreeSet<InstructorAttribute> ret = new TreeSet<InstructorAttribute>();
        for (InstructorAttribute a : this.getAttributes()) {
            if (!type.equals(a.getType())) continue;
            ret.add(a);
        }
        return ret;
    }

    @Override
    public Set<CourseOffering> getAvailableCourses() {
        return new TreeSet<CourseOffering>(DepartmentalInstructorDAO.getInstance().getSession().createQuery("from CourseOffering c where c.subjectArea.department.uniqueId = :departmentId and c.isControl = true and c.instructionalOffering.notOffered = false").setLong("departmentId", this.getDepartment().getUniqueId().longValue()).setCacheable(true).list());
    }

    @Override
    public Set getAvailableAttributeTypes() {
        return this.getDepartment().getAvailableAttributeTypes();
    }

    @Override
    public Set getAvailableAttributes() {
        return this.getDepartment().getAvailableAttributes();
    }

    public static List<DepartmentalInstructor> getUserInstructors(UserContext user) {
        if (user == null || user.getCurrentAcademicSessionId() == null || user.getExternalUserId() == null) {
            return null;
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId = :externalId order by i.department.deptCode").setLong("sessionId", user.getCurrentAcademicSessionId().longValue()).setString("externalId", user.getExternalUserId()).setCacheable(true).list();
    }
}

