/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.List;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.hibernate.Session;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.CourseDemandDAO;

public class CourseDemand
extends BaseCourseDemand
implements Comparable {
    private static final long serialVersionUID = 1L;

    public CourseDemand() {
    }

    public CourseDemand(Long uniqueId) {
        super(uniqueId);
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof CourseDemand)) {
            return -1;
        }
        CourseDemand cd = (CourseDemand)o;
        int n = this.isAlternative().booleanValue() == cd.isAlternative().booleanValue() ? 0 : (cmp = this.isAlternative() != false ? 1 : -1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getPriority().compareTo(cd.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(cd.getUniqueId() == null ? -1L : cd.getUniqueId());
    }

    public static List findAll(Long sessionId) {
        return CourseDemand.findAll(CourseDemandDAO.getInstance().getSession(), sessionId);
    }

    public static List findAll(Session hibSession, Long sessionId) {
        return hibSession.createQuery("select c from CourseDemand c where c.student.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public void updatePreferences(org.cpsolver.studentsct.model.CourseRequest request, Session hibSession) {
        if (this.getCourseRequests() == null || this.getCourseRequests().isEmpty()) {
            return;
        }
        if (!request.getSelectedChoices().isEmpty() || !request.getRequiredChoices().isEmpty()) {
            for (Course course : request.getCourses()) {
                Object section;
                CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                HashSet<Long> im = new HashSet<Long>();
                for (Choice choice : request.getSelectedChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        rc.setSelectedClass(section.getId(), section.getName(course.getId()), false, true);
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        rc.setSelectedIntructionalMethod(config.getInstructionalMethodId(), config.getInstructionalMethodName(), false, true);
                    }
                }
                for (Choice choice : request.getRequiredChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        rc.setSelectedClass(section.getId(), section.getName(course.getId()), true, true);
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        rc.setSelectedIntructionalMethod(config.getInstructionalMethodId(), config.getInstructionalMethodName(), true, true);
                    }
                }
                for (CourseRequest cr : this.getCourseRequests()) {
                    if (!cr.getCourseOffering().getUniqueId().equals(course.getId())) continue;
                    cr.updatePreferences(rc, hibSession);
                }
            }
        }
    }
}

