/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.AutocompleteValue;
import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class FilterBox
extends AbsolutePanel
implements HasValue<String>,
HasValueChangeHandlers<String>,
HasText,
Focusable,
HasAllKeyHandlers,
HasAllFocusHandlers,
HasAriaLabel,
HasEnabled,
HasSelectionHandlers<Suggestion> {
    protected static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static String[] sColors = new String[]{"blue", "green", "orange", "yellow", "pink", "purple", "teal", "darkpurple", "steelblue", "lightblue", "lightgreen", "yellowgreen", "redorange", "lightbrown", "lightpurple", "grey", "bluegrey", "lightteal", "yellowgrey", "brown", "blue", "green", "orange", "yellow", "pink", "purple", "teal", "darkpurple", "steelblue", "lightblue", "lightgreen", "yellowgreen", "redorange", "lightbrown", "lightpurple", "grey", "bluegrey", "lightteal", "yellowgrey", "brown"};
    protected AriaTextBox iFilter;
    protected PopupPanelKeepFocus iFilterPopup;
    protected PopupPanelKeepFocus iSuggestionsPopup;
    protected boolean iFocus = false;
    protected BlurHandler iBlurHandler;
    protected FocusHandler iFocusHandler;
    protected SuggestionsProvider iSuggestionsProvider = new DefaultSuggestionsProvider(null);
    protected SuggestionMenu iSuggestionMenu;
    protected Parser iParser = new DefaultParser();
    protected Chip2Color iChip2Color = new DefaultChip2Color();
    protected List<Filter> iFilters = new ArrayList<Filter>();
    protected Focusable iLastFocusedWidget = null;
    protected Image iFilterOpen;
    protected Image iFilterClose;
    protected Image iFilterClear;
    protected HandlerRegistration iResizeHandler;
    protected TakesValue<String> iDefaultValueProvider = null;
    protected boolean iShowSuggestionsOnFocus = false;
    private String iLastValue = null;
    protected static CarrotCookie sCarrotCookie;

    public FilterBox() {
        this.setStyleName("unitime-FilterBox");
        final Timer blur = new Timer(){

            public void run() {
                if (!FilterBox.this.iFocus) {
                    FilterBox.this.removeStyleName("unitime-FilterBoxFocus");
                    if (FilterBox.this.isFilterPopupShowing()) {
                        FilterBox.this.hideFilterPopup();
                    }
                }
            }
        };
        this.iFocusHandler = new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (event.getSource() != null && event.getSource() instanceof Focusable) {
                    FilterBox.this.iLastFocusedWidget = (Focusable)event.getSource();
                }
                FilterBox.this.iFocus = true;
                FilterBox.this.addStyleName("unitime-FilterBoxFocus");
                if (FilterBox.this.iShowSuggestionsOnFocus) {
                    FilterBox.this.refreshSuggestions();
                }
            }
        };
        this.iBlurHandler = new BlurHandler(){

            public void onBlur(BlurEvent event) {
                FilterBox.this.iFocus = false;
                FilterBox.this.iLastFocusedWidget = null;
                blur.schedule(100);
            }
        };
        this.iFilter = new AriaTextBox();
        this.iFilter.setStyleName("filter");
        this.iFilter.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                ChipPanel last;
                if (FilterBox.this.isFilterPopupShowing()) {
                    FilterBox.this.hideFilterPopup();
                }
                if (event.getNativeEvent().getKeyCode() == 8 && FilterBox.this.iFilter.getText().isEmpty() && (last = FilterBox.this.getLastChipPanel()) != null) {
                    FilterBox.this.remove((Widget)last);
                    FilterBox.this.resizeFilterIfNeeded();
                    FilterBox.this.setAriaLabel(FilterBox.this.toAriaString());
                    ValueChangeEvent.fire((HasValueChangeHandlers)FilterBox.this, (Object)FilterBox.this.getValue());
                    FilterBox.this.setStatus(FilterBox.this.getAriaLabel());
                }
                if (FilterBox.this.isSuggestionsShowing()) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 40: {
                            FilterBox.this.iSuggestionMenu.selectItem(FilterBox.this.iSuggestionMenu.getSelectedItemIndex() + 1);
                            FilterBox.this.setStatus(ARIA.onSuggestion(FilterBox.this.iSuggestionMenu.getSelectedItemIndex() + 1, FilterBox.this.iSuggestionMenu.getNumItems(), FilterBox.this.iSuggestionMenu.getSelectedSuggestion().toAriaString(FilterBox.this)));
                            break;
                        }
                        case 38: {
                            if (FilterBox.this.iSuggestionMenu.getSelectedItemIndex() == -1) {
                                FilterBox.this.iSuggestionMenu.selectItem(FilterBox.this.iSuggestionMenu.getNumItems() - 1);
                            } else {
                                FilterBox.this.iSuggestionMenu.selectItem(FilterBox.this.iSuggestionMenu.getSelectedItemIndex() - 1);
                            }
                            FilterBox.this.setStatus(ARIA.onSuggestion(FilterBox.this.iSuggestionMenu.getSelectedItemIndex() + 1, FilterBox.this.iSuggestionMenu.getNumItems(), FilterBox.this.iSuggestionMenu.getSelectedSuggestion().toAriaString(FilterBox.this)));
                            break;
                        }
                        case 13: {
                            FilterBox.this.iSuggestionMenu.executeSelected();
                            FilterBox.this.hideSuggestions();
                            break;
                        }
                        case 9: {
                            FilterBox.this.hideSuggestions();
                            break;
                        }
                        case 27: {
                            FilterBox.this.hideSuggestions();
                        }
                    }
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 13: 
                        case 27: 
                        case 38: 
                        case 40: {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                    }
                } else if (event.getNativeEvent().getKeyCode() == 40 && (event.getNativeEvent().getAltKey() || FilterBox.this.iFilter.getCursorPos() == FilterBox.this.iFilter.getText().length())) {
                    FilterBox.this.showSuggestions();
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        });
        this.iFilter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                FilterBox.this.refreshSuggestions();
            }
        });
        this.iFilter.addFocusHandler(this.iFocusHandler);
        this.iFilter.addBlurHandler(this.iBlurHandler);
        this.add((Widget)this.iFilter);
        this.iFilter.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FilterBox.this.setAriaLabel(FilterBox.this.toAriaString());
                ValueChangeEvent.fire((HasValueChangeHandlers)FilterBox.this, (Object)FilterBox.this.getValue());
            }
        });
        this.iFilterClear = new Image(RESOURCES.filter_clear());
        this.iFilterClear.setAltText(MESSAGES.altClearFilter());
        this.iFilterClear.setTitle(MESSAGES.altClearFilter());
        this.iFilterClear.setStyleName("button-image");
        this.add((Widget)this.iFilterClear);
        this.iFilterClear.setVisible(false);
        Roles.getDocumentRole().setAriaHiddenState((Element)this.iFilterClear.getElement(), true);
        this.iFilter.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (FilterBox.this.iFilterClear.isVisible() && FilterBox.this.getValue().isEmpty()) {
                    FilterBox.this.resizeFilterIfNeeded();
                } else if (!FilterBox.this.iFilterClear.isVisible() && !FilterBox.this.getValue().isEmpty()) {
                    FilterBox.this.resizeFilterIfNeeded();
                }
            }
        });
        this.iFilterOpen = new Image(RESOURCES.filter_open());
        this.iFilterOpen.setAltText(MESSAGES.altOpenFilter());
        this.iFilterOpen.setTitle(MESSAGES.altOpenFilter());
        this.iFilterOpen.addStyleName("button-image");
        this.add((Widget)this.iFilterOpen);
        Roles.getDocumentRole().setAriaHiddenState((Element)this.iFilterOpen.getElement(), true);
        this.iFilterClose = new Image(RESOURCES.filter_close());
        this.iFilterClose.setAltText(MESSAGES.altCloseFilter());
        this.iFilterClose.setTitle(MESSAGES.altCloseFilter());
        this.iFilterClose.addStyleName("button-image");
        this.add((Widget)this.iFilterClose);
        this.iFilterClose.setVisible(false);
        Roles.getDocumentRole().setAriaHiddenState((Element)this.iFilterClose.getElement(), true);
        this.iFilterPopup = new PopupPanelKeepFocus();
        this.iFilterPopup.setStyleName("unitime-FilterBoxPopup");
        this.iFilterPopup.setAutoHideEnabled(false);
        this.iSuggestionMenu = new SuggestionMenu();
        this.iSuggestionsPopup = new PopupPanelKeepFocus();
        this.iSuggestionsPopup.setWidget((Widget)this.iSuggestionMenu);
        this.iSuggestionsPopup.setStyleName("unitime-FilterBoxPopup");
        this.sinkEvents(4);
        this.iSuggestionsPopup.getElement().setAttribute("id", DOM.createUniqueId());
        Roles.getTextboxRole().setAriaOwnsProperty((Element)this.iFilter.getElement(), new Id[]{Id.of((Element)this.iSuggestionsPopup.getElement())});
        Roles.getTextboxRole().setAriaAutocompleteProperty((Element)this.iFilter.getElement(), AutocompleteValue.NONE);
    }

    public void setSuggestionsProvider(SuggestionsProvider suggestionsProvider) {
        this.iSuggestionsProvider = new DefaultSuggestionsProvider(suggestionsProvider);
    }

    public SuggestionsProvider getSuggestionsProvider() {
        return this.iSuggestionsProvider;
    }

    protected void applySuggestion(Suggestion suggestion) {
        this.iFilter.setText(suggestion.getReplacementString());
        if (suggestion.getChipToAdd() != null) {
            if (this.hasChip(suggestion.getChipToAdd())) {
                this.removeChip(suggestion.getChipToAdd(), false);
            } else {
                this.addChip(suggestion.getChipToAdd(), false);
            }
        }
        if (suggestion.getChipToRemove() != null) {
            this.removeChip(suggestion.getChipToRemove(), false);
        }
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.iSuggestionsPopup.setWidth(width);
        this.iFilterPopup.setWidth(width);
    }

    public void setParser(Parser parser) {
        this.iParser = parser;
    }

    public boolean isSuggestionsShowing() {
        return this.iSuggestionsPopup.isShowing();
    }

    public boolean isFilterPopupShowing() {
        return this.iFilterPopup.isShowing();
    }

    public void hideSuggestions() {
        this.iSuggestionsPopup.hide();
    }

    public void hideFilterPopup() {
        this.iFilterPopup.hide();
        this.iFilterOpen.setVisible(true);
        this.iFilterClose.setVisible(false);
        if (this.iLastFocusedWidget != null && !this.iLastFocusedWidget.equals(this.iFilter)) {
            this.iFilter.setFocus(true);
        }
    }

    public void addFilter(Filter filter) {
        this.iFilters.add(filter);
    }

    public List<Filter> getFilters() {
        return this.iFilters;
    }

    public Filter getFilter(String command) {
        for (Filter filter : this.getFilters()) {
            if (!filter.getCommand().equals(command)) continue;
            return filter;
        }
        return null;
    }

    public void showFilterPopup() {
        if (!this.isEnabled()) {
            return;
        }
        this.iFilterPopup.setWidget(this.createFilterPopup());
        if (this.iFilterPopup.isShowing()) {
            this.iFilterPopup.moveRelativeTo((UIObject)this);
            if (this.iLastFocusedWidget != null) {
                this.iLastFocusedWidget.setFocus(true);
            }
        } else {
            this.iFilterPopup.setWidth(this.getElement().getClientWidth() + "px");
            this.iFilterPopup.showRelativeTo((UIObject)this);
            this.iFilterOpen.setVisible(false);
            this.iFilterClose.setVisible(true);
        }
    }

    protected Widget createFilterPopup() {
        AbsolutePanel popupPanel = new AbsolutePanel();
        popupPanel.addStyleName("panel");
        for (final Filter filter : this.iFilters) {
            final AbsolutePanel filterPanel = new AbsolutePanel();
            filterPanel.addStyleName("filter");
            filterPanel.setVisible(false);
            popupPanel.add((Widget)filterPanel);
            filter.getPopupWidget(this, new AsyncCallback<Widget>(){

                public void onFailure(Throwable caught) {
                    Label label;
                    if (filter.getLabel() != null && !filter.getLabel().isEmpty()) {
                        label = new Label(filter.getLabel(), false);
                        label.addStyleName("command");
                        filterPanel.add((Widget)label);
                    } else if (filter.getCommand().length() > 0) {
                        label = new Label(filter.getCommand().replace('_', ' '), false);
                        label.addStyleName("command");
                        filterPanel.add((Widget)label);
                    }
                    Label error = new Label(caught.getMessage(), false);
                    error.addStyleName("error");
                    filterPanel.add((Widget)error);
                    filterPanel.setVisible(true);
                }

                public void onSuccess(Widget widget) {
                    if (widget == null) {
                        return;
                    }
                    filterPanel.add(widget);
                    filterPanel.setVisible(true);
                }
            });
        }
        if (this.iDefaultValueProvider != null) {
            boolean selected = ((String)this.iDefaultValueProvider.getValue()).equals(this.getValue().trim());
            final Image star = new Image(selected ? RESOURCES.starSelected() : RESOURCES.star());
            star.setAltText(selected ? MESSAGES.altStarFilterSelected() : MESSAGES.altStarFilter());
            star.setTitle(selected ? MESSAGES.altStarFilterSelected() : MESSAGES.altStarFilter());
            star.addStyleName("button-star");
            star.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    FilterBox.this.iDefaultValueProvider.setValue((Object)FilterBox.this.getValue().trim());
                    star.setResource(RESOURCES.starSelected());
                    star.setAltText(MESSAGES.altStarFilterSelected());
                    star.setTitle(MESSAGES.altStarFilterSelected());
                    event.getNativeEvent().stopPropagation();
                    event.getNativeEvent().preventDefault();
                }
            });
            popupPanel.add((Widget)star);
        }
        return popupPanel;
    }

    public void showSuggestions() {
        this.iLastValue = null;
        this.refreshSuggestions();
    }

    public void refreshSuggestions() {
        if (this.getSuggestionsProvider() == null) {
            return;
        }
        if (this.isFilterPopupShowing()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        String value = this.getValue();
        if (value.equals(this.iLastValue)) {
            return;
        }
        this.iLastValue = value;
        final String query = this.iFilter.getText();
        this.getSuggestionsProvider().getSuggestions(this.getChips(null), query, new AsyncCallback<Collection<Suggestion>>(){

            public void onFailure(Throwable caught) {
                if (FilterBox.this.iSuggestionsPopup.isShowing()) {
                    FilterBox.this.iSuggestionsPopup.hide();
                }
            }

            public void onSuccess(Collection<Suggestion> result) {
                if (!query.equals(FilterBox.this.iFilter.getText())) {
                    return;
                }
                if (result != null && !result.isEmpty()) {
                    FilterBox.this.updateSuggestions(result);
                    FilterBox.this.iSuggestionsPopup.setWidth(FilterBox.this.getElement().getClientWidth() + "px");
                    FilterBox.this.iSuggestionsPopup.showRelativeTo((UIObject)FilterBox.this);
                } else if (FilterBox.this.iSuggestionsPopup.isShowing()) {
                    FilterBox.this.iSuggestionsPopup.hide();
                }
            }
        });
    }

    protected void updateSuggestions(Collection<Suggestion> suggestions) {
        this.iSuggestionMenu.clearItems();
        int selected = -1;
        for (Suggestion suggestion : suggestions) {
            SuggestionMenuItem item = new SuggestionMenuItem(suggestion);
            if (selected < 0 && suggestion.isSelected()) {
                selected = this.iSuggestionMenu.getNumItems();
            }
            this.iSuggestionMenu.addItem(item);
            if (this.iSuggestionMenu.getNumItems() != 20) continue;
            break;
        }
        if (selected >= 0) {
            this.iSuggestionMenu.selectItem(selected);
        } else {
            this.iSuggestionMenu.selectItem(0);
        }
        if (this.iSuggestionMenu.getNumItems() == 1) {
            this.setStatus(ARIA.showingOneSuggestion(this.iSuggestionMenu.getSelectedSuggestion().toAriaString(this)));
        } else if (this.iSuggestionMenu.getSelectedItemIndex() == 0) {
            this.setStatus(ARIA.showingMultipleSuggestions(this.iSuggestionMenu.getNumItems(), this.toAriaString(), this.iSuggestionMenu.getSelectedSuggestion().toAriaString(this)));
        } else {
            this.setStatus(ARIA.onSuggestion(this.iSuggestionMenu.getSelectedItemIndex() + 1, this.iSuggestionMenu.getNumItems(), this.iSuggestionMenu.getSelectedSuggestion().toAriaString(this)));
        }
    }

    public void onBrowserEvent(Event event) {
        com.google.gwt.user.client.Element target = DOM.eventGetTarget((Event)event);
        switch (DOM.eventGetType((Event)event)) {
            case 4: {
                boolean open = this.iFilterOpen.getElement().equals((Object)target);
                boolean close = this.iFilterClose.getElement().equals((Object)target);
                boolean clear = this.iFilterClear.getElement().equals((Object)target);
                boolean filter = this.iFilter.getElement().equals((Object)target);
                if (this.isFilterPopupShowing() || close) {
                    this.hideFilterPopup();
                } else if (open) {
                    this.hideSuggestions();
                    this.showFilterPopup();
                }
                if (clear) {
                    this.iFilter.setText("");
                    this.removeAllChips();
                    this.setAriaLabel(this.toAriaString());
                    ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
                }
                if (filter) break;
                event.stopPropagation();
                event.preventDefault();
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        FilterBox.this.iFilter.setFocus(true);
                    }
                });
            }
        }
    }

    protected void onAttach() {
        super.onAttach();
        this.resizeFilterIfNeeded();
        this.iResizeHandler = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                FilterBox.this.resizeFilterIfNeeded();
            }
        });
    }

    protected void onDetach() {
        super.onDetach();
        if (this.iResizeHandler != null) {
            this.iResizeHandler.removeHandler();
            this.iResizeHandler = null;
        }
    }

    protected void resizeFilterIfNeeded() {
        if (!this.isAttached()) {
            return;
        }
        ChipPanel last = this.getLastChipPanel();
        this.iFilterOpen.setVisible(this.isEnabled() && !this.isFilterPopupShowing());
        this.iFilterClear.setVisible(this.isEnabled() && (!this.iFilter.getText().isEmpty() || last != null));
        int buttonWidth = (this.isFilterPopupShowing() ? this.iFilterClose : this.iFilterOpen).getElement().getOffsetWidth() + this.iFilterClear.getElement().getOffsetWidth() + 8;
        if (last != null) {
            int width = this.getAbsoluteLeft() + this.getOffsetWidth() - last.getAbsoluteLeft() - last.getOffsetWidth() - buttonWidth;
            if (width < 100) {
                width = this.getElement().getClientWidth() - buttonWidth;
            }
            this.iFilter.getElement().getStyle().setWidth((double)width, Style.Unit.PX);
        } else {
            this.iFilter.getElement().getStyle().setWidth((double)(this.getElement().getClientWidth() - buttonWidth), Style.Unit.PX);
        }
        if (this.isSuggestionsShowing()) {
            this.iSuggestionsPopup.moveRelativeTo((UIObject)this);
        }
        if (this.isFilterPopupShowing()) {
            this.iFilterPopup.moveRelativeTo((UIObject)this);
        }
    }

    protected String getChipColor(Chip chip) {
        return this.iChip2Color.getColor(chip.getCommand());
    }

    public void addChip(Chip chip, boolean fireEvents) {
        final ChipPanel panel = new ChipPanel(chip, this.getChipColor(chip));
        panel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FilterBox.this.remove((Widget)panel);
                FilterBox.this.resizeFilterIfNeeded();
                FilterBox.this.setAriaLabel(FilterBox.this.toAriaString());
                ValueChangeEvent.fire((HasValueChangeHandlers)FilterBox.this, (Object)FilterBox.this.getValue());
            }
        });
        this.insert((Widget)panel, this.getWidgetIndex((Widget)this.iFilter));
        this.resizeFilterIfNeeded();
        this.setAriaLabel(this.toAriaString());
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public boolean removeChip(Chip chip, boolean fireEvents) {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel) || !((ChipPanel)w).getChip().equals(chip)) continue;
            this.remove(i);
            this.resizeFilterIfNeeded();
            this.setAriaLabel(this.toAriaString());
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
            return true;
        }
        return false;
    }

    protected ChipPanel getFirstChipPanel() {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel)) continue;
            return (ChipPanel)w;
        }
        return null;
    }

    protected ChipPanel getLastChipPanel() {
        ChipPanel last = null;
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel)) continue;
            last = (ChipPanel)w;
        }
        return last;
    }

    public boolean hasChip(Chip chip) {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel) || !((ChipPanel)w).getChip().equals(chip)) continue;
            return true;
        }
        return false;
    }

    public Chip getChip(String command) {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel) || !((ChipPanel)w).getChip().getCommand().equalsIgnoreCase(command)) continue;
            return ((ChipPanel)w).getChip();
        }
        return null;
    }

    public List<Chip> getChips(String command) {
        ArrayList<Chip> chips = new ArrayList<Chip>();
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel) || command != null && !((ChipPanel)w).getChip().getCommand().equalsIgnoreCase(command)) continue;
            chips.add(((ChipPanel)w).getChip());
        }
        return chips;
    }

    public void fixLabel(Chip chip) {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel) || !((ChipPanel)w).getChip().equals(chip)) continue;
            ((ChipPanel)w).setText(chip.getTranslatedValue());
            this.resizeFilterIfNeeded();
        }
    }

    public void removeAllChips() {
        for (int i = this.getWidgetCount() - 1; i >= 0; --i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel)) continue;
            this.remove(i);
        }
        this.resizeFilterIfNeeded();
    }

    public String getValue() {
        String ret = "";
        for (Chip chip : this.getChips(null)) {
            ret = ret + chip.toString() + " ";
        }
        return ret + this.iFilter.getText();
    }

    public String toAriaString() {
        String ret = "";
        for (Chip chip : this.getChips(null)) {
            if (!ret.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + chip.toAriaString();
        }
        if (!this.iFilter.getText().isEmpty()) {
            if (!ret.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + this.iFilter.getText();
        }
        return ret.isEmpty() ? ARIA.emptyFilter() : ret;
    }

    public void setValue(String text) {
        this.setValue(text, false);
    }

    public void setValue(String text, final boolean fireEvents) {
        this.removeAllChips();
        this.iParser.parse(text, this.getFilters(), new AsyncCallback<Parser.Results>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Parser.Results result) {
                for (Chip chip : result.getChips()) {
                    FilterBox.this.addChip(chip, false);
                }
                FilterBox.this.iFilter.setText(result.getFilter());
                FilterBox.this.resizeFilterIfNeeded();
                FilterBox.this.setAriaLabel(FilterBox.this.toAriaString());
                if (fireEvents) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)FilterBox.this, (Object)FilterBox.this.getValue());
                }
            }
        });
    }

    public String getText() {
        return this.iFilter.getText();
    }

    public void setText(String text) {
        this.iFilter.setText(text);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public int getTabIndex() {
        return this.iFilter.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.iFilter.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.iFilter.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.iFilter.setFocus(focused);
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.iFilter.addKeyUpHandler(handler);
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.iFilter.addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.iFilter.addKeyPressHandler(handler);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.iFilter.addFocusHandler(handler);
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.iFilter.addBlurHandler(handler);
    }

    public boolean isShowSuggestionsOnFocus() {
        return this.iShowSuggestionsOnFocus;
    }

    public void setShowSuggestionsOnFocus(boolean showSuggestionsOnFocus) {
        this.iShowSuggestionsOnFocus = showSuggestionsOnFocus;
    }

    @Override
    public String getAriaLabel() {
        return this.iFilter.getAriaLabel();
    }

    @Override
    public void setAriaLabel(String text) {
        this.iFilter.setAriaLabel(text);
    }

    public void setStatus(String text) {
        AriaStatus.getInstance().setHTML(text);
    }

    public void setDefaultValueProvider(TakesValue<String> defaultValue) {
        this.iDefaultValueProvider = defaultValue;
    }

    public TakesValue<String> getDefaultValueProvider() {
        return this.iDefaultValueProvider;
    }

    public boolean isEnabled() {
        return this.iFilter.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.iFilter.setEnabled(enabled);
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            Widget w = this.getWidget(i);
            if (!(w instanceof ChipPanel)) continue;
            ((ChipPanel)w).setEnabled(enabled);
        }
        if (this.isFilterPopupShowing()) {
            this.hideFilterPopup();
        }
        if (this.isSuggestionsShowing()) {
            this.hideSuggestions();
        }
        this.resizeFilterIfNeeded();
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<Suggestion> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    private void fireSelectionEvent(Suggestion suggestion) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)suggestion);
    }

    public ValueBoxBase<String> getValueBox() {
        return this.iFilter;
    }

    protected static CarrotCookie getCarrotCookie() {
        if (sCarrotCookie == null) {
            sCarrotCookie = new CarrotCookie();
        }
        return sCarrotCookie;
    }

    protected static class CarrotCookie {
        private Set<String> iCommands = new HashSet<String>();

        private CarrotCookie() {
            try {
                String cookie = Cookies.getCookie((String)"UniTime:FilterCarrots");
                if (cookie != null) {
                    for (String cmd : cookie.split("\\|")) {
                        this.iCommands.add(cmd);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void save() {
            String cookie = "";
            for (String cmd : this.iCommands) {
                cookie = cookie + (cookie.isEmpty() ? "" : "|") + cmd;
            }
            Date expires = new Date(new Date().getTime() + 604800000L);
            Cookies.setCookie((String)"UniTime:FilterCarrots", (String)cookie, (Date)expires);
        }

        public boolean hasCarot(String command) {
            return this.iCommands.contains(command);
        }

        public void setCarrot(String command, boolean value) {
            if (value) {
                this.iCommands.add(command);
            } else {
                this.iCommands.remove(command);
            }
            this.save();
        }
    }

    protected static class Carrot
    implements TakesValue<Boolean> {
        private Boolean iValue = null;

        protected Carrot() {
        }

        public Boolean getValue() {
            return this.iValue;
        }

        public void setValue(Boolean value) {
            this.iValue = value;
        }

        public String toString() {
            return this.iValue == null ? "" : (this.iValue != false ? "&#9662;" : "&#9656;");
        }
    }

    private class SuggestionMenuItem
    extends MenuItem {
        private Suggestion iSuggestion;

        private SuggestionMenuItem(final Suggestion suggestion) {
            super(suggestion.getDisplayString() == null ? suggestion.getChip().getLabel() + " <span class='item-command'>" + suggestion.getChip().getTranslatedCommand() + "</span>" : SafeHtmlUtils.htmlEscape((String)suggestion.getDisplayString()) + (suggestion.getHint() == null ? "" : " " + suggestion.getHint()), true, (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    FilterBox.this.hideSuggestions();
                    FilterBox.this.setStatus(ARIA.suggestionSelected(suggestion.toAriaString(FilterBox.this)));
                    FilterBox.this.applySuggestion(suggestion);
                    FilterBox.this.iLastValue = FilterBox.this.getValue();
                    FilterBox.this.setAriaLabel(FilterBox.this.toAriaString());
                    FilterBox.this.fireSelectionEvent(suggestion);
                    ValueChangeEvent.fire((HasValueChangeHandlers)FilterBox.this, (Object)FilterBox.this.getValue());
                }
            });
            this.iSuggestion = null;
            this.setStyleName("item");
            this.getElement().setAttribute("whiteSpace", "nowrap");
            this.iSuggestion = suggestion;
        }

        public Suggestion getSuggestion() {
            return this.iSuggestion;
        }
    }

    private class SuggestionMenu
    extends MenuBar {
        SuggestionMenu() {
            super(true);
            this.setStyleName("");
            this.setFocusOnHoverEnabled(false);
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.selectItem((MenuItem)items.get(index));
            }
        }

        public void executeSelected() {
            MenuItem selected = this.getSelectedItem();
            if (selected != null) {
                selected.getScheduledCommand().execute();
            }
        }

        public Suggestion getSelectedSuggestion() {
            MenuItem selectedItem = this.getSelectedItem();
            return selectedItem == null ? null : ((SuggestionMenuItem)selectedItem).getSuggestion();
        }
    }

    public class PopupPanelKeepFocus
    extends PopupPanel {
        public PopupPanelKeepFocus() {
            super(true, false);
            this.setPreviewingAllNativeEvents(true);
            this.sinkEvents(4);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    FilterBox.this.iFocus = true;
                }
            }
        }

        public final void moveRelativeTo(UIObject target) {
            this.position(target, this.getOffsetWidth(), this.getOffsetHeight());
        }

        private void position(UIObject relativeObject, int offsetWidth, int offsetHeight) {
            int textBoxOffsetWidth = relativeObject.getOffsetWidth();
            int offsetWidthDiff = offsetWidth - textBoxOffsetWidth;
            int left = relativeObject.getAbsoluteLeft();
            if (offsetWidthDiff > 0) {
                int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                int windowLeft = Window.getScrollLeft();
                int distanceToWindowRight = windowRight - left;
                int distanceFromWindowLeft = left - windowLeft;
                if (distanceToWindowRight < offsetWidth && distanceFromWindowLeft >= offsetWidthDiff) {
                    left -= offsetWidthDiff;
                }
            }
            int top = relativeObject.getAbsoluteTop();
            int windowTop = Window.getScrollTop();
            int windowBottom = Window.getScrollTop() + Window.getClientHeight();
            int distanceFromWindowTop = top - windowTop;
            int distanceToWindowBottom = windowBottom - (top + relativeObject.getOffsetHeight());
            top = distanceToWindowBottom < offsetHeight && distanceFromWindowTop >= offsetHeight ? (top -= offsetHeight) : (top += relativeObject.getOffsetHeight());
            this.setPopupPosition(left, top);
        }
    }

    public static class Suggestion
    implements IsSerializable {
        private String iDisplay;
        private String iReplacement;
        private String iHint;
        private Chip iAdd;
        private Chip iRemove;
        private boolean iSelected;

        public Suggestion() {
        }

        public Suggestion(String displayString, String replacementString) {
            this.iDisplay = displayString;
            this.iReplacement = replacementString;
        }

        public Suggestion(String displayString, String replacementString, String hint) {
            this.iDisplay = displayString;
            this.iReplacement = replacementString;
            this.iHint = "<span class='item-hint'>" + hint + "</span>";
        }

        public Suggestion(Chip chip) {
            this.iAdd = chip;
            this.iReplacement = "";
            if (chip.hasToolTip()) {
                this.iDisplay = chip.getLabel();
                this.iHint = " <span class='item-hint'>" + chip.getToolTip() + "</span>";
            }
        }

        public Suggestion(Chip add, Chip remove) {
            this.iAdd = add;
            this.iRemove = remove;
            this.iReplacement = "";
            if ((add != null ? add : remove).hasToolTip()) {
                this.iDisplay = (add != null ? add : remove).getLabel();
                this.iHint = " <span class='item-hint'>" + (add != null ? add : remove).getToolTip() + "</span>";
            }
        }

        public Suggestion(String displayString, Chip add) {
            this.iDisplay = displayString;
            this.iReplacement = "";
            this.iAdd = add;
            this.iHint = add.hasToolTip() ? " <span class='item-hint'>" + add.getToolTip() + "</span>" : "<span class='item-command'>" + add.getTranslatedCommand() + "</span>";
        }

        public Suggestion(String displayString, Chip add, Chip remove) {
            this.iDisplay = displayString;
            this.iReplacement = "";
            this.iAdd = add;
            this.iRemove = remove;
            this.iHint = (add != null ? add : remove).hasToolTip() ? " <span class='item-hint'>" + (add != null ? add : remove).getToolTip() + "</span>" : "<span class='item-command'>" + (add != null ? add : remove).getTranslatedCommand() + "</span>";
        }

        public void setDisplayString(String display) {
            this.iDisplay = display;
        }

        public String getDisplayString() {
            return this.iDisplay;
        }

        public void setReplacementString(String replacement) {
            this.iReplacement = replacement;
        }

        public String getReplacementString() {
            return this.iReplacement;
        }

        public void setHint(String hint) {
            this.iHint = hint;
        }

        public String getHint() {
            return this.iHint;
        }

        public void setChipToAdd(Chip chip) {
            this.iAdd = chip;
        }

        public Chip getChipToAdd() {
            return this.iAdd;
        }

        public void setChipToRemove(Chip chip) {
            this.iRemove = chip;
        }

        public Chip getChipToRemove() {
            return this.iRemove;
        }

        public Chip getChip() {
            return this.getChipToAdd() == null ? this.getChipToRemove() : this.getChipToAdd();
        }

        public boolean isSelected() {
            return this.iSelected;
        }

        public void setSelected(boolean selected) {
            this.iSelected = selected;
        }

        public String toString() {
            return ((this.getDisplayString() == null ? "" : this.getDisplayString()) + (this.getChipToAdd() == null ? "" : " +" + this.getChipToAdd()) + (this.getChipToRemove() == null ? "" : " -" + this.getChipToRemove())).trim();
        }

        public String toAriaString(FilterBox box) {
            if (this.getChipToAdd() != null) {
                if (this.getChipToRemove() != null) {
                    return ARIA.chipReplace(this.getChipToAdd().getTranslatedCommand(), this.getChipToAdd().getLabel());
                }
                if (box.hasChip(this.getChipToAdd())) {
                    return ARIA.chipDelete(this.getChipToAdd().getTranslatedCommand(), this.getChipToAdd().getLabel());
                }
                return ARIA.chipAdd(this.getChipToAdd().getTranslatedCommand(), this.getChipToAdd().getLabel());
            }
            if (this.getChipToRemove() != null) {
                return ARIA.chipDelete(this.getChipToRemove().getTranslatedCommand(), this.getChipToRemove().getLabel());
            }
            return SafeHtmlUtils.htmlEscape((String)this.getDisplayString()) + (this.getHint() == null ? "" : " " + this.getHint());
        }
    }

    public class DefaultSuggestionsProvider
    implements SuggestionsProvider {
        SuggestionsProvider iNext;

        public DefaultSuggestionsProvider(SuggestionsProvider next) {
            this.iNext = next;
        }

        @Override
        public void getSuggestions(List<Chip> chips, String text, AsyncCallback<Collection<Suggestion>> callback) {
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
            if (!text.isEmpty()) {
                this.iterateFilters(chips, text, suggestions, FilterBox.this.getFilters().iterator(), callback);
            } else {
                this.returnSuggestions(chips, text, suggestions, callback);
            }
        }

        public void iterateFilters(final List<Chip> chips, final String text, final List<Suggestion> suggestions, final Iterator<Filter> filters, final AsyncCallback<Collection<Suggestion>> callback) {
            if (filters.hasNext()) {
                Filter filter = filters.next();
                filter.getSuggestions(chips, text, new AsyncCallback<Collection<Suggestion>>(){

                    public void onFailure(Throwable caught) {
                        DefaultSuggestionsProvider.this.iterateFilters(chips, text, suggestions, filters, (AsyncCallback<Collection<Suggestion>>)callback);
                    }

                    public void onSuccess(Collection<Suggestion> result) {
                        if (result != null) {
                            suggestions.addAll(result);
                        }
                        DefaultSuggestionsProvider.this.iterateFilters(chips, text, suggestions, filters, (AsyncCallback<Collection<Suggestion>>)callback);
                    }
                });
            } else {
                this.returnSuggestions(chips, text, suggestions, callback);
            }
        }

        public void returnSuggestions(List<Chip> chips, String text, final List<Suggestion> suggestions, final AsyncCallback<Collection<Suggestion>> callback) {
            if (this.iNext == null) {
                callback.onSuccess(suggestions);
            } else {
                this.iNext.getSuggestions(chips, text, new AsyncCallback<Collection<Suggestion>>(){

                    public void onFailure(Throwable caught) {
                        callback.onSuccess((Object)suggestions);
                    }

                    public void onSuccess(Collection<Suggestion> result) {
                        if (result != null) {
                            suggestions.addAll(result);
                        }
                        callback.onSuccess((Object)suggestions);
                    }
                });
            }
        }
    }

    public static interface SuggestionsProvider {
        public void getSuggestions(List<Chip> var1, String var2, AsyncCallback<Collection<Suggestion>> var3);
    }

    public class DefaultChip2Color
    implements Chip2Color {
        @Override
        public String getColor(String command) {
            for (int i = 0; i < FilterBox.this.iFilters.size(); ++i) {
                if (!FilterBox.this.iFilters.get(i).getCommand().equals(command)) continue;
                return sColors[i];
            }
            return "red";
        }
    }

    public static interface Chip2Color {
        public String getColor(String var1);
    }

    public static class CustomFilter
    implements Filter {
        private String iCommand;
        private String iLabel;
        private AbsolutePanel iPanel = null;
        private Widget[] iWidgets;
        private boolean iVisible = true;

        public CustomFilter(String command, String label, Widget ... popupWidgets) {
            this.iCommand = command;
            this.iLabel = label;
            this.iWidgets = popupWidgets;
        }

        @Override
        public String getCommand() {
            return this.iCommand;
        }

        @Override
        public String getLabel() {
            return this.iLabel == null || this.iLabel.isEmpty() ? this.iCommand.replace('_', ' ') : this.iLabel;
        }

        @Override
        public void validate(String value, AsyncCallback<Chip> callback) {
            callback.onSuccess((Object)new Chip(this.getCommand(), value).withTranslatedCommand(this.getLabel()));
        }

        public boolean isVisible() {
            return this.iVisible;
        }

        public void setVisible(boolean visible) {
            this.iVisible = visible;
        }

        private void fixHandlers(final FilterBox box, Widget w) {
            if (w instanceof HasBlurHandlers) {
                ((HasBlurHandlers)w).addBlurHandler(box.iBlurHandler);
            }
            if (w instanceof HasFocusHandlers) {
                ((HasFocusHandlers)w).addFocusHandler(box.iFocusHandler);
            }
            if (w instanceof HasKeyDownHandlers) {
                ((HasKeyDownHandlers)w).addKeyDownHandler(new KeyDownHandler(){

                    public void onKeyDown(KeyDownEvent event) {
                        if (event.getNativeEvent().getKeyCode() == 27 && box.isFilterPopupShowing()) {
                            box.hideFilterPopup();
                        }
                    }
                });
            }
        }

        @Override
        public void getPopupWidget(final FilterBox box, AsyncCallback<Widget> callback) {
            if (!this.isVisible()) {
                callback.onSuccess(null);
                return;
            }
            if (this.iPanel == null) {
                Label label;
                this.iPanel = new AbsolutePanel();
                this.iPanel.addStyleName("filter");
                if (this.getLabel() != null && !this.getLabel().isEmpty()) {
                    label = new Label(this.getLabel(), false);
                    label.addStyleName("command");
                    this.iPanel.add((Widget)label);
                } else if (this.getCommand() != null && !this.getCommand().isEmpty()) {
                    label = new Label(this.getCommand().replace('_', ' '), false);
                    label.addStyleName("command");
                    this.iPanel.add((Widget)label);
                }
                AbsolutePanel other = new AbsolutePanel();
                other.addStyleName("other");
                for (final Widget w : this.iWidgets) {
                    w.addStyleName("inline");
                    if (w instanceof AriaSuggestBox) {
                        this.fixHandlers(box, (Widget)((AriaSuggestBox)w).getValueBox());
                        this.fixHandlers(box, (Widget)((AriaSuggestBox)w).getSuggestionMenu());
                        ((AriaSuggestBox)w).addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

                            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                                ((AriaSuggestBox)w).setFocus(true);
                            }
                        });
                    } else {
                        this.fixHandlers(box, w);
                    }
                    if (w instanceof TimeSelector) {
                        this.fixHandlers(box, (Widget)((TimeSelector)w).getTimeMenu());
                        ((TimeSelector)w).addSelectionHandler(new SelectionHandler<Integer>(){

                            public void onSelection(SelectionEvent<Integer> event) {
                                box.setFocus(true);
                            }
                        });
                    }
                    other.add(w);
                }
                this.iPanel.add((Widget)other);
            }
            callback.onSuccess((Object)this.iPanel);
        }

        @Override
        public void getSuggestions(List<Chip> chips, String text, AsyncCallback<Collection<Suggestion>> callback) {
            callback.onSuccess(null);
        }
    }

    public static class StaticSimpleFilter
    extends SimpleFilter {
        private List<Chip> iValues = new ArrayList<Chip>();
        private boolean iValidate;

        public StaticSimpleFilter(String command, String label, boolean validate, String ... values) {
            super(command, label);
            this.iValidate = validate;
            for (String value : values) {
                this.iValues.add(new Chip(command, value).withLabel(label));
            }
        }

        public StaticSimpleFilter(String command, String label, String ... values) {
            this(command, label, values.length > 0, values);
        }

        public StaticSimpleFilter(String command, String label, boolean validate, Collection<Chip> chips) {
            super(command, label);
            this.iValidate = validate;
            if (chips != null) {
                this.iValues.addAll(chips);
            }
        }

        public StaticSimpleFilter(String command, String label, Collection<Chip> chips) {
            this(command, label, chips != null && !chips.isEmpty(), chips);
        }

        @Override
        public void getValues(List<Chip> chips, String text, AsyncCallback<Collection<Chip>> callback) {
            callback.onSuccess(this.iValues);
        }

        public void setValues(List<Chip> values) {
            this.iValues = values;
        }

        @Override
        public void validate(String text, AsyncCallback<Chip> callback) {
            if (this.iValidate) {
                for (Chip chip : this.iValues) {
                    if (!chip.getValue().equals(text)) continue;
                    callback.onSuccess((Object)chip);
                    return;
                }
                callback.onFailure((Throwable)new Exception("Unknown value " + text + "."));
            } else {
                callback.onSuccess((Object)new Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()));
            }
        }
    }

    public static abstract class SimpleFilter
    implements Filter {
        private String iCommand;
        private String iLabel;
        private boolean iMultiple = true;
        private boolean iVisible = true;
        private Carrot iCarrot = new Carrot();

        public SimpleFilter(String command, String label) {
            this.iCommand = command;
            this.iLabel = label;
        }

        public boolean isMultipleSelection() {
            return this.iMultiple;
        }

        public Filter setMultipleSelection(boolean multiple) {
            this.iMultiple = multiple;
            return this;
        }

        @Override
        public String getCommand() {
            return this.iCommand;
        }

        @Override
        public String getLabel() {
            return this.iLabel == null || this.iLabel.isEmpty() ? this.iCommand.replace('_', ' ') : this.iLabel;
        }

        public boolean isVisible() {
            return this.iVisible;
        }

        public void setVisible(boolean visible) {
            this.iVisible = visible;
        }

        public abstract void getValues(List<Chip> var1, String var2, AsyncCallback<Collection<Chip>> var3);

        @Override
        public void getSuggestions(final List<Chip> chips, final String text, final AsyncCallback<Collection<Suggestion>> callback) {
            if (text.isEmpty()) {
                callback.onSuccess(null);
            } else {
                this.getValues(chips, text, new AsyncCallback<Collection<Chip>>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(Collection<Chip> result) {
                        ArrayList<Suggestion> ret = new ArrayList<Suggestion>();
                        if (this.getCommand().toLowerCase().startsWith(text) || this.getLabel().toLowerCase().startsWith(text)) {
                            for (Chip chip : result) {
                                if (chips.contains(chip)) {
                                    ret.add(new Suggestion(chip));
                                    continue;
                                }
                                Chip old = null;
                                for (Chip c : chips) {
                                    if (!c.getCommand().equals(this.getCommand())) continue;
                                    old = c;
                                    break;
                                }
                                ret.add(new Suggestion(chip, this.isMultipleSelection() ? null : old));
                            }
                        } else {
                            for (Chip chip : result) {
                                if (!chip.startsWith(text)) continue;
                                if (chips.contains(chip)) {
                                    ret.add(new Suggestion(chip));
                                    continue;
                                }
                                Chip old = null;
                                for (Chip c : chips) {
                                    if (!c.getCommand().equals(this.getCommand())) continue;
                                    old = c;
                                    break;
                                }
                                ret.add(new Suggestion(chip, this.isMultipleSelection() ? null : old));
                            }
                        }
                        callback.onSuccess(ret);
                    }
                });
            }
        }

        @Override
        public void getPopupWidget(final FilterBox box, final AsyncCallback<Widget> callback) {
            if (!this.isVisible()) {
                callback.onSuccess(null);
                return;
            }
            this.getValues(box.getChips(null), box.getText(), new AsyncCallback<Collection<Chip>>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(Collection<Chip> values) {
                    if (values == null || values.isEmpty()) {
                        callback.onSuccess(null);
                        return;
                    }
                    final AbsolutePanel popup = new AbsolutePanel();
                    final HTML label = new HTML(this.getLabel() != null && !this.getLabel().isEmpty() ? this.getLabel() : this.getCommand().replace('_', ' '), false);
                    if (values.size() >= 10) {
                        if (iCarrot.getValue() == null) {
                            iCarrot.setValue(FilterBox.getCarrotCookie().hasCarot(this.getCommand()));
                        }
                        label.setHTML(iCarrot + (this.getLabel() != null && !this.getLabel().isEmpty() ? this.getLabel() : this.getCommand().replace('_', ' ')));
                        label.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                iCarrot.setValue(iCarrot.getValue() == false);
                                FilterBox.getCarrotCookie().setCarrot(this.getCommand(), iCarrot.getValue());
                                label.setHTML(iCarrot + (this.getLabel() != null && !this.getLabel().isEmpty() ? this.getLabel() : this.getCommand().replace('_', ' ')));
                                for (int i = 1; i < popup.getWidgetCount(); ++i) {
                                    popup.getWidget(i).setVisible(iCarrot.getValue().booleanValue());
                                }
                                event.getNativeEvent().stopPropagation();
                                event.getNativeEvent().preventDefault();
                            }
                        });
                        label.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    } else {
                        iCarrot.setValue(null);
                    }
                    label.addStyleName("command");
                    popup.add((Widget)label);
                    for (final Chip value : values) {
                        String html = SafeHtmlUtils.htmlEscape((String)value.getLabel());
                        if (value.hasCount()) {
                            html = "<span class='value-text'>" + html + "&nbsp;</span><span class='value-hint'>(" + value.getCount() + ")</span>";
                        } else if (value.hasToolTip()) {
                            html = "<span class='value-text'>" + html + "&nbsp;</span><span class='value-hint'>" + value.getToolTip() + "</span>";
                        }
                        HTML item = new HTML(html, false);
                        if (value.hasToolTip()) {
                            item.setTitle(value.getToolTip());
                        }
                        item.addStyleName("value");
                        item.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                if (this.isMultipleSelection()) {
                                    if (!box.removeChip(value, true)) {
                                        box.addChip(value, true);
                                    }
                                } else {
                                    Chip old = box.getChip(value.getCommand());
                                    if (old == null) {
                                        box.addChip(value, true);
                                    } else if (!old.equals(value)) {
                                        box.removeChip(old, false);
                                        box.addChip(value, true);
                                    }
                                }
                                event.getNativeEvent().stopPropagation();
                                event.getNativeEvent().preventDefault();
                            }
                        });
                        if (iCarrot.getValue() != null) {
                            item.setVisible(iCarrot.getValue().booleanValue());
                        }
                        popup.add((Widget)item);
                    }
                    callback.onSuccess((Object)popup);
                }
            });
        }
    }

    public static class DefaultParser
    implements Parser {
        private static RegExp[] sRegExps = new RegExp[]{RegExp.compile((String)"^(\\w+):\"([^\"]*)\"(.*)$", (String)"i"), RegExp.compile((String)"^(\\w+):([^ ]*) (.*)$", (String)"i"), RegExp.compile((String)"^(\\w+):([^ ]*)$", (String)"i")};

        @Override
        public void parse(String text, Collection<Filter> filters, AsyncCallback<Parser.Results> callback) {
            this.parse(new ArrayList<Chip>(), text, filters, callback);
        }

        private void parse(final List<Chip> chips, final String text, final Collection<Filter> filters, final AsyncCallback<Parser.Results> callback) {
            if (text.isEmpty()) {
                callback.onSuccess((Object)new Parser.Results(text, chips));
            } else {
                for (RegExp regExp : sRegExps) {
                    final MatchResult r = regExp.exec(text);
                    if (r == null) continue;
                    for (Filter filter : filters) {
                        if (!filter.getCommand().equals(r.getGroup(1))) continue;
                        filter.validate(r.getGroup(2), new AsyncCallback<Chip>(){

                            public void onFailure(Throwable caught) {
                                callback.onSuccess((Object)new Parser.Results(text, chips));
                            }

                            public void onSuccess(Chip result) {
                                if (result == null) {
                                    callback.onSuccess((Object)new Parser.Results(text, chips));
                                } else {
                                    chips.add(result);
                                    if (r.getGroupCount() > 3) {
                                        this.parse(chips, r.getGroup(3).trim(), filters, (AsyncCallback<Parser.Results>)callback);
                                    } else {
                                        callback.onSuccess((Object)new Parser.Results("", chips));
                                    }
                                }
                            }
                        });
                        return;
                    }
                }
                callback.onSuccess((Object)new Parser.Results(text, chips));
            }
        }
    }

    public static interface Parser {
        public void parse(String var1, Collection<Filter> var2, AsyncCallback<Results> var3);

        public static class Results
        implements IsSerializable {
            private Collection<Chip> iChips = new ArrayList<Chip>();
            private String iFilter = null;

            public Results(String filter, Collection<Chip> chips) {
                this.iChips = chips;
                this.iFilter = filter;
            }

            public Collection<Chip> getChips() {
                return this.iChips;
            }

            public String getFilter() {
                return this.iFilter;
            }

            public String toString() {
                return "ParserResults{chips=" + this.getChips() + ", filter=" + this.getFilter() + "}";
            }
        }
    }

    public static interface Filter {
        public String getCommand();

        public String getLabel();

        public void validate(String var1, AsyncCallback<Chip> var2);

        public void getSuggestions(List<Chip> var1, String var2, AsyncCallback<Collection<Suggestion>> var3);

        public void getPopupWidget(FilterBox var1, AsyncCallback<Widget> var2);
    }

    public static class Chip
    implements IsSerializable {
        private String iCommand;
        private String iValue;
        private String iLabel;
        private String iHint;
        private String iTranslatedCommand;
        private String iTranslatedValue;
        private Integer iCount;

        public Chip() {
        }

        public Chip(String command, String value) {
            this.iCommand = command;
            this.iValue = value;
        }

        public Chip withCount(Integer count) {
            this.iCount = count;
            if (this.iCount != null && this.iCount <= 0) {
                this.iCount = null;
            }
            return this;
        }

        public Chip withTranslatedCommand(String translation) {
            this.iTranslatedCommand = translation;
            return this;
        }

        public Chip withTranslatedValue(String translation) {
            this.iTranslatedValue = translation;
            return this;
        }

        public Chip withToolTip(String hint) {
            this.iHint = hint;
            return this;
        }

        public Chip withLabel(String label) {
            this.iLabel = label;
            return this;
        }

        public String getCommand() {
            return this.iCommand;
        }

        public String getTranslatedCommand() {
            return this.iTranslatedCommand == null || this.iTranslatedCommand.isEmpty() ? this.iCommand.replace('_', ' ') : this.iTranslatedCommand;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getTranslatedValue() {
            return this.iTranslatedValue == null || this.iTranslatedValue.isEmpty() ? this.iValue : this.iTranslatedValue;
        }

        public String getLabel() {
            return this.iLabel == null || this.iLabel.isEmpty() ? (this.iTranslatedValue == null || this.iTranslatedValue.isEmpty() ? this.iValue : this.iTranslatedValue) : this.iLabel;
        }

        public boolean hasToolTip() {
            return this.iHint != null && !this.iHint.isEmpty();
        }

        public String getToolTip() {
            return this.iHint;
        }

        public boolean hasCount() {
            return this.iCount != null && this.iCount > 0;
        }

        public Integer getCount() {
            return this.iCount;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Chip)) {
                return false;
            }
            Chip chip = (Chip)other;
            return !(chip.getCommand() != null && !chip.getCommand().equalsIgnoreCase(this.getCommand()) || chip.getValue() != null && !chip.getValue().equalsIgnoreCase(this.getValue()));
        }

        public String toString() {
            return this.getCommand() + ":" + (this.getValue().contains(" ") ? "\"" + this.getValue() + "\"" : this.getValue());
        }

        public String toAriaString() {
            return this.getTranslatedCommand() + " " + this.getTranslatedValue();
        }

        public boolean startsWith(String text) {
            String t = text.toLowerCase();
            if (this.iValue != null && this.iValue.toLowerCase().startsWith(t)) {
                return true;
            }
            if (this.iLabel != null && this.iLabel.toLowerCase().startsWith(t)) {
                return true;
            }
            if (this.iTranslatedValue != null && this.iTranslatedValue.toLowerCase().startsWith(t)) {
                return true;
            }
            if (this.iCommand != null && t.startsWith(this.iCommand.toLowerCase() + " ")) {
                if (this.iValue != null && (this.iCommand + " " + this.iValue).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iLabel != null && (this.iCommand + " " + this.iLabel).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iTranslatedValue != null && (this.iCommand + " " + this.iTranslatedValue).toLowerCase().startsWith(t)) {
                    return true;
                }
            }
            if (this.iCommand != null && t.startsWith(this.iCommand.toLowerCase() + ":")) {
                if (this.iValue != null && (this.iCommand + ":" + this.iValue).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iLabel != null && (this.iCommand + ":" + this.iLabel).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iTranslatedValue != null && (this.iCommand + ":" + this.iTranslatedValue).toLowerCase().startsWith(t)) {
                    return true;
                }
            }
            if (this.iTranslatedCommand != null && t.startsWith(this.iTranslatedCommand.toLowerCase() + " ")) {
                if (this.iValue != null && (this.iTranslatedCommand + " " + this.iValue).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iLabel != null && (this.iTranslatedCommand + " " + this.iLabel).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iTranslatedValue != null && (this.iTranslatedCommand + " " + this.iTranslatedValue).toLowerCase().startsWith(t)) {
                    return true;
                }
            }
            if (this.iTranslatedCommand != null && t.startsWith(this.iTranslatedCommand.toLowerCase() + ":")) {
                if (this.iValue != null && (this.iTranslatedCommand + ":" + this.iValue).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iLabel != null && (this.iTranslatedCommand + ":" + this.iLabel).toLowerCase().startsWith(t)) {
                    return true;
                }
                if (this.iTranslatedValue != null && (this.iTranslatedCommand + ":" + this.iTranslatedValue).toLowerCase().startsWith(t)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ChipPanel
    extends AbsolutePanel
    implements HasClickHandlers,
    HasText,
    HasEnabled {
        private Chip iChip;
        private Label iLabel;
        private HTML iButton;

        public ChipPanel(Chip chip, String color) {
            this.iChip = chip;
            this.setStyleName("chip");
            this.addStyleName(color);
            this.iLabel = new Label(chip.getTranslatedValue());
            this.iLabel.setStyleName("text");
            this.add((Widget)this.iLabel);
            this.iButton = new HTML("&times;");
            this.iButton.setStyleName("button");
            this.add((Widget)this.iButton);
            if (chip.hasToolTip()) {
                this.setTitle(this.toString() + "\n" + chip.getToolTip());
            } else {
                this.setTitle(this.toString());
            }
            Roles.getDocumentRole().setAriaHiddenState((Element)this.getElement(), true);
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.iButton.addClickHandler(handler);
        }

        public String getText() {
            return this.iLabel.getText();
        }

        public void setText(String text) {
            this.iLabel.setText(text);
        }

        public Chip getChip() {
            return this.iChip;
        }

        public String toString() {
            return this.getChip().toString();
        }

        public String toAriaString() {
            return this.getChip().toAriaString();
        }

        public boolean isEnabled() {
            return this.iButton.isVisible();
        }

        public void setEnabled(boolean enabled) {
            this.iButton.setVisible(enabled);
        }
    }
}

