/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.client.widgets.FreeTimePicker;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class CourseFinderFreeTime
extends P
implements CourseFinder.CourseFinderTab<List<CourseRequestInterface.FreeTime>> {
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private FreeTimePicker iFreeTimePicker = new FreeTimePicker();
    private Label iFreeTimeError;
    private Label iFreeTimeTip;
    private FreeTimeParser iDataProvider;

    public CourseFinderFreeTime() {
        super("free-times");
        this.iFreeTimePicker.addValueChangeHandler(new ValueChangeHandler<List<CourseRequestInterface.FreeTime>>(){

            public void onValueChange(ValueChangeEvent<List<CourseRequestInterface.FreeTime>> event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseFinderFreeTime.this, (Object)new CourseRequestInterface.RequestedCourse((List)event.getValue()));
                CourseFinderFreeTime.this.iFreeTimeError.setVisible(false);
            }
        });
        ScrollPanel panel = new ScrollPanel((Widget)this.iFreeTimePicker);
        panel.setStyleName("unitime-ScrollPanel-inner");
        panel.addStyleName("free-time-picker");
        this.add((Widget)panel);
        this.iFreeTimeTip = new Label(CONSTANTS.freeTimeTips()[(int)(Math.random() * (double)CONSTANTS.freeTimeTips().length)]);
        this.iFreeTimeTip.setStyleName("unitime-Hint");
        ToolBox.disableTextSelectInternal((Element)this.iFreeTimeTip.getElement());
        this.iFreeTimeTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseFinderFreeTime.this.iFreeTimeTip.getText();
                do {
                    CourseFinderFreeTime.this.iFreeTimeTip.setText(CONSTANTS.freeTimeTips()[(int)(Math.random() * (double)CONSTANTS.freeTimeTips().length)]);
                } while (oldText.equals(CourseFinderFreeTime.this.iFreeTimeTip.getText()));
            }
        });
        this.add((Widget)this.iFreeTimeTip);
        this.iFreeTimeError = new Label();
        this.iFreeTimeError.setStyleName("unitime-ErrorMessage");
        this.iFreeTimeError.setVisible(false);
        this.add((Widget)this.iFreeTimeError);
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        Object ret = this.iFreeTimePicker.getValue();
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return new CourseRequestInterface.RequestedCourse((List<CourseRequestInterface.FreeTime>)ret);
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, final boolean fireEvents) {
        if (value == null) {
            this.iFreeTimePicker.setValue(null);
            this.iFreeTimeError.setText(MESSAGES.courseSelectionNoFreeTime());
            this.iFreeTimeError.setVisible(true);
        } else if (value.isFreeTime()) {
            this.iFreeTimePicker.setValue(value.getFreeTime(), fireEvents);
            this.iFreeTimeError.setVisible(false);
            String status = "";
            for (CourseRequestInterface.FreeTime ft : value.getFreeTime()) {
                status = status + ft.toAriaString(CONSTANTS.longDays(), CONSTANTS.useAmPm()) + " ";
            }
            if (!status.isEmpty()) {
                AriaStatus.getInstance().setText(ARIA.courseFinderSelectedFreeTime(status));
            }
            CourseFinder.ResponseEvent.fire(this, true);
        } else if (value.isCourse()) {
            this.iDataProvider.getData(value.getCourseName(), new AsyncCallback<List<CourseRequestInterface.FreeTime>>(){

                public void onSuccess(List<CourseRequestInterface.FreeTime> freeTimes) {
                    CourseFinderFreeTime.this.iFreeTimePicker.setValue(freeTimes, fireEvents);
                    CourseFinderFreeTime.this.iFreeTimeError.setVisible(false);
                    String status = "";
                    for (CourseRequestInterface.FreeTime ft : freeTimes) {
                        status = status + ft.toAriaString(CONSTANTS.longDays(), CONSTANTS.useAmPm()) + " ";
                    }
                    if (!status.isEmpty()) {
                        AriaStatus.getInstance().setText(ARIA.courseFinderSelectedFreeTime(status));
                    }
                    CourseFinder.ResponseEvent.fire(CourseFinderFreeTime.this, true);
                }

                public void onFailure(Throwable caught) {
                    CourseFinderFreeTime.this.iFreeTimePicker.setValue(null);
                    CourseFinderFreeTime.this.iFreeTimeError.setText(caught.getMessage());
                    CourseFinderFreeTime.this.iFreeTimeError.setVisible(true);
                    CourseFinder.ResponseEvent.fire(CourseFinderFreeTime.this, false);
                }
            });
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionFreeTime();
    }

    @Override
    public void setDataProvider(DataProvider<String, List<CourseRequestInterface.FreeTime>> provider) {
        this.iDataProvider = (FreeTimeParser)provider;
    }

    @Override
    public boolean isCourseSelection() {
        return false;
    }

    @Override
    public void setCourseDetails(CourseFinder.CourseFinderCourseDetails ... details) {
        throw new UnsupportedOperationException();
    }

    public void onKeyUp(KeyUpEvent event) {
    }

    @Override
    public HandlerRegistration addResponseHandler(CourseFinder.ResponseHandler handler) {
        return this.addHandler(handler, CourseFinder.ResponseEvent.getType());
    }

    @Override
    public void changeTip() {
        this.iFreeTimeTip.setText(CONSTANTS.freeTimeTips()[(int)(Math.random() * (double)CONSTANTS.freeTimeTips().length)]);
    }

    public boolean isEnabled() {
        return this.iFreeTimePicker.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.iFreeTimePicker.setEnabled(enabled);
    }

    @Override
    public CheckBox getRequiredCheckbox() {
        return null;
    }
}

