/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class CourseFinderCourses
extends P
implements CourseFinder.CourseFinderTab<Collection<ClassAssignmentInterface.CourseAssignment>> {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> iDataProvider = null;
    private UniTimeTable<ClassAssignmentInterface.CourseAssignment> iCourses;
    private ScrollPanel iCoursesPanel;
    private Label iCoursesTip;
    private AriaTabBar iCourseDetailsTabBar;
    private ScrollPanel iCourseDetailsPanel;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private CourseFinder.CourseFinderCourseDetails[] iDetails = null;
    private String iLastQuery = null;
    private P iInstructionalMethodsPanel = null;
    private Map<CourseRequestInterface.Preference, CheckBox> iInstructionalMethods = new HashMap<CourseRequestInterface.Preference, CheckBox>();
    private Set<CourseRequestInterface.Preference> iSelectedMethods = new HashSet<CourseRequestInterface.Preference>();
    private CheckBox iRequired = null;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private boolean iShowCourseTitles = false;
    private boolean iShowDefaultSuggestions = false;

    public CourseFinderCourses() {
        this(false, false, false, null);
    }

    public CourseFinderCourses(boolean showCourseTitles, boolean showDefaultSuggestions, boolean showRequired, SpecialRegistrationInterface.SpecialRegistrationContext specReg) {
        super("courses");
        this.iShowCourseTitles = showCourseTitles;
        this.iShowDefaultSuggestions = showDefaultSuggestions;
        this.iSpecReg = specReg;
        this.iCourses = new UniTimeTable();
        this.iCourses.setAllowMultiSelect(false);
        this.iCourses.setAllowSelection(true);
        ArrayList<UniTimeTableHeader> head = new ArrayList<UniTimeTableHeader>();
        head.add(new UniTimeTableHeader(MESSAGES.colSubject()));
        head.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        head.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        head.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        head.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        head.add(new UniTimeTableHeader(MESSAGES.colNote()));
        this.iCourses.addRow(null, head);
        this.iCourses.addMouseDoubleClickListener(new UniTimeTable.MouseDoubleClickListener<ClassAssignmentInterface.CourseAssignment>(){

            @Override
            public void onMouseDoubleClick(UniTimeTable.TableEvent<ClassAssignmentInterface.CourseAssignment> event) {
                CourseFinderCourses.this.updateCourseDetails();
                if (CourseFinderCourses.this.isEnabled()) {
                    SelectionEvent.fire((HasSelectionHandlers)CourseFinderCourses.this, (Object)CourseFinderCourses.this.getValue());
                }
            }
        });
        this.iCourses.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.CourseAssignment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.CourseAssignment> event) {
                CourseFinderCourses.this.updateCourseDetails();
            }
        });
        this.iCoursesPanel = new ScrollPanel(this.iCourses);
        this.iCoursesPanel.setStyleName("unitime-ScrollPanel");
        this.iCoursesPanel.addStyleName("course-table");
        this.iCoursesTip = new Label(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.iCoursesTip.setStyleName("unitime-Hint");
        this.iCoursesTip.addStyleName("course-tip");
        ToolBox.disableTextSelectInternal((Element)this.iCoursesTip.getElement());
        this.iCoursesTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseFinderCourses.this.iCoursesTip.getText();
                do {
                    CourseFinderCourses.this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
                } while (oldText.equals(CourseFinderCourses.this.iCoursesTip.getText()));
            }
        });
        this.iCourseDetailsTabBar = new AriaTabBar();
        this.iCourseDetailsTabBar.addStyleName("course-details-tabs");
        this.iCourseDetailsPanel = new ScrollPanel();
        this.iCourseDetailsPanel.addStyleName("course-details");
        this.iCourseDetailsTabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Cookies.setCookie((String)"UniTime:CourseFinderCourses", (String)String.valueOf(event.getSelectedItem()));
                CourseFinderCourses.this.iCourseDetailsPanel.setWidget((IsWidget)CourseFinderCourses.this.iDetails[(Integer)event.getSelectedItem()]);
            }
        });
        this.iInstructionalMethodsPanel = new P("instructional-methods");
        this.iCourseDetailsTabBar.setRestWidget((Widget)this.iInstructionalMethodsPanel);
        if (showRequired) {
            this.iRequired = new CheckBox(MESSAGES.checkPreferencesAreRequired());
            this.iRequired.addStyleName("required-check");
            this.iRequired.setEnabled(this.isEnabled());
            this.iRequired.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    for (CourseRequestInterface.Preference p : CourseFinderCourses.this.iInstructionalMethods.keySet()) {
                        p.setRequired((Boolean)event.getValue());
                    }
                    for (CourseRequestInterface.Preference p : CourseFinderCourses.this.iSelectedMethods) {
                        p.setRequired((Boolean)event.getValue());
                    }
                }
            });
        }
        this.add((Widget)this.iCoursesPanel);
        this.add((Widget)this.iCourseDetailsTabBar);
        this.add((Widget)this.iCourseDetailsPanel);
        this.add((Widget)this.iCoursesTip);
    }

    @Override
    public void setDataProvider(DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionCourses();
    }

    public Widget asWidget() {
        return this;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false);
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        int row = this.iCourses.getSelectedRow();
        if (this.iCourses.getSelectedRow() < 0) {
            return null;
        }
        ClassAssignmentInterface.CourseAssignment record = this.iCourses.getData(row);
        if (record == null) {
            return null;
        }
        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
        rc.setCourseId(record.getCourseId());
        rc.setCourseName(MESSAGES.courseName(record.getSubject(), record.getCourseNbr()));
        if (record.hasTitle() && (!record.hasUniqueName() || this.iShowCourseTitles)) {
            rc.setCourseName(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle()));
        }
        rc.setCourseTitle(record.getTitle());
        rc.setCredit(record.guessCreditRange());
        for (Map.Entry<CourseRequestInterface.Preference, CheckBox> e : this.iInstructionalMethods.entrySet()) {
            if (!e.getValue().isEnabled() || !e.getValue().getValue().booleanValue()) continue;
            rc.setSelectedIntructionalMethod(e.getKey(), true);
        }
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                d.onGetValue(rc);
            }
        }
        return rc;
    }

    protected boolean isSelectedMethodRequired(Long id) {
        for (CourseRequestInterface.Preference p : this.iSelectedMethods) {
            if (!p.getId().equals(id)) continue;
            return p.isRequired();
        }
        return this.iRequired != null && this.iRequired.isEnabled() && this.iRequired.getValue() != false;
    }

    protected boolean isSelectedMethod(Long id) {
        for (CourseRequestInterface.Preference p : this.iSelectedMethods) {
            if (!p.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, final boolean fireEvents) {
        String query = value == null || !value.isCourse() ? "" : value.getCourseName();
        this.iSelectedMethods.clear();
        if (this.iRequired != null) {
            this.iRequired.setValue(Boolean.valueOf(false));
        }
        for (CheckBox ch : this.iInstructionalMethods.values()) {
            if (!ch.isEnabled()) continue;
            ch.setValue(Boolean.valueOf(false));
        }
        if (value != null && value.hasSelectedIntructionalMethods()) {
            for (CourseRequestInterface.Preference id : value.getSelectedIntructionalMethods()) {
                CheckBox ch;
                this.iSelectedMethods.add(id);
                if (id.isRequired() && this.iRequired != null) {
                    this.iRequired.setValue(Boolean.valueOf(true));
                }
                if ((ch = this.iInstructionalMethods.get(id)) == null || !ch.isEnabled()) continue;
                ch.setValue(Boolean.valueOf(true));
            }
        }
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                d.onSetValue(value);
            }
        }
        if (query.isEmpty() && !this.iShowDefaultSuggestions) {
            this.iLastQuery = null;
            this.iCourses.clearTable(1);
            this.iCourses.setEmptyMessage(MESSAGES.courseSelectionNoCourseFilter());
            this.updateCourseDetails();
        } else if (!query.equals(this.iLastQuery)) {
            this.iLastQuery = query;
            this.iDataProvider.getData(query, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderCourses.this.iCourses.clearTable(1);
                    CourseFinderCourses.this.iCourses.setEmptyMessage(caught.getMessage());
                    if (CourseFinderCourses.this.isVisible()) {
                        AriaStatus.getInstance().setText(caught.getMessage());
                    }
                    CourseFinderCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderCourses.this, false);
                }

                public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                    CourseFinderCourses.this.iCourses.clearTable(1);
                    boolean hasCredit = false;
                    boolean hasNote = false;
                    for (ClassAssignmentInterface.CourseAssignment record : result) {
                        ArrayList<Object> line = new ArrayList<Object>();
                        line.add(new Label(record.getSubject(), false));
                        line.add(new Label(record.getCourseNbr(), false));
                        line.add(new HTML(record.getLimit() == null || record.getLimit() == 0 || record.getEnrollment() == null ? "" : (record.getLimit() < 0 ? "&infin;" : record.getLimit() - record.getEnrollment() + " / " + record.getLimit()), false));
                        line.add(new Label(record.getTitle() == null ? "" : record.getTitle(), false));
                        if (record.hasCredit()) {
                            Label credit = new Label(record.getCreditAbbv(), false);
                            if (record.hasCredit()) {
                                credit.setTitle(record.getCreditText());
                            }
                            line.add(credit);
                            hasCredit = true;
                        } else {
                            line.add(new Label());
                        }
                        line.add(new Label(record.getNote() == null ? "" : record.getNote()));
                        if (record.hasNote()) {
                            hasNote = true;
                        }
                        if (record.hasTitle()) {
                            if (record.hasNote()) {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitleAndNote(record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote())));
                            } else {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle())));
                            }
                        } else if (record.hasNote()) {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithNote(record.getSubject(), record.getCourseNbr(), record.getNote())));
                        } else {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourse(record.getSubject(), record.getCourseNbr())));
                        }
                        int row = CourseFinderCourses.this.iCourses.addRow(record, line);
                        if (!CourseFinderCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseName(record.getSubject(), record.getCourseNbr())) && (record.getTitle() == null || !CourseFinderCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle())))) continue;
                        CourseFinderCourses.this.iCourses.setSelected(row, true);
                    }
                    CourseFinderCourses.this.iCourses.setColumnVisible(4, hasCredit);
                    CourseFinderCourses.this.iCourses.setColumnVisible(5, hasNote);
                    if (result.size() == 1) {
                        CourseFinderCourses.this.iCourses.setSelected(1, true);
                    }
                    if (CourseFinderCourses.this.iCourses.getSelectedRow() >= 0) {
                        CourseFinderCourses.this.scrollToSelectedRow();
                        if (fireEvents) {
                            ValueChangeEvent.fire((HasValueChangeHandlers)CourseFinderCourses.this, (Object)CourseFinderCourses.this.getValue());
                        }
                    }
                    CourseFinderCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderCourses.this, !result.isEmpty());
                }
            });
        }
        if (this.iRequired != null) {
            this.iRequired.setEnabled(this.isEnabled() && (this.iSpecReg == null || this.iSpecReg.isCanRequire()));
            this.iRequired.setVisible(this.iSpecReg == null || this.iSpecReg.isCanRequire());
        }
    }

    protected void scrollToSelectedRow() {
        if (this.iCourses.getSelectedRow() < 0) {
            return;
        }
        com.google.gwt.user.client.Element scroll = this.iCoursesPanel.getElement();
        com.google.gwt.user.client.Element item = this.iCourses.getRowFormatter().getElement(this.iCourses.getSelectedRow());
        if (item == null) {
            return;
        }
        int realOffset = 0;
        while (item != null && !item.equals((Object)scroll)) {
            realOffset += item.getOffsetTop();
            item = item.getOffsetParent();
        }
        scroll.setScrollTop(realOffset - scroll.getOffsetHeight() / 2);
    }

    protected void updateCourseDetails() {
        int row = this.iCourses.getSelectedRow();
        ClassAssignmentInterface.CourseAssignment record = this.iCourses.getData(row);
        if (record == null) {
            if (this.iDetails != null) {
                for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                    detail.setValue(null);
                }
            }
            if (this.isVisible() && this.isAttached()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderNoCourse());
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
        } else {
            CheckBox ch;
            P imp;
            for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                detail.setValue(record);
            }
            if (record.hasTitle()) {
                if (record.hasNote()) {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitleAndNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote()));
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitle(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle()));
                }
            } else if (record.hasNote()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getNote()));
            } else {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelected(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr()));
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
            if (record.hasInstructionalMethodSelection()) {
                imp = new P("preference-label");
                imp.setText(MESSAGES.labelInstructionalMethodPreference());
                this.iInstructionalMethodsPanel.add((Widget)imp);
                for (ClassAssignmentInterface.IdValue m : record.getInstructionalMethods()) {
                    ch = new CheckBox(m.getValue());
                    ch.setValue(Boolean.valueOf(this.isSelectedMethod(m.getId())));
                    ch.setEnabled(this.isEnabled());
                    final CourseRequestInterface.Preference p = new CourseRequestInterface.Preference(m.getId(), m.getValue(), this.isSelectedMethodRequired(m.getId()));
                    ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                            if (((Boolean)event.getValue()).booleanValue()) {
                                CourseFinderCourses.this.iSelectedMethods.add(p);
                            } else {
                                CourseFinderCourses.this.iSelectedMethods.remove(p);
                            }
                        }
                    });
                    ch.addStyleName("instructional-method");
                    this.iInstructionalMethods.put(p, ch);
                    this.iInstructionalMethodsPanel.add((Widget)ch);
                }
            } else if (record.hasInstructionalMethods()) {
                imp = new P("preference-label");
                imp.setText(MESSAGES.labelInstructionalMethodPreference());
                this.iInstructionalMethodsPanel.add((Widget)imp);
                for (ClassAssignmentInterface.IdValue m : record.getInstructionalMethods()) {
                    ch = new CheckBox(m.getValue());
                    ch.addStyleName("instructional-method");
                    ch.setValue(Boolean.valueOf(true));
                    ch.setEnabled(false);
                    this.iInstructionalMethods.put(new CourseRequestInterface.Preference(m.getId(), m.getValue(), this.isSelectedMethodRequired(m.getId())), ch);
                    this.iInstructionalMethodsPanel.add((Widget)ch);
                }
            }
            this.iInstructionalMethodsPanel.add((Widget)this.iRequired);
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public boolean isCourseSelection() {
        return true;
    }

    @Override
    public void setCourseDetails(CourseFinder.CourseFinderCourseDetails ... details) {
        this.iDetails = details;
        int tabIndex = 0;
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            ScrollPanel panel = new ScrollPanel(detail.asWidget());
            panel.setStyleName("unitime-ScrollPanel-inner");
            panel.addStyleName("course-info");
            this.iCourseDetailsTabBar.addTab(detail.getName(), true);
            Character ch = UniTimeHeaderPanel.guessAccessKey(detail.getName());
            if (ch != null) {
                this.iTabAccessKeys.put(ch, tabIndex);
            }
            ++tabIndex;
        }
        this.selectLastTab();
    }

    public void onKeyUp(KeyUpEvent event) {
        if (this.iCourses.getRowCount() < 2 || this.iCourses.getData(1) == null) {
            return;
        }
        int row = this.iCourses.getSelectedRow();
        if (event.getNativeKeyCode() == 40 && this.isEnabled()) {
            if (row < 0 || this.iCourses.getSelectedRow() + 1 >= this.iCourses.getRowCount()) {
                this.iCourses.setSelected(1, true);
            } else {
                this.iCourses.setSelected(row + 1, true);
            }
            this.scrollToSelectedRow();
            this.updateCourseDetails();
        } else if (event.getNativeKeyCode() == 38 && this.isEnabled()) {
            if (row - 1 < 1) {
                this.iCourses.setSelected(this.iCourses.getRowCount() - 1, true);
            } else {
                this.iCourses.setSelected(row - 1, true);
            }
            this.scrollToSelectedRow();
            this.updateCourseDetails();
        } else if (event.isControlKeyDown() || event.isAltKeyDown()) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iCourseDetailsTabBar.selectTab(entry.getValue(), true);
                event.preventDefault();
                event.stopPropagation();
            }
        }
    }

    @Override
    public HandlerRegistration addResponseHandler(CourseFinder.ResponseHandler handler) {
        return this.addHandler(handler, CourseFinder.ResponseEvent.getType());
    }

    private void selectLastTab() {
        try {
            int tab = Integer.valueOf(Cookies.getCookie((String)"UniTime:CourseFinderCourses"));
            if (tab >= 0 || tab < this.iCourseDetailsTabBar.getTabCount() && tab != this.iCourseDetailsTabBar.getSelectedTab()) {
                this.iCourseDetailsTabBar.selectTab(tab, true);
            } else {
                this.iCourseDetailsTabBar.selectTab(0, true);
            }
        }
        catch (Exception e) {
            this.iCourseDetailsTabBar.selectTab(0, true);
        }
    }

    @Override
    public void changeTip() {
        this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.selectLastTab();
    }

    public boolean isEnabled() {
        return this.iCourses.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.iCourses.setEnabled(enabled);
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails details : this.iDetails) {
                details.setEnabled(enabled);
            }
        }
        if (this.iRequired != null) {
            this.iRequired.setEnabled(enabled && (this.iSpecReg == null || this.iSpecReg.isCanRequire()));
            this.iRequired.setVisible(this.iSpecReg == null || this.iSpecReg.isCanRequire());
        }
    }

    @Override
    public CheckBox getRequiredCheckbox() {
        return this.iRequired;
    }
}

