/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

public class ConflictBasedStatisticsTree
extends Tree
implements TakesValue<List<SuggestionsInterface.CBSNode>>,
SimpleForm.HasMobileScroll {
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private List<SuggestionsInterface.CBSNode> iValue = null;
    private SuggestionsInterface.SuggestionProperties iProperties;

    public ConflictBasedStatisticsTree(SuggestionsInterface.SuggestionProperties properties) {
        super((Tree.Resources)RESOURCES, true);
        this.iProperties = properties;
        this.addStyleName("unitime-ConflictBasedStatistics");
    }

    protected void onClick(ClickEvent event, SuggestionsInterface.CBSNode node) {
        if (node.hasLink()) {
            ToolBox.open(GWT.getHostPageBaseURL() + node.getLink());
        } else if (node.hasClassId()) {
            UniTimeFrameDialog.openDialog(MESSAGES.pageSuggestions(), "gwt.jsp?page=suggestions&menu=hide&id=" + node.getClassId(), "900", "85%");
        } else if (node.hasSelection()) {
            SuggestionsInterface.SelectedAssignment selection = node.getSelection();
            UniTimeFrameDialog.openDialog(MESSAGES.pageSuggestions(), "gwt.jsp?page=suggestions&menu=hide&id=" + selection.getClassId() + "&days=" + selection.getDays() + "&slot=" + selection.getStartSlot() + "&room=" + selection.getRoomIds(",") + "&pid=" + selection.getPatternId() + "&did=" + selection.getDatePatternId(), "900", "85%");
        }
    }

    public void setValue(List<SuggestionsInterface.CBSNode> value) {
        this.clear();
        this.iValue = value;
        if (value != null) {
            for (SuggestionsInterface.CBSNode node : value) {
                this.addItem(this.generate(node));
            }
        }
    }

    protected TreeItem generate(final SuggestionsInterface.CBSNode node) {
        P widget = new P("cbs-node");
        Label counter = new Label();
        counter.setText(node.getCount() + " \u00d7");
        widget.add((Widget)counter);
        if (node.getHTML() != null) {
            HTML html = new HTML(node.getHTML());
            widget.add((Widget)html);
        } else {
            SuggestionsInterface.PreferenceInterface pref;
            Label name = new Label();
            name.setText(node.getName());
            if (node.getPref() != null && this.iProperties != null && (pref = this.iProperties.getPreference(node.getPref())) != null) {
                name.getElement().getStyle().setColor(pref.getColor());
            }
            widget.add((Widget)name);
        }
        widget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ConflictBasedStatisticsTree.this.onClick(event, node);
            }
        });
        TreeItem item = new TreeItem((Widget)widget);
        if (node.hasNodes()) {
            for (SuggestionsInterface.CBSNode child : node.getNodes()) {
                item.addItem(this.generate(child));
            }
        }
        return item;
    }

    public List<SuggestionsInterface.CBSNode> getValue() {
        return this.iValue;
    }
}

