/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.PublishedSectioningSolutionInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class PublishedSectioningSolutionsTable
extends UniTimeTable<PublishedSectioningSolutionInterface>
implements TakesValue<List<PublishedSectioningSolutionInterface>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private PublishedSectioningSolutionInterface.TableColumn iSortBy = null;
    private boolean iAsc = true;

    public PublishedSectioningSolutionsTable() {
        this.setStyleName("unitime-PublishedSectioningSolutions");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final PublishedSectioningSolutionInterface.TableColumn column : PublishedSectioningSolutionInterface.TableColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final PublishedSectioningSolutionInterface.TableColumn column : PublishedSectioningSolutionInterface.TableColumn.values()) {
            if (!TableComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    PublishedSectioningSolutionsTable.this.doSort(column);
                }

                @Override
                public boolean isApplicable() {
                    return PublishedSectioningSolutionsTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(SectioningCookie.getInstance().getSolutionsSortBy());
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<PublishedSectioningSolutionInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<PublishedSectioningSolutionInterface> event) {
                final PublishedSectioningSolutionInterface solution = event.getData();
                final int row = event.getRow();
                if (solution != null && solution.getInfo() != null) {
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    dialog.setEscapeToHide(true);
                    SimpleForm form = new SimpleForm();
                    UniTimeHeaderPanel top = new UniTimeHeaderPanel();
                    top.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialog.hide();
                        }
                    });
                    AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>> callback = new AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>>(){

                        public void onSuccess(GwtRpcResponseList<PublishedSectioningSolutionInterface> result) {
                            LoadingWidget.getInstance().hide();
                            PublishedSectioningSolutionsTable.this.setValue(result);
                        }

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }
                    };
                    AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>> callbackOpenSolver = new AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>>(){

                        public void onSuccess(GwtRpcResponseList<PublishedSectioningSolutionInterface> result) {
                            LoadingWidget.getInstance().hide();
                            ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=solver&type=student");
                        }

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }
                    };
                    if (solution.isLoaded()) {
                        top.addButton("unpublish", MESSAGES.opSectioningSolutionUnpublish(), new ClickHandler((AsyncCallback)callback){
                            final /* synthetic */ AsyncCallback val$callback;
                            {
                                this.val$callback = asyncCallback;
                            }

                            public void onClick(ClickEvent event) {
                                dialog.hide();
                                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.UNPUBLISH, solution.getUniqueId()), this.val$callback);
                            }
                        });
                        if (solution.isSelected()) {
                            dialog.hide();
                            top.addButton("deselect", MESSAGES.opSectioningSolutionDeselect(), new ClickHandler((AsyncCallback)callback){
                                final /* synthetic */ AsyncCallback val$callback;
                                {
                                    this.val$callback = asyncCallback;
                                }

                                public void onClick(ClickEvent event) {
                                    dialog.hide();
                                    LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                    RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.DESELECT, solution.getUniqueId()), this.val$callback);
                                }
                            });
                        } else if (solution.isCanSelect()) {
                            top.addButton("select", MESSAGES.opSectioningSolutionSelect(), new ClickHandler((AsyncCallback)callbackOpenSolver){
                                final /* synthetic */ AsyncCallback val$callbackOpenSolver;
                                {
                                    this.val$callbackOpenSolver = asyncCallback;
                                }

                                public void onClick(ClickEvent event) {
                                    dialog.hide();
                                    LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                    RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.SELECT, solution.getUniqueId()), this.val$callbackOpenSolver);
                                }
                            });
                        }
                    } else if (solution.isCanLoad()) {
                        top.addButton("publish", MESSAGES.opSectioningSolutionPublish(), new ClickHandler((AsyncCallback)callback){
                            final /* synthetic */ AsyncCallback val$callback;
                            {
                                this.val$callback = asyncCallback;
                            }

                            public void onClick(ClickEvent event) {
                                dialog.hide();
                                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.PUBLISH, solution.getUniqueId()), this.val$callback);
                            }
                        });
                    }
                    if (solution.isClonned()) {
                        top.addButton("unload", MESSAGES.opSectioningSolutionUnload(), new ClickHandler((AsyncCallback)callback){
                            final /* synthetic */ AsyncCallback val$callback;
                            {
                                this.val$callback = asyncCallback;
                            }

                            public void onClick(ClickEvent event) {
                                dialog.hide();
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.UNLOAD, solution.getUniqueId()), this.val$callback);
                            }
                        });
                    } else if (solution.isCanClone()) {
                        top.addButton("load", MESSAGES.opSectioningSolutionLoad(), new ClickHandler((AsyncCallback)callbackOpenSolver){
                            final /* synthetic */ AsyncCallback val$callbackOpenSolver;
                            {
                                this.val$callbackOpenSolver = asyncCallback;
                            }

                            public void onClick(ClickEvent event) {
                                dialog.hide();
                                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.LOAD, solution.getUniqueId()), this.val$callbackOpenSolver);
                            }
                        });
                    }
                    if (!solution.isLoaded()) {
                        top.addButton("remove", MESSAGES.opSectioningSolutionRemove(), new ClickHandler((AsyncCallback)callback){
                            final /* synthetic */ AsyncCallback val$callback;
                            {
                                this.val$callback = asyncCallback;
                            }

                            public void onClick(ClickEvent event) {
                                dialog.hide();
                                UniTimeConfirmationDialog.confirm(MESSAGES.confirmDeletePublishedSectioningSolution(), new Command(){

                                    public void execute() {
                                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                        RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.REMOVE, solution.getUniqueId()), val$callback);
                                    }
                                });
                            }
                        });
                    }
                    top.addButton("export", MESSAGES.opExportXML(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialog.hide();
                            ToolBox.open(GWT.getHostPageBaseURL() + "export?output=published-solution.xml.gz&id=" + solution.getUniqueId());
                        }
                    });
                    form.setStyleName("unitime-InfoTable");
                    form.addHeaderRow((Widget)top);
                    form.addRow(MESSAGES.propTimeStamp(), (Widget)new Label(sDF.format(solution.getTimeStamp())));
                    form.addRow(MESSAGES.propOwner(), (Widget)new Label(solution.getOwner()));
                    if (solution.hasConfig()) {
                        form.addRow(MESSAGES.propSolutionConfig(), (Widget)new Label(solution.getConfig()));
                    }
                    if (solution.isCanChangeNote()) {
                        TextArea text = new TextArea();
                        text.setStyleName("unitime-TextArea");
                        text.setVisibleLines(5);
                        text.setCharacterWidth(80);
                        text.setValue((Object)(solution.hasNote() ? solution.getNote() : ""));
                        form.addRow(MESSAGES.propNote(), (Widget)text);
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(final ValueChangeEvent<String> event) {
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(solution.getUniqueId(), (String)event.getValue()), new AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(caught);
                                    }

                                    public void onSuccess(GwtRpcResponseList<PublishedSectioningSolutionInterface> result) {
                                        solution.setNote((String)event.getValue());
                                        ((Label)PublishedSectioningSolutionsTable.this.getWidget(row, PublishedSectioningSolutionsTable.this.getCellIndex(PublishedSectioningSolutionInterface.TableColumn.NOTE))).setText((String)event.getValue());
                                    }
                                });
                            }
                        });
                    } else if (solution.hasNote()) {
                        Label note = new Label(solution.getNote() == null ? "" : solution.getNote());
                        note.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE);
                        form.addRow(MESSAGES.propNote(), (Widget)note);
                    }
                    TreeSet<String> keys = new TreeSet<String>(new InfoComparator());
                    keys.addAll(solution.getInfo().keySet());
                    for (String key : keys) {
                        form.addRow(key, (Widget)new HTML(solution.getInfo().get(key)));
                    }
                    form.addBottomRow((Widget)top.clonePanel());
                    P widget = new P("unitime-SolutionInfoDialog");
                    widget.add((Widget)form);
                    dialog.setWidget((Widget)widget);
                    dialog.setText(MESSAGES.dialogDetailsOfPublishedScheduleRun(sDF.format(solution.getTimeStamp()), solution.getOwner()));
                    dialog.setEscapeToHide(true);
                    dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                        public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                        }
                    });
                    dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> event) {
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                        }
                    });
                    dialog.center();
                }
            }
        });
    }

    protected void doSort(PublishedSectioningSolutionInterface.TableColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        SectioningCookie.getInstance().setSolutionsSortBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = PublishedSectioningSolutionInterface.TableColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = PublishedSectioningSolutionInterface.TableColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = PublishedSectioningSolutionInterface.TableColumn.DATE_TIME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new TableComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(PublishedSectioningSolutionInterface.TableColumn column) {
        return 1;
    }

    public String getColumnName(PublishedSectioningSolutionInterface.TableColumn column, int idx) {
        switch (column) {
            case DATE_TIME: {
                return MESSAGES.colTimeStamp();
            }
            case OWNER: {
                return MESSAGES.colOwner();
            }
            case CONFIG: {
                return MESSAGES.colSolverConfig();
            }
            case NOTE: {
                return MESSAGES.colNote();
            }
            case COURSE_REQUESTS: {
                return MESSAGES.colAssignedCourseRequests();
            }
            case PRIORITY_REQUESTS: {
                return MESSAGES.colAssignedPriorityCourseRequests();
            }
            case CRITICAL: {
                return MESSAGES.colAssignedCriticalCourseRequests();
            }
            case TIME: {
                return MESSAGES.colTimeConflicts();
            }
            case DISTANCE: {
                return MESSAGES.colDistanceConflicts();
            }
            case SELECTION: {
                return MESSAGES.colSectioningSelection();
            }
            case OPERATIONS: {
                return MESSAGES.colOperations();
            }
            case COMPLETE: {
                return MESSAGES.colStudentsWithCompleteSchedule();
            }
            case DISBALANCED: {
                return MESSAGES.colDisbalancedSections();
            }
            case NO_TIME: {
                return MESSAGES.colClassesWithoutTime();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(PublishedSectioningSolutionInterface.TableColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(PublishedSectioningSolutionInterface.TableColumn column) {
        int ret = 0;
        for (PublishedSectioningSolutionInterface.TableColumn c : PublishedSectioningSolutionInterface.TableColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(PublishedSectioningSolutionInterface solution, PublishedSectioningSolutionInterface.TableColumn column, int idx) {
        switch (column) {
            case DATE_TIME: {
                return new Label(sDF.format(solution.getTimeStamp()));
            }
            case OWNER: {
                return new Label(solution.getOwner());
            }
            case CONFIG: {
                return new Label(solution.getConfig() == null ? "" : solution.getConfig());
            }
            case NOTE: {
                Label note = new Label(solution.getNote() == null ? "" : solution.getNote());
                note.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return note;
            }
            case OPERATIONS: {
                return new OperationsCell(solution);
            }
        }
        return new Label(solution.getValue(column.getAttribute()));
    }

    public int addSolution(PublishedSectioningSolutionInterface solution) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (PublishedSectioningSolutionInterface.TableColumn column : PublishedSectioningSolutionInterface.TableColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(solution, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(solution, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        if (solution.isClonned()) {
            this.getRowFormatter().addStyleName(row, "clonned");
        }
        if (solution.isSelected()) {
            this.getRowFormatter().addStyleName(row, "selected");
        }
        if (solution.isLoaded()) {
            this.getRowFormatter().addStyleName(row, "loaded");
        }
        return row;
    }

    public PublishedSectioningSolutionInterface getFeature(Long solutionId) {
        if (solutionId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!solutionId.equals(((PublishedSectioningSolutionInterface)this.getData(i)).getUniqueId())) continue;
            return (PublishedSectioningSolutionInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long solutionId) {
        if (solutionId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!solutionId.equals(((PublishedSectioningSolutionInterface)this.getData(i)).getUniqueId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
            return;
        }
    }

    public void setValue(List<PublishedSectioningSolutionInterface> value) {
        this.clearTable(1);
        if (value != null) {
            for (PublishedSectioningSolutionInterface solution : value) {
                this.addSolution(solution);
            }
        }
        this.sort();
    }

    public List<PublishedSectioningSolutionInterface> getValue() {
        return this.getData();
    }

    public static class InfoComparator
    implements Comparator<String> {
        private static List<String> sInfoKeys = null;

        @Override
        public int compare(String key1, String key2) {
            int i1 = sInfoKeys.indexOf(key1);
            int i2 = sInfoKeys.indexOf(key2);
            if (i1 < 0) {
                if (i2 < 0) {
                    return key1.compareTo(key2);
                }
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return i1 < i2 ? -1 : 1;
        }

        static {
            sInfoKeys = new ArrayList<String>();
            sInfoKeys.add("Assigned variables");
            sInfoKeys.add("Overall solution value");
            sInfoKeys.add("Time preferences");
            sInfoKeys.add("Student conflicts");
            sInfoKeys.add("Room preferences");
            sInfoKeys.add("Distribution preferences");
            sInfoKeys.add("Back-to-back instructor preferences");
            sInfoKeys.add("Too big rooms");
            sInfoKeys.add("Useless half-hours");
            sInfoKeys.add("Same subpart balancing penalty");
            sInfoKeys.add("Department balancing penalty");
            sInfoKeys.add("Direct Conflicts");
            sInfoKeys.add("More Than 2 A Day Conflicts");
            sInfoKeys.add("Back-To-Back Conflicts");
            sInfoKeys.add("Distance Back-To-Back Conflicts");
            sInfoKeys.add("Instructor Direct Conflicts");
            sInfoKeys.add("Instructor More Than 2 A Day Conflicts");
            sInfoKeys.add("Instructor Back-To-Back Conflicts");
            sInfoKeys.add("Instructor Distance Back-To-Back Conflicts");
            sInfoKeys.add("Period Penalty");
            sInfoKeys.add("Period&times;Size Penalty");
            sInfoKeys.add("Exam Rotation Penalty");
            sInfoKeys.add("Average Period");
            sInfoKeys.add("Room Penalty");
            sInfoKeys.add("Room Split Penalty");
            sInfoKeys.add("Room Split Distance Penalty");
            sInfoKeys.add("Room Size Penalty");
            sInfoKeys.add("Not-Original Room Penalty");
            sInfoKeys.add("Distribution Penalty");
            sInfoKeys.add("Large Exams Penalty");
            sInfoKeys.add("Perturbation Penalty");
            sInfoKeys.add("Perturbation penalty");
            sInfoKeys.add("Room Perturbation Penalty");
            sInfoKeys.add("Perturbation variables");
            sInfoKeys.add("Perturbations: Total penalty");
            sInfoKeys.add("Time");
            sInfoKeys.add("Iteration");
            sInfoKeys.add("Memory usage");
            sInfoKeys.add("Speed");
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    public static class TableComparator
    implements Comparator<PublishedSectioningSolutionInterface> {
        private PublishedSectioningSolutionInterface.TableColumn iColumn;
        private boolean iAsc;

        public TableComparator(PublishedSectioningSolutionInterface.TableColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareById(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            return this.compare(r1.getUniqueId(), r2.getUniqueId());
        }

        public int compareByTimeStamp(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            return this.compare(r1.getTimeStamp(), r2.getTimeStamp());
        }

        public int compareByOwner(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            return this.compare(r1.getOwner(), r2.getOwner());
        }

        public int compareByNote(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            return this.compare(r1.getNote(), r2.getNote());
        }

        public int compareByConfig(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            return this.compare(r1.getConfig(), r2.getConfig());
        }

        public int compareByAttribute(String attribute, PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            String v1 = r1.getValue(attribute);
            String v2 = r2.getValue(attribute);
            return TableInterface.NaturalOrderComparator.compare(v1, v2);
        }

        protected int compareByColumn(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            switch (this.iColumn) {
                case DATE_TIME: {
                    return this.compareByTimeStamp(r1, r2);
                }
                case OWNER: {
                    return this.compareByOwner(r1, r2);
                }
                case CONFIG: {
                    return this.compareByConfig(r1, r2);
                }
                case NOTE: {
                    return this.compareByNote(r1, r2);
                }
            }
            String att = this.iColumn.getAttribute();
            if (att != null) {
                return this.compareByAttribute(att, r1, r2);
            }
            return this.compareById(r1, r2);
        }

        public static boolean isApplicable(PublishedSectioningSolutionInterface.TableColumn column) {
            switch (column) {
                case DATE_TIME: 
                case OWNER: 
                case CONFIG: 
                case NOTE: {
                    return true;
                }
                case OPERATIONS: {
                    return false;
                }
            }
            return column.getAttribute() != null;
        }

        @Override
        public int compare(PublishedSectioningSolutionInterface r1, PublishedSectioningSolutionInterface r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByTimeStamp(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Date n1, Date n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : n1.compareTo(n2));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }
    }

    public class OperationsCell
    extends P {
        public OperationsCell(final PublishedSectioningSolutionInterface solution) {
            super("operations");
            AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>> callback = new AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>>(){

                public void onSuccess(GwtRpcResponseList<PublishedSectioningSolutionInterface> result) {
                    LoadingWidget.getInstance().hide();
                    PublishedSectioningSolutionsTable.this.setValue(result);
                }

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    UniTimeNotifications.error(caught);
                }
            };
            AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>> callbackOpenSolver = new AsyncCallback<GwtRpcResponseList<PublishedSectioningSolutionInterface>>(){

                public void onSuccess(GwtRpcResponseList<PublishedSectioningSolutionInterface> result) {
                    LoadingWidget.getInstance().hide();
                    ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=solver&type=student");
                }

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    UniTimeNotifications.error(caught);
                }
            };
            if (solution.isLoaded()) {
                this.addButton(MESSAGES.opSectioningSolutionUnpublish(), new ClickHandler((AsyncCallback)callback){
                    final /* synthetic */ AsyncCallback val$callback;
                    {
                        this.val$callback = asyncCallback;
                    }

                    public void onClick(ClickEvent event) {
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.UNPUBLISH, solution.getUniqueId()), this.val$callback);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
                if (solution.isSelected()) {
                    this.addButton(MESSAGES.opSectioningSolutionDeselect(), new ClickHandler((AsyncCallback)callback){
                        final /* synthetic */ AsyncCallback val$callback;
                        {
                            this.val$callback = asyncCallback;
                        }

                        public void onClick(ClickEvent event) {
                            LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                            RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.DESELECT, solution.getUniqueId()), this.val$callback);
                            event.preventDefault();
                            event.stopPropagation();
                        }
                    });
                } else if (solution.isCanSelect()) {
                    this.addButton(MESSAGES.opSectioningSolutionSelect(), new ClickHandler((AsyncCallback)callbackOpenSolver){
                        final /* synthetic */ AsyncCallback val$callbackOpenSolver;
                        {
                            this.val$callbackOpenSolver = asyncCallback;
                        }

                        public void onClick(ClickEvent event) {
                            LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                            RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.SELECT, solution.getUniqueId()), this.val$callbackOpenSolver);
                            event.preventDefault();
                            event.stopPropagation();
                        }
                    });
                }
            } else if (solution.isCanLoad()) {
                this.addButton(MESSAGES.opSectioningSolutionPublish(), new ClickHandler((AsyncCallback)callback){
                    final /* synthetic */ AsyncCallback val$callback;
                    {
                        this.val$callback = asyncCallback;
                    }

                    public void onClick(ClickEvent event) {
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.PUBLISH, solution.getUniqueId()), this.val$callback);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
            }
            if (solution.isClonned()) {
                this.addButton(MESSAGES.opSectioningSolutionUnload(), new ClickHandler((AsyncCallback)callback){
                    final /* synthetic */ AsyncCallback val$callback;
                    {
                        this.val$callback = asyncCallback;
                    }

                    public void onClick(ClickEvent event) {
                        RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.UNLOAD, solution.getUniqueId()), this.val$callback);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
            } else if (solution.isCanClone()) {
                this.addButton(MESSAGES.opSectioningSolutionLoad(), new ClickHandler((AsyncCallback)callbackOpenSolver){
                    final /* synthetic */ AsyncCallback val$callbackOpenSolver;
                    {
                        this.val$callbackOpenSolver = asyncCallback;
                    }

                    public void onClick(ClickEvent event) {
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.LOAD, solution.getUniqueId()), this.val$callbackOpenSolver);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
            }
            if (!solution.isLoaded()) {
                this.addButton(MESSAGES.opSectioningSolutionRemove(), new ClickHandler((AsyncCallback)callback){
                    final /* synthetic */ AsyncCallback val$callback;
                    {
                        this.val$callback = asyncCallback;
                    }

                    public void onClick(ClickEvent event) {
                        UniTimeConfirmationDialog.confirm(MESSAGES.confirmDeletePublishedSectioningSolution(), new Command(){

                            public void execute() {
                                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                                RPC.execute(new PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest(PublishedSectioningSolutionInterface.Operation.REMOVE, solution.getUniqueId()), val$callback);
                            }
                        });
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
            }
            this.addButton(MESSAGES.opExportXML(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "export?output=published-solution.xml.gz&id=" + solution.getUniqueId());
                    event.preventDefault();
                    event.stopPropagation();
                }
            });
        }

        private void addButton(String html, ClickHandler handler) {
            AriaButton button = new AriaButton(html);
            button.addClickHandler(handler);
            this.add((Widget)button);
        }
    }
}

