/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.sectioning.StudentSchedule;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.gwt.shared.UserAuthenticationProvider;

public class EnrollmentTable
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private static NumberFormat sNF = NumberFormat.getFormat((String)CONSTANTS.executionTimeFormat());
    private Long iOfferingId = null;
    protected static final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private SimpleForm iEnrollmentPanel;
    private UniTimeTable<ClassAssignmentInterface.Enrollment> iEnrollments;
    private UniTimeHeaderPanel iHeader;
    private UniTimeTableHeader.Operation iApprove;
    private UniTimeTableHeader.Operation iReject;
    private StudentSchedule iStudentSchedule;
    private boolean iOnline;
    private boolean iShowFilter = false;

    public EnrollmentTable(boolean showHeader, boolean online) {
        this(showHeader, online, false);
    }

    public EnrollmentTable(final boolean showHeader, boolean online, boolean showFilter) {
        this.iOnline = online;
        this.iEnrollmentPanel = new SimpleForm();
        this.iEnrollmentPanel.addStyleName("unitime-StudentEnrollmentsTable");
        this.iStudentSchedule = new StudentSchedule(online){

            @Override
            protected void setCritical(Long studentId, CourseRequestInterface.Request request, Boolean critical, AsyncCallback<Boolean> callback) {
                iSectioningService.changeCriticalOverride(studentId, request.getRequestedCourse(0).getCourseId(), critical, callback);
            }
        };
        this.iShowFilter = showFilter;
        this.iHeader = new UniTimeHeaderPanel(showHeader ? MESSAGES.enrollmentsTable() : "&nbsp;");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SectioningCookie.getInstance().setEnrollmentCoursesDetails((Boolean)event.getValue());
                if (EnrollmentTable.this.iEnrollments.getRowCount() > 2) {
                    for (int row = 1; row < EnrollmentTable.this.iEnrollments.getRowCount() - 1; ++row) {
                        EnrollmentTable.this.iEnrollments.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
                if (EnrollmentTable.this.iEnrollments.getRowCount() == 0) {
                    EnrollmentTable.this.refresh();
                }
            }
        });
        this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(SectioningCookie.getInstance().getEnrollmentCoursesDetails()) : null);
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iEnrollmentPanel.removeStyleName("unitime-NotPrintableBottomLine");
        if (showHeader) {
            this.iEnrollmentPanel.addHeaderRow((Widget)this.iHeader);
            this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        }
        this.iEnrollments = new UniTimeTable();
        this.iEnrollmentPanel.addRow((Widget)this.iEnrollments);
        if (!showHeader) {
            this.iEnrollmentPanel.addBottomRow((Widget)this.iHeader);
        }
        this.iHeader.addButton("approve", MESSAGES.buttonApproveSelectedEnrollments(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable()) {
                    EnrollmentTable.this.iApprove.execute();
                }
            }
        });
        this.iHeader.addButton("reject", MESSAGES.buttonRejectSelectedEnrollments(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable()) {
                    EnrollmentTable.this.iReject.execute();
                }
            }
        });
        this.iHeader.setEnabled("approve", false);
        this.iHeader.setEnabled("reject", false);
        this.initWidget((Widget)this.iEnrollmentPanel);
        this.iEnrollments.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.Enrollment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.Enrollment> event) {
                if (event.getData() == null) {
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.loadingEnrollment(event.getData().getStudent().getName()));
                EnrollmentTable.this.iHeader.clearMessage();
                EnrollmentTable.this.showStudentSchedule(event.getData().getStudent(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        if (showHeader) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                        } else {
                            UniTimeNotifications.error(MESSAGES.failedToLoadEnrollments(caught.getMessage()), caught);
                        }
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
    }

    public UniTimeTable<ClassAssignmentInterface.Enrollment> getTable() {
        return this.iEnrollments;
    }

    public UniTimeHeaderPanel getHeader() {
        return this.iHeader;
    }

    public void showStudentSchedule(Long studentId) {
        iSectioningService.lookupStudent(this.iOnline, studentId, new AsyncCallback<ClassAssignmentInterface.Student>(){

            public void onSuccess(ClassAssignmentInterface.Student student) {
                LoadingWidget.getInstance().show(MESSAGES.pleaseWait());
                EnrollmentTable.this.showStudentSchedule(student, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        UniTimeNotifications.error(caught.getMessage());
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught.getMessage());
            }
        });
    }

    public void showStudentSchedule(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        iSectioningService.getEnrollment(this.iOnline, student.getId(), new AsyncCallback<ClassAssignmentInterface>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(final ClassAssignmentInterface result) {
                callback.onSuccess((Object)true);
                EnrollmentTable.this.iStudentSchedule.setValue(result);
                SimpleForm form = new SimpleForm();
                form.addRow((Widget)EnrollmentTable.this.iStudentSchedule);
                final UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                form.addBottomRow((Widget)buttons);
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false){

                    @Override
                    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                        super.onPreviewNativeEvent(event);
                        EnrollmentTable.this.iStudentSchedule.checkAccessKeys(event);
                    }
                };
                EnrollmentTable.this.iStudentSchedule.setSelectionHandler(new SelectionHandler<Integer>(){

                    public void onSelection(SelectionEvent<Integer> event) {
                        buttons.setMessage(EnrollmentTable.this.iStudentSchedule.getCreditMessage());
                        dialog.center();
                    }
                });
                dialog.setWidget((Widget)form);
                dialog.setText(MESSAGES.dialogEnrollments(student.getName()));
                dialog.setEscapeToHide(true);
                dialog.sinkEvents(512);
                buttons.setMessage(EnrollmentTable.this.iStudentSchedule.getCreditMessage());
                buttons.addButton("registration", MESSAGES.buttonRegistration(), new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        EnrollmentTable.showCourseRequests(student, EnrollmentTable.this.iOnline, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    dialog.hide();
                                }
                            }
                        });
                    }
                });
                buttons.setEnabled("registration", student.getSessionId() != null && student.isCanRegister());
                buttons.addButton("assistant", MESSAGES.buttonAssistant(), new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        EnrollmentTable.showStudentAssistant(student, EnrollmentTable.this.iOnline, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    dialog.hide();
                                }
                            }
                        });
                    }
                });
                buttons.setEnabled("assistant", !EnrollmentTable.this.iOnline || student.getSessionId() != null && student.isCanUseAssistant());
                if (EnrollmentTable.this.iOnline) {
                    buttons.addButton("log", MESSAGES.buttonChangeLog(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            LoadingWidget.getInstance().show(MESSAGES.loadingChangeLog(student.getName()));
                            EnrollmentTable.showChangeLog(student, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    if (result.booleanValue()) {
                                        dialog.hide();
                                    }
                                }
                            });
                        }
                    });
                    buttons.setEnabled("log", student.getSessionId() != null && (student.isCanUseAssistant() || student.isCanRegister()));
                }
                if (EnrollmentTable.this.iOnline && result.getRequest() != null && result.getRequest().hasSpecRegDashboardUrl()) {
                    buttons.addButton("dashboard", MESSAGES.buttonSpecRegDashboard(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            Window.open((String)result.getRequest().getSpecRegDashboardUrl(), (String)"_blank", (String)"");
                        }
                    });
                }
                buttons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        dialog.hide();
                    }
                });
                dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        EnrollmentTable.this.iEnrollments.clearHover();
                    }
                });
                dialog.center();
            }
        });
    }

    public static void showStudentAssistant(final ClassAssignmentInterface.Student student, boolean online, final AsyncCallback<Boolean> callback) {
        UserAuthenticationProvider user = new UserAuthenticationProvider(){

            @Override
            public String getUser() {
                return student.getName();
            }

            @Override
            public void setUser(String user, AsyncCallback<Boolean> callback) {
            }
        };
        AcademicSessionProvider session = new AcademicSessionProvider(){

            @Override
            public Long getAcademicSessionId() {
                return student.getSessionId();
            }

            @Override
            public String getAcademicSessionName() {
                return "Current Session";
            }

            @Override
            public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            }

            @Override
            public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            }

            @Override
            public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
                return null;
            }
        };
        final StudentSectioningWidget widget = new StudentSectioningWidget(online, session, user, StudentSectioningPage.Mode.SECTIONING, false);
        iSectioningService.logIn(online ? "LOOKUP" : "BATCH", online ? student.getExternalId() : String.valueOf(student.getId()), null, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(String result) {
                widget.checkEligibility(student.getSessionId(), student.getId(), true, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                        final UniTimeDialogBox d = new UniTimeDialogBox(true, false);
                        d.setWidget((Widget)widget);
                        d.setText(MESSAGES.dialogAssistant(student.getName()));
                        d.setEscapeToHide(true);
                        callback.onSuccess((Object)true);
                        d.center();
                        widget.addResizeHandler(new ResizeHandler(){

                            public void onResize(ResizeEvent event) {
                                d.center();
                            }
                        });
                    }
                });
            }
        });
    }

    public static void showCourseRequests(final ClassAssignmentInterface.Student student, boolean online, final AsyncCallback<Boolean> callback) {
        UserAuthenticationProvider user = new UserAuthenticationProvider(){

            @Override
            public String getUser() {
                return student.getName();
            }

            @Override
            public void setUser(String user, AsyncCallback<Boolean> callback) {
            }
        };
        AcademicSessionProvider session = new AcademicSessionProvider(){

            @Override
            public Long getAcademicSessionId() {
                return student.getSessionId();
            }

            @Override
            public String getAcademicSessionName() {
                return "Current Session";
            }

            @Override
            public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            }

            @Override
            public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            }

            @Override
            public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
                return null;
            }
        };
        final StudentSectioningWidget widget = new StudentSectioningWidget(online, session, user, StudentSectioningPage.Mode.REQUESTS, false);
        iSectioningService.logIn(online ? "LOOKUP" : "BATCH", online ? student.getExternalId() : String.valueOf(student.getId()), null, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(String result) {
                widget.checkEligibility(student.getSessionId(), student.getId(), true, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                        final UniTimeDialogBox d = new UniTimeDialogBox(true, false);
                        d.setWidget((Widget)widget);
                        d.setText(MESSAGES.dialogRegistration(student.getName()));
                        d.setEscapeToHide(true);
                        callback.onSuccess((Object)true);
                        d.center();
                        widget.addResizeHandler(new ResizeHandler(){

                            public void onResize(ResizeEvent event) {
                                d.center();
                            }
                        });
                    }
                });
            }
        });
    }

    public static void showChangeLog(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        iSectioningService.changeLog("id:" + student.getExternalId(), new AsyncCallback<List<ClassAssignmentInterface.SectioningAction>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(List<ClassAssignmentInterface.SectioningAction> logs) {
                if (logs == null || logs.isEmpty()) {
                    callback.onSuccess((Object)false);
                    return;
                }
                final UniTimeTable<ClassAssignmentInterface.SectioningAction> table = new UniTimeTable<ClassAssignmentInterface.SectioningAction>();
                table.addRow(null, new Widget[]{new UniTimeTableHeader(MESSAGES.colOperation()), new UniTimeTableHeader(MESSAGES.colTimeStamp()), new UniTimeTableHeader(MESSAGES.colExecutionTime()), new UniTimeTableHeader(MESSAGES.colResult()), new UniTimeTableHeader(MESSAGES.colUser()), new UniTimeTableHeader(MESSAGES.colMessage())});
                for (ClassAssignmentInterface.SectioningAction log : logs) {
                    HTML message = new HTML(log.getMessage() == null ? "" : log.getMessage());
                    message.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                    table.addRow(log, new Widget[]{new TopCell(log.getOperation()), new TopCell(sTSF.format(log.getTimeStamp())), new TopCell(log.getWallTime() == null ? "" : sNF.format(0.001 * (double)log.getWallTime().longValue())), new TopCell(log.getResult()), new TopCell(log.getUser() == null ? "" : log.getUser()), message});
                }
                table.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.SectioningAction> event) {
                        if (event.getData() != null && event.getData().getProto() != null) {
                            final HTML widget = new HTML(event.getData().getProto());
                            final ScrollPanel scroll = new ScrollPanel((Widget)widget);
                            scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                            scroll.setStyleName("unitime-ScrollPanel");
                            final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                            dialog.setWidget((Widget)scroll);
                            dialog.setText(MESSAGES.dialogChangeMessage(student.getName()));
                            dialog.setEscapeToHide(true);
                            dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                                public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                                    RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                                    scroll.setHeight(Math.min(widget.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                                    dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                                }
                            });
                            dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> event) {
                                    table.clearHover();
                                    RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                                }
                            });
                            dialog.center();
                        }
                    }
                });
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                final ScrollPanel scroll = new ScrollPanel(table);
                scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                scroll.setStyleName("unitime-ScrollPanel");
                dialog.setWidget((Widget)scroll);
                dialog.setText(MESSAGES.dialogChangeLog(student.getName()));
                dialog.setEscapeToHide(true);
                dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                    public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                        scroll.setHeight(Math.min(table.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                        dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                    }
                });
                dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        table.clearHover();
                        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                    }
                });
                callback.onSuccess((Object)true);
                dialog.center();
            }
        });
    }

    protected void refresh() {
        this.clear();
        this.iHeader.showLoading();
        this.iHeader.setEnabled("approve", false);
        this.iHeader.setEnabled("reject", false);
        if (this.iOfferingId != null) {
            iSectioningService.canApprove(this.iOfferingId, new AsyncCallback<List<Long>>(){

                public void onFailure(Throwable caught) {
                    EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                }

                public void onSuccess(final List<Long> courseIdsToApprove) {
                    iSectioningService.listEnrollments(EnrollmentTable.this.iOfferingId, new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                            EnrollmentTable.this.iHeader.setCollapsible(null);
                            SectioningCookie.getInstance().setEnrollmentCoursesDetails(false);
                        }

                        public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                            if (result.isEmpty()) {
                                EnrollmentTable.this.iHeader.setMessage(EnrollmentTable.this.iOfferingId >= 0L ? MESSAGES.offeringHasNoEnrollments() : MESSAGES.classHasNoEnrollments());
                                EnrollmentTable.this.iHeader.setCollapsible(null);
                            } else {
                                EnrollmentTable.this.iHeader.clearMessage();
                                EnrollmentTable.this.iHeader.setCollapsible(true);
                                EnrollmentTable.this.populate(result, courseIdsToApprove);
                                if (EnrollmentTable.this.iEnrollments.getRowCount() > 2) {
                                    for (int row = 1; row < EnrollmentTable.this.iEnrollments.getRowCount() - 1; ++row) {
                                        EnrollmentTable.this.iEnrollments.getRowFormatter().setVisible(row, SectioningCookie.getInstance().getEnrollmentCoursesDetails());
                                    }
                                }
                                EnrollmentTable.this.iHeader.setEnabled("approve", courseIdsToApprove != null && !courseIdsToApprove.isEmpty() && EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                                EnrollmentTable.this.iHeader.setEnabled("reject", courseIdsToApprove != null && !courseIdsToApprove.isEmpty() && EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                            }
                        }
                    });
                }
            });
        }
    }

    public void clear() {
        for (int row = this.iEnrollments.getRowCount() - 1; row >= 0; --row) {
            this.iEnrollments.removeRow(row);
        }
        this.iEnrollments.clear(true);
    }

    protected boolean filter(SectioningCookie.EnrollmentFilter f, ClassAssignmentInterface.Enrollment e) {
        switch (f) {
            case ALL: {
                return false;
            }
            case ENROLLED: {
                return !e.hasClasses();
            }
            case WAIT_LISTED: {
                return e.hasClasses() || !e.isWaitList();
            }
            case NOT_ENROLLED: {
                return e.hasClasses() || e.isWaitList();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void populate(final List<ClassAssignmentInterface.Enrollment> enrollments, final List<Long> courseIdsCanApprove) {
        boolean showFilter;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        int enrolled = 0;
        int waitlisted = 0;
        int unassigned = 0;
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            if (enrollment.hasClasses()) {
                ++enrolled;
                continue;
            }
            if (enrollment.isWaitList()) {
                ++waitlisted;
                continue;
            }
            ++unassigned;
        }
        SectioningCookie.EnrollmentFilter f = SectioningCookie.EnrollmentFilter.ALL;
        boolean bl = showFilter = this.iShowFilter && this.iOfferingId != null && this.iOfferingId > 0L;
        if (showFilter) {
            f = SectioningCookie.getInstance().getEnrollmentFilter();
            if (f == SectioningCookie.EnrollmentFilter.ALL) {
                this.iHeader.setHeaderTitle(MESSAGES.studentsTable());
            } else {
                this.iHeader.setHeaderTitle(MESSAGES.enrollmentTableFilter(CONSTANTS.enrollmentFilterValues()[f.ordinal()]));
            }
        }
        Collections.sort(enrollments, new Comparator<ClassAssignmentInterface.Enrollment>(){

            @Override
            public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
            }
        });
        boolean hasExtId = false;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e) || !e.getStudent().isCanShowExternalId()) continue;
            hasExtId = true;
            break;
        }
        UniTimeTableHeader hExtId = null;
        if (hasExtId) {
            hExtId = new UniTimeTableHeader(MESSAGES.colStudentExternalId());
            header.add(hExtId);
            this.addSortOperation(hExtId, EnrollmentComparator.SortBy.EXTERNAL_ID, MESSAGES.colStudentExternalId());
        }
        UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        this.addSortOperation(hStudent, EnrollmentComparator.SortBy.STUDENT, MESSAGES.colStudent());
        boolean crosslist = false;
        Long courseId = null;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e)) continue;
            if (courseId == null) {
                courseId = e.getCourseId();
            } else if (e.getCourseId() != courseId) {
                crosslist = true;
                break;
            }
            if (e.getCourse() == null || !e.getCourse().hasCrossList()) continue;
            crosslist = true;
            break;
        }
        UniTimeTableHeader hCourse = null;
        if (crosslist) {
            hCourse = new UniTimeTableHeader(MESSAGES.colCourse());
            header.add(hCourse);
            this.addSortOperation(hStudent, EnrollmentComparator.SortBy.COURSE, MESSAGES.colCourse());
        }
        boolean hasPriority = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasAlternative = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConflict = false;
        boolean hasMessage = false;
        boolean hasAdvisor = false;
        HashSet<String> groupTypes = new HashSet<String>();
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e)) continue;
            if (e.getPriority() > 0) {
                hasPriority = true;
            }
            if (e.isAlternative()) {
                hasAlternative = true;
            }
            if (e.getStudent().hasArea()) {
                hasArea = true;
            }
            if (e.getStudent().hasMajor()) {
                hasMajor = true;
            }
            if (e.getStudent().hasGroup()) {
                hasGroup = true;
            }
            if (e.getStudent().hasAccommodation()) {
                hasAcmd = true;
            }
            if (e.getReservation() != null) {
                hasReservation = true;
            }
            if (e.getRequestedDate() != null) {
                hasRequestedDate = true;
            }
            if (e.getEnrolledDate() != null) {
                hasEnrolledDate = true;
            }
            if (e.hasConflict()) {
                hasConflict = true;
            }
            if (e.hasEnrollmentMessage()) {
                hasMessage = true;
            }
            if (e.getStudent().hasGroups()) {
                groupTypes.addAll(e.getStudent().getGroupTypes());
            }
            if (!e.getStudent().hasAdvisor()) continue;
            hasAdvisor = true;
        }
        UniTimeTableHeader hPriority = null;
        if (hasPriority) {
            hPriority = new UniTimeTableHeader(MESSAGES.colPriority());
            header.add(hPriority);
            this.addSortOperation(hPriority, EnrollmentComparator.SortBy.PRIORITY, MESSAGES.colPriority());
        }
        UniTimeTableHeader hAlternative = null;
        if (hasAlternative) {
            hAlternative = new UniTimeTableHeader(MESSAGES.colAlternative());
            header.add(hAlternative);
            this.addSortOperation(hAlternative, EnrollmentComparator.SortBy.ALTERNATIVE, MESSAGES.colAlternative());
        }
        UniTimeTableHeader hArea = null;
        UniTimeTableHeader hClasf = null;
        if (hasArea) {
            hArea = new UniTimeTableHeader(MESSAGES.colArea());
            header.add(hArea);
            this.addSortOperation(hArea, EnrollmentComparator.SortBy.AREA, MESSAGES.colArea());
            hClasf = new UniTimeTableHeader(MESSAGES.colClassification());
            header.add(hClasf);
            this.addSortOperation(hClasf, EnrollmentComparator.SortBy.CLASSIFICATION, MESSAGES.colClassification());
        }
        UniTimeTableHeader hMajor = null;
        if (hasMajor) {
            hMajor = new UniTimeTableHeader(MESSAGES.colMajor());
            header.add(hMajor);
            this.addSortOperation(hMajor, EnrollmentComparator.SortBy.MAJOR, MESSAGES.colMajor());
        }
        UniTimeTableHeader hGroup = null;
        if (hasGroup) {
            hGroup = new UniTimeTableHeader(MESSAGES.colGroup());
            header.add(hGroup);
            this.addSortOperation(hGroup, EnrollmentComparator.SortBy.GROUP, MESSAGES.colGroup());
        }
        HashMap<String, UniTimeTableHeader> hGroups = new HashMap<String, UniTimeTableHeader>();
        for (String type : groupTypes) {
            UniTimeTableHeader h = new UniTimeTableHeader(type);
            header.add(h);
            this.addSortOperation(h, EnrollmentComparator.SortBy.GROUP, MESSAGES.colGroup(), type);
            hGroups.put(type, h);
        }
        UniTimeTableHeader hAccmd = null;
        if (hasAcmd) {
            hAccmd = new UniTimeTableHeader(MESSAGES.colAccommodation());
            header.add(hAccmd);
            this.addSortOperation(hAccmd, EnrollmentComparator.SortBy.ACCOMODATION, MESSAGES.colAccommodation());
        }
        UniTimeTableHeader hReservation = null;
        if (hasReservation) {
            hReservation = new UniTimeTableHeader(MESSAGES.colReservation());
            header.add(hReservation);
            this.addSortOperation(hReservation, EnrollmentComparator.SortBy.RESERVATION, MESSAGES.colReservation());
        }
        final TreeSet<String> subparts = new TreeSet<String>();
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            if (this.filter(f, enrollment) || !enrollment.hasClasses()) continue;
            for (ClassAssignmentInterface.ClassAssignment c : enrollment.getClasses()) {
                subparts.add(c.getSubpart());
            }
        }
        HashMap<String, UniTimeTableHeader> hSubparts = new HashMap<String, UniTimeTableHeader>();
        for (String subpart : subparts) {
            UniTimeTableHeader hSubpart = new UniTimeTableHeader(subpart);
            hSubparts.put(subpart, hSubpart);
            final int col = 1 + (hasExtId ? 1 : 0) + (crosslist ? 1 : 0) + (hasPriority ? 1 : 0) + (hasAlternative ? 1 : 0) + (hasArea ? 2 : 0) + (hasMajor ? 1 : 0) + (hasGroup ? 1 : 0) + (hasAcmd ? 1 : 0) + (hasReservation ? 1 : 0) + groupTypes.size();
            hSubpart.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningCookie.getInstance().setShowClassNumbers(false);
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        ClassAssignmentInterface.Enrollment e = (ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row);
                        if (e == null || !e.hasClasses()) continue;
                        int idx = 0;
                        for (String subpart : subparts) {
                            ((HTML)EnrollmentTable.this.iEnrollments.getWidget(row, col + idx)).setHTML(e.getClasses(subpart, ", ", false));
                            ++idx;
                        }
                    }
                }

                @Override
                public boolean isApplicable() {
                    return SectioningCookie.getInstance().getShowClassNumbers();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.showExternalIds();
                }
            });
            hSubpart.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningCookie.getInstance().setShowClassNumbers(true);
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        ClassAssignmentInterface.Enrollment e = (ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row);
                        if (e == null || !e.hasClasses()) continue;
                        int idx = 0;
                        for (String subpart : subparts) {
                            ((HTML)EnrollmentTable.this.iEnrollments.getWidget(row, col + idx)).setHTML(e.getClasses(subpart, ", ", true));
                            ++idx;
                        }
                    }
                }

                @Override
                public boolean isApplicable() {
                    return !SectioningCookie.getInstance().getShowClassNumbers();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.showClassNumbers();
                }
            });
            header.add(hSubpart);
            this.addSortOperation(hSubpart, subpart);
        }
        Object var39_43 = null;
        if (hasRequestedDate) {
            UniTimeTableHeader uniTimeTableHeader = new UniTimeTableHeader(MESSAGES.colRequestTimeStamp());
            header.add(uniTimeTableHeader);
            this.addSortOperation(uniTimeTableHeader, EnrollmentComparator.SortBy.REQUEST_TS, MESSAGES.colRequestTimeStamp());
        }
        UniTimeTableHeader hEnrollmentTS = null;
        if (hasEnrolledDate) {
            hEnrollmentTS = new UniTimeTableHeader(MESSAGES.colEnrollmentTimeStamp());
            header.add(hEnrollmentTS);
            this.addSortOperation(hEnrollmentTS, EnrollmentComparator.SortBy.ENROLLMENT_TS, MESSAGES.colEnrollmentTimeStamp());
        }
        UniTimeTableHeader hMessage = null;
        if (hasMessage) {
            hMessage = new UniTimeTableHeader(MESSAGES.colMessage());
            header.add(hMessage);
            this.addSortOperation(hMessage, EnrollmentComparator.SortBy.MESSAGE, MESSAGES.colMessage());
        }
        UniTimeTableHeader hAdvisor = null;
        if (hasAdvisor) {
            hAdvisor = new UniTimeTableHeader(MESSAGES.colAdvisor());
            header.add(hAdvisor);
            this.addSortOperation(hAdvisor, EnrollmentComparator.SortBy.MESSAGE, MESSAGES.colAdvisor());
        }
        UniTimeTableHeader hConflictType = null;
        UniTimeTableHeader hConflictName = null;
        UniTimeTableHeader hConflictDate = null;
        UniTimeTableHeader hConflictTime = null;
        UniTimeTableHeader hConflictRoom = null;
        if (hasConflict) {
            hConflictType = new UniTimeTableHeader(MESSAGES.colConflictType());
            header.add(hConflictType);
            this.addSortOperation(hConflictType, EnrollmentComparator.SortBy.CONFLICT_TYPE, MESSAGES.colConflictType());
            hConflictName = new UniTimeTableHeader(MESSAGES.colConflictName());
            header.add(hConflictName);
            this.addSortOperation(hConflictName, EnrollmentComparator.SortBy.CONFLICT_NAME, MESSAGES.colConflictName());
            hConflictDate = new UniTimeTableHeader(MESSAGES.colConflictDate());
            header.add(hConflictDate);
            this.addSortOperation(hConflictDate, EnrollmentComparator.SortBy.CONFLICT_DATE, MESSAGES.colConflictDate());
            hConflictTime = new UniTimeTableHeader(MESSAGES.colConflictTime());
            header.add(hConflictTime);
            this.addSortOperation(hConflictTime, EnrollmentComparator.SortBy.CONFLICT_TIME, MESSAGES.colConflictTime());
            hConflictRoom = new UniTimeTableHeader(MESSAGES.colConflictRoom());
            header.add(hConflictRoom);
            this.addSortOperation(hConflictRoom, EnrollmentComparator.SortBy.CONFLICT_ROOM, MESSAGES.colConflictRoom());
        }
        UniTimeTableHeader hApproved = null;
        if (courseIdsCanApprove != null && !courseIdsCanApprove.isEmpty()) {
            hApproved = new UniTimeTableHeader(MESSAGES.colApproved());
            hApproved.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(true));
                    }
                    EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                    EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || ((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.selectAll();
                }
            });
            hApproved.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(false));
                    }
                    EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                    EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.clearAll();
                }
            });
            this.iApprove = new UniTimeTableHeader.Operation(){

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>();
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        studentIds.add(((ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row)).getStudent().getId());
                    }
                    EnrollmentTable.this.iHeader.showLoading();
                    iSectioningService.approveEnrollments(EnrollmentTable.this.iOfferingId, studentIds, new AsyncCallback<String>(){

                        public void onSuccess(String result) {
                            EnrollmentTable.this.iHeader.clearMessage();
                            String[] approval = result.split(":");
                            for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                                Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                                if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                EnrollmentTable.this.iEnrollments.replaceWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1, (Widget)new HTML(MESSAGES.approval(sDF.format(new Date(Long.valueOf(approval[0]))), approval[2]), false));
                            }
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToApproveEnrollments(caught.getMessage()));
                        }
                    });
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return true;
                }

                @Override
                public String getName() {
                    return MESSAGES.approveSelectedEnrollments();
                }
            };
            hApproved.addOperation(this.iApprove);
            this.iReject = new UniTimeTableHeader.Operation(){

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>();
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        studentIds.add(((ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row)).getStudent().getId());
                    }
                    EnrollmentTable.this.iHeader.showLoading();
                    iSectioningService.rejectEnrollments(EnrollmentTable.this.iOfferingId, studentIds, new AsyncCallback<Boolean>(){

                        public void onSuccess(Boolean result) {
                            EnrollmentTable.this.iHeader.clearMessage();
                            int row = 0;
                            while (row < EnrollmentTable.this.iEnrollments.getRowCount()) {
                                Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                                if (w instanceof CheckBox && ((CheckBox)w).getValue().booleanValue()) {
                                    EnrollmentTable.this.iEnrollments.removeRow(row);
                                    continue;
                                }
                                ++row;
                            }
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToApproveEnrollments(caught.getMessage()));
                        }
                    });
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.rejectSelectedEnrollments();
                }
            };
            hApproved.addOperation(this.iReject);
            header.add(hApproved);
            this.addSortOperation(hApproved, EnrollmentComparator.SortBy.APPROVED, MESSAGES.colApproved());
        } else {
            this.iApprove = null;
            this.iReject = null;
        }
        this.iEnrollments.addRow(null, header);
        boolean suffix = SectioningCookie.getInstance().getShowClassNumbers();
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            if (this.filter(f, enrollment)) continue;
            ArrayList<Object> line = new ArrayList<Object>();
            if (hasExtId) {
                line.add(new Label(enrollment.getStudent().isCanShowExternalId() ? enrollment.getStudent().getExternalId() : "", false));
            }
            line.add(new Label(enrollment.getStudent().getName(), false));
            if (crosslist) {
                line.add(new Label(enrollment.getCourseName(), false));
            }
            if (hasPriority) {
                line.add(new Label(enrollment.getPriority() <= 0 ? "&nbsp;" : MESSAGES.priority(enrollment.getPriority())));
            }
            if (hasAlternative) {
                line.add(new Label(enrollment.getAlternative(), false));
            }
            if (hasArea) {
                line.add(new HTML(enrollment.getStudent().getArea("<br>"), false));
                line.add(new HTML(enrollment.getStudent().getClassification("<br>"), false));
            }
            if (hasMajor) {
                line.add(new HTML(enrollment.getStudent().getMajor("<br>"), false));
            }
            if (hasGroup) {
                line.add((Object)new Groups(enrollment.getStudent().getGroups()));
            }
            for (String type : groupTypes) {
                line.add((Object)new Groups(enrollment.getStudent().getGroups(type)));
            }
            if (hasAcmd) {
                line.add(new HTML(enrollment.getStudent().getAccommodation("<br>"), false));
            }
            if (hasReservation) {
                line.add(new HTML(enrollment.getReservation() == null ? "&nbsp;" : enrollment.getReservation(), false));
            }
            if (!subparts.isEmpty()) {
                if (!enrollment.hasClasses()) {
                    line.add(new WarningLabel(enrollment.isWaitList() ? MESSAGES.courseWaitListed() : MESSAGES.courseNotEnrolled(), subparts.size()));
                } else {
                    for (String subpart : subparts) {
                        line.add(new HTML(enrollment.getClasses(subpart, ", ", suffix), false));
                    }
                }
            }
            if (hasRequestedDate) {
                line.add(new HTML(enrollment.getRequestedDate() == null ? "&nbsp;" : sDF.format(enrollment.getRequestedDate()), false));
            }
            if (hasEnrolledDate) {
                line.add(new HTML(enrollment.getEnrolledDate() == null ? "&nbsp;" : sDF.format(enrollment.getEnrolledDate()), false));
            }
            if (hasMessage) {
                line.add(new HTML(enrollment.hasEnrollmentMessage() ? enrollment.getEnrollmentMessage().replace("\n", "<br>") : "&nbsp;", true));
            }
            if (hasAdvisor) {
                line.add(new HTML(enrollment.getStudent().hasAdvisor() ? enrollment.getStudent().getAdvisor("<br>") : "&nbsp;", true));
            }
            if (hasConflict) {
                if (enrollment.hasConflict()) {
                    void var53_71;
                    String type;
                    String string = "";
                    type = "";
                    String date = "";
                    String time = "";
                    String room = "";
                    for (ClassAssignmentInterface.Conflict conflict : enrollment.getConflicts()) {
                        void var53_75;
                        if (!var53_71.isEmpty()) {
                            String string2 = (String)var53_71 + "<br>";
                            type = type + "<br>";
                            date = date + "<br>";
                            time = time + "<br>";
                            room = room + "<br>";
                        }
                        if (conflict.hasStyle()) {
                            void var53_73;
                            String string3 = (String)var53_73 + "<span class='" + conflict.getStyle() + "'>";
                            type = type + "<span class='" + conflict.getStyle() + "'>";
                            date = date + "<span class='" + conflict.getStyle() + "'>";
                            time = time + "<span class='" + conflict.getStyle() + "'>";
                            room = room + "<span class='" + conflict.getStyle() + "'>";
                        }
                        String string4 = (String)var53_75 + conflict.getName();
                        type = type + conflict.getType();
                        date = date + conflict.getDate();
                        time = time + conflict.getTime();
                        room = room + conflict.getRoom();
                        if (!conflict.hasStyle()) continue;
                        String string5 = string4 + "</span>";
                        type = type + "</span>";
                        date = date + "</span>";
                        time = time + "</span>";
                        room = room + "</span>";
                    }
                    HTML html = new HTML(type, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML((String)var53_71, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML(date, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML(time, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML(room, false);
                    html.addStyleName("conflict");
                    line.add(html);
                } else {
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                }
            }
            if (courseIdsCanApprove != null && !courseIdsCanApprove.isEmpty()) {
                if (!enrollment.hasClasses()) {
                    line.add(new HTML("&nbsp;"));
                } else if (!courseIdsCanApprove.contains(enrollment.getCourseId())) {
                    line.add(new HTML("&nbsp;"));
                } else if (enrollment.getApprovedDate() == null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            event.stopPropagation();
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }
                    });
                    line.add(checkBox);
                } else {
                    line.add(new HTML(MESSAGES.approval(sDF.format(enrollment.getApprovedDate()), enrollment.getApprovedBy()), false));
                }
            }
            this.iEnrollments.addRow(enrollment, line);
            this.iEnrollments.getRowFormatter().setVerticalAlign(this.iEnrollments.getRowCount() - 1, HasVerticalAlignment.ALIGN_TOP);
        }
        ArrayList<UniTimeTable.HasStyleName> footer = new ArrayList<UniTimeTable.HasStyleName>();
        if (enrolled > 0) {
            footer.add(new TotalLabel(MESSAGES.totalEnrolled(enrolled), header.size()));
        }
        if (waitlisted > 0) {
            footer.add(new TotalLabel(MESSAGES.totalWaitListed(waitlisted), header.size()));
        }
        if (unassigned > 0) {
            footer.add(new TotalLabel(MESSAGES.totalNotEnrolled(unassigned + waitlisted), header.size()));
        }
        if (showFilter) {
            void var53_82;
            FilterRow filter = new FilterRow(header.size());
            filter.add((Widget)new Label(MESSAGES.filter()));
            final ListBox box = new ListBox();
            boolean bl2 = false;
            while (var53_82 < SectioningCookie.EnrollmentFilter.values().length) {
                SectioningCookie.EnrollmentFilter x = SectioningCookie.EnrollmentFilter.values()[var53_82];
                box.addItem(CONSTANTS.enrollmentFilterValues()[var53_82], x.name());
                ++var53_82;
            }
            box.setSelectedIndex(f.ordinal());
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    EnrollmentTable.this.iHeader.setCollapsible(true);
                    SectioningCookie.getInstance().setEnrollmentCoursesDetails(true);
                    SectioningCookie.getInstance().setEnrollmentFilter(SectioningCookie.EnrollmentFilter.valueOf(box.getValue(box.getSelectedIndex())));
                    EnrollmentTable.this.clear();
                    EnrollmentTable.this.populate(enrollments, courseIdsCanApprove);
                }
            });
            filter.add((Widget)box);
            footer.add(filter);
            if (this.iEnrollments.getRowCount() == 1) {
                if (f == SectioningCookie.EnrollmentFilter.ALL) {
                    this.iEnrollments.addRow(null, new Widget[]{new EmptyLabel(MESSAGES.offeringHasNoEnrollments(), Math.max(header.size(), footer.size()))});
                } else {
                    this.iEnrollments.addRow(null, new Widget[]{new EmptyLabel(MESSAGES.offeringHasNoEnrollmentsOfType(CONSTANTS.enrollmentFilterValues()[f.ordinal()]), Math.max(header.size(), footer.size()))});
                }
            }
        }
        if (!footer.isEmpty()) {
            if (footer.size() > 1) {
                int span = Math.max(1, header.size() / footer.size());
                for (Widget widget : footer) {
                    ((SetColSpan)widget).setColSpan(span);
                }
                ((SetColSpan)footer.get(footer.size() - 1)).setColSpan(Math.max(1, header.size() - (footer.size() - 1) * span));
            }
            int row = this.iEnrollments.addRow(null, footer);
            if (showFilter) {
                this.iEnrollments.getCellFormatter().setHorizontalAlignment(row, footer.size() - 1, HasHorizontalAlignment.ALIGN_RIGHT);
            }
        }
        if (showFilter) {
            for (int i = 0; i < SectioningCookie.EnrollmentFilter.values().length; ++i) {
                final SectioningCookie.EnrollmentFilter x = SectioningCookie.EnrollmentFilter.values()[i];
                UniTimeTableHeader.Operation operation = new UniTimeTableHeader.Operation(){

                    public void execute() {
                        SectioningCookie.getInstance().setEnrollmentFilter(x);
                        EnrollmentTable.this.clear();
                        EnrollmentTable.this.populate(enrollments, courseIdsCanApprove);
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    @Override
                    public boolean hasSeparator() {
                        return x.ordinal() == 0;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.enrollmentTableFilter(CONSTANTS.enrollmentFilterValues()[x.ordinal()]);
                    }
                };
                for (UniTimeTableHeader h : header) {
                    h.addOperation(operation);
                }
            }
        }
        if (SectioningCookie.getInstance().getEnrollmentSortBy() != 0) {
            boolean asc = SectioningCookie.getInstance().getEnrollmentSortBy() > 0;
            EnrollmentComparator.SortBy sort = EnrollmentComparator.SortBy.values()[Math.abs(SectioningCookie.getInstance().getEnrollmentSortBy()) - 1];
            String string = SectioningCookie.getInstance().getEnrollmentSortByGroup();
            UniTimeTableHeader h = null;
            switch (sort) {
                case ACCOMODATION: {
                    h = hAccmd;
                    break;
                }
                case ALTERNATIVE: {
                    h = hAlternative;
                    break;
                }
                case APPROVED: {
                    h = hApproved;
                    break;
                }
                case AREA: {
                    h = hArea;
                    break;
                }
                case CLASSIFICATION: {
                    h = hClasf;
                    break;
                }
                case CONFLICT_DATE: {
                    h = hConflictDate;
                    break;
                }
                case CONFLICT_NAME: {
                    h = hConflictName;
                    break;
                }
                case CONFLICT_ROOM: {
                    h = hConflictRoom;
                    break;
                }
                case CONFLICT_TIME: {
                    h = hConflictTime;
                    break;
                }
                case CONFLICT_TYPE: {
                    h = hConflictType;
                    break;
                }
                case COURSE: {
                    h = hCourse;
                    break;
                }
                case ENROLLMENT_TS: {
                    h = hEnrollmentTS;
                    break;
                }
                case EXTERNAL_ID: {
                    h = hExtId;
                    break;
                }
                case GROUP: {
                    if (string == null || string.isEmpty()) {
                        h = hGroup;
                        break;
                    }
                    h = (UniTimeTableHeader)hGroups.get(string);
                    break;
                }
                case MAJOR: {
                    h = hMajor;
                    break;
                }
                case MESSAGE: {
                    h = hMessage;
                    break;
                }
                case PRIORITY: {
                    h = hPriority;
                    break;
                }
                case REQUEST_TS: {
                    void var39_45;
                    h = var39_45;
                    break;
                }
                case RESERVATION: {
                    h = hReservation;
                    break;
                }
                case STUDENT: {
                    h = hStudent;
                }
            }
            if (h != null) {
                this.iEnrollments.sort(h, new EnrollmentComparator(sort, string), asc);
            }
        } else {
            boolean asc;
            UniTimeTableHeader uniTimeTableHeader;
            String subpart = SectioningCookie.getInstance().getEnrollmentSortBySubpart();
            if (subpart != null && !subpart.isEmpty() && (uniTimeTableHeader = (UniTimeTableHeader)hSubparts.get((asc = !subpart.startsWith("-")) ? subpart : subpart.substring(1))) != null) {
                this.iEnrollments.sort(uniTimeTableHeader, new EnrollmentComparator(asc ? subpart : subpart.substring(1), SectioningCookie.getInstance().getShowClassNumbers()), asc);
            }
        }
    }

    public void insert(RootPanel panel) {
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        if (this.iOfferingId >= 0L && this.iShowFilter) {
            this.iHeader.setHeaderTitle(MESSAGES.studentsTable());
        }
        if (SectioningCookie.getInstance().getEnrollmentCoursesDetails()) {
            this.refresh();
        } else {
            this.clear();
            this.iHeader.clearMessage();
            this.iHeader.setCollapsible(false);
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    public void setId(Long id) {
        this.iOfferingId = id;
    }

    public Long getId() {
        return this.iOfferingId;
    }

    public void scrollIntoView(Long studentId) {
        for (int r = 1; r < this.iEnrollments.getRowCount(); ++r) {
            if (this.iEnrollments.getData(r) == null || this.iEnrollments.getData(r).getStudent().getId() != studentId.longValue()) continue;
            this.iEnrollments.getRowFormatter().getElement(r).scrollIntoView();
        }
    }

    public void select(Long studentId) {
        for (int i = 0; i < this.iEnrollments.getRowCount(); ++i) {
            ClassAssignmentInterface.Enrollment e = this.iEnrollments.getData(i);
            if (e == null) continue;
            if (e.getStudent().getId() == studentId.longValue()) {
                this.iEnrollments.getRowFormatter().setStyleName(i, "unitime-TableRowSelected");
                continue;
            }
            if (!"unitime-TableRowSelected".equals(this.iEnrollments.getRowFormatter().getStyleName(i))) continue;
            this.iEnrollments.getRowFormatter().removeStyleName(i, "unitime-TableRowSelected");
        }
    }

    protected void addSortOperation(UniTimeTableHeader header, EnrollmentComparator.SortBy sort, String column) {
        this.addSortOperation(header, sort, column, "");
    }

    protected void addSortOperation(final UniTimeTableHeader header, final EnrollmentComparator.SortBy sort, final String column, final String type) {
        header.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                EnrollmentTable.this.iEnrollments.sort(header, new EnrollmentComparator(sort, type));
                SectioningCookie.getInstance().setEnrollmentSortBy(header.getOrder() != false ? 1 + sort.ordinal() : -1 - sort.ordinal(), type);
            }

            @Override
            public boolean isApplicable() {
                return true;
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                if (sort == EnrollmentComparator.SortBy.GROUP && type != null && !type.isEmpty()) {
                    return MESSAGES.sortBy(type);
                }
                return MESSAGES.sortBy(column);
            }
        });
    }

    protected void addSortOperation(final UniTimeTableHeader header, final String subpart) {
        header.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                EnrollmentTable.this.iEnrollments.sort(header, new EnrollmentComparator(subpart, SectioningCookie.getInstance().getShowClassNumbers()));
                SectioningCookie.getInstance().setEnrollmentSortBySubpart(header.getOrder() != false ? subpart : "-" + subpart);
            }

            @Override
            public boolean isApplicable() {
                return true;
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.sortBy(subpart);
            }
        });
    }

    public static class EnrollmentComparator
    implements Comparator<ClassAssignmentInterface.Enrollment> {
        private SortBy iSortBy = null;
        private String iSubpart = null;
        private boolean iShowClassNumbers = true;
        private String iGroupType = null;

        public EnrollmentComparator(SortBy sortBy, String type) {
            this.iSortBy = sortBy;
            this.iGroupType = type;
        }

        public EnrollmentComparator(String subpart, boolean showClassNumbers) {
            this.iSubpart = subpart;
            this.iShowClassNumbers = showClassNumbers;
            this.iGroupType = null;
        }

        protected int doCompare(ClassAssignmentInterface.Conflict c1, ClassAssignmentInterface.Conflict c2) {
            switch (this.iSortBy) {
                case CONFLICT_TYPE: {
                    return c1.getType().compareTo(c2.getType());
                }
                case CONFLICT_NAME: {
                    return c1.getName().compareTo(c2.getName());
                }
                case CONFLICT_DATE: {
                    return c1.getDate().compareTo(c2.getDate());
                }
                case CONFLICT_TIME: {
                    return c1.getTime().compareTo(c2.getTime());
                }
                case CONFLICT_ROOM: {
                    return c1.getRoom().compareTo(c2.getRoom());
                }
            }
            return c1.getName().compareTo(c2.getName());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected int doCompare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
            int cmp;
            if (this.iSubpart != null && (cmp = e1.getClasses(this.iSubpart, "|", this.iShowClassNumbers).compareTo(e2.getClasses(this.iSubpart, "|", this.iShowClassNumbers))) != 0) {
                return cmp;
            }
            if (this.iSortBy == null) return 0;
            cmp = 0;
            switch (this.iSortBy) {
                case EXTERNAL_ID: {
                    return (e1.getStudent().isCanShowExternalId() ? e1.getStudent().getExternalId() : "").compareTo(e2.getStudent().isCanShowExternalId() ? e2.getStudent().getExternalId() : "");
                }
                case STUDENT: {
                    return e1.getStudent().getName().compareTo(e2.getStudent().getName());
                }
                case COURSE: {
                    return e1.getCourseName().compareTo(e2.getCourseName());
                }
                case PRIORITY: {
                    cmp = new Integer(e1.getPriority()).compareTo(e2.getPriority());
                    if (cmp == 0) return e1.getAlternative().compareTo(e2.getAlternative());
                    return cmp;
                }
                case ALTERNATIVE: {
                    cmp = e1.getAlternative().compareTo(e2.getAlternative());
                    if (cmp == 0) return new Integer(e1.getPriority()).compareTo(e2.getPriority());
                    return cmp;
                }
                case AREA: {
                    cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                    if (cmp == 0) return e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                    return cmp;
                }
                case CLASSIFICATION: {
                    cmp = e1.getStudent().getClassification("|").compareTo(e2.getStudent().getClassification("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getStudent().getArea("|").compareTo(e2.getStudent().getArea("|"));
                    if (cmp == 0) return e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                    return cmp;
                }
                case MAJOR: {
                    cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                    if (cmp == 0) return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                    return cmp;
                }
                case GROUP: {
                    cmp = e1.getStudent().getGroup(this.iGroupType, "|").compareTo(e2.getStudent().getGroup(this.iGroupType, "|"));
                    if (cmp == 0) return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                    return cmp;
                }
                case ACCOMODATION: {
                    cmp = e1.getStudent().getAccommodation("|").compareTo(e2.getStudent().getAccommodation("|"));
                    if (cmp == 0) return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                    return cmp;
                }
                case RESERVATION: {
                    return (e1.getReservation() == null ? "" : e1.getReservation()).compareTo(e2.getReservation() == null ? "" : e2.getReservation());
                }
                case REQUEST_TS: {
                    return (e1.getRequestedDate() == null ? new Date(0L) : e1.getRequestedDate()).compareTo(e2.getRequestedDate() == null ? new Date(0L) : e2.getRequestedDate());
                }
                case ENROLLMENT_TS: {
                    return (e1.getEnrolledDate() == null ? new Date(0L) : e1.getEnrolledDate()).compareTo(e2.getEnrolledDate() == null ? new Date(0L) : e2.getEnrolledDate());
                }
                case MESSAGE: {
                    return (e1.getEnrollmentMessage() == null ? "" : e1.getEnrollmentMessage()).compareTo(e2.getEnrollmentMessage() == null ? "" : e2.getEnrollmentMessage());
                }
                case ADVISOR: {
                    return e1.getStudent().getAdvisor("|").compareTo(e2.getStudent().getAdvisor("|"));
                }
                case CONFLICT_DATE: 
                case CONFLICT_NAME: 
                case CONFLICT_TIME: 
                case CONFLICT_TYPE: {
                    if (e1.hasConflict()) {
                        if (!e2.hasConflict()) return -1;
                        Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                        Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                        while (i1.hasNext() && i2.hasNext()) {
                            ClassAssignmentInterface.Conflict c2;
                            ClassAssignmentInterface.Conflict c1 = i1.next();
                            cmp = this.doCompare(c1, c2 = i2.next());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = c1.getName().compareTo(c2.getName());
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        if (i1.hasNext()) {
                            return -1;
                        }
                        if (!i2.hasNext()) return 0;
                        return 1;
                    }
                    if (!e2.hasConflict()) return 0;
                    return 1;
                }
                case APPROVED: {
                    return new Long(e1.getApprovedDate() == null ? 0L : e1.getApprovedDate().getTime()).compareTo(e2.getApprovedDate() == null ? 0L : e2.getApprovedDate().getTime());
                }
            }
            return 0;
        }

        @Override
        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
            int cmp = this.doCompare(e1, e2);
            if (cmp != 0) {
                return cmp;
            }
            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
        }

        public static enum SortBy {
            EXTERNAL_ID,
            STUDENT,
            COURSE,
            PRIORITY,
            ALTERNATIVE,
            AREA,
            CLASSIFICATION,
            MAJOR,
            GROUP,
            ACCOMODATION,
            RESERVATION,
            REQUEST_TS,
            ENROLLMENT_TS,
            MESSAGE,
            CONFLICT_TYPE,
            CONFLICT_NAME,
            CONFLICT_DATE,
            CONFLICT_TIME,
            CONFLICT_ROOM,
            APPROVED,
            ADVISOR;

        }
    }

    public static class TopCell
    extends Label
    implements UniTimeTable.HasVerticalCellAlignment {
        TopCell(String cell) {
            super(cell);
        }

        @Override
        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment() {
            return HasVerticalAlignment.ALIGN_TOP;
        }
    }

    public static interface ReservationClickHandler {
        public void onClick(ReservationClickedEvent var1);
    }

    public static class ReservationClickedEvent {
        private ReservationInterface iReservation;

        public ReservationClickedEvent(ReservationInterface reservation) {
            this.iReservation = reservation;
        }

        public ReservationInterface getReservation() {
            return this.iReservation;
        }
    }

    private static class FilterRow
    extends HorizontalPanel
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public FilterRow(int colspan) {
            this.iColSpan = colspan;
        }

        @Override
        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }

        @Override
        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static class Groups
    extends P {
        private Groups(Collection<ClassAssignmentInterface.Group> groups) {
            super(new String[0]);
            if (groups != null && !groups.isEmpty()) {
                for (ClassAssignmentInterface.Group group : groups) {
                    P g = new P(new String[0]);
                    g.setText(group.getName());
                    if (group.hasTitle()) {
                        g.setTitle(group.getTitle());
                    }
                    this.add((Widget)g);
                }
            }
        }
    }

    private static class EmptyLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public EmptyLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        @Override
        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }

        @Override
        public String getStyleName() {
            return "text-gray";
        }
    }

    private static class WarningLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public WarningLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        @Override
        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }

        @Override
        public String getStyleName() {
            return "text-red";
        }
    }

    private static class TotalLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public TotalLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }

        @Override
        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        @Override
        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static interface SetColSpan
    extends UniTimeTable.HasColSpan {
        public void setColSpan(int var1);
    }
}

