/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class InstructionalOfferingDetailForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = -5161466018324037153L;
    private String op;
    private Long subjectAreaId;
    private Long crsOfferingId;
    private Long instrOfferingId;
    private Long ctrlCrsOfferingId;
    private Integer projectedDemand;
    private Integer enrollment;
    private Integer snapshotLimit;
    private Integer demand;
    private Integer limit;
    private Boolean unlimited;
    private Boolean notOffered;
    private String instrOfferingName;
    private String instrOfferingNameNoTitle;
    private List courseOfferings;
    private String subjectAreaAbbr;
    private String courseNbr;
    private String nextId;
    private String previousId;
    private String catalogLinkLabel;
    private String catalogLinkLocation;
    private boolean byReservationOnly;
    private String coordinators;
    private String wkEnroll;
    private String wkChange;
    private String wkDrop;
    private String weekStartDayOfWeek;
    private String accommodation;
    private boolean hasConflict;
    private String notes;
    private boolean teachingRequests;
    protected DynamicListObjectFactory factoryCourseOfferings = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        throw new UnsupportedOperationException(MSG.exceptionValidateNotImplemented());
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "view";
        this.subjectAreaId = null;
        this.subjectAreaAbbr = null;
        this.courseNbr = null;
        this.crsOfferingId = null;
        this.instrOfferingId = null;
        this.ctrlCrsOfferingId = null;
        this.enrollment = null;
        this.snapshotLimit = null;
        this.demand = null;
        this.projectedDemand = null;
        this.limit = null;
        this.unlimited = new Boolean(false);
        this.notOffered = null;
        this.instrOfferingName = "";
        this.instrOfferingNameNoTitle = "";
        this.courseOfferings = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.previousId = null;
        this.nextId = null;
        this.catalogLinkLabel = null;
        this.catalogLinkLocation = null;
        this.byReservationOnly = false;
        this.coordinators = null;
        this.wkEnroll = null;
        this.wkChange = null;
        this.wkDrop = null;
        this.weekStartDayOfWeek = null;
        this.accommodation = null;
        this.hasConflict = false;
        this.notes = null;
        this.teachingRequests = false;
    }

    public List getCourseOfferings() {
        return this.courseOfferings;
    }

    public String getCourseOfferings(int key) {
        return this.courseOfferings.get(key).toString();
    }

    public void setCourseOfferings(int key, Object value) {
        this.courseOfferings.set(key, value);
    }

    public void setCourseOfferings(List courseOfferings) {
        this.courseOfferings = courseOfferings;
    }

    public Long getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Long subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public Long getCrsOfferingId() {
        return this.crsOfferingId;
    }

    public void setCrsOfferingId(Long crsOfferingId) {
        this.crsOfferingId = crsOfferingId;
    }

    public Long getCtrlCrsOfferingId() {
        return this.ctrlCrsOfferingId;
    }

    public void setCtrlCrsOfferingId(Long ctrlCrsOfferingId) {
        this.ctrlCrsOfferingId = ctrlCrsOfferingId;
    }

    public Integer getDemand() {
        return this.demand;
    }

    public void setDemand(Integer demand) {
        this.demand = demand;
    }

    public Integer getProjectedDemand() {
        return this.projectedDemand;
    }

    public void setProjectedDemand(Integer projectedDemand) {
        this.projectedDemand = projectedDemand;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public Boolean getNotOffered() {
        return this.notOffered;
    }

    public void setNotOffered(Boolean notOffered) {
        this.notOffered = notOffered;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getSubjectAreaAbbr() {
        return this.subjectAreaAbbr;
    }

    public void setSubjectAreaAbbr(String subjectAreaAbbr) {
        this.subjectAreaAbbr = subjectAreaAbbr;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.courseNbr = courseNbr;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public String getInstrOfferingNameNoTitle() {
        return this.instrOfferingNameNoTitle;
    }

    public void setInstrOfferingNameNoTitle(String instrOfferingNameNoTitle) {
        this.instrOfferingNameNoTitle = instrOfferingNameNoTitle;
    }

    public String getCatalogLinkLabel() {
        return this.catalogLinkLabel;
    }

    public void setCatalogLinkLabel(String catalogLinkLabel) {
        this.catalogLinkLabel = catalogLinkLabel;
    }

    public String getCatalogLinkLocation() {
        return this.catalogLinkLocation;
    }

    public void setCatalogLinkLocation(String catalogLinkLocation) {
        this.catalogLinkLocation = catalogLinkLocation;
    }

    public void addToCourseOfferings(CourseOffering co) {
        this.courseOfferings.add(co);
    }

    public Integer getCourseOfferingCount() {
        return new Integer(this.courseOfferings.size());
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String previousId) {
        this.previousId = previousId;
    }

    public boolean getHasDemandOfferings() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getDemandOffering() == null) continue;
            return true;
        }
        return false;
    }

    public boolean getHasAlternativeCourse() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty() || ApplicationProperty.StudentSchedulingAlternativeCourse.isFalse()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getAlternativeOffering() == null) continue;
            return true;
        }
        return false;
    }

    public Integer getEnrollment() {
        return this.enrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.enrollment = enrollment;
    }

    public Integer getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public void setSnapshotLimit(Integer snapshotLimit) {
        this.snapshotLimit = snapshotLimit;
    }

    public boolean isByReservationOnly() {
        return this.byReservationOnly;
    }

    public void setByReservationOnly(boolean byReservationOnly) {
        this.byReservationOnly = byReservationOnly;
    }

    public String getCoordinators() {
        return this.coordinators;
    }

    public void setCoordinators(String coordinators) {
        this.coordinators = coordinators;
    }

    public String getWkEnroll() {
        return this.wkEnroll;
    }

    public void setWkEnroll(String wkEnroll) {
        this.wkEnroll = wkEnroll;
    }

    public String getWkChange() {
        return this.wkChange;
    }

    public void setWkChange(String wkChange) {
        this.wkChange = wkChange;
    }

    public String getWkDrop() {
        return this.wkDrop;
    }

    public void setWkDrop(String wkDrop) {
        this.wkDrop = wkDrop;
    }

    public String getWeekStartDayOfWeek() {
        return this.weekStartDayOfWeek;
    }

    public void setWeekStartDayOfWeek(String weekStartDayOfWeek) {
        this.weekStartDayOfWeek = weekStartDayOfWeek;
    }

    public boolean isDisplayEnrollmentDeadlineNote() {
        return this.wkEnroll != null && !this.wkEnroll.isEmpty() || this.wkChange != null && !this.wkChange.isEmpty() || this.wkDrop != null && !this.wkDrop.isEmpty();
    }

    public boolean getHasCourseTypes() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getCourseType() == null) continue;
            return true;
        }
        return false;
    }

    public boolean getHasConsent() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getConsentType() == null) continue;
            return true;
        }
        return false;
    }

    public String getAccommodation() {
        return this.accommodation;
    }

    public void setAccommodation(String accommodation) {
        this.accommodation = accommodation;
    }

    public boolean getHasCredit() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getCredit() == null) continue;
            return true;
        }
        return false;
    }

    public boolean getHasScheduleBookNote() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        for (CourseOffering course : this.courseOfferings) {
            if (course.getScheduleBookNote() == null || course.getScheduleBookNote().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasCourseReservation() {
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        Iterator i = this.courseOfferings.iterator();
        while (i.hasNext()) {
            if (((CourseOffering)i.next()).getReservation() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasConflict() {
        return this.hasConflict;
    }

    public void setHasConflict(boolean hasConflict) {
        this.hasConflict = hasConflict;
    }

    public boolean getHasCourseExternalId() {
        if (!ApplicationProperty.CourseOfferingShowExternalIds.isTrue()) {
            return false;
        }
        if (this.courseOfferings == null || this.courseOfferings.isEmpty()) {
            return false;
        }
        for (CourseOffering co : this.courseOfferings) {
            if (co.getExternalUniqueId() == null || co.getExternalUniqueId().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasDisabledOverrides() {
        for (CourseOffering co : this.courseOfferings) {
            if (co.getDisabledOverrides().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasOverrides() {
        return !OverrideTypeDAO.getInstance().findAll().isEmpty();
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean getTeachingRequests() {
        return this.teachingRequests;
    }

    public void setTeachingRequests(boolean teachingRequests) {
        this.teachingRequests = teachingRequests;
    }
}

