/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.ReferenceList;

public class DepartmentEditForm
extends ActionForm {
    private static final long serialVersionUID = -6614766002463228171L;
    public Long iId = null;
    public Long iSessionId = null;
    public String iName = null;
    public String iDeptCode = null;
    public String iStatusType = null;
    public String iOp = null;
    public String iAbbv = null;
    public String iExternalId = null;
    public int iDistPrefPriority = 0;
    public boolean iIsExternal = false;
    public String iExtAbbv = null;
    public String iExtName = null;
    public boolean iAllowReqTime = false;
    public boolean iAllowReqRoom = false;
    public boolean iAllowReqDist = false;
    public boolean iAllowEvents = false;
    public boolean iInheritInstructorPreferences = false;
    public boolean iAllowStudentScheduling = false;
    private List iDependentDepartments;
    private List iDependentStatuses;
    private boolean iFullyEditable = false;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iName == null || this.iName.trim().equalsIgnoreCase("")) {
            errors.add("name", new ActionMessage("errors.required", (Object)"Name"));
        }
        if (this.iName != null && this.iName.trim().length() > 100) {
            errors.add("name", new ActionMessage("errors.maxlength", (Object)"Name", (Object)"100"));
        }
        if (this.iAbbv == null || this.iAbbv.trim().equalsIgnoreCase("")) {
            errors.add("abbv", new ActionMessage("errors.required", (Object)"Abbreviation"));
        }
        if (this.iAbbv != null && this.iAbbv.trim().length() > 20) {
            errors.add("abbv", new ActionMessage("errors.maxlength", (Object)"Abbreviation", (Object)"20"));
        }
        if (this.iDeptCode == null || this.iDeptCode.trim().equalsIgnoreCase("")) {
            errors.add("deptCode", new ActionMessage("errors.required", (Object)"Code"));
        }
        if (this.iDeptCode != null && this.iDeptCode.trim().length() > 50) {
            errors.add("deptCode", new ActionMessage("errors.maxlength", (Object)"Code", (Object)"50"));
        }
        if (this.iIsExternal && (this.iExtName == null || this.iExtName.trim().length() == 0)) {
            errors.add("extName", new ActionMessage("errors.required", (Object)"External Manager Name"));
        }
        if (!this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 0) {
            errors.add("extName", new ActionMessage("errors.generic", (Object)"External Manager Name should only be used when the department is marked as 'External Manager'"));
        }
        if (this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 30) {
            errors.add("extName", new ActionMessage("errors.maxlength", (Object)"External Manager Name", (Object)"30"));
        }
        if (this.iIsExternal && (this.iExtAbbv == null || this.iExtAbbv.trim().length() == 0)) {
            errors.add("extAbbv", new ActionMessage("errors.required", (Object)"External Manager Abbreviation"));
        }
        if (!this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 0) {
            errors.add("extName", new ActionMessage("errors.generic", (Object)"External Manager Abbreviation should only be used when the department is marked as 'External Manager'"));
        }
        if (this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 10) {
            errors.add("extAbbv", new ActionMessage("errors.maxlength", (Object)"External Manager Abbreviation", (Object)"10"));
        }
        try {
            Department dept = Department.findByDeptCode(this.iDeptCode, this.iSessionId);
            if (dept != null && !dept.getUniqueId().equals(this.iId)) {
                errors.add("deptCode", new ActionMessage("errors.exists", (Object)this.iDeptCode));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            errors.add("deptCode", new ActionMessage("errors.generic", (Object)e.getMessage()));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iId = null;
        this.iSessionId = null;
        this.iName = null;
        this.iDeptCode = null;
        this.iStatusType = null;
        this.iAbbv = null;
        this.iDistPrefPriority = 0;
        this.iIsExternal = false;
        this.iExtName = null;
        this.iExtAbbv = null;
        this.iAllowReqTime = false;
        this.iAllowReqRoom = false;
        this.iAllowReqDist = false;
        this.iAllowEvents = false;
        this.iInheritInstructorPreferences = false;
        this.iAllowStudentScheduling = false;
        this.iDependentDepartments = DynamicList.getInstance(new ArrayList(), new DynamicListObjectFactory(){

            @Override
            public Object create() {
                return new String("-1");
            }
        });
        this.iDependentStatuses = DynamicList.getInstance(new ArrayList(), new DynamicListObjectFactory(){

            @Override
            public Object create() {
                return new String("");
            }
        });
        this.iFullyEditable = false;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public int getDistPrefPriority() {
        return this.iDistPrefPriority;
    }

    public void setDistPrefPriority(int distPrefPriority) {
        this.iDistPrefPriority = distPrefPriority;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    public String getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(String statusType) {
        this.iStatusType = statusType;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public boolean getIsExternal() {
        return this.iIsExternal;
    }

    public void setIsExternal(boolean isExternal) {
        this.iIsExternal = isExternal;
    }

    public boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    public boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    public boolean getAllowReqDist() {
        return this.iAllowReqDist;
    }

    public void setAllowReqDist(boolean allowReqDist) {
        this.iAllowReqDist = allowReqDist;
    }

    public boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    public boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    public String getExtAbbv() {
        return this.iExtAbbv;
    }

    public void setExtAbbv(String extAbbv) {
        this.iExtAbbv = extAbbv;
    }

    public String getExtName() {
        return this.iExtName;
    }

    public void setExtName(String extName) {
        this.iExtName = extName;
    }

    public boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    public ReferenceList getStatusOptions() {
        ReferenceList ref = new ReferenceList();
        ref.addAll(DepartmentStatusType.findAllForDepartment());
        return ref;
    }

    public List getDependentDepartments() {
        return this.iDependentDepartments;
    }

    public String getDependentDepartments(int key) {
        return this.iDependentDepartments.get(key).toString();
    }

    public void setDependentDepartments(int key, Object value) {
        this.iDependentDepartments.set(key, value);
    }

    public void setDependentDepartments(List departments) {
        this.iDependentDepartments = departments;
    }

    public List getDependentStatuses() {
        return this.iDependentStatuses;
    }

    public String getDependentStatuses(int key) {
        return this.iDependentStatuses.get(key).toString();
    }

    public void setDependentStatuses(int key, Object value) {
        this.iDependentStatuses.set(key, value);
    }

    public void setDependentStatuses(List statuses) {
        this.iDependentStatuses = statuses;
    }

    public void load(Department department) {
        this.setId(department.getUniqueId());
        this.setSessionId(department.getSessionId());
        this.setName(department.getName());
        this.setAbbv(department.getAbbreviation());
        this.setDistPrefPriority(department.getDistributionPrefPriority() == null ? 0 : department.getDistributionPrefPriority());
        this.setDeptCode(department.getDeptCode());
        this.setStatusType(department.getStatusType() == null ? null : department.getStatusType().getReference());
        this.setExternalId(department.getExternalUniqueId());
        this.setIsExternal(department.isExternalManager());
        this.setExtAbbv(department.getExternalMgrAbbv());
        this.setExtName(department.getExternalMgrLabel());
        this.setAllowReqRoom(department.isAllowReqRoom() != null && department.isAllowReqRoom() != false);
        this.setAllowReqTime(department.isAllowReqTime() != null && department.isAllowReqTime() != false);
        this.setAllowReqDist(department.isAllowReqDistribution() != null && department.isAllowReqDistribution() != false);
        this.setAllowEvents(department.isAllowEvents());
        this.setAllowStudentScheduling(department.isAllowStudentScheduling());
        this.setInheritInstructorPreferences(department.isInheritInstructorPreferences());
        this.iDependentDepartments.clear();
        this.iDependentStatuses.clear();
        if (department.isExternalManager().booleanValue() && department.getExternalStatusTypes() != null) {
            if (!department.getExternalStatusTypes().isEmpty()) {
                TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                    @Override
                    public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                        return e1.getDepartment().compareTo(e2.getDepartment());
                    }
                });
                set.addAll(department.getExternalStatusTypes());
                for (ExternalDepartmentStatusType e : set) {
                    this.iDependentDepartments.add(e.getDepartment().getUniqueId().toString());
                    this.iDependentStatuses.add(e.getStatusType().getReference());
                }
            }
            this.addBlankDependentDepartment();
            this.addBlankDependentDepartment();
        }
    }

    public void addBlankDependentDepartment() {
        this.iDependentDepartments.add("-1");
        this.iDependentStatuses.add("");
    }

    public void deleteDependentDepartment(int idx) {
        this.iDependentDepartments.remove(idx);
        this.iDependentStatuses.remove(idx);
    }

    public void deleteAllDependentDepartments() {
        this.iDependentDepartments.clear();
        this.iDependentStatuses.clear();
        this.addBlankDependentDepartment();
        this.addBlankDependentDepartment();
    }

    public void save(SessionContext context) throws Exception {
        Department department;
        DepartmentDAO dao = new DepartmentDAO();
        org.hibernate.Session session = dao.getSession();
        Session acadSession = null;
        if (this.getId().equals(new Long(0L))) {
            department = new Department();
            acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            department.setSession(acadSession);
            department.setDistributionPrefPriority(new Integer(0));
            acadSession.addTodepartments(department);
            department.setExternalStatusTypes(new HashSet<ExternalDepartmentStatusType>());
        } else {
            department = (Department)dao.get(this.getId(), session);
        }
        if (department != null) {
            if (this.isFullyEditable()) {
                department.setStatusType(this.getStatusType() == null || this.getStatusType().length() == 0 ? null : DepartmentStatusType.findByRef(this.getStatusType()));
                department.setName(this.getName());
                department.setDeptCode(this.getDeptCode());
                department.setAbbreviation(this.getAbbv());
                department.setExternalUniqueId(this.getExternalId());
                department.setDistributionPrefPriority(new Integer(this.getDistPrefPriority()));
                department.setExternalManager(new Boolean(this.getIsExternal()));
                department.setExternalMgrLabel(this.getExtName());
                department.setExternalMgrAbbv(this.getExtAbbv());
                department.setAllowReqRoom(new Boolean(this.getAllowReqRoom()));
                department.setAllowReqTime(new Boolean(this.getAllowReqTime()));
                department.setAllowReqDistribution(new Boolean(this.getAllowReqDist()));
                department.setAllowEvents(this.getAllowEvents());
                department.setAllowStudentScheduling(this.getAllowStudentScheduling());
                department.setInheritInstructorPreferences(this.getInheritInstructorPreferences());
            }
            ArrayList<ExternalDepartmentStatusType> statuses = new ArrayList<ExternalDepartmentStatusType>(department.getExternalStatusTypes());
            if (department.isExternalManager().booleanValue()) {
                for (int i = 0; i < Math.min(this.iDependentDepartments.size(), this.iDependentStatuses.size()); ++i) {
                    Long deptId = Long.valueOf((String)this.iDependentDepartments.get(i));
                    String status = (String)this.iDependentStatuses.get(i);
                    if (deptId < 0L || status.isEmpty()) continue;
                    ExternalDepartmentStatusType t = null;
                    Iterator j = statuses.iterator();
                    while (j.hasNext()) {
                        ExternalDepartmentStatusType x = (ExternalDepartmentStatusType)j.next();
                        if (!deptId.equals(x.getDepartment().getUniqueId())) continue;
                        j.remove();
                        t = x;
                        break;
                    }
                    if (t == null) {
                        t = new ExternalDepartmentStatusType();
                        t.setExternalDepartment(department);
                        t.setDepartment((Department)DepartmentDAO.getInstance().get(deptId));
                        department.getExternalStatusTypes().add(t);
                    }
                    t.setStatusType(DepartmentStatusType.findByRef(status));
                }
            }
            for (ExternalDepartmentStatusType t : statuses) {
                department.getExternalStatusTypes().remove(t);
                session.delete((Object)t);
            }
            session.saveOrUpdate((Object)department);
            ChangeLog.addChange(session, context, department, ChangeLog.Source.DEPARTMENT_EDIT, this.getId().equals(new Long(0L)) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, department);
            session.flush();
            if (acadSession != null) {
                session.refresh((Object)acadSession);
            }
        }
    }

    public boolean isFullyEditable() {
        return this.iFullyEditable;
    }

    public void setFullyEditable(boolean fullyEditable) {
        this.iFullyEditable = fullyEditable;
    }
}

