/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="/studentScheduling")
public class StudentSchedulingAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;
    @Autowired
    ApplicationContext applicationContext;

    protected boolean matchCampus(AcademicSessionProvider.AcademicSessionInfo info, String campus) {
        if (info.hasExternalCampus() && campus.equalsIgnoreCase(info.getExternalCampus())) {
            return true;
        }
        return campus.equalsIgnoreCase(info.getCampus());
    }

    protected boolean matchTerm(AcademicSessionProvider.AcademicSessionInfo info, String term) {
        if (info.hasExternalTerm() && term.equalsIgnoreCase(info.getExternalTerm())) {
            return true;
        }
        return term.equalsIgnoreCase(info.getTerm() + info.getYear()) || term.equalsIgnoreCase(info.getYear() + info.getTerm()) || term.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus());
    }

    protected boolean matchSession(AcademicSessionProvider.AcademicSessionInfo info, String session) {
        if (info.hasExternalTerm() && info.hasExternalCampus() && session.equalsIgnoreCase(info.getExternalTerm() + info.hasExternalCampus())) {
            return true;
        }
        return session.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus()) || session.equalsIgnoreCase(info.getTerm() + info.getYear()) || session.equals(info.getSessionId().toString());
    }

    public boolean match(HttpServletRequest request, AcademicSessionProvider.AcademicSessionInfo info, boolean useDefault) {
        String campus = request.getParameter("campus");
        if (campus != null && !this.matchCampus(info, campus)) {
            return false;
        }
        String term = request.getParameter("term");
        if (term != null && !this.matchTerm(info, term)) {
            return false;
        }
        String session = request.getParameter("session");
        if (session != null && !this.matchSession(info, session)) {
            return false;
        }
        if (useDefault && campus == null && term == null && session == null) {
            return info.getSessionId().equals(this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<? extends UserQualifier> q;
        String target = null;
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String string : (String[])entry.getValue()) {
                target = target == null ? (String)entry.getKey() + "=" + URLEncoder.encode(string, "UTF-8") : target + "&" + (String)entry.getKey() + "=" + URLEncoder.encode(string, "UTF-8");
            }
        }
        boolean useDefault = ApplicationProperty.StudentSchedulingUseDefaultSession.isTrue();
        SectioningService service = (SectioningService)this.applicationContext.getBean("sectioning.gwt");
        if (this.sessionContext.isAuthenticated()) {
            UserAuthority preferredAuthority = null;
            try {
                for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(true)) {
                    if (!this.match(request, academicSessionInfo, true)) continue;
                    for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, new SimpleQualifier("Session", academicSessionInfo.getSessionId()))) {
                        if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                        preferredAuthority = userAuthority;
                    }
                }
                if (preferredAuthority == null) {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(false)) {
                        if (!this.match(request, academicSessionInfo, true)) continue;
                        for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, new SimpleQualifier("Session", academicSessionInfo.getSessionId()))) {
                            if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                                preferredAuthority = userAuthority;
                                continue;
                            }
                            if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                                preferredAuthority = userAuthority;
                                continue;
                            }
                            if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                            preferredAuthority = userAuthority;
                        }
                    }
                }
            }
            catch (SectioningException sectioningException) {
                // empty catch block
            }
            if (preferredAuthority == null && this.sessionContext.getUser().getCurrentAuthority() != null) {
                for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, this.sessionContext.getUser().getCurrentAuthority().getAcademicSession())) {
                    if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                    preferredAuthority = userAuthority;
                }
            }
            if (preferredAuthority != null) {
                this.sessionContext.getUser().setCurrentAuthority(preferredAuthority);
            }
        }
        if (this.sessionContext.hasPermission(Right.SchedulingDashboard)) {
            if (!this.sessionContext.hasPermission(Right.StudentSchedulingAdmin)) {
                Number myStudents = (Number)CourseOfferingDAO.getInstance().getSession().createQuery("select count(s) from Advisor a inner join a.students s where a.externalUniqueId = :user and a.role.reference = :role and a.session.uniqueId = :sessionId").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("user", this.sessionContext.getUser().getExternalUserId()).setString("role", this.sessionContext.getUser().getCurrentAuthority().getRole()).setCacheable(true).uniqueResult();
                response.sendRedirect("gwt.jsp?page=onlinesctdash" + (target == null ? "" : "&" + target) + (myStudents.intValue() > 0 ? "#mode:%22My%20Students%22@" : ""));
            } else {
                response.sendRedirect("gwt.jsp?page=onlinesctdash" + (target == null ? "" : "&" + target));
            }
            return null;
        }
        if ("Student".equals(this.sessionContext.getUser().getCurrentAuthority().getRole()) && (q = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Student")) != null && !q.isEmpty()) {
            StudentSectioningStatus status;
            Student student;
            UserQualifier studentQualifier = q.get(0);
            if (ApplicationProperty.StudentSchedulingPreferCourseRequests.isTrue()) {
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(false)) {
                        StudentSectioningStatus status2;
                        void var12_53;
                        if (!this.match(request, academicSessionInfo, useDefault)) continue;
                        Student student2 = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student2 == null) {
                            Student student3 = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (var12_53 == null || (status2 = var12_53.getEffectiveStatus()) == null || !status2.hasOption(StudentSectioningStatus.Option.regenabled)) continue;
                        response.sendRedirect("gwt.jsp?page=requests" + (target == null ? "" : "&" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(true)) {
                        OnlineSectioningServer onlineSectioningServer;
                        if (!this.match(request, academicSessionInfo, useDefault) || (onlineSectioningServer = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(academicSessionInfo.getSessionId().toString())) == null || !onlineSectioningServer.getAcademicSession().isSectioningEnabled()) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enrollment)) continue;
                        response.sendRedirect("gwt.jsp?page=sectioning" + (target == null ? "" : "&" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {}
            } else {
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(true)) {
                        OnlineSectioningServer onlineSectioningServer;
                        if (!this.match(request, academicSessionInfo, useDefault) || (onlineSectioningServer = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(academicSessionInfo.getSessionId().toString())) == null || !onlineSectioningServer.getAcademicSession().isSectioningEnabled()) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enrollment)) continue;
                        response.sendRedirect("gwt.jsp?page=sectioning" + (target == null ? "" : "&" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(false)) {
                        StudentSectioningStatus status2;
                        void var12_61;
                        if (!this.match(request, academicSessionInfo, useDefault)) continue;
                        Student student4 = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student4 == null) {
                            Student student5 = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (var12_61 == null || (status2 = var12_61.getEffectiveStatus()) == null || !status2.hasOption(StudentSectioningStatus.Option.regenabled)) continue;
                        response.sendRedirect("gwt.jsp?page=requests" + (target == null ? "" : "&" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
            }
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(true)) {
                if (!this.match(request, session, useDefault)) continue;
                response.sendRedirect("gwt.jsp?page=sectioning" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(false)) {
                if (!this.match(request, session, useDefault)) continue;
                response.sendRedirect("gwt.jsp?page=requests" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        response.sendRedirect("main.jsp");
        return null;
    }
}

