/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.CrossListsModifyForm;
import org.unitime.timetable.interfaces.ExternalCourseCrosslistAction;
import org.unitime.timetable.interfaces.ExternalCourseOfferingRemoveAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingInCrosslistAddAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/crossListsModify")
public class CrossListsModifyAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String deletedOffering;
        ActionErrors errors;
        String op;
        MessageResources rsc = this.getResources(request);
        CrossListsModifyForm frm = (CrossListsModifyForm)form;
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null) {
            op = request.getParameter("hdnOp");
        }
        if (op == null || op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + op);
        }
        String courseOfferingId = "";
        frm.setOp(op);
        LookupTables.setupCourseOfferings(request, this.sessionContext, new LookupTables.CourseFilter(){

            @Override
            public boolean accept(CourseOffering course) {
                return course.getInstructionalOffering().isNotOffered();
            }
        });
        if (op.equalsIgnoreCase(MSG.actionCrossLists())) {
            courseOfferingId = request.getParameter("uid") == null ? (request.getAttribute("uid") == null ? null : request.getAttribute("uid").toString()) : request.getParameter("uid");
            this.doLoad(frm, courseOfferingId);
        }
        if (op.equalsIgnoreCase(MSG.actionAddCourseToCrossList())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                Long addedOffering = frm.getAddCourseOfferingId();
                CourseOfferingDAO cdao = new CourseOfferingDAO();
                CourseOffering co = (CourseOffering)cdao.get(addedOffering);
                frm.addToCourseOfferings(co, this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) || this.sessionContext.getUser().getCurrentAuthority().hasQualifier(co.getDepartment()), true);
                frm.setAddCourseOfferingId(null);
            } else {
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.delete")) && (deletedOffering = request.getParameter("deletedCourseOfferingId")) != null && deletedOffering.trim().length() > 0) {
            frm.removeFromCourseOfferings(deletedOffering);
        }
        if (op.equalsIgnoreCase(MSG.actionUpdateCrossLists())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                this.doUpdate(request, frm);
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("instructionalOfferingDetail"));
                redirect.addParameter("io", (Object)frm.getInstrOfferingId());
                redirect.addParameter("op", (Object)"view");
                return redirect;
            }
            this.saveErrors(request, (ActionMessages)errors);
        }
        this.setReadOnlyCourseId(request, frm);
        this.filterCourseOfferingList(request, frm);
        return mapping.findForward("crossListsModify");
    }

    private void filterCourseOfferingList(HttpServletRequest request, CrossListsModifyForm frm) {
        List existingOfferings = frm.getCourseOfferingIds();
        Collection offerings = (Collection)request.getAttribute("crsOfferingList");
        Iterator i = offerings.iterator();
        while (i.hasNext()) {
            CourseOffering co = (CourseOffering)i.next();
            if (!co.getInstructionalOffering().isNotOffered().booleanValue() && !co.getInstructionalOffering().getInstrOfferingConfigs().isEmpty() || co.getInstructionalOffering().getCourseOfferings().size() > 1) {
                i.remove();
                continue;
            }
            for (String course : existingOfferings) {
                if (!course.equals(co.getUniqueId().toString())) continue;
                i.remove();
            }
        }
        request.setAttribute("crsOfferingList", (Object)offerings);
    }

    private void setReadOnlyCourseId(HttpServletRequest request, CrossListsModifyForm frm) {
        int ct = 0;
        String originalOfferings = frm.getOriginalOfferings();
        List courseOfferingIds = frm.getCourseOfferingIds();
        Iterator i = courseOfferingIds.iterator();
        while (i.hasNext()) {
            String cid = i.next().toString();
            if (originalOfferings.indexOf(cid) <= 0) continue;
            if ((ct = (int)((short)(ct + 1))) > 1) {
                frm.setReadOnlyCrsOfferingId(null);
                break;
            }
            frm.setReadOnlyCrsOfferingId(new Long(cid));
        }
        Debug.debug("Read Only Ctr Course: " + frm.getReadOnlyCrsOfferingId());
    }

    private void doUpdate(HttpServletRequest request, CrossListsModifyForm frm) throws Exception {
        List ids = frm.getCourseOfferingIds();
        String courseIds = Constants.arrayToStr(ids.toArray(), "", " ");
        String origCourseIds = frm.getOriginalOfferings();
        CourseOfferingDAO cdao = new CourseOfferingDAO();
        InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
        InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
        Session hibSession = idao.getSession();
        hibSession.setFlushMode(FlushMode.MANUAL);
        Transaction tx = null;
        HashMap<String, SubjectArea> saList = new HashMap<String, SubjectArea>();
        ArrayList<CurriculumCourse> cc = new ArrayList<CurriculumCourse>();
        ArrayList<CourseRequest> courseRequests = new ArrayList<CourseRequest>();
        try {
            Object addAction;
            String className;
            tx = hibSession.beginTransaction();
            StringTokenizer strTok = new StringTokenizer(origCourseIds);
            while (strTok.hasMoreTokens()) {
                String origCrs = strTok.nextToken();
                if (courseIds.indexOf(origCrs) < 0) {
                    Debug.debug("Course removed from offering: " + origCrs);
                    InstructionalOffering io1 = new InstructionalOffering();
                    CourseOffering co1 = (CourseOffering)cdao.get(new Long(origCrs.trim()));
                    this.sessionContext.checkPermission(co1, Right.CourseOfferingDeleteFromCrossList);
                    io1.setDemand(io.getDemand());
                    io1.setLimit(io.getLimit());
                    io1.setNotOffered(new Boolean(true));
                    io1.setSession(io.getSession());
                    io1.setByReservationOnly(io.getByReservationOnly());
                    CourseOffering courseOffering = (CourseOffering)co1.clone();
                    courseOffering.setIsControl(new Boolean(true));
                    for (CurriculumCourse x : hibSession.createQuery("from CurriculumCourse where course.uniqueId = :courseId").setLong("courseId", co1.getUniqueId().longValue()).list()) {
                        cc.add(x.clone(courseOffering));
                        x.getClassification().getCourses().remove(x);
                        hibSession.delete((Object)x);
                    }
                    if (ApplicationProperty.ModifyCrossListKeepCourseRequests.isTrue()) {
                        for (CourseRequest oldReq : hibSession.createQuery("from CourseRequest where courseOffering.uniqueId = :courseId").setLong("courseId", co1.getUniqueId().longValue()).list()) {
                            CourseRequest newReq = new CourseRequest();
                            newReq.setAllowOverlap(oldReq.getAllowOverlap());
                            newReq.setOrder(oldReq.getOrder());
                            newReq.setCredit(oldReq.getCredit());
                            newReq.setCourseOffering(courseOffering);
                            newReq.setCourseDemand(oldReq.getCourseDemand());
                            oldReq.getCourseDemand().getCourseRequests().remove(oldReq);
                            courseRequests.add(newReq);
                            hibSession.delete((Object)oldReq);
                        }
                    }
                    Set<CourseOffering> offerings = io.getCourseOfferings();
                    for (CourseOffering co3 : offerings) {
                        if (!co3.equals(co1)) continue;
                        SubjectArea sa = co3.getSubjectArea();
                        sa.getCourseOfferings().remove(co1);
                        hibSession.saveOrUpdate((Object)sa);
                        saList.put(sa.getSubjectAreaAbbreviation(), sa);
                    }
                    io.removeCourseOffering(co1);
                    Event.deleteFromEvents(hibSession, co1);
                    Exam.deleteFromExams(hibSession, co1);
                    className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
                    if (className != null && className.trim().length() > 0) {
                        ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).newInstance();
                        removeAction.performExternalCourseOfferingRemoveAction(co1, hibSession);
                    }
                    hibSession.delete((Object)co1);
                    hibSession.saveOrUpdate((Object)io);
                    hibSession.flush();
                    courseOffering.setInstructionalOffering(io1);
                    io1.addTocourseOfferings(courseOffering);
                    if (io1.getInstrOfferingPermId() == null) {
                        io1.generateInstrOfferingPermId();
                    }
                    hibSession.saveOrUpdate((Object)io1);
                    hibSession.flush();
                    hibSession.refresh((Object)io);
                    hibSession.refresh((Object)io1);
                    className = ApplicationProperty.ExternalActionInstructionalOfferingInCrosslistAdd.value();
                    if (className == null || className.trim().length() <= 0) continue;
                    addAction = (ExternalInstructionalOfferingInCrosslistAddAction)Class.forName(className).newInstance();
                    addAction.performExternalInstructionalOfferingInCrosslistAddAction(io1, hibSession);
                    continue;
                }
                Debug.debug("Updating controlling course  and course reservation: " + origCrs);
                CourseOffering co = (CourseOffering)cdao.get(new Long(origCrs));
                if (frm.getCtrlCrsOfferingId().equals(co.getUniqueId())) {
                    co.setIsControl(new Boolean(true));
                } else {
                    co.setIsControl(new Boolean(false));
                }
                int indx = frm.getIndex(origCrs);
                try {
                    co.setReservation(ids.size() > 1 ? Integer.valueOf(frm.getLimits(indx)) : null);
                }
                catch (NumberFormatException numberFormatException) {
                    co.setReservation(null);
                }
                hibSession.saveOrUpdate((Object)co);
                hibSession.flush();
                hibSession.refresh((Object)co);
            }
            Vector<CourseOffering> addedOfferings = new Vector<CourseOffering>();
            StringTokenizer strTok2 = new StringTokenizer(courseIds);
            while (strTok2.hasMoreTokens()) {
                String course = strTok2.nextToken();
                if (origCourseIds.indexOf(course) >= 0) continue;
                Debug.debug("Course added to offering: " + course);
                CourseOffering courseOffering = (CourseOffering)cdao.get(new Long(course.trim()));
                InstructionalOffering io1 = courseOffering.getInstructionalOffering();
                SubjectArea sa = io1.getControllingCourseOffering().getSubjectArea();
                Set<CourseOffering> offerings = io1.getCourseOfferings();
                for (CourseOffering co2 : offerings) {
                    SubjectArea sa2 = co2.getSubjectArea();
                    CourseOffering co3 = (CourseOffering)co2.clone();
                    if (frm.getCtrlCrsOfferingId().equals(co2.getUniqueId())) {
                        co3.setIsControl(new Boolean(true));
                    } else {
                        co3.setIsControl(new Boolean(false));
                    }
                    for (CurriculumCourse x : hibSession.createQuery("from CurriculumCourse where course.uniqueId = :courseId").setLong("courseId", co2.getUniqueId().longValue()).list()) {
                        cc.add(x.clone(co3));
                        x.getClassification().getCourses().remove(x);
                        hibSession.delete((Object)x);
                    }
                    if (ApplicationProperty.ModifyCrossListKeepCourseRequests.isTrue()) {
                        for (CourseRequest oldReq : hibSession.createQuery("from CourseRequest where courseOffering.uniqueId = :courseId").setLong("courseId", co2.getUniqueId().longValue()).list()) {
                            CourseRequest newReq = new CourseRequest();
                            newReq.setAllowOverlap(oldReq.getAllowOverlap());
                            newReq.setOrder(oldReq.getOrder());
                            newReq.setCredit(oldReq.getCredit());
                            newReq.setCourseOffering(co3);
                            newReq.setCourseDemand(oldReq.getCourseDemand());
                            oldReq.getCourseDemand().getCourseRequests().remove(oldReq);
                            courseRequests.add(newReq);
                            hibSession.delete((Object)oldReq);
                        }
                    }
                    addedOfferings.addElement(co3);
                    int indx = frm.getIndex(course);
                    try {
                        co3.setReservation(Integer.valueOf(frm.getLimits(indx)));
                    }
                    catch (NumberFormatException e) {
                        co3.setReservation(null);
                    }
                    sa2.getCourseOfferings().remove(co2);
                    hibSession.saveOrUpdate((Object)sa2);
                    saList.put(sa2.getSubjectAreaAbbreviation(), sa2);
                    io1.removeCourseOffering(co2);
                    Event.deleteFromEvents(hibSession, co2);
                    Exam.deleteFromExams(hibSession, co2);
                    String className2 = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
                    if (className2 != null && className2.trim().length() > 0) {
                        ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className2).newInstance();
                        removeAction.performExternalCourseOfferingRemoveAction(co2, hibSession);
                    }
                    hibSession.delete((Object)co2);
                    hibSession.flush();
                }
                Event.deleteFromEvents(hibSession, io1);
                Exam.deleteFromExams(hibSession, io1);
                hibSession.delete((Object)io1);
                hibSession.flush();
                hibSession.saveOrUpdate((Object)sa);
                saList.put(sa.getSubjectAreaAbbreviation(), sa);
            }
            hibSession.flush();
            for (int i = 0; i < addedOfferings.size(); ++i) {
                CourseOffering courseOffering = (CourseOffering)addedOfferings.elementAt(i);
                courseOffering.setInstructionalOffering(io);
                io.addTocourseOfferings(courseOffering);
                hibSession.saveOrUpdate((Object)courseOffering);
                hibSession.flush();
                hibSession.refresh((Object)courseOffering);
                hibSession.saveOrUpdate((Object)io);
            }
            for (CurriculumCourse curriculumCourse : cc) {
                hibSession.saveOrUpdate((Object)curriculumCourse);
            }
            for (CourseRequest courseRequest : courseRequests) {
                courseRequest.getCourseDemand().getCourseRequests().add(courseRequest);
                hibSession.saveOrUpdate((Object)courseRequest);
            }
            Department dept = io.getControllingCourseOffering().getDepartment();
            Set<InstrOfferingConfig> set = io.getInstrOfferingConfigs();
            for (InstrOfferingConfig cfg : set) {
                Set<SchedulingSubpart> subparts = cfg.getSchedulingSubparts();
                for (SchedulingSubpart subpart : subparts) {
                    Set<Class_> classes = subpart.getClasses();
                    for (Class_ cls : classes) {
                        if (cls.getManagingDept().isExternalManager().booleanValue()) continue;
                        cls.setManagingDept(dept, this.sessionContext.getUser(), hibSession);
                        hibSession.saveOrUpdate((Object)cls);
                    }
                }
            }
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.CROSS_LIST, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            hibSession.flush();
            hibSession.clear();
            hibSession.refresh((Object)io);
            for (InstrOfferingConfig cfg : io.getInstrOfferingConfigs()) {
                for (SchedulingSubpart ss : cfg.getSchedulingSubparts()) {
                    for (Class_ c : ss.getClasses()) {
                        hibSession.refresh((Object)c);
                    }
                    hibSession.refresh((Object)ss);
                }
            }
            Set keys = saList.keySet();
            Iterator i1 = keys.iterator();
            while (i1.hasNext()) {
                hibSession.refresh(saList.get(i1.next()));
            }
            className = ApplicationProperty.ExternalActionCourseCrosslist.value();
            if (className != null && className.trim().length() > 0) {
                addAction = (ExternalCourseCrosslistAction)Class.forName(className).newInstance();
                addAction.performExternalCourseCrosslistAction(io, hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void doLoad(CrossListsModifyForm frm, String courseOfferingId) throws Exception {
        if (courseOfferingId == null || courseOfferingId.trim().length() == 0) {
            throw new Exception(MSG.errorUniqueIdNeeded());
        }
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        CourseOffering co = (CourseOffering)coDao.get(Long.valueOf(courseOfferingId));
        InstructionalOffering io = co.getInstructionalOffering();
        this.sessionContext.checkPermission(io, Right.InstructionalOfferingCrossLists);
        ArrayList<CourseOffering> offerings = new ArrayList<CourseOffering>(io.getCourseOfferings());
        Collections.sort(offerings, new CourseOfferingComparator(2));
        frm.setInstrOfferingId(io.getUniqueId());
        frm.setCtrlCrsOfferingId(io.getControllingCourseOffering().getUniqueId());
        frm.setReadOnlyCrsOfferingId(null);
        frm.setSubjectAreaId(co.getSubjectArea().getUniqueId());
        frm.setInstrOfferingName(io.getCourseNameWithTitle());
        frm.setOwnedInstrOffr(true);
        frm.setIoLimit(io.getLimit());
        frm.setUnlimited(io.hasUnlimitedEnrollment());
        for (CourseOffering co1 : offerings) {
            frm.addToCourseOfferings(co1, this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) || this.sessionContext.getUser().getCurrentAuthority().hasQualifier(co1.getDepartment()), this.sessionContext.hasPermission(co1, Right.CourseOfferingDeleteFromCrossList));
            frm.addToOriginalCourseOfferings(co1);
        }
    }
}

