/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceDates
extends ICalProperty {
    private List<ICalDate> dates = new ArrayList<ICalDate>();
    private List<Period> periods = new ArrayList<Period>();

    public List<ICalDate> getDates() {
        return this.dates;
    }

    public void addDate(ICalDate date) {
        this.dates.add(date);
    }

    public void addDate(Date date) {
        this.addDate(new ICalDate(date, true));
    }

    public List<Period> getPeriods() {
        return this.periods;
    }

    public void addPeriod(Period period) {
        this.periods.add(period);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        if (this.dates.isEmpty() && this.periods.isEmpty()) {
            warnings.add(Warning.validate(26, new Object[0]));
        }
        if (!this.dates.isEmpty() && !this.periods.isEmpty()) {
            warnings.add(Warning.validate(49, new Object[0]));
        }
        if (version == ICalVersion.V1_0 && !this.periods.isEmpty()) {
            warnings.add(Warning.validate(51, new Object[0]));
        }
        if (!this.dates.isEmpty()) {
            boolean hasTime = this.dates.get(0).hasTime();
            for (ICalDate date : this.dates.subList(1, this.dates.size())) {
                if (date.hasTime() == hasTime) continue;
                warnings.add(Warning.validate(50, new Object[0]));
                break;
            }
        }
    }
}

