/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.TextProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumProperty
extends TextProperty {
    public EnumProperty(String value) {
        super(value);
    }

    protected boolean is(String value) {
        return value.equalsIgnoreCase((String)this.value);
    }

    protected abstract Collection<String> getStandardValues(ICalVersion var1);

    protected Collection<ICalVersion> getValueSupportedVersions() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(ICalVersion.values());
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        super.validate(components, version, warnings);
        if (this.value == null) {
            return;
        }
        Collection<ICalVersion> supportedVersions = this.getValueSupportedVersions();
        if (supportedVersions.isEmpty()) {
            warnings.add(Warning.validate(28, this.value, this.getStandardValues(version)));
            return;
        }
        boolean supported = supportedVersions.contains((Object)version);
        if (!supported) {
            warnings.add(Warning.validate(46, this.value, supportedVersions));
        }
    }
}

