/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.DataModelConverter;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.io.scribe.property.RecurrencePropertyScribe;
import biweekly.io.text.ICalParseException;
import biweekly.io.text.ICalRawReader;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.AudioAlarm;
import biweekly.property.DisplayAlarm;
import biweekly.property.EmailAlarm;
import biweekly.property.ICalProperty;
import biweekly.property.ProcedureAlarm;
import biweekly.util.IOUtils;
import biweekly.util.org.apache.commons.codec.DecoderException;
import biweekly.util.org.apache.commons.codec.net.QuotedPrintableCodec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ICalReader
extends StreamReader {
    private static final String icalComponentName = ScribeIndex.getICalendarScribe().getComponentName();
    private final ICalRawReader reader;
    private Charset defaultQuotedPrintableCharset;

    public ICalReader(String str) {
        this(new StringReader(str));
    }

    public ICalReader(InputStream in) {
        this(IOUtils.utf8Reader(in));
    }

    public ICalReader(File file) throws FileNotFoundException {
        this(IOUtils.utf8Reader(file));
    }

    public ICalReader(Reader reader) {
        this.reader = new ICalRawReader(reader);
        this.defaultQuotedPrintableCharset = this.reader.getEncoding();
        if (this.defaultQuotedPrintableCharset == null) {
            this.defaultQuotedPrintableCharset = Charset.defaultCharset();
        }
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public Charset getDefaultQuotedPrintableCharset() {
        return this.defaultQuotedPrintableCharset;
    }

    public void setDefaultQuotedPrintableCharset(Charset charset) {
        this.defaultQuotedPrintableCharset = charset;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected ICalendar _readNext() throws IOException {
        ical = null;
        values = new ArrayList<String>();
        stack = new ComponentStack();
        block7: while (true) {
            try {
                line = this.reader.readLine();
            }
            catch (ICalParseException e) {
                this.warnings.add(this.reader.getLineNum(), null, 3, new Object[]{e.getLine()});
                continue;
            }
            if (line == null) break;
            this.context.setVersion(this.reader.getVersion());
            propertyName = line.getName();
            if ("BEGIN".equalsIgnoreCase(propertyName)) {
                componentName = line.getValue();
                if (ical == null && !ICalReader.icalComponentName.equalsIgnoreCase(componentName)) continue;
                parentComponent = stack.peek();
                scribe = this.index.getComponentScribe(componentName, this.reader.getVersion());
                component = scribe.emptyInstance();
                stack.push(component, componentName);
                if (parentComponent == null) {
                    ical = (ICalendar)component;
                    continue;
                }
                parentComponent.addComponent(component);
                continue;
            }
            if (ical == null) continue;
            if ("END".equalsIgnoreCase(propertyName)) {
                componentName = line.getValue();
                if (ICalReader.icalComponentName.equalsIgnoreCase(componentName)) break;
                found = stack.popThrough(componentName);
                if (found) continue;
                this.warnings.add(this.reader.getLineNum(), "END", 2, new Object[0]);
                continue;
            }
            parameters = line.getParameters();
            value = line.getValue();
            scribe = this.index.getPropertyScribe(propertyName, this.reader.getVersion());
            this.processNamelessParameters(parameters, propertyName);
            if (parameters.getEncoding() == Encoding.QUOTED_PRINTABLE) {
                try {
                    value = this.decodeQuotedPrintableValue(propertyName, parameters.getCharset(), value);
                }
                catch (DecoderException e) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, 31, new Object[]{e.getMessage()});
                }
                parameters.setEncoding(null);
            }
            if ((dataType = parameters.getValue()) == null) {
                dataType = scribe.defaultDataType(this.reader.getVersion());
            } else {
                parameters.setValue(null);
            }
            values.clear();
            if (this.reader.getVersion() == ICalVersion.V1_0 && scribe instanceof RecurrencePropertyScribe) {
                p = Pattern.compile("#\\d+|\\d{8}T\\d{6}Z?");
                m = p.matcher(value);
                prevIndex = 0;
                while (m.find()) {
                    end = m.end() + 1;
                    subValue = value.substring(prevIndex, end).trim();
                    values.add(subValue);
                    prevIndex = end;
                }
                subValue = value.substring(prevIndex).trim();
                if (subValue.length() > 0) {
                    values.add(subValue);
                }
            } else {
                values.add(value);
            }
            this.context.getWarnings().clear();
            propertiesToAdd = new ArrayList<Object>();
            componentsToAdd = new ArrayList<E>();
            for (String v : values) {
                try {
                    property = scribe.parseText(v, dataType, parameters, this.context);
                    propertiesToAdd.add(property);
                }
                catch (SkipMeException e) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, 0, new Object[]{e.getMessage()});
                }
                catch (CannotParseException e) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, 1, new Object[]{v, e.getMessage()});
                    property /* !! */  = new RawPropertyScribe(propertyName).parseText(v, dataType, parameters, this.context);
                    propertiesToAdd.add(property /* !! */ );
                }
            }
            parentComponent = stack.peek();
            isVCal = this.reader.getVersion() == null || this.reader.getVersion() == ICalVersion.V1_0;
            for (ICalProperty property : propertiesToAdd) {
                for (Warning warning : this.context.getWarnings()) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, warning);
                }
                if (isVCal) {
                    obj = this.convertVCalProperty(property /* !! */ );
                    if (obj instanceof ICalComponent) {
                        parentComponent.addComponent((ICalComponent)obj);
                        continue;
                    }
                    if (obj instanceof ICalProperty) {
                        property /* !! */  = (ICalProperty)obj;
                    }
                }
                parentComponent.addProperty(property /* !! */ );
            }
            i$ = componentsToAdd.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block7;
                result = (ICalPropertyScribe.Result)i$.next();
                for (Warning warning : result.getWarnings()) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, warning);
                }
                parentComponent.addComponent((ICalComponent)result.getProperty());
            }
            break;
        }
        return ical;
    }

    private void processNamelessParameters(ICalParameters parameters, String propertyName) {
        List namelessParamValues = parameters.removeAll(null);
        if (namelessParamValues.isEmpty()) {
            return;
        }
        if (this.reader.getVersion() != ICalVersion.V1_0) {
            this.warnings.add(this.reader.getLineNum(), propertyName, 4, namelessParamValues);
        }
        for (String paramValue : namelessParamValues) {
            String paramName = this.guessParameterName(paramValue);
            parameters.put(paramName, paramValue);
        }
    }

    private String guessParameterName(String value) {
        if (ICalDataType.find(value) != null) {
            return "VALUE";
        }
        if (Encoding.find(value) != null) {
            return "ENCODING";
        }
        return "TYPE";
    }

    private String decodeQuotedPrintableValue(String propertyName, String charsetParam, String value) throws DecoderException {
        Charset charset = null;
        if (charsetParam == null) {
            charset = this.defaultQuotedPrintableCharset;
        } else {
            try {
                charset = Charset.forName(charsetParam);
            }
            catch (Throwable t) {
                charset = this.defaultQuotedPrintableCharset;
                this.warnings.add(this.reader.getLineNum(), propertyName, 32, charsetParam, charset.name());
            }
        }
        QuotedPrintableCodec codec = new QuotedPrintableCodec(charset.name());
        return codec.decode(value);
    }

    private Object convertVCalProperty(ICalProperty property) {
        if (property instanceof Attendee) {
            Attendee attendee = (Attendee)property;
            return attendee.getRole() == Role.ORGANIZER ? DataModelConverter.convert(attendee) : property;
        }
        if (property instanceof AudioAlarm) {
            AudioAlarm aalarm = (AudioAlarm)property;
            return DataModelConverter.convert(aalarm);
        }
        if (property instanceof DisplayAlarm) {
            DisplayAlarm dalarm = (DisplayAlarm)property;
            return DataModelConverter.convert(dalarm);
        }
        if (property instanceof EmailAlarm) {
            EmailAlarm malarm = (EmailAlarm)property;
            return DataModelConverter.convert(malarm);
        }
        if (property instanceof ProcedureAlarm) {
            ProcedureAlarm palarm = (ProcedureAlarm)property;
            return DataModelConverter.convert(palarm);
        }
        return property;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private static class ComponentStack {
        private final List<ICalComponent> components = new ArrayList<ICalComponent>();
        private final List<String> names = new ArrayList<String>();

        private ComponentStack() {
        }

        public ICalComponent peek() {
            return this.components.isEmpty() ? null : this.components.get(this.components.size() - 1);
        }

        public void push(ICalComponent component, String name) {
            this.components.add(component);
            this.names.add(name);
        }

        public boolean popThrough(String name) {
            for (int i = this.components.size() - 1; i >= 0; --i) {
                String curName = this.names.get(i);
                if (!curName.equalsIgnoreCase(name)) continue;
                this.components.subList(i, this.components.size()).clear();
                this.names.subList(i, this.names.size()).clear();
                return true;
            }
            return false;
        }
    }
}

