/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class CriticalCoursesTable
implements StudentSectioningReport {
    private StudentSectioningModel iModel = null;

    public CriticalCoursesTable(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("__Student"), new CSVFile.CSVField("Student"), new CSVFile.CSVField("Priority"), new CSVFile.CSVField("Course"), new CSVFile.CSVField("1st Alt"), new CSVFile.CSVField("2nd Alt"), new CSVFile.CSVField("Enrolled"), new CSVFile.CSVField("Choice")});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int priority = 0;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                ++priority;
                if (!cr.isCritical() || cr.isAlternative()) continue;
                Enrollment e = cr.getAssignment(assignment);
                Course course = cr.getCourses().get(0);
                Course alt1 = cr.getCourses().size() < 2 ? null : cr.getCourses().get(1);
                Course alt2 = cr.getCourses().size() < 3 ? null : cr.getCourses().get(2);
                Course enrolled = e == null ? null : e.getCourse();
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField(student.getExternalId()), new CSVFile.CSVField(priority), new CSVFile.CSVField(course.getName()), new CSVFile.CSVField(alt1 == null ? "" : alt1.getName()), new CSVFile.CSVField(alt2 == null ? "" : alt2.getName()), new CSVFile.CSVField(enrolled == null ? "" : enrolled.getName()), new CSVFile.CSVField(enrolled == null ? "" : String.valueOf(cr.getCourses().indexOf(enrolled) + 1))});
            }
        }
        return csv;
    }
}

