/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.OnlineSectioningCriterion;

public class EqualWeightCriterion
extends OnlineSectioningCriterion {
    public EqualWeightCriterion(Student student, OnlineSectioningModel model, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> preferredSections) {
        super(student, model, assignment, preferredSections);
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int idx;
        int x;
        int bestTimeOverlaps;
        if (best == null) {
            return -1;
        }
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        for (int idx2 = 0; idx2 < current.length; ++idx2) {
            if (current[idx2] != null && current[idx2].getAssignments() != null) {
                ++currentAssignedRequests;
                if (current[idx2].isCourseRequest()) {
                    ++currentAssignedCourseReq;
                }
                currentAssignedPriority += current[idx2].getPriority() * current[idx2].getPriority();
                currentAssignedAlternativity += current[idx2].getRequest().isAlternative() ? 1 : 0;
            }
            if (best[idx2] == null || best[idx2].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx2].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx2].getPriority() * best[idx2].getPriority();
            bestAssignedAlternativity += best[idx2].getRequest().isAlternative() ? 1 : 0;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return -1;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return 1;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return -1;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return 1;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return -1;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return 1;
        }
        int bestNotAvailable = 0;
        int currentNotAvailable = 0;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (best[idx3] != null && best[idx3].getAssignments() != null && best[idx3].getRequest() instanceof CourseRequest && best[idx3].getReservation() != null && best[idx3].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx3].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++bestNotAvailable;
                }
            }
            if (current[idx3] == null || current[idx3].getAssignments() == null || !(current[idx3].getRequest() instanceof CourseRequest) || current[idx3].getReservation() == null || !current[idx3].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx3].getSections()) {
                if (section.getLimit() != 0) continue;
                ++currentNotAvailable;
            }
        }
        if (bestNotAvailable > currentNotAvailable) {
            return -1;
        }
        if (bestNotAvailable < currentNotAvailable) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx4;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx4 = 0; idx4 < current.length; ++idx4) {
                if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx4; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx4]);
                    }
                }
                if (current[idx4] == null || current[idx4].getAssignments() == null || !(current[idx4].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx4; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx4]);
                }
            }
            for (idx4 = 0; idx4 < current.length; ++idx4) {
                if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx4]);
                }
                if (current[idx4] == null || current[idx4].getAssignments() == null || !current[idx4].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx4]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx5;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx5; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx5]);
                    }
                }
                if (current[idx5] == null || current[idx5].getAssignments() == null || !(current[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx5; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx5]);
                }
                if (current[idx5] == null || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx6 = 0; idx6 < current.length; ++idx6) {
            if (best[idx6] != null && best[idx6].getAssignments() != null && best[idx6].isCourseRequest()) {
                for (Section section : best[idx6].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, best, idx6, section, best[idx6].getRequest());
                }
            }
            if (current[idx6] == null || current[idx6].getAssignments() == null || !current[idx6].isCourseRequest()) continue;
            for (Section section : current[idx6].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx6, section, current[idx6].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return -1;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return 1;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            Set<Section> preferred = this.getPreferredSections(this.getRequest(idx7));
            if (preferred == null || preferred.isEmpty()) continue;
            if (best[idx7] != null && best[idx7].getAssignments() != null && best[idx7].isCourseRequest()) {
                for (Section section : best[idx7].getSections()) {
                    if (!preferred.contains(section)) continue;
                    ++bestSelected;
                }
            }
            if (current[idx7] == null || current[idx7].getAssignments() == null || !current[idx7].isCourseRequest()) continue;
            for (Section section : current[idx7].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return -1;
        }
        if (bestSelected > currentSelected) {
            return 1;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            if (best[idx8] != null && best[idx8].getAssignments() != null && best[idx8].isCourseRequest()) {
                bestSelectedSections += best[idx8].percentSelectedSameSection();
                bestSelectedConfigs += best[idx8].percentSelectedSameConfig();
            }
            if (current[idx8] == null || current[idx8].getAssignments() == null || !current[idx8].isCourseRequest()) continue;
            currentSelectedSections += current[idx8].percentSelectedSameSection();
            currentSelectedConfigs += current[idx8].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return -1;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (idx = 0; idx < current.length; ++idx) {
                    int x2;
                    if (best[idx] != null && best[idx].getAssignments() != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx]);
                        for (x2 = 0; x2 < idx; ++x2) {
                            if (best[x2] == null || best[x2].getAssignments() == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx]);
                        }
                    }
                    if (current[idx] == null || current[idx].getAssignments() == null) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx]);
                    for (x2 = 0; x2 < idx; ++x2) {
                        if (current[x2] == null || current[x2].getAssignments() == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return -1;
            }
            if (bestQuality < currentQuality) {
                return 1;
            }
        } else {
            int x3;
            int idx9;
            if (this.getModel().getTimeOverlaps() != null) {
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null && best[idx9].getAssignments() != null) {
                        for (x3 = 0; x3 < idx9; ++x3) {
                            if (best[x3] != null && best[x3].getAssignments() != null) {
                                bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx9]);
                                continue;
                            }
                            if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx9]);
                        }
                    }
                    if (current[idx9] == null || current[idx9].getAssignments() == null) continue;
                    for (x3 = 0; x3 < idx9; ++x3) {
                        if (current[x3] != null && current[x3].getAssignments() != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx9]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx9]);
                    }
                }
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null && best[idx9].getAssignments() != null && best[idx9].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx9]);
                    }
                    if (current[idx9] == null || current[idx9].getAssignments() == null || !current[idx9].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx9]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return -1;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return 1;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null && best[idx9].getAssignments() != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx9]);
                        for (x3 = 0; x3 < idx9; ++x3) {
                            if (best[x3] == null || best[x3].getAssignments() == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx9]);
                        }
                    }
                    if (current[idx9] == null || current[idx9].getAssignments() == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx9]);
                    for (x3 = 0; x3 < idx9; ++x3) {
                        if (current[x3] == null || current[x3].getAssignments() == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx9]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return -1;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return 1;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (int idx10 = 0; idx10 < current.length; ++idx10) {
            if (best[idx10] != null && best[idx10].getAssignments() != null) {
                for (Section section : best[idx10].getSections()) {
                    if (section.getTime() != null) continue;
                    ++bestNoTime;
                }
            }
            if (current[idx10] == null || current[idx10].getAssignments() == null) continue;
            for (Section section : current[idx10].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return -1;
        }
        if (bestNoTime < currentNoTime) {
            return 1;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return -1;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return 1;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx11 = 0; idx11 < current.length; ++idx11) {
            if (best[idx11] != null && best[idx11].getAssignments() != null) {
                for (Section section : best[idx11].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx11].getSections().size();
                }
            }
            if (current[idx11] == null || current[idx11].getAssignments() == null) continue;
            for (Section section : current[idx11].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx11].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return -1;
        }
        if (bestPenalty < currentPenalty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int idx;
        int x;
        int bestTimeOverlaps;
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        int alt = 0;
        for (int idx2 = 0; idx2 < current.length; ++idx2) {
            if (idx2 < maxIdx) {
                if (current[idx2] != null && current[idx2].getAssignments() != null) {
                    ++currentAssignedRequests;
                    if (current[idx2].isCourseRequest()) {
                        ++currentAssignedCourseReq;
                    }
                    currentAssignedPriority += current[idx2].getPriority() * current[idx2].getPriority();
                    currentAssignedAlternativity += current[idx2].getRequest().isAlternative() ? 1 : 0;
                } else if (!this.isFreeTime(idx2) && !this.getRequest(idx2).isAlternative()) {
                    ++alt;
                }
            } else if (!this.getRequest(idx2).isAlternative()) {
                ++currentAssignedRequests;
                if (!this.isFreeTime(idx2)) {
                    ++currentAssignedCourseReq;
                }
            } else if (alt > 0) {
                ++currentAssignedRequests;
                ++currentAssignedCourseReq;
                --alt;
                ++currentAssignedAlternativity;
            }
            if (best[idx2] == null || best[idx2].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx2].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx2].getPriority() * best[idx2].getPriority();
            bestAssignedAlternativity += best[idx2].getRequest().isAlternative() ? 1 : 0;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return true;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return false;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return true;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return false;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return true;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return false;
        }
        int notAvailable = 0;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (best[idx3] != null && best[idx3].getAssignments() != null && best[idx3].getRequest() instanceof CourseRequest && best[idx3].getReservation() != null && best[idx3].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx3].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++notAvailable;
                }
            }
            if (idx3 >= maxIdx || current[idx3] == null || current[idx3].getAssignments() == null || !(current[idx3].getRequest() instanceof CourseRequest) || current[idx3].getReservation() == null || !current[idx3].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx3].getSections()) {
                if (section.getLimit() != 0) continue;
                --notAvailable;
            }
        }
        if (notAvailable > 0) {
            return true;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx4;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx4 = 0; idx4 < current.length; ++idx4) {
                if (best[idx4] != null && best[idx4].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx4; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx4]);
                    }
                }
                if (current[idx4] == null || idx4 >= maxIdx || !(current[idx4].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx4; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx4]);
                }
            }
            for (idx4 = 0; idx4 < current.length; ++idx4) {
                if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx4]);
                }
                if (current[idx4] == null || idx4 >= maxIdx || current[idx4].getAssignments() == null || !current[idx4].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx4]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx5;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx5; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx5]);
                    }
                }
                if (current[idx5] == null || idx5 >= maxIdx || !(current[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx5; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx5]);
                }
                if (current[idx5] == null || idx5 >= maxIdx || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx6 = 0; idx6 < current.length; ++idx6) {
            if (best[idx6] != null) {
                for (Section section : best[idx6].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, best, idx6, section, best[idx6].getRequest());
                }
            }
            if (current[idx6] == null || idx6 >= maxIdx) continue;
            for (Section section : current[idx6].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx6, section, current[idx6].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return true;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return false;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            Set<Section> preferred;
            if (best[idx7] != null && best[idx7].isCourseRequest() && (preferred = this.getPreferredSections(best[idx7].getRequest())) != null && !preferred.isEmpty()) {
                for (Section section : best[idx7].getSections()) {
                    if (preferred.contains(section)) {
                        if (idx7 >= maxIdx) continue;
                        ++bestSelected;
                        continue;
                    }
                    if (idx7 < maxIdx) continue;
                    --bestSelected;
                }
            }
            if (current[idx7] == null || idx7 >= maxIdx || !current[idx7].isCourseRequest() || (preferred = this.getPreferredSections(current[idx7].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : current[idx7].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return true;
        }
        if (bestSelected > currentSelected) {
            return false;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            if (best[idx8] != null && best[idx8].getAssignments() != null && best[idx8].isCourseRequest()) {
                bestSelectedSections += best[idx8].percentSelectedSameSection();
                bestSelectedConfigs += best[idx8].percentSelectedSameConfig();
                if (idx8 >= maxIdx) {
                    bestSelectedSections -= 1.0;
                    bestSelectedConfigs -= 1.0;
                }
            }
            if (current[idx8] == null || idx8 >= maxIdx || current[idx8].getAssignments() == null || !current[idx8].isCourseRequest()) continue;
            currentSelectedSections += current[idx8].percentSelectedSameSection();
            currentSelectedConfigs += current[idx8].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return true;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return false;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (idx = 0; idx < current.length; ++idx) {
                    int x2;
                    if (best[idx] != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx]);
                        for (x2 = 0; x2 < idx; ++x2) {
                            if (best[x2] == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx]);
                        }
                    }
                    if (current[idx] == null || idx >= maxIdx) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx]);
                    for (x2 = 0; x2 < idx; ++x2) {
                        if (current[x2] == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return true;
            }
            if (bestQuality < currentQuality) {
                return false;
            }
        } else {
            int x3;
            int idx9;
            if (this.getModel().getTimeOverlaps() != null) {
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null) {
                        for (x3 = 0; x3 < idx9; ++x3) {
                            if (best[x3] != null) {
                                bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx9]);
                                continue;
                            }
                            if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx9]);
                        }
                    }
                    if (current[idx9] == null || idx9 >= maxIdx) continue;
                    for (x3 = 0; x3 < idx9; ++x3) {
                        if (current[x3] != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx9]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx9]);
                    }
                }
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null && best[idx9].getAssignments() != null && best[idx9].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx9]);
                    }
                    if (current[idx9] == null || idx9 >= maxIdx || current[idx9].getAssignments() == null || !current[idx9].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx9]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return true;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return false;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (idx9 = 0; idx9 < current.length; ++idx9) {
                    if (best[idx9] != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx9]);
                        for (x3 = 0; x3 < idx9; ++x3) {
                            if (best[x3] == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx9]);
                        }
                    }
                    if (current[idx9] == null || idx9 >= maxIdx) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx9]);
                    for (x3 = 0; x3 < idx9; ++x3) {
                        if (current[x3] == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx9]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return true;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return false;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (int idx10 = 0; idx10 < current.length; ++idx10) {
            if (best[idx10] != null) {
                for (Section section : best[idx10].getSections()) {
                    if (section.getTime() != null) continue;
                    ++bestNoTime;
                }
            }
            if (current[idx10] == null || idx10 >= maxIdx) continue;
            for (Section section : current[idx10].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return true;
        }
        if (bestNoTime < currentNoTime) {
            return false;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return true;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return false;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx11 = 0; idx11 < current.length; ++idx11) {
            if (best[idx11] != null) {
                for (Section section : best[idx11].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx11].getSections().size();
                }
                if (idx11 >= maxIdx && best[idx11].isCourseRequest()) {
                    bestPenalty -= ((CourseRequest)best[idx11].getRequest()).getMinPenalty();
                }
            }
            if (current[idx11] == null || idx11 >= maxIdx) continue;
            for (Section section : current[idx11].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx11].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return true;
        }
        return !(bestPenalty < currentPenalty);
    }
}

