/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.reservation.Reservation;

public class Subpart
implements Comparable<Subpart> {
    private long iId = -1L;
    private String iInstructionalType = null;
    private String iName = null;
    private List<Section> iSections = new ArrayList<Section>();
    private Config iConfig = null;
    private Subpart iParent = null;
    private boolean iAllowOverlap = false;
    private String iCredit = null;
    private Float iCreditValue = null;
    private List<Reservation> iSectionReservations = null;
    private Integer iLimit = null;

    public Subpart(long id, String itype, String name, Config config, Subpart parent) {
        this.iId = id;
        this.iInstructionalType = itype;
        this.iName = name;
        this.iConfig = config;
        this.iParent = parent;
        this.iConfig.getSubparts().add(this);
    }

    public long getId() {
        return this.iId;
    }

    public String getInstructionalType() {
        return this.iInstructionalType;
    }

    public String getName() {
        return this.iName;
    }

    public Config getConfig() {
        return this.iConfig;
    }

    public List<Section> getSections() {
        return this.iSections;
    }

    public Subpart getParent() {
        return this.iParent;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isParentOf(Subpart subpart) {
        if (subpart.getParent() == null) {
            return false;
        }
        if (subpart.getParent().equals(this)) {
            return true;
        }
        return this.isParentOf(subpart.getParent());
    }

    @Override
    public int compareTo(Subpart s) {
        if (this.isParentOf(s)) {
            return -1;
        }
        if (s.isParentOf(this)) {
            return 1;
        }
        int cmp = this.getInstructionalType().compareTo(s.getInstructionalType());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), s.getId());
    }

    public Set<Choice> getChoices() {
        HashSet<Choice> choices = new HashSet<Choice>();
        for (Section section : this.getSections()) {
            choices.add(new Choice(section));
        }
        return choices;
    }

    public double getMinPenalty() {
        double min = Double.MAX_VALUE;
        for (Section section : this.getSections()) {
            min = Math.min(min, section.getPenalty());
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMaxPenalty() {
        double max = Double.MIN_VALUE;
        for (Section section : this.getSections()) {
            max = Math.max(max, section.getPenalty());
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public List<Subpart> getChildren() {
        ArrayList<Subpart> ret = new ArrayList<Subpart>(this.getConfig().getSubparts().size());
        for (Subpart s : this.getConfig().getSubparts()) {
            if (!this.equals(s.getParent())) continue;
            ret.add(s);
        }
        return ret;
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public void setAllowOverlap(boolean allowOverlap) {
        this.iAllowOverlap = allowOverlap;
    }

    public synchronized List<Reservation> getSectionReservations() {
        if (this.iSectionReservations == null) {
            this.iSectionReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getConfig().getOffering().getReservations()) {
                if (r.getSections(this) == null) continue;
                this.iSectionReservations.add(r);
            }
        }
        return this.iSectionReservations;
    }

    public synchronized void clearReservationCache() {
        for (Section s : this.getSections()) {
            s.clearReservationCache();
        }
        this.iSectionReservations = null;
    }

    public int getLimit() {
        if (this.iLimit == null) {
            this.iLimit = this.getLimitNoCache();
        }
        return this.iLimit;
    }

    private int getLimitNoCache() {
        int limit = 0;
        for (Section section : this.getSections()) {
            if (section.getLimit() < 0) {
                return -1;
            }
            limit += section.getLimit();
        }
        return limit;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Subpart)) {
            return false;
        }
        return this.getId() == ((Subpart)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public void setCredit(String credit) {
        this.iCredit = credit;
        if (this.iCreditValue == null && credit != null) {
            int split = credit.indexOf(124);
            String abbv = null;
            abbv = split >= 0 ? credit.substring(0, split) : credit;
            Matcher m = Pattern.compile("(^| )(\\d+\\.?\\d*)([,-]?(\\d+\\.?\\d*))?($| )").matcher(abbv);
            if (m.find()) {
                this.iCreditValue = Float.valueOf(Float.parseFloat(m.group(2)));
            }
        }
    }

    public String getCredit() {
        return this.iCredit;
    }

    public boolean hasCreditValue() {
        return this.iCreditValue != null;
    }

    public void setCreditValue(Float creditValue) {
        this.iCreditValue = creditValue;
    }

    public Float getCreditValue() {
        return this.iCreditValue;
    }
}

