/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class StudentEnrollmentSwapSelection
implements NeighbourSelection<Request, Enrollment>,
InfoProvider<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private Selection iSelection = null;
    protected Queue<Request> iRequests = null;
    protected long iNbrIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;

    public StudentEnrollmentSwapSelection(DataProperties properties) {
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> variables = new ArrayList<Request>(solver.currentSolution().getModel().assignedVariables(solver.currentSolution().getAssignment()));
        Collections.shuffle(variables);
        this.iRequests = new LinkedList<Request>(variables);
        if (this.iSelection == null) {
            try {
                this.iSelection = new Selection(solver.getProperties());
                this.iSelection.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, variables.size());
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Enrollment swaps...");
    }

    protected synchronized Request nextRequest() {
        return this.iRequests.poll();
    }

    public synchronized void addRequest(Request request) {
        if (this.iRequests != null) {
            this.iRequests.add(request);
        }
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Request request = null;
        while ((request = this.nextRequest()) != null) {
            Progress.getInstance(solution.getModel()).incProgress();
            if (!(request instanceof CourseRequest)) continue;
            try {
                Enrollment e = request.getAssignment(solution.getAssignment());
                if (e != null && e.getPriority() <= 0 && ((CourseRequest)request).getSelectedChoices().isEmpty()) continue;
                Neighbour<Request, Enrollment> n = this.iSelection.selectNeighbour(solution, request);
                if (this.iSelection.getContext() != null) {
                    ++this.iNbrIterations;
                    this.iTotalTime += this.iSelection.getContext().getTime();
                    if (this.iSelection.getContext().isTimeoutReached()) {
                        ++this.iNbrTimeoutReached;
                    }
                    if (n == null) {
                        ++this.iNbrNoSolution;
                    }
                }
                if (n == null || !(n.value(solution.getAssignment()) <= 0.0)) continue;
                return n;
            }
            catch (ConcurrentModificationException e) {
                this.addRequest(request);
            }
        }
        return null;
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iSelection.getTimeout() / 1000.0) + " seconds reached)");
        }
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    class Selection
    extends BacktrackNeighbourSelection<Request, Enrollment> {
        private int iMaxValues;

        Selection(DataProperties properties) throws Exception {
            super(properties);
            this.iMaxValues = 1000;
            this.setTimeout(properties.getPropertyInt("Neighbour.EnrollmentSwapTimeout", 500));
            this.iMaxValues = properties.getPropertyInt("Neighbour.EnrollmentSwapMaxValues", this.iMaxValues);
        }

        @Override
        protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            if (variable instanceof CourseRequest) {
                final CourseRequest request = (CourseRequest)variable;
                final StudentSectioningModel model = (StudentSectioningModel)context.getModel();
                final Assignment<Request, Enrollment> assignment = context.getAssignment();
                List<Enrollment> values = null;
                Enrollment current = (Enrollment)request.getAssignment(context.getAssignment());
                values = !request.getSelectedChoices().isEmpty() && current != null && current.getPriority() == 0 ? request.getSelectedEnrollments(assignment, false) : (this.iMaxValues > 0 ? request.computeRandomEnrollments(assignment, this.iMaxValues) : request.computeEnrollments(assignment));
                Collections.sort(values, new Comparator<Enrollment>(){
                    private HashMap<Enrollment, Double> iValues = new HashMap();

                    private Double value(Enrollment e) {
                        Double value = this.iValues.get(e);
                        if (value == null) {
                            value = model.getStudentQuality() != null ? Double.valueOf(model.getStudentWeights().getWeight(assignment, e, model.getStudentQuality().conflicts(e))) : Double.valueOf(model.getStudentWeights().getWeight(assignment, e, model.getDistanceConflict() == null ? null : model.getDistanceConflict().conflicts(e), model.getTimeOverlaps() == null ? null : model.getTimeOverlaps().conflicts(e)));
                            this.iValues.put(e, value);
                        }
                        return value;
                    }

                    @Override
                    public int compare(Enrollment e1, Enrollment e2) {
                        Double v2;
                        if (e1.equals(assignment.getValue(request))) {
                            return -1;
                        }
                        if (e2.equals(assignment.getValue(request))) {
                            return 1;
                        }
                        Double v1 = this.value(e1);
                        return v1.equals(v2 = this.value(e2)) ? e1.compareTo(assignment, e2) : v2.compareTo(v1);
                    }
                });
                return values.iterator();
            }
            return variable.computeEnrollments(context.getAssignment()).iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void selectNeighbour(Solution<Request, Enrollment> solution, Request variable, BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context) {
            this.iContext = context;
            Lock lock = solution.getLock().writeLock();
            lock.lock();
            try {
                this.exploreEnrollmentSwaps(context, variable);
            }
            finally {
                lock.unlock();
            }
        }

        protected void exploreEnrollmentSwaps(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            Enrollment current = (Enrollment)context.getAssignment().getValue(variable);
            double currentValue = current == null ? 0.0 : current.toDouble(context.getAssignment());
            Iterator<Enrollment> e = this.values(context, variable);
            while (this.canContinueEvaluation(context) && e.hasNext()) {
                Enrollment value = e.next();
                if (value.equals(current) || current != null && currentValue <= value.toDouble(context.getAssignment())) continue;
                if (context.isTimeoutReached() || context.isMaxItersReached()) break;
                context.incIteration();
                if (context.getModel().inConflict(context.getAssignment(), value)) {
                    for (Enrollment other : new ArrayList<Enrollment>(((Course.CourseContext)value.getCourse().getContext(context.getAssignment())).getEnrollments())) {
                        if (other.getStudent().equals(value.getStudent()) || !other.getSections().equals(value.getSections())) continue;
                        context.getAssignment().unassign(0L, other.variable());
                        if (!context.getModel().inConflict(context.getAssignment(), value)) {
                            if (current != null) {
                                context.getAssignment().unassign(0L, current.variable());
                            }
                            context.getAssignment().assign(0L, value);
                            Iterator<Enrollment> f = this.values(context, (Request)other.variable());
                            while (this.canContinueEvaluation(context) && f.hasNext()) {
                                Enrollment fix = f.next();
                                if (context.getModel().inConflict(context.getAssignment(), fix)) continue;
                                context.getAssignment().assign(0L, fix);
                                context.saveBest(new Request[]{variable, (Request)other.variable()});
                                context.getAssignment().unassign(0L, fix.variable());
                            }
                            if (current == null) {
                                context.getAssignment().unassign(0L, variable);
                            } else {
                                context.getAssignment().assign(0L, current);
                            }
                        }
                        context.getAssignment().assign(0L, other);
                    }
                    continue;
                }
                if (current != null) {
                    context.getAssignment().unassign(0L, current.variable());
                }
                context.getAssignment().assign(0L, value);
                context.saveBest(new Request[]{variable});
                if (current == null) {
                    context.getAssignment().unassign(0L, variable);
                    continue;
                }
                context.getAssignment().assign(0L, current);
            }
        }
    }
}

