/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class StandardSelection
implements NeighbourSelection<Request, Enrollment> {
    private long iIteration = 0L;
    private ValueSelection<Request, Enrollment> iValueSelection = null;
    private VariableSelection<Request, Enrollment> iVariableSelection = null;
    protected long iNrIterations = -1L;

    public StandardSelection(DataProperties properties, VariableSelection<Request, Enrollment> variableSelection, ValueSelection<Request, Enrollment> valueSelection) {
        this.iVariableSelection = variableSelection;
        this.iValueSelection = valueSelection;
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Ifs...");
    }

    protected void init(Solver<Request, Enrollment> solver, String name) {
        this.iVariableSelection.init(solver);
        this.iValueSelection.init(solver);
        this.iIteration = 0L;
        this.iNrIterations = solver.getProperties().getPropertyLong("Neighbour.StandardIterations", -1L);
        if (this.iNrIterations < 0L) {
            this.iNrIterations = solver.currentSolution().getModel().nrUnassignedVariables(solver.currentSolution().getAssignment());
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, this.iNrIterations);
    }

    public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
        float credit;
        if (conflict.getRequest().isMPP() && conflict.equals(conflict.getRequest().getInitialAssignment())) {
            return false;
        }
        if (conflict.getRequest().getStudent().hasMinCredit() && (credit = conflict.getRequest().getStudent().getAssignedCredit(assignment) - conflict.getCredit()) < conflict.getRequest().getStudent().getMinCredit()) {
            return false;
        }
        if (!enrollment.getStudent().isPriority() && conflict.getStudent().isPriority()) {
            return false;
        }
        return conflict.getRequest().isAlternative() || !conflict.getRequest().isCritical();
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (solution.getModel().unassignedVariables(solution.getAssignment()).isEmpty() || ++this.iIteration >= this.iNrIterations) {
            return null;
        }
        Progress.getInstance(solution.getModel()).incProgress();
        block0: for (int i = 0; i < 10; ++i) {
            Set<Enrollment> conflicts;
            Enrollment enrollment;
            Request request = this.iVariableSelection.selectVariable(solution);
            if (request == null || (enrollment = this.iValueSelection.selectValue(solution, request)) == null || (conflicts = ((Request)enrollment.variable()).getModel().conflictValues(solution.getAssignment(), enrollment)).contains(enrollment)) continue;
            for (Enrollment conflict : conflicts) {
                if (this.canUnassign(enrollment, conflict, solution.getAssignment())) continue;
                continue block0;
            }
            return new SimpleNeighbour<Request, Enrollment>(request, enrollment, conflicts);
        }
        return null;
    }
}

