/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.selection.StandardSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CriticalStandardSelection
extends StandardSelection {
    public CriticalStandardSelection(DataProperties properties, ValueSelection<Request, Enrollment> valueSelection) {
        super(properties, new UnassignedCriticalCourseRequestSelection(), valueSelection);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Ifs (critical)...");
    }

    @Override
    public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
        return !conflict.getRequest().isMPP() || !conflict.equals(conflict.getRequest().getInitialAssignment());
    }

    static class UnassignedCriticalCourseRequestSelection
    implements VariableSelection<Request, Enrollment> {
        protected int iNrRounds = 0;
        protected Queue<Request> iRequests = null;

        UnassignedCriticalCourseRequestSelection() {
        }

        @Override
        public void init(Solver<Request, Enrollment> solver) {
            this.iRequests = new LinkedList<Request>();
            this.iNrRounds = solver.getProperties().getPropertyInt("Neighbour.CriticalRounds", 10);
        }

        @Override
        public Request selectVariable(Solution<Request, Enrollment> solution) {
            return this.nextRequest(solution);
        }

        protected synchronized Request nextRequest(Solution<Request, Enrollment> solution) {
            if (this.iRequests.isEmpty() && this.iNrRounds > 0) {
                --this.iNrRounds;
                ArrayList<Request> variables = new ArrayList<Request>();
                for (Request r : solution.getModel().unassignedVariables(solution.getAssignment())) {
                    if (!r.isCritical()) continue;
                    variables.add(r);
                }
                Collections.shuffle(variables);
                this.iRequests.addAll(variables);
            }
            return this.iRequests.poll();
        }
    }
}

