/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.RandomizedBacktrackNeighbourSelection;
import org.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CriticalBacktrackSelection
extends BacktrackSelection {
    public CriticalBacktrackSelection(DataProperties properties) {
        super(properties);
        this.iIncludeAssignedRequests = properties.getPropertyBoolean("Neighbour.IncludeCriticalAssignedRequests", this.iIncludeAssignedRequests);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> variables = new ArrayList<Request>();
        for (Request r : this.iIncludeAssignedRequests ? solver.currentSolution().getModel().variables() : solver.currentSolution().getModel().unassignedVariables(solver.currentSolution().getAssignment())) {
            if (!r.isCritical()) continue;
            variables.add(r);
        }
        Collections.shuffle(variables);
        this.iRequests = new LinkedList(variables);
        if (this.iRBtNSel == null) {
            try {
                this.iRBtNSel = new RandomizedBacktrackNeighbourSelection(solver.getProperties());
                this.iRBtNSel.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Backtracking (critical)...", variables.size());
    }
}

