/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.util.DistanceMetric;

public class InstructorConstraint
extends ConstraintWithContext<Lecture, Placement, InstructorConstraintContext> {
    private Long iResourceId;
    private String iName;
    private String iPuid;
    private List<Placement> iUnavailabilities = null;
    private boolean iIgnoreDistances = false;
    private Long iType = null;

    public InstructorConstraint(Long id, String puid, String name, boolean ignDist) {
        this.iResourceId = id;
        this.iName = name;
        this.iPuid = puid;
        this.iIgnoreDistances = ignDist;
    }

    public void setNotAvailable(Placement placement) {
        if (this.iUnavailabilities == null) {
            this.iUnavailabilities = new ArrayList<Placement>();
        }
        this.iUnavailabilities.add(placement);
        for (Lecture lecture : this.variables()) {
            lecture.clearValueCache();
        }
    }

    public boolean isAvailable(Lecture lecture, TimeLocation time) {
        if (this.iUnavailabilities == null) {
            return true;
        }
        for (Placement c : this.iUnavailabilities) {
            if (!c.getTimeLocation().hasIntersection(time) || lecture.canShareRoom((Lecture)c.variable())) continue;
            return false;
        }
        return true;
    }

    private DistanceMetric getDistanceMetric() {
        return ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    public boolean isAvailable(Lecture lecture, Placement placement) {
        if (this.iUnavailabilities == null) {
            return true;
        }
        TimeLocation t1 = placement.getTimeLocation();
        for (Placement c : this.iUnavailabilities) {
            TimeLocation t2;
            if (!(!c.getTimeLocation().hasIntersection(placement.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable()) && placement.sameRooms(c))) {
                return false;
            }
            if (this.iIgnoreDistances || !t1.shareDays(t2 = c.getTimeLocation()) || !t1.shareWeeks(t2) || !(t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot() ? Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c) > this.getDistanceMetric().getInstructorProhibitedLimit() : this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() && (t1.getStartSlot() + t1.getLength() < t2.getStartSlot() ? Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, c) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength()) : t2.getStartSlot() + t2.getLength() < t1.getStartSlot() && Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, c) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())))) continue;
            return false;
        }
        return true;
    }

    public List<Placement> getUnavailabilities() {
        return this.iUnavailabilities;
    }

    @Deprecated
    public List<Placement>[] getAvailableArray() {
        if (this.iUnavailabilities == null) {
            return null;
        }
        List[] available = new List[288 * Constants.DAY_CODES.length];
        for (int i = 0; i < available.length; ++i) {
            available[i] = null;
        }
        for (Placement p : this.iUnavailabilities) {
            TimeLocation.IntEnumeration e = p.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                if (available[slot] == null) {
                    available[slot] = new ArrayList(1);
                }
                available[slot].add(p);
            }
        }
        return available;
    }

    public int getDistancePreference(Placement p1, Placement p2) {
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return Constants.sPreferenceLevelNeutral;
        }
        if (t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot()) {
            double distance = Placement.getDistanceInMeters(this.getDistanceMetric(), p1, p2);
            if (distance <= this.getDistanceMetric().getInstructorNoPreferenceLimit()) {
                return Constants.sPreferenceLevelNeutral;
            }
            if (distance <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                return Constants.sPreferenceLevelDiscouraged;
            }
            if (this.iIgnoreDistances || distance <= this.getDistanceMetric().getInstructorProhibitedLimit()) {
                return Constants.sPreferenceLevelStronglyDiscouraged;
            }
            return Constants.sPreferenceLevelProhibited;
        }
        if (this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (t1.getStartSlot() + t1.getLength() < t2.getStartSlot()) {
                int distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), p1, p2);
                if (distanceInMinutes > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                    return this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited;
                }
                if ((double)distanceInMinutes >= this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                    return Constants.sPreferenceLevelStronglyDiscouraged;
                }
                if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                    return Constants.sPreferenceLevelDiscouraged;
                }
            } else if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot()) {
                int distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), p1, p2);
                if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                    return this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited;
                }
                if ((double)distanceInMinutes >= this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                    return Constants.sPreferenceLevelStronglyDiscouraged;
                }
                if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                    return Constants.sPreferenceLevelDiscouraged;
                }
            }
        }
        return Constants.sPreferenceLevelNeutral;
    }

    public Long getResourceId() {
        return this.iResourceId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        Lecture lecture = (Lecture)placement.variable();
        Placement current = assignment.getValue(lecture);
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        InstructorConstraintContext context = (InstructorConstraintContext)this.getContext((Assignment)assignment);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement p : context.getPlacements(slot)) {
                if (p.equals(current) || !p.getTimeLocation().shareWeeks(weekCode) || p.canShareRooms(placement) && p.sameRooms(placement)) continue;
                conflicts.add(p);
            }
        }
        if (!this.iIgnoreDistances) {
            e = placement.getTimeLocation().getStartSlots();
            while (e.hasMoreElements()) {
                int nextSlot;
                int startSlot = (Integer)e.nextElement();
                int prevSlot = startSlot - 1;
                if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                    for (Placement placement2 : context.getPlacements(prevSlot, placement)) {
                        if (lecture.equals(placement2.variable()) || placement2.canShareRooms(placement) && placement2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        conflicts.add(placement2);
                    }
                }
                if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                    for (Placement c2 : context.getPlacements(nextSlot, placement)) {
                        if (lecture.equals(c2.variable()) || c2.canShareRooms(placement) && c2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        conflicts.add(c2);
                    }
                }
                if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
                TimeLocation timeLocation = placement.getTimeLocation();
                for (Lecture other : this.variables()) {
                    Placement otherPlacement = assignment.getValue(other);
                    if (otherPlacement == null || other.equals(placement.variable())) continue;
                    TimeLocation t2 = otherPlacement.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                        if (Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement) <= timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) continue;
                        conflicts.add(otherPlacement);
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() >= timeLocation.getStartSlot() || Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement) <= t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) continue;
                    conflicts.add(otherPlacement);
                }
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        Lecture lecture = (Lecture)placement.variable();
        Placement current = assignment.getValue(lecture);
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        InstructorConstraintContext context = (InstructorConstraintContext)this.getContext((Assignment)assignment);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement p : context.getPlacements(slot)) {
                if (p.equals(current) || !p.getTimeLocation().shareWeeks(weekCode) || p.canShareRooms(placement) && p.sameRooms(placement)) continue;
                return true;
            }
        }
        if (!this.iIgnoreDistances) {
            e = placement.getTimeLocation().getStartSlots();
            while (e.hasMoreElements()) {
                int nextSlot;
                int startSlot = (Integer)e.nextElement();
                int prevSlot = startSlot - 1;
                if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                    for (Placement placement2 : context.getPlacements(prevSlot, placement)) {
                        if (lecture.equals(placement2.variable()) || placement2.canShareRooms(placement) && placement2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        return true;
                    }
                }
                if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                    for (Placement c2 : context.getPlacements(nextSlot, placement)) {
                        if (lecture.equals(c2.variable()) || c2.canShareRooms(placement) && c2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        return true;
                    }
                }
                if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
                TimeLocation timeLocation = placement.getTimeLocation();
                for (Lecture other : this.variables()) {
                    Placement otherPlacement = assignment.getValue(other);
                    if (otherPlacement == null || other.equals(placement.variable())) continue;
                    TimeLocation t2 = otherPlacement.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2) || !(timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot() ? Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement) > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength()) : t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot() && Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        if (p1.canShareRooms(p2) && p1.sameRooms(p2)) {
            return true;
        }
        if (p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
            return false;
        }
        return this.getDistancePreference(p1, p2) != Constants.sPreferenceLevelProhibited;
    }

    public String toString() {
        return "Instructor " + this.getName();
    }

    public int getPreference(Assignment<Lecture, Placement> assignment, Placement value) {
        Lecture lecture = (Lecture)value.variable();
        Placement placement = value;
        int pref = 0;
        HashSet<Placement> checked = new HashSet<Placement>();
        InstructorConstraintContext context = (InstructorConstraintContext)this.getContext((Assignment)assignment);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getStartSlots();
        while (e.hasMoreElements()) {
            int nextSlot;
            int startSlot = (Integer)e.nextElement();
            int prevSlot = startSlot - 1;
            if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                for (Placement placement2 : context.getPlacements(prevSlot, placement)) {
                    if (lecture.equals(placement2.variable()) || !checked.add(placement2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref += Constants.sPreferenceLevelDiscouraged;
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref += Constants.sPreferenceLevelStronglyDiscouraged;
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref += Constants.sPreferenceLevelProhibited;
                }
            }
            if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                for (Placement c2 : context.getPlacements(nextSlot, placement)) {
                    if (lecture.equals(c2.variable()) || !checked.add(c2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref += Constants.sPreferenceLevelDiscouraged;
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref += Constants.sPreferenceLevelStronglyDiscouraged;
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = Constants.sPreferenceLevelProhibited;
                }
            }
            if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
            TimeLocation timeLocation = placement.getTimeLocation();
            Placement before = null;
            Placement after = null;
            for (Lecture other : this.variables()) {
                int distanceInMinutes;
                Placement otherPlacement = assignment.getValue(other);
                if (otherPlacement == null || other.equals(placement.variable())) continue;
                TimeLocation t2 = otherPlacement.getTimeLocation();
                if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement);
                    if (distanceInMinutes > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref += this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited;
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref += Constants.sPreferenceLevelDiscouraged;
                    }
                } else if (t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement);
                    if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref += this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited;
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref += Constants.sPreferenceLevelDiscouraged;
                    }
                }
                if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                    if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                    after = otherPlacement;
                    continue;
                }
                if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                before = otherPlacement;
            }
            if (this.iUnavailabilities != null) {
                for (Placement c : this.iUnavailabilities) {
                    TimeLocation t2 = c.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                        if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                        after = c;
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                    before = c;
                }
            }
            if (before != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                pref += Constants.sPreferenceLevelStronglyDiscouraged;
            }
            if (after != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), after, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                pref += Constants.sPreferenceLevelStronglyDiscouraged;
            }
            if (before == null || after == null || !((double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, after) > this.getDistanceMetric().getInstructorLongTravelInMinutes())) continue;
            pref -= Constants.sPreferenceLevelStronglyDiscouraged;
        }
        return pref;
    }

    public int getPreference(Assignment<Lecture, Placement> assignment) {
        return ((InstructorConstraintContext)this.getContext((Assignment)assignment)).getPreference();
    }

    public int getPreferenceCombination(Assignment<Lecture, Placement> assignment, Placement value) {
        Lecture lecture = (Lecture)value.variable();
        Placement placement = value;
        int pref = 0;
        HashSet<Placement> checked = new HashSet<Placement>();
        InstructorConstraintContext context = (InstructorConstraintContext)this.getContext((Assignment)assignment);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getStartSlots();
        while (e.hasMoreElements()) {
            int nextSlot;
            int startSlot = (Integer)e.nextElement();
            int prevSlot = startSlot - 1;
            if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                for (Placement placement2 : context.getPlacements(prevSlot, placement)) {
                    if (lecture.equals(placement2.variable()) || !checked.add(placement2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref = Math.max(pref, Constants.sPreferenceLevelDiscouraged);
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref = Math.max(pref, Constants.sPreferenceLevelStronglyDiscouraged);
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = Math.max(pref, Constants.sPreferenceLevelProhibited);
                }
            }
            if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                for (Placement c2 : context.getPlacements(nextSlot, placement)) {
                    if (lecture.equals(c2.variable()) || !checked.add(c2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref = Math.max(pref, Constants.sPreferenceLevelDiscouraged);
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref = Math.max(pref, Constants.sPreferenceLevelStronglyDiscouraged);
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = Constants.sPreferenceLevelProhibited;
                }
            }
            if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
            TimeLocation timeLocation = placement.getTimeLocation();
            Placement before = null;
            Placement after = null;
            for (Lecture other : this.variables()) {
                int distanceInMinutes;
                Placement otherPlacement = assignment.getValue(other);
                if (otherPlacement == null || other.equals(placement.variable())) continue;
                TimeLocation t2 = otherPlacement.getTimeLocation();
                if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement);
                    if (distanceInMinutes > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref = Math.max(pref, this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited);
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref = Math.max(pref, Constants.sPreferenceLevelDiscouraged);
                    }
                } else if (t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, otherPlacement);
                    if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref = Math.max(pref, this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited);
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref = Math.max(pref, Constants.sPreferenceLevelDiscouraged);
                    }
                }
                if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                    if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                    after = otherPlacement;
                    continue;
                }
                if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                before = otherPlacement;
            }
            if (this.iUnavailabilities != null) {
                for (Placement c : this.iUnavailabilities) {
                    TimeLocation t2 = c.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                        if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                        after = c;
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                    before = c;
                }
            }
            int tooLongTravel = 0;
            if (before != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                ++tooLongTravel;
            }
            if (after != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), after, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                ++tooLongTravel;
            }
            if (tooLongTravel <= 0) continue;
            pref += Math.max(pref, Constants.sPreferenceLevelStronglyDiscouraged);
        }
        return pref;
    }

    public int getWorstPreference() {
        return Constants.sPreferenceLevelStronglyDiscouraged * (this.variables().size() - 1);
    }

    public String getPuid() {
        return this.iPuid;
    }

    public boolean isIgnoreDistances() {
        return this.iIgnoreDistances;
    }

    public void setIgnoreDistances(boolean ignDist) {
        this.iIgnoreDistances = ignDist;
    }

    public Long getType() {
        return this.iType;
    }

    public void setType(Long type) {
        this.iType = type;
    }

    @Override
    public InstructorConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new InstructorConstraintContext(assignment);
    }

    public class InstructorConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        public int iPreference = 0;
        protected List<Placement>[] iResource = new List[288 * Constants.DAY_CODES.length];

        public InstructorConstraintContext(Assignment<Lecture, Placement> assignment) {
            for (int i = 0; i < this.iResource.length; ++i) {
                this.iResource[i] = new ArrayList<Placement>(3);
            }
            for (Lecture lecture : InstructorConstraint.this.variables()) {
                Placement placement = assignment.getValue(lecture);
                if (placement == null) continue;
                TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
                while (e.hasMoreElements()) {
                    int slot = (Integer)e.nextElement();
                    this.iResource[slot].add(placement);
                }
            }
            this.iPreference = this.countPreference(assignment);
            InstructorConstraint.this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(assignment, this.iPreference);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                this.iResource[slot].add(placement);
            }
            InstructorConstraint.this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(assignment, -this.iPreference);
            this.iPreference = this.countPreference(assignment);
            InstructorConstraint.this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(assignment, this.iPreference);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                this.iResource[slot].remove(placement);
            }
            InstructorConstraint.this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(assignment, -this.iPreference);
            this.iPreference = this.countPreference(assignment);
            InstructorConstraint.this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(assignment, this.iPreference);
        }

        public List<Placement> getPlacements(int slot) {
            return this.iResource[slot];
        }

        public Placement getPlacement(int slot, int day) {
            for (Placement p : this.iResource[slot]) {
                if (!p.getTimeLocation().hasDay(day)) continue;
                return p;
            }
            return null;
        }

        public List<Placement> getPlacements(int slot, BitSet weekCode) {
            ArrayList<Placement> placements = new ArrayList<Placement>(this.iResource[slot].size());
            for (Placement p : this.iResource[slot]) {
                if (!p.getTimeLocation().shareWeeks(weekCode)) continue;
                placements.add(p);
            }
            return placements;
        }

        public List<Placement> getPlacements(int slot, Placement placement) {
            return this.getPlacements(slot, placement.getTimeLocation().getWeekCode());
        }

        public int getNrSlots() {
            return this.iResource.length;
        }

        public Placement[] getResourceOfWeek(int startDay) {
            Placement[] ret = new Placement[this.iResource.length];
            for (int i = 0; i < this.iResource.length; ++i) {
                ret[i] = this.getPlacement(i, startDay + i / 288);
            }
            return ret;
        }

        public int getPreference() {
            return this.iPreference;
        }

        public int countPreference(Assignment<Lecture, Placement> assignment) {
            int pref = 0;
            HashSet<Placement> checked = new HashSet<Placement>();
            for (int slot = 1; slot < this.getNrSlots(); ++slot) {
                if (slot % 288 == 0) continue;
                for (Placement placement : this.getPlacements(slot)) {
                    for (Placement c : this.getPlacements(slot - 1, placement)) {
                        if (((Lecture)placement.variable()).equals(c.variable()) || !checked.add(c)) continue;
                        double dist = Placement.getDistanceInMeters(InstructorConstraint.this.getDistanceMetric(), c, placement);
                        if (dist > InstructorConstraint.this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= InstructorConstraint.this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                            pref += Constants.sPreferenceLevelDiscouraged;
                        }
                        if (!(dist > InstructorConstraint.this.getDistanceMetric().getInstructorDiscouragedLimit())) continue;
                        pref += Constants.sPreferenceLevelStronglyDiscouraged;
                    }
                }
            }
            if (InstructorConstraint.this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
                for (Lecture v1 : InstructorConstraint.this.variables()) {
                    TimeLocation t1;
                    Placement p1 = assignment.getValue(v1);
                    TimeLocation timeLocation = t1 = p1 == null ? null : p1.getTimeLocation();
                    if (t1 == null) continue;
                    Placement before = null;
                    for (Lecture l2 : InstructorConstraint.this.variables()) {
                        TimeLocation t2;
                        Placement p2 = assignment.getValue(l2);
                        if (p2 == null || l2.equals(v1) || (t2 = p2.getTimeLocation()) == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) continue;
                        if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot()) {
                            int distanceInMinutes = Placement.getDistanceInMinutes(InstructorConstraint.this.getDistanceMetric(), p1, p2);
                            if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                                pref += InstructorConstraint.this.iIgnoreDistances ? Constants.sPreferenceLevelStronglyDiscouraged : Constants.sPreferenceLevelProhibited;
                            } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                                pref += Constants.sPreferenceLevelDiscouraged;
                            }
                        }
                        if (t2.getStartSlot() + t2.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                        before = p2;
                    }
                    if (InstructorConstraint.this.iUnavailabilities != null) {
                        for (Placement c : InstructorConstraint.this.iUnavailabilities) {
                            TimeLocation t2 = c.getTimeLocation();
                            if (t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2) || t2.getStartSlot() + t2.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                            before = c;
                        }
                    }
                    if (before == null || !((double)Placement.getDistanceInMinutes(InstructorConstraint.this.getDistanceMetric(), before, p1) > InstructorConstraint.this.getDistanceMetric().getInstructorLongTravelInMinutes())) continue;
                    pref += Constants.sPreferenceLevelStronglyDiscouraged;
                }
            }
            return pref;
        }
    }
}

