/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class UnassignedCriticalCourseRequestSelection
implements VariableSelection<Request, Enrollment> {
    protected Queue<Request> iRequests = null;

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iRequests = new LinkedList<Request>();
    }

    @Override
    public Request selectVariable(Solution<Request, Enrollment> solution) {
        return this.nextRequest(solution);
    }

    protected synchronized Request nextRequest(Solution<Request, Enrollment> solution) {
        Request ret = this.iRequests.poll();
        if (ret == null) {
            ArrayList<Request> variables = new ArrayList<Request>();
            for (Request r : solution.getModel().unassignedVariables(solution.getAssignment())) {
                if (!r.isCritical()) continue;
                variables.add(r);
            }
            Collections.shuffle(variables);
            this.iRequests.addAll(variables);
            ret = this.iRequests.poll();
        }
        return ret;
    }
}

