/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Callback;

public abstract class ProblemLoader<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
implements Runnable {
    private M iModel = null;
    private Assignment<V, T> iAssignment = null;
    private Callback iCallback = null;
    private TerminationCondition<V, T> iTermination = null;

    public ProblemLoader(M model, Assignment<V, T> assignment) {
        this.iModel = model;
        this.iAssignment = assignment;
    }

    public M getModel() {
        return this.iModel;
    }

    public Assignment<V, T> getAssignment() {
        return this.iAssignment;
    }

    public abstract void load() throws Exception;

    public void setCallback(Callback callback) {
        this.iCallback = callback;
    }

    public void setTerminationCondition(TerminationCondition<V, T> termination) {
        this.iTermination = termination;
    }

    public TerminationCondition<V, T> getTerminationCondition() {
        return this.iTermination;
    }

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e.getMessage(), e);
        }
        finally {
            if (this.iCallback != null) {
                this.iCallback.execute();
            }
        }
    }
}

