/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;

public class RandomSwapMove<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
HillClimberSelection {
    protected int iMaxAttempts = 3;
    protected boolean iHC = false;
    protected int iTimeLimit = 200;

    public RandomSwapMove(DataProperties config) {
        this.iMaxAttempts = config.getPropertyInt("RandomSwap.MaxAttempts", this.iMaxAttempts);
        this.iTimeLimit = config.getPropertyInt("RandomSwap.TimeLimit", this.iTimeLimit);
    }

    @Override
    public void setHcMode(boolean hcMode) {
        this.iHC = hcMode;
    }

    @Override
    public void init(Solver<V, T> solver) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Model<V, T> model = solution.getModel();
        Assignment assignment = solution.getAssignment();
        double total = model.getTotalValue(assignment);
        int varIdx = ToolBox.random(model.variables().size());
        block5: for (int i = 0; i < model.variables().size(); ++i) {
            Variable variable = (Variable)model.variables().get((i + varIdx) % model.variables().size());
            List<T> values = variable.values(solution.getAssignment());
            if (values.isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            T old = variable.getAssignment(assignment);
            Lock lock = solution.getLock().writeLock();
            lock.lock();
            try {
                int attempts = 0;
                long startTime = JProf.currentTimeMillis();
                for (int j = 0; j < values.size(); ++j) {
                    Set<Value> conflicts;
                    Value value = (Value)values.get((j + valIdx) % values.size());
                    if (value.equals(old) || (conflicts = model.conflictValues(assignment, value)).contains(value)) continue;
                    if (conflicts.isEmpty()) {
                        SimpleNeighbour<Variable, Value> n = new SimpleNeighbour<Variable, Value>(variable, value);
                        if (this.iHC && !(n.value(assignment) <= 0.0)) continue;
                        SimpleNeighbour<Variable, Value> simpleNeighbour = n;
                        return simpleNeighbour;
                    }
                    HashMap<Variable, Value> assignments = new HashMap<Variable, Value>();
                    assignments.put(variable, value);
                    for (Value conflict : conflicts) {
                        assignment.unassign(solution.getIteration(), conflict.variable());
                    }
                    assignment.assign(solution.getIteration(), value);
                    Double v = this.resolve(solution, total, startTime, assignments, new ArrayList<Value>(conflicts), 0);
                    if (!conflicts.isEmpty()) {
                        ++attempts;
                    }
                    assignment.unassign(solution.getIteration(), variable);
                    for (Value conflict : conflicts) {
                        assignment.assign(solution.getIteration(), conflict);
                    }
                    if (old != null) {
                        assignment.assign(solution.getIteration(), old);
                    }
                    if (v != null) {
                        SwapNeighbour swapNeighbour = new SwapNeighbour(assignments.values(), v);
                        return swapNeighbour;
                    }
                    if (attempts < this.iMaxAttempts) continue;
                    continue block5;
                }
                continue;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    protected boolean isTimeLimitReached(long startTime) {
        return this.iTimeLimit > 0 && JProf.currentTimeMillis() - startTime > (long)this.iTimeLimit;
    }

    protected Double resolve(Solution<V, T> solution, double total, long startTime, Map<V, T> assignments, List<T> conflicts, int index) {
        Assignment assignment = solution.getAssignment();
        if (index == conflicts.size()) {
            return solution.getModel().getTotalValue(assignment) - total;
        }
        Value conflict = (Value)conflicts.get(index);
        V variable = conflict.variable();
        List<T> values = ((Variable)variable).values(solution.getAssignment());
        if (values.isEmpty()) {
            return null;
        }
        int valIdx = ToolBox.random(values.size());
        int attempts = 0;
        for (int i = 0; i < values.size(); ++i) {
            Value value = (Value)values.get((i + valIdx) % values.size());
            if (value.equals(conflict) || solution.getModel().inConflict(assignment, value)) continue;
            assignment.assign(solution.getIteration(), value);
            Double v = this.resolve(solution, total, startTime, assignments, conflicts, 1 + index);
            assignment.unassign(solution.getIteration(), variable);
            ++attempts;
            if (v != null && (!this.iHC || v <= 0.0)) {
                assignments.put((Value)variable, (T)value);
                return v;
            }
            if (attempts >= this.iMaxAttempts || this.isTimeLimitReached(startTime)) break;
        }
        return null;
    }

    public class SwapNeighbour
    implements Neighbour<V, T> {
        private double iValue = 0.0;
        private Collection<T> iAssignments = null;

        public SwapNeighbour(Collection<T> assignments, double value) {
            this.iAssignments = assignments;
            this.iValue = value;
        }

        @Override
        public double value(Assignment<V, T> assignment) {
            return this.iValue;
        }

        @Override
        public void assign(Assignment<V, T> assignment, long iteration) {
            for (Value value : this.iAssignments) {
                assignment.unassign(iteration, value.variable());
            }
            for (Value value : this.iAssignments) {
                assignment.assign(iteration, value);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Swap{" + this.iValue + ": ");
            Iterator i = this.iAssignments.iterator();
            while (i.hasNext()) {
                Value p = (Value)i.next();
                sb.append("\n    " + ((Variable)p.variable()).getName() + " " + p.getName() + (i.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public Map<V, T> assignments() {
            HashMap ret = new HashMap();
            for (Value value : this.iAssignments) {
                ret.put(value.variable(), value);
            }
            return ret;
        }
    }
}

