/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.ToolBox;

public class MaxBreaksFlexibleConstraint
extends FlexibleConstraint
implements WeakeningConstraint<Lecture, Placement> {
    private int iMaxBreakBetweenBTB;
    protected int iMaxBlocksOnADay;

    public MaxBreaksFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_BREAKS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxBlocksOnADay = 1 + Integer.parseInt(matcher.group(2));
            this.iMaxBreakBetweenBTB = Integer.parseInt(matcher.group(3)) / Constants.SLOT_LENGTH_MIN;
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_BREAKS;
        }
    }

    public List<FlexibleConstraint.Block> getBlocks(Assignment<Lecture, Placement> assignment, int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        ArrayList<Placement> toBeSorted = new ArrayList<Placement>(this.getRelevantPlacements(assignment, dayCode, conflicts, value, assignments, week));
        Collections.sort(toBeSorted, new FlexibleConstraint.PlacementTimeComparator());
        return this.mergeToBlocks(toBeSorted, this.iMaxBreakBetweenBTB);
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        int penalty = 0;
        for (int dayCode : Constants.DAY_CODES) {
            for (BitSet week : this.getWeeks()) {
                List<FlexibleConstraint.Block> blocks = this.getBlocks(assignment, dayCode, null, null, assignments, week);
                if (blocks.size() <= this.iMaxBlocksOnADay) continue;
                penalty += (blocks.size() - this.iMaxBlocksOnADay) * (blocks.size() - this.iMaxBlocksOnADay);
            }
        }
        return penalty;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        if (((MaxBreaksFlexibleConstraintContext)this.getContext((Assignment)assignment)).isWeak(value)) {
            Object object = this.variables().iterator();
            while (object.hasNext()) {
                Lecture v = (Lecture)object.next();
                if (assignment.getValue(v) != null || v.equals(value.variable())) continue;
                return;
            }
        }
        for (int dayCode : Constants.DAY_CODES) {
            if ((value.getTimeLocation().getDayCode() & dayCode) == 0) continue;
            for (BitSet week : this.getWeeks()) {
                if (week != null && !week.intersects(value.getTimeLocation().getWeekCode())) continue;
                List<FlexibleConstraint.Block> blocks = this.getBlocks(assignment, dayCode, conflicts, value, null, week);
                while (blocks.size() > this.iMaxBlocksOnADay) {
                    ArrayList<FlexibleConstraint.Block> adepts = new ArrayList<FlexibleConstraint.Block>();
                    int size = 0;
                    for (FlexibleConstraint.Block block : blocks) {
                        if (block.getPlacements().contains(value)) continue;
                        if (adepts.isEmpty() || size > block.getPlacements().size()) {
                            adepts.clear();
                            adepts.add(block);
                            size = block.getPlacements().size();
                            continue;
                        }
                        if (size != block.getPlacements().size()) continue;
                        adepts.add(block);
                    }
                    FlexibleConstraint.Block block = (FlexibleConstraint.Block)ToolBox.random(adepts);
                    blocks.remove(block);
                    for (Placement conflict : block.getPlacements()) {
                        if (!conflict.equals(assignment.getValue((Lecture)conflict.variable()))) continue;
                        conflicts.add(conflict);
                    }
                }
            }
        }
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        if (this.isHard()) {
            ((MaxBreaksFlexibleConstraintContext)this.getContext((Assignment)assignment)).weaken(value);
        }
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxBreaksFlexibleConstraintContext(assignment);
    }

    public class MaxBreaksFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Map<Lecture, Placement> iWeakAssignment;

        public MaxBreaksFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            super(MaxBreaksFlexibleConstraint.this, assignment);
            this.iWeakAssignment = new HashMap<Lecture, Placement>();
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            super.assigned(assignment, value);
            if (MaxBreaksFlexibleConstraint.this.isHard()) {
                this.iWeakAssignment.remove(value.variable());
            }
        }

        public void weaken(Placement value) {
            if (MaxBreaksFlexibleConstraint.this.isHard()) {
                this.iWeakAssignment.put((Lecture)value.variable(), value);
            }
        }

        public boolean isWeak(Placement value) {
            return value.equals(this.iWeakAssignment.get(value.variable()));
        }
    }
}

