/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.BinaryConstraintWithContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;

public class JenrlConstraint
extends BinaryConstraintWithContext<Lecture, Placement, JenrlConstraintContext>
implements WeakeningConstraint<Lecture, Placement> {
    private double iJenrl = 0.0;
    private double iPriority = 0.0;
    private Set<Student> iStudents = new HashSet<Student>();
    private Set<Student> iInstructors = new HashSet<Student>();
    private double iJenrlMaxConflicts = 1.0;
    private double iJenrlMaxConflictsWeaken = 0.001;

    @Override
    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null && model instanceof TimetableModel) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iJenrlMaxConflicts = config.getPropertyDouble("General.JenrlMaxConflicts", 1.0);
            this.iJenrlMaxConflictsWeaken = config.getPropertyDouble("General.JenrlMaxConflictsWeaken", 0.001);
        }
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!((JenrlConstraintContext)this.getContext((Assignment)assignment)).isOverLimit() || ((Lecture)value.variable()).isCommitted()) {
            return;
        }
        Lecture other = (Lecture)this.another(value.variable());
        if (other == null) {
            return;
        }
        Placement otherPlacement = assignment.getValue(other);
        if (otherPlacement != null && !other.isCommitted() && JenrlConstraint.isInConflict(value, otherPlacement, this.getDistanceMetric(), this.getWorkDayLimit())) {
            conflicts.add(otherPlacement);
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!((JenrlConstraintContext)this.getContext((Assignment)assignment)).isOverLimit() || ((Lecture)value.variable()).isCommitted()) {
            return false;
        }
        Lecture other = (Lecture)this.another(value.variable());
        if (other == null) {
            return false;
        }
        Placement otherPlacement = assignment.getValue(other);
        return otherPlacement != null && !other.isCommitted() && JenrlConstraint.isInConflict(value, otherPlacement, this.getDistanceMetric(), this.getWorkDayLimit());
    }

    public static boolean isInConflict(Placement p1, Placement p2, DistanceMetric m, int workDayLimit) {
        return p1 != null && p2 != null && !StudentConflict.ignore((Lecture)p1.variable(), (Lecture)p2.variable()) && (StudentConflict.distance(m, p1, p2) || StudentConflict.overlaps(p1, p2) || StudentConflict.workday(workDayLimit, p1, p2));
    }

    public long jenrl(Assignment<Lecture, Placement> assignment, Lecture variable, Placement value) {
        Lecture other = ((Lecture)this.first()).equals(variable) ? (Lecture)this.second() : (Lecture)this.first();
        Placement otherPlacement = other == null ? null : assignment.getValue(other);
        return otherPlacement != null && JenrlConstraint.isInConflict(value, otherPlacement, this.getDistanceMetric(), this.getWorkDayLimit()) ? Math.round(this.iJenrl) : 0L;
    }

    private DistanceMetric getDistanceMetric() {
        return this.getModel() == null ? null : ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    private int getWorkDayLimit() {
        return this.getModel() == null ? null : Integer.valueOf(((TimetableModel)this.getModel()).getStudentWorkDayLimit());
    }

    public boolean isInConflict(Assignment<Lecture, Placement> assignment) {
        return ((JenrlConstraintContext)this.getContext((Assignment)assignment)).isConflicting();
    }

    public void incJenrl(Assignment<Lecture, Placement> assignment, Student student) {
        JenrlConstraintContext context = (JenrlConstraintContext)this.getContext((Assignment)assignment);
        boolean hard = context.isOverLimit();
        double jenrlWeight = student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
        this.iJenrl += jenrlWeight;
        Double conflictPriority = student.getConflictingPriorty((Lecture)this.first(), (Lecture)this.second());
        if (conflictPriority != null) {
            this.iPriority += conflictPriority * jenrlWeight;
        }
        this.iStudents.add(student);
        if (student.getInstructor() != null && (student.getInstructor().variables().contains(this.first()) || student.getInstructor().variables().contains(this.second()))) {
            this.iInstructors.add(student);
        }
        for (Criterion criterion : this.getModel().getCriteria()) {
            if (!(criterion instanceof StudentConflict)) continue;
            ((StudentConflict)criterion).incJenrl(assignment, this, jenrlWeight, conflictPriority, student);
        }
        if (!hard && context.isOverLimit() && this.isInConflict(assignment)) {
            context.incLimit(jenrlWeight);
        }
    }

    public double getJenrlWeight(Student student) {
        return student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
    }

    public void decJenrl(Assignment<Lecture, Placement> assignment, Student student) {
        JenrlConstraintContext context = (JenrlConstraintContext)this.getContext((Assignment)assignment);
        boolean hard = context.isOverLimit();
        double jenrlWeight = student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
        this.iJenrl -= jenrlWeight;
        Double conflictPriority = student.getConflictingPriorty((Lecture)this.first(), (Lecture)this.second());
        if (conflictPriority != null) {
            this.iPriority -= conflictPriority * jenrlWeight;
        }
        this.iStudents.remove(student);
        this.iInstructors.remove(student);
        for (Criterion criterion : this.getModel().getCriteria()) {
            if (!(criterion instanceof StudentConflict)) continue;
            ((StudentConflict)criterion).incJenrl(assignment, this, -jenrlWeight, conflictPriority, student);
        }
        if (hard && !context.isOverLimit()) {
            context.decLimit(jenrlWeight);
        }
    }

    public long getJenrl() {
        return Math.round(this.iJenrl);
    }

    public double jenrl() {
        return this.iJenrl;
    }

    public double priority() {
        return this.iPriority;
    }

    public int getNrStudents() {
        return this.iStudents.size();
    }

    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public int getNrInstructors() {
        return this.iInstructors.size();
    }

    public Set<Student> getInstructors() {
        return this.iInstructors;
    }

    @Override
    public boolean isHard() {
        return true;
    }

    @Override
    public String getName() {
        return "Join Enrollment";
    }

    public String toString() {
        return "Join Enrollment between " + ((Lecture)this.first()).getName() + " and " + ((Lecture)this.second()).getName();
    }

    public boolean areStudentConflictsHard() {
        return StudentConflict.hard((Lecture)this.first(), (Lecture)this.second());
    }

    public boolean areStudentConflictsDistance(Assignment<Lecture, Placement> assignment) {
        return StudentConflict.distance(this.getDistanceMetric(), assignment.getValue((Lecture)this.first()), assignment.getValue((Lecture)this.second()));
    }

    public boolean areStudentConflictsCommitted() {
        return StudentConflict.committed((Lecture)this.first(), (Lecture)this.second());
    }

    public boolean areStudentConflictsDistance(Assignment<Lecture, Placement> assignment, Placement value) {
        return StudentConflict.distance(this.getDistanceMetric(), value, assignment.getValue((Lecture)this.another(value.variable())));
    }

    public boolean areStudentConflictsWorkday(Assignment<Lecture, Placement> assignment, Placement value) {
        return StudentConflict.workday(this.getWorkDayLimit(), value, assignment.getValue((Lecture)this.another(value.variable())));
    }

    public boolean isOfTheSameProblem() {
        return ToolBox.equals(((Lecture)this.first()).getSolverGroupId(), ((Lecture)this.second()).getSolverGroupId());
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
        ((JenrlConstraintContext)this.getContext((Assignment)assignment)).weaken();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        ((JenrlConstraintContext)this.getContext((Assignment)assignment)).weaken(assignment, value);
    }

    public boolean isToBeIgnored() {
        return ((Lecture)this.first()).isToIgnoreStudentConflictsWith((Lecture)this.second());
    }

    @Override
    public JenrlConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new JenrlConstraintContext(assignment);
    }

    public class JenrlConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private boolean iAdded = false;
        private Double iJenrlLimit = null;
        private double iTwiggle = 0.0;

        public JenrlConstraintContext(Assignment<Lecture, Placement> assignment) {
            Placement p1 = assignment.getValue((Lecture)JenrlConstraint.this.first());
            Placement p2 = assignment.getValue((Lecture)JenrlConstraint.this.second());
            if (p1 != null && p2 != null && JenrlConstraint.isInConflict(p1, p2, JenrlConstraint.this.getDistanceMetric(), JenrlConstraint.this.getWorkDayLimit())) {
                this.iAdded = true;
                ((Lecture)JenrlConstraint.this.first()).addActiveJenrl(assignment, JenrlConstraint.this);
                ((Lecture)JenrlConstraint.this.second()).addActiveJenrl(assignment, JenrlConstraint.this);
            }
            if (JenrlConstraint.this.iJenrlMaxConflicts >= 0.0 && JenrlConstraint.this.iJenrlMaxConflicts < 1.0) {
                this.iJenrlLimit = (double)Math.min(((Lecture)JenrlConstraint.this.first()).maxClassLimit(), ((Lecture)JenrlConstraint.this.second()).maxClassLimit()) * JenrlConstraint.this.iJenrlMaxConflicts;
            }
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            Lecture other = (Lecture)JenrlConstraint.this.another(value.variable());
            if (other == null) {
                return;
            }
            Placement otherValue = assignment.getValue(other);
            if (!this.iAdded && otherValue != null && JenrlConstraint.isInConflict(value, otherValue, JenrlConstraint.this.getDistanceMetric(), JenrlConstraint.this.getWorkDayLimit())) {
                this.iAdded = true;
                ((Lecture)JenrlConstraint.this.first()).addActiveJenrl(assignment, JenrlConstraint.this);
                ((Lecture)JenrlConstraint.this.second()).addActiveJenrl(assignment, JenrlConstraint.this);
            }
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            if (this.iAdded) {
                this.iAdded = false;
                ((Lecture)JenrlConstraint.this.first()).removeActiveJenrl(assignment, JenrlConstraint.this);
                ((Lecture)JenrlConstraint.this.second()).removeActiveJenrl(assignment, JenrlConstraint.this);
            }
        }

        public boolean isConflicting() {
            return this.iAdded;
        }

        public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
            if (JenrlConstraint.this.inConflict(assignment, value)) {
                double maxConflicts = JenrlConstraint.this.iJenrlMaxConflicts + this.iTwiggle;
                this.iTwiggle = (JenrlConstraint.this.iJenrl + 1.0E-5) / (double)Math.min(((Lecture)JenrlConstraint.this.first()).maxClassLimit(), ((Lecture)JenrlConstraint.this.second()).maxClassLimit()) - maxConflicts;
                this.iJenrlLimit = maxConflicts + this.iTwiggle >= 0.0 && maxConflicts + this.iTwiggle < 1.0 ? Double.valueOf((double)Math.min(((Lecture)JenrlConstraint.this.first()).maxClassLimit(), ((Lecture)JenrlConstraint.this.second()).maxClassLimit()) * (maxConflicts + this.iTwiggle)) : null;
            }
        }

        public void weaken() {
            this.iTwiggle += JenrlConstraint.this.iJenrlMaxConflictsWeaken;
            double maxConflicts = JenrlConstraint.this.iJenrlMaxConflicts + this.iTwiggle;
            this.iJenrlLimit = maxConflicts >= 0.0 && maxConflicts < 1.0 ? Double.valueOf((double)Math.min(((Lecture)JenrlConstraint.this.first()).maxClassLimit(), ((Lecture)JenrlConstraint.this.second()).maxClassLimit()) * maxConflicts) : null;
        }

        public boolean isOverLimit() {
            return this.iJenrlLimit != null && JenrlConstraint.this.iJenrl > this.iJenrlLimit;
        }

        public void incLimit(double weight) {
            if (this.iJenrlLimit != null) {
                this.iJenrlLimit = this.iJenrlLimit + weight;
            }
        }

        public void decLimit(double weight) {
            double maxConflicts = JenrlConstraint.this.iJenrlMaxConflicts + this.iTwiggle;
            this.iJenrlLimit = maxConflicts >= 0.0 && maxConflicts < 1.0 ? Double.valueOf(Math.max((double)Math.min(((Lecture)JenrlConstraint.this.first()).maxClassLimit(), ((Lecture)JenrlConstraint.this.second()).maxClassLimit()) * maxConflicts, this.iJenrlLimit - weight)) : null;
        }
    }
}

